/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.Pane;
import com.extentech.formats.OOXML.Selection;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;

public class SheetView
implements OOXMLElement {
    private static final long serialVersionUID = 8750051341951797617L;
    private HashMap<String, Object> attrs = new HashMap();
    private Pane pane = null;
    private ArrayList<Selection> selections = new ArrayList();

    public SheetView() {
    }

    public SheetView(HashMap<String, Object> attrs, Pane p, ArrayList<Selection> selections) {
        this.attrs = attrs;
        this.pane = p;
        this.selections = selections;
    }

    public SheetView(SheetView s) {
        this.attrs = s.attrs;
        this.pane = s.pane;
        this.selections = s.selections;
    }

    public static OOXMLElement parseOOXML(XmlPullParser xpp) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        Pane p = null;
        ArrayList<Selection> selections = new ArrayList<Selection>();
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("sheetView")) {
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            attrs.put(xpp.getAttributeName(i), xpp.getAttributeValue(i));
                            ++i;
                        }
                    } else if (tnm.equals("pane")) {
                        p = Pane.parseOOXML(xpp);
                    } else if (tnm.equals("selection")) {
                        selections.add(Selection.parseOOXML(xpp));
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("sheetView")) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("sheetView.parseOOXML: " + e.toString());
        }
        SheetView s = new SheetView(attrs, p, selections);
        return s;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<sheetView");
        for (String key : this.attrs.keySet()) {
            String val = (String)this.attrs.get(key);
            ooxml.append(" " + key + "=\"" + val + "\"");
        }
        ooxml.append(">");
        if (this.pane != null) {
            ooxml.append(this.pane.getOOXML());
        }
        if (this.selections.size() > 0) {
            int j = 0;
            while (j < this.selections.size()) {
                ooxml.append(this.selections.get(j).getOOXML());
                ++j;
            }
        }
        ooxml.append("</sheetView>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new SheetView(this);
    }

    public Object getAttr(String key) {
        return this.attrs.get(key);
    }

    public void setAttr(String key, Object val) {
        this.attrs.put(key, val);
    }

    public void removeAttr(String key) {
        this.attrs.remove(key);
    }

    public void removeSelection() {
        this.removeAttr("tabSelected");
        this.selections = new ArrayList();
    }

    public String getAttrS(String key) {
        Object o = this.attrs.get(key);
        if (o == null) {
            return "";
        }
        return o.toString();
    }
}

