/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.Color;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import org.xmlpull.v1.XmlPullParser;

class Stop
implements OOXMLElement {
    private static final long serialVersionUID = -9215564484103992694L;
    private String position = null;
    private Color c = null;

    public Stop(String position, Color c) {
        this.position = position;
        this.c = c;
    }

    public Stop(Stop s) {
        this.position = s.position;
        this.c = s.c;
    }

    public static Stop parseOOXML(XmlPullParser xpp, WorkBookHandle bk) {
        String position = null;
        Color c = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("stop")) {
                        position = xpp.getAttributeValue(0);
                    } else if (tnm.equals("color")) {
                        c = (Color)Color.parseOOXML(xpp, (short)-1, bk).cloneElement();
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("stop")) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("stop.parseOOXML: " + e.toString());
        }
        Stop s = new Stop(position, c);
        return s;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<stop");
        ooxml.append(" position=\"" + this.position + "\"");
        ooxml.append(">");
        if (this.c != null) {
            ooxml.append(this.c.getOOXML());
        }
        ooxml.append("</stop>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new Stop(this);
    }
}

