/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.Br;
import com.extentech.formats.OOXML.Fld;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.r;
import com.extentech.toolkit.Logger;
import java.util.HashMap;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

public class TextRun
implements OOXMLElement {
    private static final long serialVersionUID = -6224636879471246452L;
    private r run = null;
    private Br brk = null;
    private Fld f = null;

    public TextRun(r run, Br brk, Fld f) {
        this.run = run;
        this.brk = brk;
        this.f = f;
    }

    public TextRun(TextRun r2) {
        this.run = r2.run;
        this.brk = r2.brk;
        this.f = r2.f;
    }

    public TextRun(String s) {
        this.run = new r(s, null);
    }

    public static OOXMLElement parseOOXML(XmlPullParser xpp, Stack<String> lastTag, WorkBookHandle bk) {
        r run = null;
        Br brk = null;
        Fld f = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("r")) {
                        lastTag.push(tnm);
                        run = r.parseOOXML(xpp, lastTag, bk);
                        lastTag.pop();
                        break;
                    }
                    if (tnm.equals("br")) {
                        lastTag.push(tnm);
                        brk = Br.parseOOXML(xpp, lastTag, bk);
                        lastTag.pop();
                        break;
                    }
                    if (tnm.equals("fld")) {
                        lastTag.push(tnm);
                        f = Fld.parseOOXML(xpp, lastTag, bk);
                        lastTag.pop();
                        break;
                    }
                } else if (eventType == 3) {
                    lastTag.pop();
                    break;
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("textRun.parseOOXML: " + e.toString());
        }
        TextRun oe = new TextRun(run, brk, f);
        return oe;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        if (this.run != null) {
            ooxml.append(this.run.getOOXML());
        } else if (this.brk != null) {
            ooxml.append(this.brk.getOOXML());
        } else if (this.f != null) {
            ooxml.append(this.f.getOOXML());
        }
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new TextRun(this);
    }

    public String getTitle() {
        if (this.run != null) {
            return this.run.getTitle();
        }
        if (this.f != null) {
            return this.f.getTitle();
        }
        return null;
    }

    public HashMap<String, String> getTextProperties() {
        if (this.run != null) {
            return this.run.getTextProperties();
        }
        return new HashMap<String, String>();
    }
}

