/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.ColHandle;
import com.extentech.ExtenXLS.RowHandle;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.From;
import com.extentech.formats.OOXML.GraphicFrame;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.ObjectChoice;
import com.extentech.formats.OOXML.Pic;
import com.extentech.formats.OOXML.SpPr;
import com.extentech.formats.OOXML.To;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

public class TwoCellAnchor
implements OOXMLElement {
    private static final long serialVersionUID = 4180396678197959710L;
    public static final short EMU = 1270;
    private String editAs = null;
    private String embedName = null;
    private From from = null;
    private To to = null;
    private ObjectChoice o = null;

    public TwoCellAnchor(String editAs) {
        this.editAs = editAs;
    }

    public TwoCellAnchor(String editAs, From f, To t, ObjectChoice o) {
        this.editAs = editAs;
        this.from = f;
        this.to = t;
        this.o = o;
    }

    public TwoCellAnchor(TwoCellAnchor tce) {
        this.editAs = tce.editAs;
        this.from = tce.from;
        this.to = tce.to;
        this.o = tce.o;
    }

    public static OOXMLElement parseOOXML(XmlPullParser xpp, Stack<String> lastTag, WorkBookHandle bk) {
        String editAs = null;
        From f = null;
        To t = null;
        ObjectChoice o = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block8: {
                    String endTag;
                    block6: {
                        String tnm;
                        block10: {
                            block9: {
                                block7: {
                                    if (eventType != 2) break block6;
                                    tnm = xpp.getName();
                                    if (!tnm.equals("twoCellAnchor")) break block7;
                                    if (xpp.getAttributeCount() > 0) {
                                        editAs = xpp.getAttributeValue(0);
                                    }
                                    break block8;
                                }
                                if (!tnm.equals("from")) break block9;
                                lastTag.push(tnm);
                                f = From.parseOOXML(xpp, lastTag);
                                break block8;
                            }
                            if (!tnm.equals("to")) break block10;
                            lastTag.push(tnm);
                            t = To.parseOOXML(xpp, lastTag);
                            break block8;
                        }
                        if (!tnm.equals("cxnSp") && !tnm.equals("graphicFrame") && !tnm.equals("grpSp") && !tnm.equals("pic") && !tnm.equals("sp")) break block8;
                        o = (ObjectChoice)ObjectChoice.parseOOXML(xpp, lastTag, bk);
                        break block8;
                    }
                    if (eventType == 3 && (endTag = xpp.getName()).equals("twoCellAnchor")) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("twoCellAnchor.parseOOXML: " + e.toString());
        }
        TwoCellAnchor tca = new TwoCellAnchor(editAs, f, t, o);
        return tca;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<xdr:twoCellAnchor");
        if (this.editAs != null) {
            ooxml.append(" editAs=\"" + this.editAs + "\"");
        }
        ooxml.append(">");
        if (this.from != null) {
            ooxml.append(this.from.getOOXML());
        }
        if (this.to != null) {
            ooxml.append(this.to.getOOXML());
        }
        ooxml.append(this.o.getOOXML());
        ooxml.append("<xdr:clientData/>");
        ooxml.append("</xdr:twoCellAnchor>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new TwoCellAnchor(this);
    }

    public int[] getBounds() {
        int[] bounds = new int[8];
        System.arraycopy(this.from.getBounds(), 0, bounds, 0, 4);
        System.arraycopy(this.to.getBounds(), 0, bounds, 4, 4);
        return bounds;
    }

    public void setBounds(int[] bounds) {
        int[] b = new int[4];
        System.arraycopy(bounds, 0, b, 0, 4);
        if (this.from == null) {
            this.from = new From(b);
        } else {
            this.from.setBounds(b);
        }
        System.arraycopy(bounds, 4, b, 0, 4);
        if (this.to == null) {
            this.to = new To(b);
        } else {
            this.to.setBounds(b);
        }
    }

    public String getName() {
        if (this.o != null) {
            return this.o.getName();
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public boolean hasImage() {
        return this.o.hasImage();
    }

    public boolean hasChart() {
        if (this.o != null) {
            return this.o.hasChart();
        }
        return false;
    }

    public boolean hasShape() {
        if (this.o != null) {
            return this.o.hasShape();
        }
        return false;
    }

    public void setName(String name) {
        if (this.o != null) {
            this.o.setName(name);
        }
    }

    public String getDescr() {
        if (this.o != null) {
            return this.o.getDescr();
        }
        return null;
    }

    public void setDescr(String descr) {
        if (this.o != null) {
            this.o.setDescr(descr);
        }
    }

    public String getMacro() {
        if (this.o != null) {
            return this.o.getMacro();
        }
        return null;
    }

    public void setMacro(String macro) {
        if (this.o != null) {
            this.o.setMacro(macro);
        }
    }

    public String getURI() {
        if (this.o != null) {
            return this.o.getURI();
        }
        return null;
    }

    public void setURI(String uri) {
        if (this.o != null) {
            this.o.setURI(uri);
        }
    }

    public String getChartRId() {
        if (this.o != null) {
            return this.o.getChartRId();
        }
        return null;
    }

    public void setChartRId(String rId) {
        if (this.o != null) {
            this.o.setChartRId(rId);
        }
    }

    public String getEmbed() {
        if (this.o != null) {
            return this.o.getEmbed();
        }
        return null;
    }

    public void setEmbed(String embed) {
        if (this.o != null) {
            this.o.setEmbed(embed);
        }
    }

    public String getEmbedFilename() {
        return this.embedName;
    }

    public void setEmbedFilename(String embedFile) {
        this.embedName = embedFile;
    }

    public String getLink() {
        if (this.o != null) {
            return this.o.getLink();
        }
        return null;
    }

    public void setLink(String link) {
        if (this.o != null) {
            this.o.setLink(link);
        }
    }

    public String getEditAs() {
        return this.editAs;
    }

    public void setEditAs(String editAs) {
        this.editAs = editAs;
    }

    public SpPr getSppr() {
        if (this.o != null) {
            return this.o.getSppr();
        }
        return null;
    }

    public void setAsChart(int rid, String name, int[] bounds) {
        this.o = new ObjectChoice();
        this.o.setObject(new GraphicFrame());
        this.o.setName(name);
        this.o.setChartRId("rId" + Integer.valueOf(rid).toString());
        this.o.setId(rid);
        this.setBounds(bounds);
    }

    public void setAsImage(int rid, String name, String descr, int spid, SpPr sp) {
        this.o = new ObjectChoice();
        this.o.setObject(new Pic());
        this.o.setName(name);
        this.o.setDescr(descr);
        this.o.setEmbed("rId" + Integer.valueOf(rid).toString());
        this.o.setId(spid);
        if (sp != null) {
            ((Pic)this.o.getObject()).setSppr(sp);
        }
    }

    public static int[] convertBoundsFromBIFF8(Boundsheet sheet, short[] bbounds) {
        int[] bounds = new int[8];
        bounds[0] = bbounds[0];
        double cw = ColHandle.getWidth(sheet, bbounds[0]);
        bounds[1] = (int)(cw * 256.0 * ((double)bbounds[1] / 1024.0));
        double rh = RowHandle.getHeight(sheet, bbounds[2]);
        bounds[2] = bbounds[2];
        bounds[3] = (int)(1270.0 * rh * ((double)bbounds[3] / 256.0));
        cw = ColHandle.getWidth(sheet, bbounds[4]);
        bounds[4] = bbounds[4];
        bounds[5] = (int)(cw * 256.0 * ((double)bbounds[5] / 1024.0));
        rh = RowHandle.getHeight(sheet, bbounds[6]);
        bounds[6] = bbounds[6];
        bounds[7] = (int)(1270.0 * rh * ((double)bbounds[7] / 256.0));
        return bounds;
    }

    public static short[] convertBoundsToBIFF8(Boundsheet sheet, int[] bounds) {
        short[] bbounds = new short[8];
        bbounds[0] = (short)bounds[0];
        double cw = ColHandle.getWidth(sheet, bounds[0]);
        bbounds[1] = (short)((double)bounds[1] * 1024.0 / (cw * 256.0));
        bbounds[2] = (short)bounds[2];
        double rh = RowHandle.getHeight(sheet, bounds[2]);
        bbounds[3] = (short)((double)bounds[3] * 256.0 / (1270.0 * rh));
        bbounds[4] = (short)bounds[4];
        cw = ColHandle.getWidth(sheet, bounds[4]);
        bbounds[5] = (short)((double)bounds[5] * 1024.0 / (cw * 256.0));
        bbounds[6] = (short)bounds[6];
        rh = RowHandle.getHeight(sheet, bounds[6]);
        bbounds[7] = (short)((double)bounds[7] * 256.0 / (1270.0 * rh));
        return bbounds;
    }
}

