/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Blank;
import com.extentech.formats.XLS.CellNotFoundException;
import com.extentech.formats.XLS.Rk;
import com.extentech.formats.XLS.Row;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.formulas.Calculator;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;

public final class AutoFilter
extends XLSRecord {
    private static final long serialVersionUID = -5228830347211523997L;
    short iEntry;
    Doper doper1;
    Doper doper2;
    boolean wJoin;
    boolean fSimple1;
    boolean fSimple2;
    boolean fTop10;
    boolean fTop;
    boolean fPercent;
    short wTop10;
    private byte[] PROTOTYPE_BYTES = new byte[24];

    public static XLSRecord getPrototype() {
        AutoFilter af = new AutoFilter();
        af.setOpcode((short)158);
        af.setData(af.PROTOTYPE_BYTES);
        af.init();
        return af;
    }

    @Override
    public void init() {
        super.init();
        this.iEntry = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        short grbit = ByteTools.readShort(this.getByteAt(2), this.getByteAt(3));
        this.decodeGrbit(grbit);
        this.doper1 = this.parseDoper(this.getBytesAt(4, 10));
        this.doper2 = this.parseDoper(this.getBytesAt(14, 10));
        if (this.getData().length > 25) {
            byte[] rgch = this.getBytesAt(25, this.getData().length - 25);
            int pos = 0;
            if (this.doper1 instanceof StringDoper) {
                ((StringDoper)this.doper1).setString(rgch, pos);
                pos += ((StringDoper)this.doper1).getCch();
                ++pos;
            }
            if (this.doper2 instanceof StringDoper) {
                ((StringDoper)this.doper2).setString(rgch, pos);
            }
        }
    }

    private void decodeGrbit(short grbit) {
        this.wJoin = (grbit & 3) == 3;
        this.fSimple1 = (grbit & 4) == 4;
        this.fSimple2 = (grbit & 8) == 8;
        this.fTop10 = (grbit & 0x10) == 16;
        this.fTop = (grbit & 0x20) == 32;
        this.fPercent = (grbit & 0x40) == 64;
        this.wTop10 = (short)((grbit & 0xFF80) >> 7);
    }

    private short encodeGrbit() {
        short grbit = 0;
        if (this.wJoin) {
            grbit = 3;
        }
        grbit = ByteTools.updateGrBit(grbit, this.fSimple1, 2);
        grbit = ByteTools.updateGrBit(grbit, this.fSimple2, 3);
        grbit = ByteTools.updateGrBit(grbit, this.fTop10, 4);
        grbit = ByteTools.updateGrBit(grbit, this.fTop, 5);
        grbit = ByteTools.updateGrBit(grbit, this.fPercent, 6);
        grbit = (short)(this.wTop10 << 7 | grbit);
        return grbit;
    }

    private Doper parseDoper(byte[] doperBytes) {
        Doper retDoper = null;
        switch (doperBytes[0]) {
            case 0: {
                retDoper = new UnusedDoper(doperBytes);
                break;
            }
            case 2: {
                retDoper = new RKDoper(doperBytes);
                break;
            }
            case 4: {
                retDoper = new IEEEDoper(doperBytes);
                break;
            }
            case 6: {
                retDoper = new StringDoper(doperBytes);
                break;
            }
            case 8: {
                retDoper = new ErrorDoper(doperBytes);
                break;
            }
            case 12: {
                retDoper = new AllBlanksDoper(doperBytes);
                break;
            }
            case 14: {
                retDoper = new NoBlanksDoper(doperBytes);
            }
        }
        return retDoper;
    }

    public void update() {
        byte[] data = new byte[25];
        byte[] b = ByteTools.shortToLEBytes(this.iEntry);
        System.arraycopy(b, 0, data, 0, 2);
        b = ByteTools.shortToLEBytes(this.encodeGrbit());
        System.arraycopy(b, 0, data, 2, 2);
        System.arraycopy(this.doper1.getRecord(), 0, data, 4, 10);
        System.arraycopy(this.doper2.getRecord(), 0, data, 14, 10);
        if (this.doper1 instanceof StringDoper) {
            data = ByteTools.append(((StringDoper)this.doper1).getStrBytes(), data);
        }
        if (this.doper2 instanceof StringDoper) {
            data = ByteTools.append(((StringDoper)this.doper2).getStrBytes(), data);
        }
        this.setData(data);
    }

    public void evaluate() {
        block23: {
            boolean passes;
            String op2;
            String op1;
            boolean hasDoper2;
            Object val1;
            Object val2;
            block24: {
                block22: {
                    val2 = null;
                    val1 = this.getVal(this.doper1);
                    boolean bl = hasDoper2 = !(this.doper2 instanceof UnusedDoper);
                    if (hasDoper2) {
                        val2 = this.getVal(this.doper2);
                    }
                    op1 = "=";
                    op2 = "";
                    passes = true;
                    if (!this.fSimple1) {
                        op1 = this.doper1.getComparisonOperator();
                    }
                    if (!this.fSimple2 && hasDoper2) {
                        op2 = this.doper2.getComparisonOperator();
                    }
                    if (!this.fTop10) break block22;
                    if (this.fTop) {
                        this.evaluateTopN();
                    } else {
                        this.evaluateBottomN();
                    }
                    break block23;
                }
                if (!(this.doper1 instanceof AllBlanksDoper) && !(this.doper1 instanceof NoBlanksDoper)) break block24;
                boolean filterBlanks = this.doper1 instanceof NoBlanksDoper;
                int n = this.getSheet().getNumRows();
                int i = 0;
                while (i < n) {
                    Row r2 = this.getSheet().getRowByNumber(i);
                    if (r2 == null) {
                        if (filterBlanks) {
                            this.getSheet().addValue("", ExcelTools.formatLocation(new int[]{i, this.iEntry}));
                            r2 = this.getSheet().getRowByNumber(i);
                            r2.setHidden(true);
                        }
                    } else {
                        try {
                            BiffRec c = r2.getCell(this.iEntry);
                            if (c instanceof Blank && filterBlanks) {
                                r2.setHidden(true);
                            } else if (!filterBlanks) {
                                r2.setHidden(true);
                            }
                        }
                        catch (NullPointerException e) {
                            if (filterBlanks) {
                                r2.setHidden(true);
                            }
                        }
                        catch (CellNotFoundException cellNotFoundException) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
                Row[] rows = this.getSheet().getRows();
                if (filterBlanks) break block23;
                int i2 = 1;
                while (i2 < rows.length) {
                    rows[i2].setHidden(true);
                    ++i2;
                }
                break block23;
            }
            Row[] rows = this.getSheet().getRows();
            int i = 1;
            while (i < rows.length) {
                try {
                    BiffRec c = rows[i].getCell(this.iEntry);
                    passes = Calculator.compareCellValue(c, val1, op1);
                    if (hasDoper2 && (this.wJoin || !this.wJoin && passes)) {
                        passes = Calculator.compareCellValue(c, val2, op2);
                    }
                    if (!passes) {
                        rows[i].setHidden(true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    private Object getVal(Doper d) {
        Object val = null;
        if (d instanceof ErrorDoper) {
            val = ((ErrorDoper)d).isBooleanVal() ? Boolean.valueOf(((ErrorDoper)d).getBooleanVal()) : ((ErrorDoper)d).getErrVal();
        } else if (d instanceof StringDoper) {
            val = d.toString();
        } else if (d instanceof RKDoper) {
            val = new Double(((RKDoper)d).getVal());
        } else if (d instanceof IEEEDoper) {
            val = new Double(((IEEEDoper)d).getVal());
        }
        return val;
    }

    private void evaluateTopN() {
        ArrayList<String> top10 = new ArrayList<String>();
        int n = !this.fPercent ? this.wTop10 : this.getSheet().getNumRows() / this.wTop10;
        double[] maxVals = new double[n];
        int i = 0;
        while (i < n) {
            maxVals[i] = Double.NEGATIVE_INFINITY;
            ++i;
        }
        double curmin = Double.NEGATIVE_INFINITY;
        Row[] rows = this.getSheet().getRows();
        int i2 = 1;
        while (i2 < rows.length) {
            try {
                BiffRec c = rows[i2].getCell(this.iEntry);
                double val = c.getDblVal();
                int insertionpoint = -1;
                if (val >= curmin) {
                    int j = 0;
                    while (j < n) {
                        if (val == maxVals[j]) {
                            String idxs = (String)top10.get(j);
                            idxs = idxs == null ? String.valueOf(i2) + ", " : String.valueOf(idxs) + i2 + ", ";
                            top10.set(j, idxs);
                            insertionpoint = -1;
                            break;
                        }
                        if (val > maxVals[j] && (insertionpoint == -1 || maxVals[j] < maxVals[insertionpoint])) {
                            insertionpoint = j;
                        }
                        ++j;
                    }
                    if (insertionpoint >= 0) {
                        if (top10.size() > insertionpoint) {
                            top10.remove(insertionpoint);
                        }
                        String idxs = String.valueOf(i2) + ", ";
                        top10.add(insertionpoint, idxs);
                        maxVals[insertionpoint] = val;
                        curmin = Double.MAX_VALUE;
                        int j2 = 0;
                        while (j2 < n) {
                            curmin = Math.min(maxVals[j2], curmin);
                            ++j2;
                        }
                    }
                }
            }
            catch (Exception c) {
                // empty catch block
            }
            ++i2;
        }
        String nonhiddenIdxs = "";
        int i3 = 0;
        while (i3 < top10.size()) {
            nonhiddenIdxs = String.valueOf(nonhiddenIdxs) + (String)top10.get(i3);
            ++i3;
        }
        int j = 1;
        while (j < rows.length) {
            String idx = String.valueOf(j) + ", ";
            if (nonhiddenIdxs.indexOf(idx) == -1) {
                rows[j].setHidden(true);
            }
            ++j;
        }
    }

    private void evaluateBottomN() {
        ArrayList<String> bottomN = new ArrayList<String>();
        int n = !this.fPercent ? this.wTop10 : this.getSheet().getNumRows() / this.wTop10;
        double[] minVals = new double[n];
        int i = 0;
        while (i < n) {
            minVals[i] = Double.POSITIVE_INFINITY;
            ++i;
        }
        double curmax = Double.POSITIVE_INFINITY;
        Row[] rows = this.getSheet().getRows();
        int i2 = 1;
        while (i2 < rows.length) {
            try {
                BiffRec c = rows[i2].getCell(this.iEntry);
                double val = c.getDblVal();
                int insertionpoint = -1;
                if (val <= curmax) {
                    int j = 0;
                    while (j < n) {
                        if (val == minVals[j]) {
                            String idxs = (String)bottomN.get(j);
                            idxs = idxs == null ? String.valueOf(i2) + ", " : String.valueOf(idxs) + i2 + ", ";
                            bottomN.set(j, idxs);
                            insertionpoint = -1;
                            break;
                        }
                        if (val < minVals[j] && (insertionpoint == -1 || minVals[j] > minVals[insertionpoint])) {
                            insertionpoint = j;
                        }
                        ++j;
                    }
                    if (insertionpoint >= 0) {
                        if (bottomN.size() > insertionpoint) {
                            bottomN.remove(insertionpoint);
                        }
                        String idxs = String.valueOf(i2) + ", ";
                        bottomN.add(insertionpoint, idxs);
                        minVals[insertionpoint] = val;
                        curmax = Double.NEGATIVE_INFINITY;
                        int j2 = 0;
                        while (j2 < n) {
                            curmax = Math.max(minVals[j2], curmax);
                            ++j2;
                        }
                    }
                }
            }
            catch (Exception c) {
                // empty catch block
            }
            ++i2;
        }
        String nonhiddenIdxs = "";
        int i3 = 0;
        while (i3 < bottomN.size()) {
            nonhiddenIdxs = String.valueOf(nonhiddenIdxs) + (String)bottomN.get(i3);
            ++i3;
        }
        int j = 1;
        while (j < rows.length) {
            String idx = String.valueOf(j) + ", ";
            if (nonhiddenIdxs.indexOf(idx) == -1) {
                rows[j].setHidden(true);
            }
            ++j;
        }
    }

    @Override
    public String toString() {
        boolean hasDoper2;
        String op1 = "=";
        String op2 = "";
        boolean bl = hasDoper2 = this.doper2 != null && !(this.doper2 instanceof UnusedDoper);
        if (this.fTop10) {
            if (this.fTop) {
                if (this.fPercent) {
                    return "Top " + this.wTop10 + "%";
                }
                return "Top " + this.wTop10 + " Items";
            }
            if (this.fPercent) {
                return "Bottom " + this.wTop10 + "%";
            }
            return "Bottom " + this.wTop10 + " Items";
        }
        if (!this.fSimple1) {
            op1 = this.doper1.getComparisonOperator();
        } else {
            if (this.doper1 instanceof AllBlanksDoper) {
                return "Non Blanks";
            }
            if (this.doper1 instanceof NoBlanksDoper) {
                return "Blanks";
            }
        }
        if (!this.fSimple2 && hasDoper2) {
            op2 = this.doper2.getComparisonOperator();
        }
        if (!hasDoper2) {
            return String.valueOf(op1) + this.doper1.toString();
        }
        return String.valueOf(op1) + this.doper1.toString() + (this.wJoin ? " OR " : " AND ") + op2 + this.doper2.toString();
    }

    @Override
    public void preStream() {
    }

    public int getCol() {
        return this.iEntry;
    }

    public void setCol(int col) {
        this.iEntry = (short)col;
        this.update();
    }

    public void setVal(Object val, String op) {
        byte[] doperRec = new byte[10];
        if (val instanceof String) {
            String s = (String)val;
            if (!s.startsWith("!")) {
                doperRec[0] = 6;
                this.doper1 = new StringDoper(doperRec);
                ((StringDoper)this.doper1).setString(s);
            } else {
                doperRec[0] = 8;
                doperRec[2] = 1;
                this.doper1 = new ErrorDoper(doperRec);
            }
        } else if (val instanceof Boolean) {
            doperRec[0] = 8;
            doperRec[2] = 0;
            doperRec[3] = (byte)((Boolean)val != false ? 1 : 0);
            this.doper1 = new ErrorDoper(doperRec);
        } else {
            doperRec[0] = 2;
            try {
                double d = 0.0;
                if (val instanceof Double) {
                    d = (Double)val;
                } else if (val instanceof Integer) {
                    d = ((Integer)val).doubleValue();
                } else {
                    throw new NumberFormatException("Unable to convert to Numeric Object" + val.getClass());
                }
                this.doper1 = new RKDoper(doperRec);
                ((RKDoper)this.doper1).setVal(d);
            }
            catch (Exception e) {
                Logger.logErr("AutoFilter.setVal: error setting value to " + val + ":" + e.toString());
            }
        }
        this.doper1.setComparisonOperator(op);
        this.fSimple1 = "=".equals(op);
        this.update();
    }

    public void setVal2(Object val, String op, boolean AND) {
        byte[] doperRec = new byte[10];
        if (val instanceof String) {
            String s = (String)val;
            if (!s.startsWith("!")) {
                doperRec[0] = 6;
                this.doper2 = new StringDoper(doperRec);
                ((StringDoper)this.doper1).setString(s);
            } else {
                doperRec[0] = 8;
                doperRec[2] = 1;
                this.doper2 = new ErrorDoper(doperRec);
            }
        } else if (val instanceof Boolean) {
            doperRec[0] = 8;
            doperRec[2] = 0;
            doperRec[3] = (byte)((Boolean)val != false ? 1 : 0);
            this.doper2 = new ErrorDoper(doperRec);
        } else {
            doperRec[0] = 2;
            try {
                double d = 0.0;
                if (val instanceof Double) {
                    d = (Double)val;
                } else if (val instanceof Integer) {
                    d = ((Integer)val).doubleValue();
                } else {
                    throw new NumberFormatException("Unable to convert to Numeric Object" + val.getClass());
                }
                this.doper2 = new RKDoper(doperRec);
                ((RKDoper)this.doper2).setVal(d);
            }
            catch (Exception e) {
                Logger.logErr("AutoFilter.setVal: error setting value to " + val + ":" + e.toString());
            }
        }
        this.doper2.setComparisonOperator(op);
        this.fSimple2 = "=".equals(op);
        this.wJoin = !AND;
        this.update();
    }

    @Override
    public Object getVal() {
        return this.doper1.toString();
    }

    public Object getVal2() {
        return this.doper2.toString();
    }

    public String getOp() {
        return this.doper1.getComparisonOperator();
    }

    public String getOp2() {
        if (!(this.doper2 instanceof UnusedDoper)) {
            return this.doper2.getComparisonOperator();
        }
        return null;
    }

    public void setTop10(int n, boolean percent, boolean top10) {
        if (n == 0) {
            this.fTop = false;
            this.fTop10 = false;
            this.fPercent = false;
            this.wTop10 = 0;
        } else if (n > 0 && n <= 500) {
            this.fTop = top10;
            this.fTop10 = true;
            this.wTop10 = (short)n;
            this.fPercent = percent;
            this.fSimple1 = false;
            this.fSimple2 = false;
            byte[] byArray = new byte[10];
            byArray[0] = 4;
            byArray[1] = 6;
            this.doper1 = new IEEEDoper(byArray);
            ((IEEEDoper)this.doper1).setVal(n);
            this.doper2 = new UnusedDoper(new byte[10]);
        } else {
            Logger.logErr("AutoFilter.setTop10: value " + n + " must be between 0 and 500");
        }
        this.update();
    }

    public void setFilterBlanks() {
        this.fSimple1 = true;
        this.fSimple2 = false;
        this.fTop = false;
        this.fTop10 = false;
        this.fPercent = false;
        this.wTop10 = 0;
        byte[] byArray = new byte[10];
        byArray[0] = 14;
        byArray[1] = 5;
        this.doper1 = new NoBlanksDoper(byArray);
        this.doper2 = new UnusedDoper(new byte[10]);
        this.update();
    }

    public boolean isFilterBlanks() {
        return this.fSimple1 && !this.fSimple2 && !this.fTop && !this.fTop10 && this.doper1 instanceof NoBlanksDoper;
    }

    public void setFilterNonBlanks() {
        this.fSimple1 = true;
        this.fSimple2 = false;
        this.fTop = false;
        this.fTop10 = false;
        this.fPercent = false;
        this.wTop10 = 0;
        byte[] byArray = new byte[10];
        byArray[0] = 12;
        byArray[1] = 2;
        byArray[7] = 1;
        this.doper1 = new AllBlanksDoper(byArray);
        this.doper2 = new UnusedDoper(new byte[10]);
        this.update();
    }

    public boolean isFilterNonBlanks() {
        return this.fSimple1 && !this.fSimple2 && !this.fTop && !this.fTop10 && this.doper1 instanceof AllBlanksDoper;
    }

    public boolean isTop10() {
        return this.fTop10 && this.wTop10 > 0;
    }

    private class AllBlanksDoper
    extends Doper {
        protected AllBlanksDoper(byte[] rec) {
            super(rec);
        }

        @Override
        public String toString() {
            return "All Blanks";
        }
    }

    private class Doper {
        byte vt;
        byte grbitSign;
        byte[] doperRec;

        protected Doper(byte[] rec) {
            this.vt = rec[0];
            this.grbitSign = rec[1];
            this.doperRec = rec;
        }

        public byte getGrbitSign() {
            return this.grbitSign;
        }

        public void setGrbitSign(byte grbitSign) {
            this.grbitSign = grbitSign;
        }

        public byte getVt() {
            return this.vt;
        }

        public void setVt(byte vt) {
            this.vt = vt;
        }

        public byte[] getRecord() {
            return this.doperRec;
        }

        public String toString() {
            return null;
        }

        public String getComparisonOperator() {
            switch (this.grbitSign) {
                case 1: {
                    return "<";
                }
                case 2: {
                    return "=";
                }
                case 3: {
                    return "<=";
                }
                case 4: {
                    return ">";
                }
                case 5: {
                    return "<>";
                }
                case 6: {
                    return ">=";
                }
            }
            return "";
        }

        public void setComparisonOperator(String op) {
            if ("<".equals(op)) {
                this.grbitSign = 1;
            }
            if ("=".equals(op)) {
                this.grbitSign = (byte)2;
            }
            if ("<=".equals(op)) {
                this.grbitSign = (byte)3;
            }
            if (">".equals(op)) {
                this.grbitSign = (byte)4;
            }
            if ("<>".equals(op)) {
                this.grbitSign = (byte)5;
            }
            if (">=".equals(op)) {
                this.grbitSign = (byte)6;
            }
            this.doperRec[1] = this.grbitSign;
        }
    }

    private class ErrorDoper
    extends Doper {
        boolean bVal;
        int errVal;

        protected ErrorDoper(byte[] rec) {
            super(rec);
            if (this.doperRec[2] == 0) {
                this.bVal = this.doperRec[3] != 0;
            } else {
                this.errVal = this.doperRec[3];
            }
        }

        public boolean isErrVal() {
            return this.doperRec[2] == 1;
        }

        public boolean isBooleanVal() {
            return this.doperRec[2] == 0;
        }

        public boolean getBooleanVal() {
            return this.bVal;
        }

        public String getErrVal() {
            if (this.doperRec[2] == 1) {
                switch (this.errVal) {
                    case 0: {
                        return "#NULL!";
                    }
                    case 7: {
                        return "#DIV/0!";
                    }
                    case 15: {
                        return "#VALUE!";
                    }
                    case 23: {
                        return "#REF!";
                    }
                    case 29: {
                        return "#NAME?";
                    }
                    case 36: {
                        return "#NUM!";
                    }
                    case 42: {
                        return "#N/A";
                    }
                }
            }
            return "";
        }

        @Override
        public String toString() {
            if (this.isErrVal()) {
                return this.getErrVal();
            }
            return this.bVal ? "true" : "false";
        }
    }

    private class IEEEDoper
    extends Doper {
        double val;

        protected IEEEDoper(byte[] rec) {
            super(rec);
            byte[] b = new byte[8];
            System.arraycopy(this.doperRec, 2, b, 0, 8);
            this.val = ByteTools.eightBytetoLEDouble(b);
        }

        public double getVal() {
            return this.val;
        }

        public void setVal(double d) {
            this.val = d;
            byte[] b = ByteTools.doubleToLEByteArray(this.val);
            System.arraycopy(b, 0, this.doperRec, 2, 8);
        }

        @Override
        public String toString() {
            return new Double(this.val).toString();
        }
    }

    private class NoBlanksDoper
    extends Doper {
        protected NoBlanksDoper(byte[] rec) {
            super(rec);
        }

        @Override
        public String toString() {
            return "No Blanks";
        }
    }

    private class RKDoper
    extends Doper {
        double val;

        protected RKDoper(byte[] rec) {
            super(rec);
            byte[] b = new byte[4];
            System.arraycopy(this.doperRec, 2, b, 0, 4);
            this.val = Rk.parseRkNumber(b);
        }

        @Override
        public String toString() {
            return new Double(this.val).toString();
        }

        public void setVal(double d) {
            this.val = d;
            byte[] b = Rk.getRkBytes(d);
            System.arraycopy(b, 0, this.doperRec, 2, 4);
        }

        public double getVal() {
            return this.val;
        }
    }

    private class StringDoper
    extends Doper {
        String s;

        protected StringDoper(byte[] rec) {
            super(rec);
        }

        public void setString(byte[] rgch, int start) {
            byte cch = this.doperRec[6];
            byte[] stringbytes = new byte[cch];
            System.arraycopy(rgch, start, stringbytes, 0, cch);
            this.s = new String(stringbytes);
        }

        public int getCch() {
            return this.doperRec[6];
        }

        public void setString(String s) {
            this.s = s;
            byte[] b = s.getBytes();
            this.doperRec[6] = (byte)b.length;
        }

        public byte[] getStrBytes() {
            return this.s.getBytes();
        }

        @Override
        public String toString() {
            return this.s;
        }
    }

    private class UnusedDoper
    extends Doper {
        protected UnusedDoper(byte[] rec) {
            super(rec);
        }

        @Override
        public String toString() {
            return "Unused";
        }
    }
}

