/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.XLSCellRecord;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;

public final class Blank
extends XLSCellRecord {
    private static final long serialVersionUID = -3847009755105117050L;

    @Override
    public String getStringVal() {
        return "";
    }

    public static XLSRecord getPrototype() {
        Blank bl = new Blank();
        bl.setData(new byte[6]);
        return bl;
    }

    Blank() {
        this(new byte[6]);
    }

    Blank(byte[] b) {
        this.setData(b);
        this.setOpcode((short)513);
        this.setLength(6);
        this.init();
    }

    @Override
    public void init() {
        super.init();
        int pos = 4;
        super.initRowCol();
        this.ixfe = ByteTools.readShort(this.getByteAt(pos++), this.getByteAt(pos++));
        this.setIsValueForCell(true);
        this.isBlank = true;
    }

    public void setCol(int i) {
        if (this.isValueForCell) {
            this.getData();
            if (this.data == null) {
                this.setData(new byte[6]);
            }
            byte[] c = ByteTools.shortToLEBytes((short)i);
            System.arraycopy(c, 0, this.getData(), 2, 2);
        }
        this.col = (short)i;
    }

    public void setRow(int i) {
        if (this.isValueForCell) {
            this.getData();
            if (this.data == null) {
                this.setData(new byte[6]);
            }
            byte[] r2 = ByteTools.shortToLEBytes((short)i);
            System.arraycopy(r2, 0, this.getData(), 0, 2);
        }
        this.rw = i;
    }
}

