/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.LEO.InvalidFileException;
import com.extentech.formats.XLS.UnencryptedXLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;

public final class Bof
extends UnencryptedXLSRecord {
    private static final long serialVersionUID = 3005631881544437570L;
    short grbit;
    String xlsver = "";
    int oldlen = -1;

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " lbplypos: " + this.getLbPlyPos();
    }

    @Override
    public void setOffset(int s) {
        super.setOffset(s);
        if (this.worksheet != null && (this.isSheetBof() || this.isVBModuleBof() || this.worksheet.getMyBof() == this)) {
            this.worksheet.setLbPlyPos(this.getLbPlyPos());
        }
    }

    boolean isValidBIFF8() {
        return this.oldlen == 20;
    }

    String getXLSVersionString() {
        return this.xlsver;
    }

    @Override
    public void init() {
        super.init();
        this.getData();
        this.grbit = ByteTools.readShort(this.getByteAt(2), this.getByteAt(3));
        int compat = ByteTools.readInt(this.getByteAt(12), this.getByteAt(13), this.getByteAt(14), this.getByteAt(15));
        this.xlsver = String.valueOf(compat);
        this.oldlen = this.getLength();
        if (this.oldlen < 16) {
            Logger.logErr("Not Excel '97 (BIFF8) or later version.  Unsupported file format.");
            throw new InvalidFileException("InvalidFileException: Not Excel '97 (BIFF8) or later version.  Unsupported file format.");
        }
    }

    long getLbPlyPos() {
        if (!this.isValidBIFF8()) {
            return this.offset + 8;
        }
        return this.offset;
    }

    public boolean isSheetBof() {
        return (this.grbit & 0x10) == 16;
    }

    public boolean isVBModuleBof() {
        return (this.grbit & 6) == 6;
    }

    public boolean isChartBof() {
        return (this.grbit & 0x20) == 32;
    }

    public void setSheetBof() {
        this.grbit = (short)16;
    }
}

