/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.CellRange;
import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.Dxf;
import com.extentech.formats.OOXML.Fill;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.Condfmt;
import com.extentech.formats.XLS.ExpressionParser;
import com.extentech.formats.XLS.Font;
import com.extentech.formats.XLS.FormatConstants;
import com.extentech.formats.XLS.Formula;
import com.extentech.formats.XLS.FormulaNotFoundException;
import com.extentech.formats.XLS.OOXMLAdapter;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.formulas.FormulaParser;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgArray;
import com.extentech.formats.XLS.formulas.PtgRefN;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import com.extentech.toolkit.StringTool;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

public final class Cf
extends XLSRecord {
    private static final long serialVersionUID = 5624169378370505532L;
    short ct = 0;
    short cp = 0;
    int cce1 = 0;
    int cce2 = 0;
    String rgbdxf = "";
    String rgce1 = "";
    String rgce2 = "";
    int flags = 0;
    boolean bHasFontBlock = false;
    boolean bHasBorderBlock = false;
    boolean bHasPatternBlock = false;
    private Ptg prefHolder = null;
    private Stack expression1 = new Stack();
    private Stack expression2 = new Stack();
    private Formula formula1 = null;
    private Formula formula2 = null;
    private String containsText = null;
    private Condfmt condfmt = null;
    public static final int PATTERN_FILL_STYLE = 64512;
    private int patternFillStyle = -1;
    public static final int PATTERN_FILL_COLOR = 127;
    public static final int PATTERN_FILL_BACK_COLOR = 16256;
    private int patternFillColorsFlag = 0;
    private int patternFillColor = 0;
    private int patternFillColorBack = -1;
    private Fill fill = null;
    private Font font = null;
    private int fontHeight = -1;
    public static final int FONT_OPTIONS_POSTURE = 2;
    public static final int FONT_OPTIONS_CANCELLATION = 128;
    public static final int FONT_OPTIONS_POSTURE_NORMAL = 0;
    public static final int FONT_OPTIONS_POSTURE_ITALIC = 1;
    public static final int FONT_OPTIONS_CANCELLATION_OFF = 0;
    public static final int FONT_OPTIONS_CANCELLATION_ON = 1;
    private int fontOptsFlag = -1;
    private int fontWeight = -1;
    public static final int FONT_ESCAPEMENT_NONE = 0;
    public static final int FONT_ESCAPEMENT_SUPER = 1;
    public static final int FONT_ESCAPEMENT_SUB = 2;
    private int fontEscapementFlag = -1;
    public static final int FONT_UNDERLINE_NONE = 0;
    public static final int FONT_UNDERLINE_SINGLE = 1;
    public static final int FONT_UNDERLINE_DOUBLE = 2;
    public static final int FONT_UNDERLINE_SINGLEACCOUNTING = 33;
    public static final int FONT_UNDERLINE_DOUBLEACCOUNTING = 34;
    private int fontUnderlineStyle = -1;
    private int fontColorIndex = -1;
    public static final int FONT_MODIFIED_OPTIONS_STYLE = 2;
    public static final int FONT_MODIFIED_OPTIONS_CANCELLATIONS = 128;
    private int fontModifiedOptionsFlag = -1;
    private int fontEscapementFlagModifiedFlag = -1;
    private int fontUnderlineModifiedFlag = -1;
    public static final int BORDER_LINESTYLE_LEFT = 15;
    public static final int BORDER_LINESTYLE_RIGHT = 240;
    public static final int BORDER_LINESTYLE_TOP = 3840;
    public static final int BORDER_LINESTYLE_BOTTOM = 61440;
    public static final int BORDER_MODIFIED_LEFT = 1024;
    public static final int BORDER_MODIFIED_RIGHT = 2048;
    public static final int BORDER_MODIFIED_TOP = 4096;
    public static final int BORDER_MODIFIED_BOTTOM = 8192;
    private short borderLineStylesFlag = 0;
    private int borderLineStylesLeft = -1;
    private int borderLineStylesRight = -1;
    private int borderLineStylesTop = -1;
    private int borderLineStylesBottom = -1;
    public static final int BORDER_LINECOLOR_LEFT = 127;
    public static final int BORDER_LINECOLOR_RIGHT = 16256;
    public static final int BORDER_LINECOLOR_TOP = 0x7F0000;
    public static final int BORDER_LINECOLOR_BOTTOM = 1065353216;
    private int borderLineColorsFlag = 0;
    private int borderLineColorLeft = 0;
    private int borderLineColorRight = 0;
    private int borderLineColorTop = 0;
    private int borderLineColorBottom = 0;
    private byte[] PROTOTYPE_BYTES;
    private int refPos;

    public Cf() {
        byte[] byArray = new byte[13];
        byArray[0] = 1;
        byArray[1] = 3;
        this.PROTOTYPE_BYTES = byArray;
        this.refPos = -1;
    }

    public Cf(Condfmt f) {
        this();
        this.setData(this.PROTOTYPE_BYTES);
        this.setCondfmt(f);
    }

    @Override
    public void init() {
        super.init();
        this.data = this.getData();
        this.ct = this.getByteAt(0);
        this.cp = this.getByteAt(1);
        this.cce1 = ByteTools.readShort(this.getByteAt(2), this.getByteAt(3));
        this.cce2 = ByteTools.readShort(this.getByteAt(4), this.getByteAt(5));
        this.flags = ByteTools.readInt(this.getByteAt(6), this.getByteAt(7), this.getByteAt(8), this.getByteAt(9));
        this.bHasFontBlock = (this.flags & 0x4000000) == 0x4000000;
        this.bHasBorderBlock = (this.flags & 0x10000000) == 0x10000000;
        this.bHasPatternBlock = (this.flags & 0x20000000) == 0x20000000;
        int pos = 12;
        if (this.bHasFontBlock) {
            pos += 64;
            this.fontHeight = ByteTools.readInt(this.getByteAt(pos++), this.getByteAt(pos++), this.getByteAt(pos++), this.getByteAt(pos++));
            this.fontOptsFlag = ByteTools.readInt(this.getByteAt(pos++), this.getByteAt(pos++), this.getByteAt(pos++), this.getByteAt(pos++));
            this.fontWeight = ByteTools.readShort(this.getByteAt(pos++), this.getByteAt(pos++));
            this.fontEscapementFlag = ByteTools.readShort(this.getByteAt(pos++), this.getByteAt(pos++));
            this.fontUnderlineStyle = this.getByteAt(pos++);
            pos += 3;
            this.fontColorIndex = ByteTools.readInt(this.getByteAt(pos++), this.getByteAt(pos++), this.getByteAt(pos++), this.getByteAt(pos++));
            pos += 4;
            this.fontModifiedOptionsFlag = ByteTools.readInt(this.getByteAt(pos++), this.getByteAt(pos++), this.getByteAt(pos++), this.getByteAt(pos++));
            this.fontEscapementFlagModifiedFlag = ByteTools.readInt(this.getByteAt(pos++), this.getByteAt(pos++), this.getByteAt(pos++), this.getByteAt(pos++));
            this.fontUnderlineModifiedFlag = ByteTools.readInt(this.getByteAt(pos++), this.getByteAt(pos++), this.getByteAt(pos++), this.getByteAt(pos++));
            pos += 16;
            if ((pos += 2) != 130) {
                Logger.logWarn("Cf font block parsing pos mismatch" + pos);
            }
            this.getFont();
        }
        if (this.bHasBorderBlock) {
            this.borderLineStylesFlag = ByteTools.readShort(this.getByteAt(pos++), this.getByteAt(pos++));
            this.updateBorderLineStyles();
            this.borderLineColorsFlag = ByteTools.readInt(this.getByteAt(pos++), this.getByteAt(pos++), this.getByteAt(pos++), this.getByteAt(pos++));
            this.updateBorderLineColors();
            pos += 2;
        }
        if (this.bHasPatternBlock) {
            this.patternFillStyle = ByteTools.readShort(this.getByteAt(pos++), this.getByteAt(pos++)) >> 9;
            this.patternFillColorsFlag = ByteTools.readShort(this.getByteAt(pos++), this.getByteAt(pos++));
            this.updatePatternFillColors();
        }
        int postest = 12;
        if (this.bHasFontBlock) {
            postest += 118;
        }
        if (this.bHasBorderBlock) {
            postest += 8;
        }
        if (this.bHasPatternBlock) {
            postest += 4;
        }
        if (postest != pos) {
            Logger.logWarn("Cf bad pos offset during init().");
            pos = postest;
        }
        byte[] function = this.getBytesAt(pos, this.cce1);
        try {
            this.expression1 = ExpressionParser.parseExpression(function, this, this.cce1);
        }
        catch (Exception e) {
            Logger.logErr("Initializing expression1 for Cf failed: " + new String(function));
        }
        function = this.getBytesAt(pos += this.cce1, this.cce2);
        if (this.cce2 > 0) {
            try {
                this.expression2 = ExpressionParser.parseExpression(function, this, this.cce2);
            }
            catch (Exception e) {
                Logger.logErr("Initializing expression2 for Cf failed: " + new String(function));
            }
        }
        if (this.DEBUGLEVEL > 50) {
            Logger.logInfo("Cf record encountered.");
        }
    }

    private void updateRecord() {
        byte[] function;
        byte[] newdata = new byte[12];
        newdata[0] = (byte)this.ct;
        newdata[1] = (byte)this.cp;
        this.flags = 3720191;
        if (this.bHasFontBlock) {
            this.flags |= 0x4000000;
        }
        if (this.bHasBorderBlock) {
            this.flags |= 0x10000000;
            this.flags |= 0x400;
            this.flags |= 0x800;
            this.flags |= 0x1000;
            this.flags |= 0x2000;
        }
        if (this.bHasPatternBlock) {
            this.flags |= 0x20000000;
            this.flags |= 0x10000;
            this.flags |= 0x20000;
            this.flags |= 0x40000;
        }
        byte[] b = ByteTools.cLongToLEBytes(this.flags);
        System.arraycopy(b, 0, newdata, 6, 4);
        int pos = 12;
        if (this.bHasFontBlock) {
            newdata = ByteTools.append(new byte[118], newdata);
            b = ByteTools.cLongToLEBytes(this.fontHeight);
            System.arraycopy(b, 0, newdata, pos += 64, 4);
            b = ByteTools.cLongToLEBytes(this.fontOptsFlag);
            System.arraycopy(b, 0, newdata, pos += 4, 4);
            b = ByteTools.shortToLEBytes((short)this.fontWeight);
            System.arraycopy(b, 0, newdata, pos += 4, 2);
            b = ByteTools.shortToLEBytes((short)this.fontEscapementFlag);
            System.arraycopy(b, 0, newdata, pos += 2, 2);
            b = ByteTools.shortToLEBytes((short)this.fontUnderlineStyle);
            System.arraycopy(b, 0, newdata, pos += 2, 1);
            ++pos;
            b = ByteTools.cLongToLEBytes(this.fontColorIndex);
            System.arraycopy(b, 0, newdata, pos += 3, 4);
            pos += 4;
            b = ByteTools.cLongToLEBytes(this.fontModifiedOptionsFlag);
            System.arraycopy(b, 0, newdata, pos += 4, 4);
            b = ByteTools.cLongToLEBytes(this.fontEscapementFlagModifiedFlag);
            System.arraycopy(b, 0, newdata, pos += 4, 4);
            b = ByteTools.cLongToLEBytes(this.fontUnderlineModifiedFlag);
            System.arraycopy(b, 0, newdata, pos += 4, 4);
            pos += 4;
            pos += 16;
            int n = ++pos;
            ++pos;
            newdata[n] = 1;
        }
        if (this.bHasBorderBlock) {
            newdata = ByteTools.append(new byte[8], newdata);
            b = ByteTools.shortToLEBytes(this.borderLineStylesFlag);
            System.arraycopy(b, 0, newdata, pos, 2);
            b = ByteTools.cLongToLEBytes(this.borderLineColorsFlag);
            System.arraycopy(b, 0, newdata, pos += 2, 4);
            pos += 4;
            pos += 2;
        }
        if (this.bHasPatternBlock) {
            newdata = ByteTools.append(new byte[4], newdata);
            b = ByteTools.shortToLEBytes((short)(this.patternFillStyle << 9));
            System.arraycopy(b, 0, newdata, pos, 2);
            b = ByteTools.shortToLEBytes((short)this.patternFillColorsFlag);
            System.arraycopy(b, 0, newdata, pos += 2, 2);
            pos += 2;
        }
        if (this.formula1 != null) {
            function = this.getFormulaExpression(this.formula1);
            newdata = ByteTools.append(function, newdata);
            this.cce1 = function.length;
            b = ByteTools.shortToLEBytes((short)this.cce1);
            newdata[2] = b[0];
            newdata[3] = b[1];
        }
        if (this.formula2 != null) {
            function = this.getFormulaExpression(this.formula2);
            newdata = ByteTools.append(function, newdata);
            this.cce2 = function.length;
            b = ByteTools.shortToLEBytes((short)this.cce2);
            newdata[4] = b[0];
            newdata[5] = b[1];
        }
        this.setData(newdata);
    }

    private byte[] getFormulaExpression(Formula f) {
        boolean hasArray = false;
        byte[] expbytes = new byte[]{};
        byte[] arraybytes = null;
        Stack expression = f.getExpression();
        int i = 0;
        while (i < expression.size()) {
            byte[] b;
            Object o = expression.elementAt(i);
            Ptg ptg = (Ptg)o;
            if (o instanceof PtgArray) {
                PtgArray pa = (PtgArray)o;
                b = pa.getPreRecord();
                arraybytes = ByteTools.append(pa.getPostRecord(), arraybytes);
                hasArray = true;
            } else {
                b = ptg.getRecord();
            }
            expbytes = ByteTools.append(b, expbytes);
            ++i;
        }
        if (hasArray) {
            expbytes = ByteTools.append(arraybytes, expbytes);
        }
        return expbytes;
    }

    public static void setStylePropsFromString(String style, Cf cx) {
        String[] toks = StringTool.getTokensUsingDelim(style, ";");
        int t = 0;
        while (t < toks.length) {
            boolean b;
            int s;
            int cl;
            int pos = toks[t].indexOf(":");
            String n = "";
            if (pos > 0) {
                n = toks[t].substring(0, pos);
            }
            String v = toks[t].substring(toks[t].indexOf(":") + 1);
            n = StringTool.strip(n, '\"');
            v = StringTool.strip(v, '#');
            n = StringTool.allTrim(n);
            v = StringTool.allTrim(v);
            if ((n = n.toLowerCase()).indexOf("border") == 0) {
                String[] vs = StringTool.getTokensUsingDelim(v, " ");
                int sz = -1;
                int cz = -1;
                int stl = -1;
                String clr = null;
                try {
                    sz = Integer.parseInt(vs[0]);
                    clr = vs[2];
                    int i = 0;
                    while (i < FormatConstants.BORDER_NAMES.length) {
                        if (FormatConstants.BORDER_NAMES[i].equals(vs[1])) {
                            stl = i;
                            break;
                        }
                        ++i;
                    }
                    cz = FormatHandle.HexStringToColorInt(clr, FormatHandle.colorBACKGROUND);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n.indexOf("border-top") == 0) {
                    if (clr != null) {
                        cx.setBorderLineColorTop(cz);
                    }
                    if (stl > -1) {
                        cx.setBorderLineStylesTop(stl);
                    }
                } else if (n.indexOf("border-left") == 0) {
                    if (clr != null) {
                        cx.setBorderLineColorLeft(cz);
                    }
                    if (stl > -1) {
                        cx.setBorderLineStylesLeft(stl);
                    }
                } else if (n.indexOf("border-bottom") == 0) {
                    if (clr != null) {
                        cx.setBorderLineColorBottom(cz);
                    }
                    if (stl > -1) {
                        cx.setBorderLineStylesBottom(stl);
                    }
                } else if (n.indexOf("border-right") == 0) {
                    if (clr != null) {
                        cx.setBorderLineColorRight(cz);
                    }
                    if (stl > -1) {
                        cx.setBorderLineStylesRight(stl);
                    }
                }
            } else if (n.equalsIgnoreCase("text-line-through")) {
                if (v.equalsIgnoreCase("none")) {
                    cx.setFontStriken(false);
                } else {
                    cx.setFontStriken(true);
                }
            } else if (n.equalsIgnoreCase("fg")) {
                cl = FormatHandle.HexStringToColorInt(v, FormatHandle.colorFOREGROUND);
                cx.setFontColorIndex(cl);
            } else if (n.equalsIgnoreCase("pattern")) {
                int vv = Integer.parseInt(v);
                cx.setPatternFillStyle(vv);
            } else if (n.equalsIgnoreCase("color") || n.equalsIgnoreCase("patterncolor")) {
                cl = FormatHandle.HexStringToColorInt(v, FormatHandle.colorFONT);
                cx.setPatternFillColor(cl, v);
            } else if (n.equalsIgnoreCase("background")) {
                cl = FormatHandle.HexStringToColorInt(v, FormatHandle.colorBACKGROUND);
                cx.setPatternFillColorBack(cl);
            } else if (n.equalsIgnoreCase("alignment-horizontal")) {
                cl = Integer.parseInt(v);
            } else if (n.equalsIgnoreCase("alignment-vertical")) {
                cl = Integer.parseInt(v);
            } else if (n.equalsIgnoreCase("numberformat")) {
                cl = Integer.parseInt(v);
            } else if (n.equalsIgnoreCase("font-height")) {
                s = Integer.parseInt(v);
                cx.setFontHeight(s);
            } else if (n.equalsIgnoreCase("font-weight")) {
                s = Integer.parseInt(v);
                cx.setFontWeight(s);
            } else if (n.equalsIgnoreCase("font-EscapementFlag")) {
                s = Integer.parseInt(v);
                cx.setFontEscapement(s);
            } else if (n.equalsIgnoreCase("font-striken")) {
                b = Boolean.valueOf(v);
                cx.setFontStriken(b);
            } else if (n.equalsIgnoreCase("font-italic")) {
                b = Boolean.valueOf(v);
                cx.setFontItalic(b);
            } else if (n.equalsIgnoreCase("font-ColorIndex")) {
                s = Integer.parseInt(v);
                cx.setFontColorIndex(s);
            } else if (n.equalsIgnoreCase("font-UnderlineStyle")) {
                s = Integer.parseInt(v);
                cx.setFontUnderlineStyle(s);
            }
            ++t;
        }
        cx.updateRecord();
    }

    public static void setStylePropsFromDxf(Dxf dxf, Cf cf) {
        int fls;
        int[] borderStyles = dxf.getBorderStyles();
        if (borderStyles != null) {
            int[] borderColors = dxf.getBorderColors();
            int[] borderSizes = dxf.getBorderSizes();
            cf.setBorderLineColorTop(borderColors[0]);
            cf.setBorderLineStylesTop(borderStyles[0]);
            cf.setBorderLineColorLeft(borderColors[1]);
            cf.setBorderLineStylesLeft(borderStyles[1]);
            cf.setBorderLineColorBottom(borderColors[2]);
            cf.setBorderLineStylesBottom(borderStyles[2]);
            cf.setBorderLineColorRight(borderColors[3]);
            cf.setBorderLineStylesRight(borderStyles[3]);
        }
        if ((fls = dxf.getFillPatternInt()) >= 0) {
            cf.setPatternFillStyle(fls);
            int fg = dxf.getFg();
            int bg = dxf.getBg();
            if (fg != -1) {
                cf.setPatternFillColor(fg, null);
            }
            if (bg != -1) {
                cf.setPatternFillColorBack(bg);
            }
        }
        cf.fill = dxf.getFill();
        String s = dxf.getHorizontalAlign();
        if (s != null) {
            int n = Integer.parseInt(s);
        }
        if ((s = dxf.getVerticalAlign()) != null) {
            int n = Integer.parseInt(s);
        }
        if ((s = dxf.getNumberFormat()) != null) {
            int n = Integer.parseInt(s);
        }
        if (dxf.getFont() != null) {
            cf.parseFont(dxf.getFont());
            cf.font = dxf.getFont();
        }
        cf.updateRecord();
    }

    public void setOperator(String s) {
        this.cp = Cf.getConditionFromString(s);
        if (this.cp == 0) {
            this.expression1 = ExpressionParser.parseExpression(s.getBytes(), this);
        }
    }

    public void setOperator(int op) {
        this.cp = (short)op;
    }

    public short getOperator() {
        return this.cp;
    }

    protected void setType(int type) {
        this.ct = (short)type;
    }

    public short getType() {
        return this.ct;
    }

    public String getTypeString() {
        return Cf.translateType(this.ct);
    }

    public void setCondition1(String s) {
        if ((s = Cf.unescapeFormulaString(s)).indexOf("=") != 0) {
            s = "=" + s;
            try {
                int[] r2 = new int[2];
                this.formula1 = FormulaParser.getFormulaFromString(s, this.getSheet(), r2);
                this.formula1.setWorkBook(this.getWorkBook());
                this.expression1 = this.formula1.getExpression();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setCondition2(String s) {
        if (s.equals("")) {
            return;
        }
        s = Cf.unescapeFormulaString(s);
        if (this.cp == 0) {
            this.expression2 = ExpressionParser.parseExpression(s.getBytes(), this);
        } else if (s.indexOf("=") != 0) {
            s = "=" + s;
            try {
                int[] r2 = new int[2];
                this.formula2 = FormulaParser.getFormulaFromString(s, this.getSheet(), r2);
                this.expression2 = this.formula1.getExpression();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.cce2 = s.length();
    }

    public Condfmt getCondfmt() {
        return this.condfmt;
    }

    public void setCondfmt(Condfmt condfmt) {
        this.condfmt = condfmt;
    }

    public int getFontEscapement() {
        return this.fontEscapementFlag;
    }

    public String getPatternFgColor() {
        if (this.fill != null) {
            return this.fill.getFgColorAsRGB(this.getWorkBook().getTheme());
        }
        if (this.patternFillColor != -1) {
            return FormatHandle.colorToHexString(this.getColorTable()[this.patternFillColor]);
        }
        return null;
    }

    public String getPatternBgColor() {
        if (this.fill != null) {
            if (this.patternFillStyle == 1) {
                return this.fill.getFgColorAsRGB(this.getWorkBook().getTheme());
            }
            return this.fill.getBgColorAsRGB(this.getWorkBook().getTheme());
        }
        if (this.patternFillColorBack != -1) {
            return FormatHandle.colorToHexString(this.getColorTable()[this.patternFillColorBack]);
        }
        return null;
    }

    private void parseFont(Font font) {
        int z = font.getFontHeight();
        if (z > 0) {
            this.setFontHeight(z);
        }
        if ((z = font.getFontWeight()) > 0) {
            this.setFontWeight(z);
        }
        this.setFontStriken(font.getStricken());
        this.setFontItalic(font.getItalic());
        z = font.getColor();
        if (z > -1) {
            this.setFontColorIndex(z);
        }
        if ((z = font.getUnderlineStyle()) > -1) {
            this.setFontUnderlineStyle(z);
        }
    }

    public void setFontEscapement(int fontEscapementFlag) {
        this.fontEscapementFlag = fontEscapementFlag;
        this.fontEscapementFlagModifiedFlag = 0;
        this.bHasFontBlock = true;
    }

    void updateBorderLineStyles() {
        if ((this.flags & 0x400) == 0) {
            this.borderLineStylesLeft = (short)(this.borderLineStylesFlag & 0xF);
        }
        if ((this.flags & 0x800) == 0) {
            this.borderLineStylesRight = (short)((this.borderLineStylesFlag & 0xF0) >> 4);
        }
        if ((this.flags & 0x1000) == 0) {
            this.borderLineStylesTop = (short)((this.borderLineStylesFlag & 0xF00) >> 8);
        }
        if ((this.flags & 0x2000) == 0) {
            this.borderLineStylesBottom = (short)((this.borderLineStylesFlag & 0xF000) >> 12);
        }
        this.bHasBorderBlock = true;
    }

    public void updateBorderLineStylesFlag() {
        this.flags |= 0x10000000;
        this.bHasBorderBlock = (this.flags & 0x10000000) == 0x10000000;
        this.borderLineStylesFlag = 0;
        if (this.borderLineStylesLeft >= 0) {
            this.borderLineStylesFlag = (short)this.borderLineStylesLeft;
        }
        if (this.borderLineStylesRight >= 0) {
            this.borderLineStylesFlag = (short)(this.borderLineStylesFlag | this.borderLineStylesRight << 4);
        }
        if (this.borderLineStylesTop >= 0) {
            this.borderLineStylesFlag = (short)(this.borderLineStylesFlag | this.borderLineStylesTop << 8);
        }
        if (this.borderLineStylesBottom >= 0) {
            this.borderLineStylesFlag = (short)(this.borderLineStylesFlag | this.borderLineStylesBottom << 12);
        }
    }

    void updateBorderLineColors() {
        if ((this.flags & 0x400) == 0) {
            this.borderLineColorLeft = (short)(this.borderLineColorsFlag & 0x7F);
        }
        if ((this.flags & 0x800) == 0) {
            this.borderLineColorRight = (short)((this.borderLineColorsFlag & 0x3F80) >> 7);
        }
        if ((this.flags & 0x1000) == 0) {
            this.borderLineColorTop = (short)((this.borderLineColorsFlag & 0x7F0000) >> 16);
        }
        if ((this.flags & 0x2000) == 0) {
            this.borderLineColorBottom = (short)((this.borderLineColorsFlag & 0x3F800000) >> 23);
        }
    }

    public void updateBorderLineColorsFlag() {
        this.flags |= 0x10000000;
        this.bHasBorderBlock = (this.flags & 0x10000000) == 0x10000000;
        this.borderLineColorsFlag = 0;
        this.borderLineColorsFlag |= this.borderLineColorLeft;
        this.borderLineColorsFlag |= this.borderLineColorRight << 7;
        this.borderLineColorsFlag |= this.borderLineColorTop << 16;
        this.borderLineColorsFlag |= this.borderLineColorBottom << 23;
    }

    void updatePatternFillColors() {
        this.patternFillColor = (short)((this.patternFillColorsFlag & 0x3F80) >> 7);
        this.patternFillColorBack = (short)(this.patternFillColorsFlag & 0x7F);
        this.bHasPatternBlock = true;
    }

    public Fill getFill() {
        return this.fill;
    }

    public void updatePatternFillColorsFlag() {
        this.flags |= 0x20000000;
        this.bHasPatternBlock = true;
        this.patternFillColorsFlag = (short)this.patternFillColorBack;
        this.patternFillColorsFlag = (short)(this.patternFillColorsFlag | this.patternFillColor << 7);
    }

    @Override
    public Font getFont() {
        if (!this.bHasFontBlock) {
            return null;
        }
        if (this.font != null) {
            return this.font;
        }
        int t = this.fontHeight;
        int x = this.fontWeight;
        t = t == -1 ? 180 : (t *= 20);
        if (x == -1) {
            x = 400;
        }
        this.font = new Font("Arial", x, t);
        if (this.fontColorIndex > -1) {
            this.font.setColor(this.fontColorIndex);
        }
        return this.font;
    }

    public Color[] getBorderColors() {
        if (!this.bHasBorderBlock) {
            return null;
        }
        Color[] test = new Color[]{this.getColorTable()[this.getBorderLineColorTop()], this.getColorTable()[this.getBorderLineColorLeft()], this.getColorTable()[this.getBorderLineColorBottom()], this.getColorTable()[this.getBorderLineColorRight()]};
        return test;
    }

    public int[] getAllBorderColors() {
        if (!this.bHasBorderBlock) {
            return null;
        }
        int[] test = new int[]{this.getBorderLineColorTop(), this.getBorderLineColorLeft(), this.getBorderLineColorBottom(), this.getBorderLineColorRight()};
        return test;
    }

    public int[] getBorderStyles() {
        if (!this.bHasBorderBlock) {
            return null;
        }
        int[] test = new int[]{this.getBorderLineStylesTop(), this.getBorderLineStylesLeft(), this.getBorderLineStylesBottom(), this.getBorderLineStylesRight(), -1};
        return test;
    }

    public int[] getBorderSizes() {
        if (!this.bHasBorderBlock) {
            return null;
        }
        boolean hasTop = this.getBorderLineStylesTop() > 0;
        boolean hasLeft = this.getBorderLineStylesLeft() > 0;
        boolean hasBottom = this.getBorderLineStylesBottom() > 0;
        boolean hasRight = this.getBorderLineStylesRight() > 0;
        int[] nArray = new int[5];
        nArray[0] = hasTop ? 1 : 0;
        nArray[1] = hasLeft ? 1 : 0;
        nArray[2] = hasBottom ? 1 : 0;
        nArray[3] = hasRight ? 1 : 0;
        int[] test = nArray;
        return test;
    }

    public int getForegroundColor() {
        if (!this.bHasPatternBlock) {
            return -1;
        }
        if (this.fill != null) {
            return this.fill.getFgColorAsInt(this.getWorkBook().getTheme());
        }
        if (this.patternFillStyle == 1) {
            return this.patternFillColorBack;
        }
        return this.patternFillColor;
    }

    public int getFontOptsPosture() {
        return (short)(this.fontOptsFlag & 2);
    }

    public void setFontOptsPosture(int fontOptsPosture) {
        this.fontOptsFlag = (short)(this.fontOptsFlag & 2);
        this.bHasFontBlock = true;
    }

    public int getFontOptsCancellation() {
        return (short)((this.fontOptsFlag & 0x80) >> 7);
    }

    public boolean getFontItalic() {
        return (this.fontOptsFlag & 2) == 1;
    }

    public void setFontItalic(boolean italic) {
        if (italic) {
            this.fontOptsFlag |= 2;
            this.fontModifiedOptionsFlag |= 2;
            this.bHasFontBlock = true;
        } else {
            this.fontOptsFlag ^= 2;
            this.fontModifiedOptionsFlag ^= 2;
        }
        if (this.font != null) {
            this.font.setItalic(italic);
        }
    }

    public boolean getFontStriken() {
        return (this.fontOptsFlag & 0x80) == 1;
    }

    public void setFontStriken(boolean bStriken) {
        if (bStriken) {
            this.fontOptsFlag |= 0x80;
            this.fontModifiedOptionsFlag |= 0x80;
            this.bHasFontBlock = true;
        } else {
            this.fontOptsFlag ^= 0x80;
            this.fontModifiedOptionsFlag ^= 0x80;
        }
        if (this.font != null) {
            this.font.setStricken(bStriken);
        }
    }

    public boolean getFontEscapementSuper() {
        return this.fontEscapementFlag == 1;
    }

    public void setFontEscapementSuper() {
        this.fontEscapementFlag = 1;
        this.fontEscapementFlagModifiedFlag = 0;
        this.bHasFontBlock = true;
    }

    public boolean getFontEscapementSub() {
        return this.fontEscapementFlag == 2;
    }

    public void setFontEscapementSub() {
        this.fontEscapementFlag = 2;
        this.fontEscapementFlagModifiedFlag = 0;
        this.bHasFontBlock = true;
    }

    public int getBorderLineStylesLeft() {
        return this.borderLineStylesLeft;
    }

    public void setBorderLineStylesLeft(int b) {
        this.borderLineStylesLeft = b;
        this.updateBorderLineStylesFlag();
    }

    public int getBorderLineStylesRight() {
        return this.borderLineStylesRight;
    }

    public void setBorderLineStylesRight(int b) {
        this.borderLineStylesRight = b;
        this.updateBorderLineStylesFlag();
    }

    public int getBorderLineStylesTop() {
        return this.borderLineStylesTop;
    }

    public void setBorderLineStylesTop(int b) {
        this.borderLineStylesTop = b;
        this.updateBorderLineStylesFlag();
    }

    public int getBorderLineStylesBottom() {
        return this.borderLineStylesBottom;
    }

    public void setBorderLineStylesBottom(int b) {
        this.borderLineStylesBottom = b;
        this.updateBorderLineStylesFlag();
    }

    public int getBorderLineColorLeft() {
        if (this.borderLineColorLeft > this.getColorTable().length) {
            return 0;
        }
        if (this.borderLineColorLeft < 0) {
            return 0;
        }
        return this.borderLineColorLeft;
    }

    public void setBorderLineColorLeft(int borderLineColorLeft) {
        this.borderLineColorLeft = borderLineColorLeft;
        this.flags &= 0x3FF;
        this.updateBorderLineColorsFlag();
    }

    public int getBorderLineColorRight() {
        if (this.borderLineColorRight > this.getColorTable().length) {
            return 0;
        }
        if (this.borderLineColorRight < 0) {
            return 0;
        }
        return this.borderLineColorRight;
    }

    public void setBorderLineColorRight(int borderLineColorRight) {
        this.borderLineColorRight = borderLineColorRight;
        this.flags &= 0x7FF;
        this.updateBorderLineColorsFlag();
    }

    public int getBorderLineColorTop() {
        if (this.borderLineColorTop > this.getColorTable().length) {
            return 0;
        }
        if (this.borderLineColorTop < 0) {
            return 0;
        }
        return this.borderLineColorTop;
    }

    public void setBorderLineColorTop(int b) {
        this.borderLineColorTop = b;
        this.flags &= 0xFFF;
        this.updateBorderLineColorsFlag();
        if (this.borderLineColorTop != b) {
            Logger.logWarn("setBorderLineColorTop failed");
        }
    }

    public int getBorderLineColorBottom() {
        if (this.borderLineColorBottom > this.getColorTable().length) {
            return 0;
        }
        if (this.borderLineColorBottom < 0) {
            return 0;
        }
        return this.borderLineColorBottom;
    }

    public void setBorderLineColorBottom(int b) {
        this.borderLineColorBottom = b;
        this.flags &= 0x1FFF;
        this.updateBorderLineColorsFlag();
        if (this.borderLineColorBottom != b) {
            Logger.logWarn("borderLineColorBottom failed");
        }
    }

    public int getPatternFillStyle() {
        return this.patternFillStyle;
    }

    public void setPatternFillStyle(int p) {
        this.patternFillStyle = p;
        this.bHasPatternBlock = true;
    }

    public int getPatternFillColor() {
        if (this.fill != null) {
            return this.fill.getFgColorAsInt(this.getWorkBook().getTheme());
        }
        return this.patternFillColor;
    }

    public void setPatternFillColor(int p, String custom) {
        this.patternFillColor = p;
        if (this.fill != null) {
            this.fill.setFgColor(p);
        }
        this.updatePatternFillColorsFlag();
    }

    public int getPatternFillColorBack() {
        if (this.fill != null) {
            return this.fill.getBgColorAsInt(this.getWorkBook().getTheme());
        }
        return this.patternFillColorBack;
    }

    public void setPatternFillColorBack(int p) {
        this.patternFillColorBack = p;
        if (this.fill != null) {
            this.fill.setBgColor(p);
        }
        this.updatePatternFillColorsFlag();
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public void setFontHeight(int fontHeight) {
        this.fontHeight = fontHeight;
        this.bHasFontBlock = true;
        if (this.font != null) {
            this.font.setFontHeight(fontHeight);
        }
    }

    public int getFontWeight() {
        return this.fontWeight;
    }

    public void setFontWeight(int f) {
        this.fontWeight = f;
        this.fontOptsFlag &= 0xFD;
        this.bHasFontBlock = true;
        if (this.font != null) {
            this.font.setFontWeight(f);
        }
    }

    public int getFontUnderlineStyle() {
        return this.fontUnderlineStyle;
    }

    public void setFontUnderlineStyle(int fontUnderlineStyle) {
        this.fontUnderlineStyle = fontUnderlineStyle;
        this.fontUnderlineModifiedFlag = 0;
        this.bHasFontBlock = true;
        if (this.font != null) {
            this.font.setUnderlineStyle((byte)fontUnderlineStyle);
        }
    }

    public int getFontColorIndex() {
        return this.fontColorIndex;
    }

    public void setFontColorIndex(int fontColorIndex) {
        this.fontColorIndex = fontColorIndex;
        this.bHasFontBlock = true;
        if (this.font != null) {
            this.font.setColor(fontColorIndex);
        }
    }

    protected static XLSRecord getPrototype() {
        Cf cf = new Cf();
        cf.setOpcode((short)433);
        cf.setData(cf.PROTOTYPE_BYTES);
        cf.init();
        return cf;
    }

    private void resetFormulaRef() {
        Stack expr = this.getFormula1().getExpression();
        Iterator itx = expr.iterator();
        if (this.refPos > -1) {
            expr.insertElementAt(this.prefHolder, this.refPos);
        }
    }

    private void setFormulaRef(Ptg refcell) throws FormulaNotFoundException {
        Stack expr = this.getFormula1().getExpression();
        Iterator itx = expr.iterator();
        int[] rc = refcell.getIntLocation();
        if (this.refPos == -1) {
            while (itx.hasNext()) {
                Ptg prex = (Ptg)itx.next();
                if (!(prex instanceof PtgRefN)) continue;
                ((PtgRefN)prex).setFormulaRow(rc[0]);
                ((PtgRefN)prex).setFormulaCol(rc[1]);
            }
        } else {
            expr.remove(this.refPos);
        }
        if (this.refPos > -1) {
            expr.remove(this.prefHolder);
            expr.insertElementAt(refcell, this.refPos);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean evaluate(Ptg refcell) {
        try {
            Object val2 = null;
            Object val1 = null;
            if (this.cp != 0) {
                val1 = this.getFormula1().calculateFormula();
            }
            if (this.cce2 > 0) {
                val2 = this.getFormula2().calculateFormula();
            }
            Object valX = refcell.getValue();
            double d1 = 0.0;
            double d2 = 0.0;
            double dX = 0.0;
            try {
                d1 = new Double(val1.toString());
                dX = new Double(valX.toString());
                if (this.cce2 > 0) {
                    d2 = new Double(val2.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (this.cp) {
                case 0: {
                    this.setFormulaRef(refcell);
                    val1 = this.getFormula1().calculateFormula();
                    return (Boolean)val1;
                }
                case 1: {
                    return dX >= d1 && dX <= d2;
                }
                case 5: {
                    return dX > d1;
                }
                case 2: {
                    if (dX < d1) {
                        return false;
                    }
                    if (dX > d1) {
                        return false;
                    }
                }
                case 6: {
                    return dX < d1;
                }
                case 3: {
                    return dX == d1;
                }
                case 7: {
                    return dX >= d1;
                }
                case 4: {
                    return dX != d1;
                }
                case 8: {
                    return dX <= d1;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    return false;
                }
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static final byte getConditionFromString(String cx) {
        cx = StringTool.allTrim(cx);
        if ((cx = cx.toUpperCase()).equals("BETWEEN")) {
            return 1;
        }
        if (cx.equals("GREATER THAN")) {
            return 5;
        }
        if (cx.equals("NOT BETWEEN")) {
            return 2;
        }
        if (cx.equals("LESS THAN")) {
            return 6;
        }
        if (cx.equals("EQUALS")) {
            return 3;
        }
        if (cx.equals("GREATER THAN OR EQUAL")) {
            return 7;
        }
        if (cx.equals("NOT EQUAL")) {
            return 4;
        }
        if (cx.equals("LESS THAN OR EQUAL")) {
            return 8;
        }
        return 0;
    }

    public String getConditionString() {
        switch (this.cp) {
            case 0: {
                return String.valueOf(this.expression1.toString()) + this.expression2.toString();
            }
            case 1: {
                return "Between";
            }
            case 5: {
                return "Greater Than";
            }
            case 2: {
                return "Not Between";
            }
            case 6: {
                return "Less Than";
            }
            case 3: {
                return "Equals";
            }
            case 7: {
                return "Greater Than or Equal";
            }
            case 4: {
                return "Not Equal";
            }
            case 8: {
                return "Less Than or Equal";
            }
            case 9: {
                return "Begins With";
            }
            case 10: {
                return "Ends With";
            }
            case 11: {
                return "Contains Text";
            }
            case 12: {
                return "Not Contains";
            }
        }
        return "Unknown";
    }

    public Formula getFormula1() {
        if (this.formula1 == null) {
            this.formula1 = new Formula();
            this.formula1.setWorkBook(this.getWorkBook());
            if (this.getSheet() == null) {
                this.setSheet(this.condfmt.getSheet());
            }
            this.formula1.setSheet(this.getSheet());
            this.formula1.setExpression(this.expression1);
        }
        return this.formula1;
    }

    public Formula getFormula2() {
        if (this.formula2 == null && this.cce2 > 0) {
            this.formula2 = new Formula();
            this.formula2.setWorkBook(this.getWorkBook());
            if (this.getSheet() == null) {
                this.setSheet(this.condfmt.getSheet());
            }
            this.formula2.setSheet(this.getSheet());
            this.formula2.setExpression(this.expression2);
        }
        if (this.formula2 != null) {
            this.formula2.setSheet(this.getSheet());
        }
        return this.formula2;
    }

    private static String unescapeFormulaString(String fmx) {
        fmx = StringTool.replaceText(fmx, "&quot;", "\"");
        fmx = StringTool.replaceText(fmx, "&lt;", "<");
        fmx = StringTool.replaceText(fmx, "&gt;", ">");
        return fmx;
    }

    protected static int translateOperator(String operator) {
        if (operator == null) {
            return 0;
        }
        if (operator.equals("between")) {
            return 1;
        }
        if (operator.equals("greaterThan")) {
            return 5;
        }
        if (operator.equals("notBetween")) {
            return 2;
        }
        if (operator.equals("lessThan")) {
            return 6;
        }
        if (operator.equals("equal")) {
            return 3;
        }
        if (operator.equals("greaterThanOrEqual")) {
            return 7;
        }
        if (operator.equals("notEqual")) {
            return 4;
        }
        if (operator.equals("lessThanOrEqual")) {
            return 8;
        }
        if (operator.equals("beginsWith")) {
            return 9;
        }
        if (operator.equals("endsWith")) {
            return 10;
        }
        if (operator.equals("containsText")) {
            return 11;
        }
        if (operator.equals("notContains")) {
            return 12;
        }
        return 0;
    }

    protected static String translateType(int type) {
        switch (type) {
            case 1: {
                return "Cell Is";
            }
            case 2: {
                return "expression";
            }
            case 3: {
                return "containsText";
            }
            case 4: {
                return "aboveAverage";
            }
            case 5: {
                return "beginsWith";
            }
            case 6: {
                return "colorScale";
            }
            case 7: {
                return "containsBlanks";
            }
            case 8: {
                return "containsErrors";
            }
            case 9: {
                return "dataBar";
            }
            case 10: {
                return "duplicateValues";
            }
            case 11: {
                return "endsWith";
            }
            case 12: {
                return "iconSet";
            }
            case 13: {
                return "notContainsBlanks";
            }
            case 14: {
                return "notContainsErrors";
            }
            case 15: {
                return "notContainsText";
            }
            case 16: {
                return "timePeriod";
            }
            case 17: {
                return "top10";
            }
            case 18: {
                return "uniqueValues";
            }
        }
        return "Unknnown";
    }

    protected static int translateOOXMLType(String type) {
        if (type.equals("cellIs")) {
            return 1;
        }
        if (type.equals("expression")) {
            return 2;
        }
        if (type.equals("containsText")) {
            return 3;
        }
        if (type.equals("aboveAverage")) {
            return 4;
        }
        if (type.equals("beginsWith")) {
            return 5;
        }
        if (type.equals("colorScale")) {
            return 6;
        }
        if (type.equals("containsBlanks")) {
            return 7;
        }
        if (type.equals("containsErrors")) {
            return 8;
        }
        if (type.equals("dataBar")) {
            return 9;
        }
        if (type.equals("duplicateValues")) {
            return 10;
        }
        if (type.equals("endsWith")) {
            return 11;
        }
        if (type.equals("iconSet")) {
            return 12;
        }
        if (type.equals("notContainsBlanks")) {
            return 13;
        }
        if (type.equals("notContainsErrors")) {
            return 14;
        }
        if (type.equals("notContainsText")) {
            return 15;
        }
        if (type.equals("timePeriod")) {
            return 16;
        }
        if (type.equals("top10")) {
            return 17;
        }
        if (type.equals("uniqueValues")) {
            return 18;
        }
        return 1;
    }

    private static String escapeFormulaString(String fmx) {
        if ((fmx = StringTool.replaceText(fmx, "\"", "&quot;")).indexOf("=") == 0) {
            fmx = fmx.substring(1);
        }
        fmx = StringTool.replaceText(fmx, "<", "&lt;");
        fmx = StringTool.replaceText(fmx, ">", "&gt;");
        return fmx;
    }

    public String getXML() {
        return Cf.getXML(this);
    }

    private static final String getXML(Cf cfx) {
        String fsi2;
        if (cfx.refPos > -1) {
            cfx.resetFormulaRef();
        }
        StringBuffer xml = new StringBuffer();
        xml.append("<Range>");
        CellRange rn = new CellRange(cfx.getCondfmt().getBoundingRange());
        if (rn != null) {
            xml.append(rn.getR1C1Range());
        }
        xml.append("</Range>");
        xml.append("<Condition>");
        if (cfx.cp != 0) {
            xml.append("<Qualifier>");
            xml.append(cfx.getConditionString());
            xml.append("</Qualifier>");
        }
        if (cfx.cp != 0) {
            xml.append("<Value1>");
            Object val1 = cfx.getFormula1().calculateFormula();
            if (val1 == null) {
                xml.append("");
            } else {
                xml.append(val1.toString());
            }
            xml.append("</Value1>");
        } else {
            xml.append("<Value1>");
            String fmx = cfx.getFormula1().getFormulaString();
            fmx = Cf.escapeFormulaString(fmx);
            xml.append(fmx);
            xml.append("</Value1>");
        }
        if (cfx.cce2 > 0) {
            Object val2 = cfx.getFormula2().calculateFormula();
            xml.append("<Value2>");
            if (val2 == null) {
                xml.append("");
            } else {
                xml.append(val2.toString());
            }
            xml.append("</Value2>");
        }
        xml.append("<Format Style='");
        int cfi = cfx.getPatternFillColor();
        if (cfi > -1) {
            fsi2 = FormatHandle.colorToHexString(FormatHandle.getColor(cfi));
            xml.append("color:" + fsi2 + ";");
        }
        if (cfx.getFontWeight() > -1) {
            xml.append("font-weight:" + cfx.getFontWeight() + ";");
        }
        if (cfx.getFontOptsCancellation() > -1) {
            if (cfx.getFontOptsCancellation() == 0) {
                xml.append("text-line-through:none;");
            } else {
                xml.append("text-line-through:" + cfx.getFontOptsCancellation() + ";");
            }
        }
        if (cfx.getBorderSizes() != null) {
            try {
                xml.append("border-top:" + cfx.getBorderSizes()[0] + " " + FormatHandle.BORDER_NAMES[cfx.getBorderStyles()[0] + 1] + " " + FormatHandle.colorToHexString(cfx.getBorderColors()[0]) + ";");
                xml.append("border-left:" + cfx.getBorderSizes()[1] + " " + FormatHandle.BORDER_NAMES[cfx.getBorderStyles()[1] + 1] + " " + FormatHandle.colorToHexString(cfx.getBorderColors()[1]) + ";");
                xml.append("border-bottom:" + cfx.getBorderSizes()[2] + " " + FormatHandle.BORDER_NAMES[cfx.getBorderStyles()[2] + 1] + " " + FormatHandle.colorToHexString(cfx.getBorderColors()[2]) + ";");
                xml.append("border-right:" + cfx.getBorderSizes()[3] + " " + FormatHandle.BORDER_NAMES[cfx.getBorderStyles()[3] + 1] + " " + FormatHandle.colorToHexString(cfx.getBorderColors()[3]) + ";");
            }
            catch (ArrayIndexOutOfBoundsException fsi2) {
                // empty catch block
            }
        }
        if ((cfi = cfx.getPatternFillColorBack()) > -1) {
            fsi2 = FormatHandle.colorToHexString(FormatHandle.getColor(cfi));
            xml.append("background:" + fsi2 + ";");
        }
        xml.append("'/>");
        xml.append("</Condition>");
        return xml.toString();
    }

    public static Cf parseXML(XmlPullParser xpp, Condfmt cfx, Boundsheet bs) {
        Cf oe = bs.createCf(cfx);
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("Condition")) {
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            String n = xpp.getAttributeName(i);
                            String v = xpp.getAttributeValue(i);
                            if (n.equals("Qualifier")) {
                                oe.setOperator(v);
                            } else if (n.equals("Value1")) {
                                oe.setCondition1(v);
                            } else if (n.equals("Value2")) {
                                oe.setCondition2(v);
                            } else if (n.equals("Format")) {
                                Cf.setStylePropsFromString(v, oe);
                            }
                            ++i;
                        }
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("Condition")) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("Cf.parseXML: " + e.toString());
        }
        return oe;
    }

    public void setContainsText(String s) {
        this.containsText = s;
    }

    public String getOOXML(WorkBookHandle bk, int priority, ArrayList dxfs) {
        StringBuffer ooxml = new StringBuffer();
        Dxf dxf = new Dxf();
        if (this.bHasFontBlock) {
            if (this.font != null) {
                dxf.setFont(this.font);
            } else {
                dxf.createFont(this.fontWeight, this.getFontItalic(), this.fontUnderlineStyle, this.fontColorIndex, this.fontHeight);
            }
        }
        if (this.bHasPatternBlock) {
            if (this.fill != null) {
                dxf.setFill(this.fill);
            } else {
                dxf.createFill(this.patternFillStyle, this.patternFillColor, this.patternFillColorBack, bk);
            }
        }
        if (this.bHasBorderBlock) {
            dxf.createBorder(bk, this.getBorderStyles(), new int[]{this.getBorderLineColorTop(), this.getBorderLineColorLeft(), this.getBorderLineColorBottom(), this.getBorderLineColorRight()});
        }
        dxfs.add(dxf);
        int dxfId = dxfs.size() - 1;
        ooxml.append("<cfRule dxfId=\"" + dxfId + "\"");
        switch (this.ct) {
            case 1: {
                ooxml.append(" type=\"cellIs\"");
                break;
            }
            case 2: {
                ooxml.append(" type=\"expression\"");
                break;
            }
            case 3: {
                ooxml.append(" type=\"containsText\"");
                break;
            }
            case 4: {
                ooxml.append(" type=\"aboveAverage\"");
                break;
            }
            case 5: {
                ooxml.append(" type=\"beginsWith\"");
                break;
            }
            case 6: {
                ooxml.append(" type=\"colorScale\"");
                break;
            }
            case 7: {
                ooxml.append(" type=\"containsBlanks\"");
                break;
            }
            case 8: {
                ooxml.append(" type=\"containsErrors\"");
                break;
            }
            case 9: {
                ooxml.append(" type=\"dataBar\"");
                break;
            }
            case 10: {
                ooxml.append(" type=\"duplicateValues\"");
                break;
            }
            case 11: {
                ooxml.append(" type=\"endsWith\"");
                break;
            }
            case 12: {
                ooxml.append(" type=\"iconSet\"");
                break;
            }
            case 13: {
                ooxml.append(" type=\"notContainsBlanks\"");
                break;
            }
            case 14: {
                ooxml.append(" type=\"notContainsErrors\"");
                break;
            }
            case 15: {
                ooxml.append(" type=\"notContainsText\"");
                break;
            }
            case 16: {
                ooxml.append(" type=\"timePeriod\"");
                break;
            }
            case 17: {
                ooxml.append(" type=\"top10\"");
                break;
            }
            case 18: {
                ooxml.append(" type=\"uniqueValues\"");
            }
        }
        if (this.ct == 3 && this.containsText != null) {
            ooxml.append(" text=\"" + this.containsText + "\"");
        }
        switch (this.cp) {
            case 1: {
                ooxml.append(" operator=\"between\"");
                break;
            }
            case 5: {
                ooxml.append(" operator=\"greaterThan\"");
                break;
            }
            case 2: {
                ooxml.append(" operator=\"notBetween\"");
                break;
            }
            case 6: {
                ooxml.append(" operator=\"lessThan\"");
                break;
            }
            case 3: {
                ooxml.append(" operator=\"equal\"");
                break;
            }
            case 7: {
                ooxml.append(" operator=\"greaterThanOrEqual\"");
                break;
            }
            case 4: {
                ooxml.append(" operator=\"notEqual\"");
                break;
            }
            case 8: {
                ooxml.append(" operator=\"lessThanOrEqual\"");
                break;
            }
            case 9: {
                ooxml.append(" operator=\"beginsWith\"");
                break;
            }
            case 10: {
                ooxml.append(" operator=\"endsWith\"");
                break;
            }
            case 11: {
                ooxml.append(" operator=\"containsText\"");
                break;
            }
            case 12: {
                ooxml.append(" operator=\"notContains\"");
            }
        }
        ooxml.append(" priority=\"" + priority + "\"");
        ooxml.append(" stopIfTrue=\"1\"");
        ooxml.append(">");
        if (this.getFormula1() != null) {
            ooxml.append("<formula>" + OOXMLAdapter.stripNonAsciiRetainQuote(this.getFormula1().getFormulaString()).substring(1) + "</formula>");
        }
        if (this.getFormula2() != null) {
            ooxml.append("<formula>" + OOXMLAdapter.stripNonAsciiRetainQuote(this.getFormula2().getFormulaString()).substring(1) + "</formula>");
        }
        ooxml.append("</cfRule>");
        return ooxml.toString();
    }
}

