/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.formats.XLS.ColumnRange;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;

public final class Colinfo
extends XLSRecord
implements ColumnRange {
    private static final long serialVersionUID = 3048724897018541459L;
    public static final int DEFAULT_COLWIDTH = 2340;
    private int colFirst;
    private int colLast;
    private int colWidth;
    private short grbit;
    private boolean collapsed;
    private boolean hidden;
    private int outlineLevel = 0;
    private static double fudgefactor = 0.711;

    public void setColFirst(int c) {
        byte[] b = ByteTools.shortToLEBytes((short)c);
        byte[] dt = this.getData();
        System.arraycopy(b, 0, dt, 0, 2);
        this.colFirst = c;
    }

    @Override
    public int getColFirst() {
        return this.colFirst;
    }

    public void setColLast(int c) {
        byte[] b = ByteTools.shortToLEBytes((short)c);
        byte[] dt = this.getData();
        System.arraycopy(b, 0, dt, 2, 2);
        this.colLast = c;
    }

    @Override
    public int getColLast() {
        return this.colLast;
    }

    public void moveColInfo(int offset) {
        this.setColFirst(this.getColFirst() + offset);
        this.setColLast(this.getColLast() + offset);
    }

    @Override
    public void init() {
        super.init();
        this.colFirst = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        this.colLast = ByteTools.readShort(this.getByteAt(2), this.getByteAt(3));
        this.colWidth = ByteTools.readShort(this.getByteAt(4), this.getByteAt(5));
        this.ixfe = ByteTools.readShort(this.getByteAt(6), this.getByteAt(7));
        this.grbit = ByteTools.readShort(this.getByteAt(8), this.getByteAt(9));
        this.decodeGrbit();
        if (this.DEBUGLEVEL > 5) {
            Logger.logInfo("Col: " + ExcelTools.getAlphaVal(this.colFirst) + "-" + ExcelTools.getAlphaVal(this.colLast) + "  ixfe: " + String.valueOf(this.ixfe) + " width: " + this.colWidth);
        }
    }

    public static Colinfo getPrototype(int colF, int colL, int wide, int formatIdx) {
        Colinfo ret = new Colinfo();
        ret.originalsize = 12;
        ret.setOpcode((short)125);
        ret.setLength((short)ret.originalsize);
        byte[] newbytes = new byte[ret.originalsize];
        byte[] b = ByteTools.shortToLEBytes((short)colF);
        newbytes[0] = b[0];
        newbytes[1] = b[1];
        b = ByteTools.shortToLEBytes((short)colL);
        newbytes[2] = b[0];
        newbytes[3] = b[1];
        b = ByteTools.shortToLEBytes((short)wide);
        newbytes[4] = b[0];
        newbytes[5] = b[1];
        b = ByteTools.shortToLEBytes((short)formatIdx);
        newbytes[6] = b[0];
        newbytes[7] = b[1];
        ret.setData(newbytes);
        ret.init();
        return ret;
    }

    public boolean isSingleColColinfo() {
        return this.getColFirst() == this.getColLast();
    }

    public boolean inrange(int x) {
        return x <= this.colLast && x >= this.colFirst;
    }

    public void setColWidthInChars(double x) {
        x = (double)((int)(x + fudgefactor)) * 256.0;
        byte[] cl = ByteTools.shortToLEBytes((short)x);
        System.arraycopy(cl, 0, this.getData(), 4, 2);
        this.colWidth = ByteTools.readShort(this.getData()[4], this.getData()[5]);
        if (this.grbit == 0) {
            this.setGrbit(2);
        }
    }

    public void setColWidth(int x) {
        byte[] cl = ByteTools.shortToLEBytes((short)x);
        System.arraycopy(cl, 0, this.getData(), 4, 2);
        this.colWidth = ByteTools.readUnsignedShort(this.getData()[4], this.getData()[5]);
        if (this.grbit == 0) {
            this.setGrbit(2);
        }
    }

    public int getColWidth() {
        return this.colWidth;
    }

    public int getColWidthInChars() {
        int colwidth = this.getColWidth();
        colwidth = (int)Math.round(((double)colwidth - fudgefactor) / 256.0);
        return colwidth;
    }

    public void setCollapsed(boolean b) {
        this.collapseIt(b);
        int i = 0;
        while (i < this.colFirst) {
            Colinfo r2 = this.getSheet().getColInfo(i);
            if (r2 != null && r2.getOutlineLevel() == this.getOutlineLevel()) {
                r2.setHidden(b);
            }
            ++i;
        }
    }

    private void collapseIt(boolean b) {
        this.collapsed = b;
        this.updateGrbit();
    }

    public void setHidden(boolean b) {
        this.hidden = b;
        this.updateGrbit();
        this.getWorkBook().getUsersviewbegin().setDisplayOutlines(true);
    }

    public void setOutlineLevel(int x) {
        this.outlineLevel = x;
        this.updateGrbit();
        this.getSheet().getGuts().setColGutterSize(10 + 10 * x);
        this.getSheet().getGuts().setMaxColLevel(x + 1);
    }

    private void decodeGrbit() {
        byte[] grbytes = ByteTools.shortToLEBytes(this.grbit);
        this.hidden = (grbytes[0] & 1) == 1;
        this.collapsed = (grbytes[1] & 0x10) == 16;
        this.outlineLevel = grbytes[1] & 7;
    }

    public int getGrbit() {
        return this.grbit;
    }

    public void setGrbit(int grbit) {
        this.grbit = (short)grbit;
        this.updateGrbit();
    }

    public void updateGrbit() {
        byte[] grbytes = ByteTools.shortToLEBytes(this.grbit);
        grbytes[1] = this.collapsed ? (byte)(0x10 | grbytes[1]) : (byte)(0xEF & grbytes[1]);
        grbytes[0] = this.hidden ? (byte)(1 | grbytes[0]) : (byte)(0xFE & grbytes[0]);
        grbytes[1] = (byte)(this.outlineLevel | grbytes[1]);
        this.grbit = ByteTools.readShort(grbytes[0], grbytes[1]);
        byte[] recdata = this.getData();
        recdata[8] = grbytes[0];
        recdata[9] = grbytes[1];
        this.setData(recdata);
    }

    public int getOutlineLevel() {
        return this.outlineLevel;
    }

    @Override
    public int getIxfe() {
        return this.ixfe;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void setIxfe(int i) {
        this.ixfe = i;
        byte[] newxfe = ByteTools.cLongToLEBytes(i);
        byte[] b = this.getData();
        System.arraycopy(newxfe, 0, b, 6, 2);
        this.setData(b);
    }

    @Override
    public String toString() {
        return "ColInfo: " + ExcelTools.getAlphaVal(this.colFirst) + "-" + ExcelTools.getAlphaVal(this.colLast) + "  ixfe: " + String.valueOf(this.ixfe) + " width: " + this.colWidth;
    }

    @Override
    public boolean isSingleCol() {
        return this.getColFirst() == this.getColLast();
    }
}

