/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.XLSConstants;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;

public class DConBin
extends XLSRecord
implements XLSConstants {
    private static final long serialVersionUID = 2639291289806138985L;
    private byte nBuiltin;
    private short cchFile;

    @Override
    public void init() {
        super.init();
        this.nBuiltin = this.getByteAt(0);
        this.cchFile = ByteTools.readShort(this.getByteAt(5), this.getByteAt(6));
        if (this.cchFile > 0) {
            Logger.logWarn("PivotTable: External Workbooks for Built-in Named Range Source are Unspported");
        }
        if (this.DEBUGLEVEL > 3) {
            Logger.logInfo("DCONBIN: nBuiltin:" + this.nBuiltin + " cchFile: " + this.cchFile);
        }
    }

    public int getBuiltInType() {
        return this.nBuiltin;
    }

    public void setBuiltInType(int builtinType) {
        this.getData()[0] = this.nBuiltin = (byte)builtinType;
    }

    public static XLSRecord getPrototype() {
        DConBin db = new DConBin();
        db.setOpcode((short)437);
        db.setData(new byte[6]);
        db.init();
        return db;
    }
}

