/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.XLSConstants;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.io.UnsupportedEncodingException;

public class DConName
extends XLSRecord
implements XLSConstants {
    private static final long serialVersionUID = 2639291289806138985L;
    private short cchFile;
    private String namedRange = null;

    @Override
    public void init() {
        super.init();
        short cch = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        int pos = 1;
        if (cch > 0) {
            byte encoding = this.getByteAt(++pos);
            byte[] tmp = this.getBytesAt(++pos, cch * (encoding + 1));
            try {
                this.namedRange = encoding == 0 ? new String(tmp, "ISO-8859-1") : new String(tmp, "UTF-16LE");
            }
            catch (UnsupportedEncodingException e) {
                Logger.logInfo("encoding PivotTable name in DCONNAME: " + e);
            }
        }
        this.cchFile = ByteTools.readShort(this.getByteAt(pos + cch), this.getByteAt(pos + cch + 1));
        if (this.cchFile > 0) {
            Logger.logWarn("PivotTable: External Workbooks for Named Range Source are Unspported");
        }
        if (this.DEBUGLEVEL > 3) {
            Logger.logInfo("DCONNAME: namedRange:" + this.namedRange + " cchFile: " + this.cchFile);
        }
    }

    public String getNamedRange() {
        return this.namedRange;
    }

    public void setNamedRange(String namedRange) {
        short cch = (short)((short)namedRange.length() + 1);
        this.namedRange = namedRange;
        byte[] data = new byte[3];
        byte[] b = ByteTools.shortToLEBytes(this.cchFile);
        data[0] = b[0];
        data[1] = b[1];
        try {
            data = ByteTools.append(namedRange.getBytes("ISO-8859-1"), data);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        data = ByteTools.append(new byte[2], data);
        this.setData(data);
    }

    public static XLSRecord getPrototype() {
        DConName dn = new DConName();
        dn.setOpcode((short)82);
        dn.setData(new byte[2]);
        dn.init();
        return dn;
    }
}

