/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.Bof;
import com.extentech.formats.XLS.Index;
import com.extentech.formats.XLS.Row;
import com.extentech.formats.XLS.XLSConstants;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.util.Iterator;
import java.util.List;

public final class Dbcell
extends XLSRecord
implements XLSConstants {
    private static final long serialVersionUID = -3169134298616400374L;
    private Bof mybof;
    private byte[] rkdata = new byte[0];
    private int numrecs = -1;
    private int dbRtrw;
    private int dbcnum;
    private short[] rgdb;
    private Index myidx;
    Row[] myrows = new Row[32];
    int rwct = 0;

    void setBof(Bof b) {
        this.mybof = b;
    }

    public void initDbCell(int offsetToFirstRow, List valrecOffsets) {
        byte[] newData = new byte[4 + (valrecOffsets.size() - 1) * 2];
        byte[] firstOffset = ByteTools.cLongToLEBytes(offsetToFirstRow);
        System.arraycopy(firstOffset, 0, newData, 0, 4);
        Iterator it = valrecOffsets.iterator();
        int pointer = 4;
        while (it.hasNext()) {
            Short s = (Short)it.next();
            if (!it.hasNext()) continue;
            short ns = s;
            byte[] b = ByteTools.shortToLEBytes(ns);
            newData[pointer++] = b[0];
            newData[pointer++] = b[1];
        }
        this.setData(newData);
    }

    @Override
    public void setIndex(Index idx) {
        this.myidx = idx;
    }

    boolean addRow(Row r2) {
        this.myrows[this.rwct++] = r2;
        return true;
    }

    public int getdbRtrw() {
        if (this.rwct > 0) {
            Row rw1 = this.myrows[0];
            int i = rw1.getOffset();
            int y = this.getOffset();
            return y - i;
        }
        return -1;
    }

    byte[] getDBCELLPointerPos() {
        int bofpos = this.mybof.offset;
        int thispos = this.offset;
        int diff = thispos - bofpos;
        return ByteTools.cLongToLEBytes(diff);
    }

    public static XLSRecord getPrototype() {
        Dbcell dbc = new Dbcell();
        byte[] dt = new byte[4];
        dbc.originalsize = 4;
        dbc.setData(dt);
        dbc.setOpcode((short)215);
        dbc.setLength(4);
        dbc.init();
        return dbc;
    }

    void setDBCNum(int l) {
        this.dbcnum = l;
    }

    int getDBCNum() {
        return this.dbcnum;
    }

    public int getNumRows() {
        return this.rwct;
    }

    void setIDX(Index indx) {
        this.myidx = indx;
    }

    public Index getIDX() {
        return this.myidx;
    }

    @Override
    public void init() {
        super.init();
        this.dbRtrw = ByteTools.readInt(this.getByteAt(0), this.getByteAt(1), this.getByteAt(2), this.getByteAt(3));
        this.numrecs = (this.getLength() - 8) / 2;
        int pos = 4;
        this.rgdb = new short[this.numrecs];
        int i = 0;
        while (i < this.numrecs) {
            this.rgdb[i] = ByteTools.readShort(this.getByteAt(pos++), this.getByteAt(pos++));
            ++i;
        }
        if (this.DEBUGLEVEL > 10) {
            int t = 0;
            while (t < this.rgdb.length) {
                Logger.logInfo(" rgdb" + t + ":" + String.valueOf(this.rgdb[t]));
                ++t;
            }
            Logger.logInfo(" num idxs: " + String.valueOf(this.numrecs));
        }
    }

    void setDbRtrw(int val) {
        this.dbRtrw = val;
        byte[] b = ByteTools.cLongToLEBytes(val);
        System.arraycopy(b, 0, this.getData(), 0, 4);
    }

    @Override
    public void preStream() {
    }

    @Override
    public void close() {
        super.close();
        this.rgdb = null;
        this.myidx = null;
        this.myrows = null;
    }
}

