/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.Sheet;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;

public class Dimensions
extends XLSRecord {
    private static final long serialVersionUID = 7156425132146869228L;
    int rowFirst = 0;
    int rowLast = 0;
    short colFirst = 0;
    short colLast = 0;

    public void setRowFirst(int c) {
        byte[] b = ByteTools.cLongToLEBytes(++c);
        byte[] dt = this.getData();
        if (dt.length > 4) {
            System.arraycopy(b, 0, dt, 0, 4);
        }
        this.rowFirst = c;
    }

    public int getRowFirst() {
        return this.rowFirst;
    }

    public void setRowLast(int c) {
        byte[] b = ByteTools.cLongToLEBytes(++c);
        byte[] dt = this.getData();
        if (dt.length > 4) {
            System.arraycopy(b, 0, dt, 4, 4);
        }
        this.rowLast = c;
    }

    public int getRowLast() {
        return this.rowLast;
    }

    public void setColFirst(int c) {
        byte[] b = ByteTools.shortToLEBytes((short)c);
        byte[] dt = this.getData();
        if (dt.length > 4) {
            System.arraycopy(b, 0, dt, 8, 2);
        }
        this.colFirst = (short)c;
    }

    public int getColFirst() {
        return this.colFirst;
    }

    public void setColLast(int c) {
        if (++c >= 256 && !this.wkbook.getIsExcel2007()) {
            Logger.logWarn("Dimensions.setColLast column: " + c + " is incompatible with pre Excel2007 versions.");
        }
        if (c >= 16384) {
            c = 16384;
        }
        byte[] b = ByteTools.shortToLEBytes((short)c);
        byte[] dt = this.getData();
        if (dt.length > 4) {
            System.arraycopy(b, 0, dt, 10, 2);
        }
        this.colLast = (short)c;
    }

    public int getColLast() {
        return this.colLast;
    }

    @Override
    public void setSheet(Sheet bs) {
        super.setSheet(bs);
        bs.setDimensions(this);
    }

    @Override
    public void init() {
        super.init();
        this.rowFirst = ByteTools.readInt(this.getByteAt(0), this.getByteAt(1), this.getByteAt(2), this.getByteAt(3));
        this.rowLast = ByteTools.readInt(this.getByteAt(4), this.getByteAt(5), this.getByteAt(6), this.getByteAt(7));
        this.colFirst = ByteTools.readShort(this.getByteAt(8), this.getByteAt(9));
        this.colLast = ByteTools.readShort(this.getByteAt(10), this.getByteAt(11));
        this.getData();
    }

    public void updateDimensions(int row, short col) {
        this.updateRowDimensions(row);
        this.updateColDimension(col);
    }

    public void updateRowDimensions(int row) {
        if (row >= this.rowLast) {
            this.setRowLast(row);
        }
        if (row < this.rowFirst) {
            this.setRowFirst(row);
        }
        if (this.DEBUGLEVEL > 10) {
            String shtnm = this.getSheet().getSheetName();
            Logger.logInfo(String.valueOf(shtnm) + " dimensions: " + this.rowFirst + ":" + this.colFirst + "-" + this.rowLast + ":" + this.colLast);
        }
    }

    public void updateColDimension(short col) {
        if (col > this.colLast) {
            this.setColLast(col);
        } else if (col - 1 < this.colFirst) {
            this.setColFirst(col);
        }
        if (this.DEBUGLEVEL > 10) {
            String shtnm = this.getSheet().getSheetName();
            Logger.logInfo(String.valueOf(shtnm) + " dimensions: " + this.rowFirst + ":" + this.colFirst + "-" + this.rowLast + ":" + this.colLast);
        }
    }
}

