/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.formulas.PtgArea;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.formats.XLS.refPtgComparer;
import com.extentech.formats.XLS.refPtgs;
import com.extentech.toolkit.ByteTools;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;

public class DiscontiguousRefStruct
implements Serializable {
    private static final long serialVersionUID = -7923448634000437926L;
    private refPtgs allrefs = new refPtgs((Comparator)new refPtgComparer());
    XLSRecord parentRec = null;

    public DiscontiguousRefStruct(String ranges, XLSRecord parentRec) {
        this.parentRec = parentRec;
        String[] refs = ranges.split(",");
        int i = 0;
        while (i < refs.length) {
            try {
                if (!refs[i].equals("")) {
                    this.allrefs.add(refs[i], parentRec);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++i;
        }
    }

    public String[] getRefs() {
        String[] s = new String[this.allrefs.size()];
        Iterator ptgs = this.allrefs.values().iterator();
        int i = 0;
        while (ptgs.hasNext()) {
            try {
                PtgRef pr = (PtgRef)ptgs.next();
                s[i++] = pr.getLocation();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s;
    }

    public DiscontiguousRefStruct(byte[] sqrefrec, XLSRecord parentRec) {
        this.parentRec = parentRec;
        int i = 0;
        while (i < sqrefrec.length) {
            byte[] sref = new byte[8];
            System.arraycopy(sqrefrec, i, sref, 0, 8);
            this.allrefs.add(sref, parentRec);
            i += 8;
        }
    }

    public byte[] getRecordData() {
        byte[] retData = new byte[]{};
        Iterator ptgs = this.allrefs.values().iterator();
        while (ptgs.hasNext()) {
            try {
                PtgRef pr = (PtgRef)ptgs.next();
                retData = ByteTools.append(retData, this.getRecordData(pr));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retData;
    }

    public int getNumRefs() {
        return this.allrefs.size();
    }

    public String toString() {
        String result = "[";
        result = String.valueOf(result) + "]";
        return result;
    }

    public void addRef(String range) {
        this.allrefs.add(range, this.parentRec);
    }

    public boolean containsReference(int[] rowcol) {
        return this.allrefs.containsReference(rowcol);
    }

    public int[] getRowColBounds() {
        int[] nArray = new int[4];
        nArray[0] = Integer.MAX_VALUE;
        nArray[1] = Integer.MAX_VALUE;
        int[] retValues = nArray;
        Iterator ptgs = this.allrefs.values().iterator();
        int i = 0;
        while (ptgs.hasNext()) {
            PtgRef pr = (PtgRef)ptgs.next();
            int[] locs = pr.getIntLocation();
            int x = 0;
            while (x < 2) {
                if (locs[x] < retValues[x]) {
                    retValues[x] = locs[x];
                }
                ++x;
            }
            x = 2;
            while (x < 4) {
                if (locs[x] > retValues[x]) {
                    retValues[x] = locs[x];
                }
                ++x;
            }
            ++i;
        }
        return retValues;
    }

    private byte[] getRecordData(PtgRef myPtg) {
        byte[] retData = new byte[]{};
        int[] rc = myPtg.getRowCol();
        if (rc[0] >= 65536) {
            rc[0] = -1;
        }
        if (rc[2] >= 65536) {
            rc[2] = -1;
        }
        retData = ByteTools.append(ByteTools.shortToLEBytes((short)rc[0]), retData);
        retData = ByteTools.append(ByteTools.shortToLEBytes((short)rc[2]), retData);
        retData = ByteTools.append(ByteTools.shortToLEBytes((short)rc[1]), retData);
        retData = ByteTools.append(ByteTools.shortToLEBytes((short)rc[3]), retData);
        return retData;
    }

    class SqRef
    implements Serializable {
        private static final long serialVersionUID = -7923448634000437926L;
        PtgRef myPtg;

        public SqRef(String range, XLSRecord parentRec) {
            if (range != null && !range.equals("")) {
                this.myPtg = new PtgArea(range, parentRec);
                this.myPtg.addToRefTracker();
            }
        }

        public String toString() {
            return this.myPtg.toString();
        }

        public SqRef(PtgRef ptg) {
            this.myPtg = ptg;
        }

        public String getLocation() {
            return this.myPtg.getLocation();
        }

        public boolean contains(int[] rowcol) {
            if (this.myPtg instanceof PtgArea) {
                return ((PtgArea)this.myPtg).contains(rowcol);
            }
            return false;
        }

        public int[] getIntLocation() {
            return this.myPtg.getIntLocation();
        }

        public SqRef(byte[] b, XLSRecord parentRec) {
            short row = ByteTools.readShort(b[0], b[1]);
            short col = ByteTools.readShort(b[4], b[5]);
            int row2 = ByteTools.readShort(b[2], b[3]);
            if (row2 < 0) {
                row2 += 65536;
            }
            short col2 = ByteTools.readShort(b[6], b[7]);
            int[] rc = new int[]{row, col, row2, col2};
            boolean[] bool = new boolean[]{true, true, true, true};
            String location = ExcelTools.formatRangeRowCol(rc, bool);
            this.myPtg = new PtgArea(location, parentRec);
            this.myPtg.addToRefTracker();
        }

        public byte[] getRecordData() {
            byte[] retData = new byte[]{};
            int[] rc = this.myPtg.getRowCol();
            if (rc[0] >= 65536) {
                rc[0] = -1;
            }
            if (rc[2] >= 65536) {
                rc[2] = -1;
            }
            retData = ByteTools.append(ByteTools.shortToLEBytes((short)rc[0]), retData);
            retData = ByteTools.append(ByteTools.shortToLEBytes((short)rc[2]), retData);
            retData = ByteTools.append(ByteTools.shortToLEBytes((short)rc[1]), retData);
            retData = ByteTools.append(ByteTools.shortToLEBytes((short)rc[3]), retData);
            return retData;
        }
    }
}

