/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.DateConverter;
import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.ExpressionParser;
import com.extentech.formats.XLS.Formula;
import com.extentech.formats.XLS.OOXMLAdapter;
import com.extentech.formats.XLS.Unicodestring;
import com.extentech.formats.XLS.ValidationException;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.formulas.FormulaParser;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgArea;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import com.extentech.toolkit.StringTool;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

public class Dv
extends XLSRecord {
    private static final long serialVersionUID = -7895028832113540094L;
    private int grbit;
    private Unicodestring dTitlePrompt;
    private Unicodestring dTitleError;
    private Unicodestring dTextPrompt;
    private Unicodestring dTextError;
    private Stack firstCond;
    private Stack secondCond;
    private ArrayList cRangeList;
    private byte[] garbageByteOne = new byte[2];
    private byte[] garbageByteTwo = new byte[2];
    byte numLocs;
    private byte valType;
    private byte errStyle;
    private boolean fStrLookup;
    private boolean fAllowBlank;
    private boolean fSuppressCombo;
    private boolean fShowInputMsg;
    private boolean fShowErrMsg;
    private short IMEMode;
    private byte typOperator;
    private boolean dirtyflag = false;
    private byte[] PROTOTYPE_BYTES;
    private static final int BITMASK_VALTYPE = 15;
    private static final int BITMASK_ERRSTYLE = 112;
    private static final int BITMASK_FSTRLOOKUP = 128;
    private static final int BITMASK_FALLOWBLANK = 256;
    private static final int BITMASK_FSUPRESSCOMBO = 512;
    private static final int BITMASK_MDIMEMODE = 261120;
    private static final int BITMASK_FSHOWINPUTMSG = 262144;
    private static final int BITMASK_FSHOWERRORMSG = 524288;
    private static final int BITMASK_TYPOPERATOR = 0xF00000;
    private String[] ooxmlranges;

    public Dv() {
        byte[] byArray = new byte[38];
        byArray[0] = 3;
        byArray[1] = 1;
        byArray[2] = 12;
        byArray[4] = 1;
        byArray[8] = 1;
        byArray[12] = 1;
        byArray[16] = 1;
        byArray[28] = 1;
        byArray[34] = 1;
        byArray[36] = 1;
        this.PROTOTYPE_BYTES = byArray;
        this.ooxmlranges = null;
    }

    public boolean isValid(Object value) throws ValidationException {
        if (value == null) {
            throw new ValidationException(this.getErrorBoxTitle(), this.getErrorBoxText());
        }
        if (!this.isCorrectDataType(value)) {
            throw new ValidationException(this.getErrorBoxTitle(), this.getErrorBoxText());
        }
        if (value instanceof Date) {
            double d = DateConverter.getXLSDateVal((Date)value);
            value = String.valueOf(d);
        }
        switch (this.typOperator) {
            case 0: {
                if (this.isBetween(value)) {
                    return true;
                }
                throw new ValidationException(this.getErrorBoxTitle(), this.getErrorBoxText());
            }
            case 1: {
                if (this.isNotBetween(value)) {
                    return true;
                }
                throw new ValidationException(this.getErrorBoxTitle(), this.getErrorBoxText());
            }
            case 2: {
                if (this.isEqual(value)) {
                    return true;
                }
                throw new ValidationException(this.getErrorBoxTitle(), this.getErrorBoxText());
            }
            case 4: {
                if (this.isGreaterThan(value)) {
                    return true;
                }
                throw new ValidationException(this.getErrorBoxTitle(), this.getErrorBoxText());
            }
            case 6: {
                if (this.isGreaterOrEqual(value)) {
                    return true;
                }
                throw new ValidationException(this.getErrorBoxTitle(), this.getErrorBoxText());
            }
            case 7: {
                if (this.isLessOrEqual(value)) {
                    return true;
                }
                throw new ValidationException(this.getErrorBoxTitle(), this.getErrorBoxText());
            }
            case 5: {
                if (this.isGreaterOrEqual(value)) {
                    return true;
                }
                throw new ValidationException(this.getErrorBoxTitle(), this.getErrorBoxText());
            }
            case 3: {
                if (this.isNotEqual(value)) {
                    return true;
                }
                throw new ValidationException(this.getErrorBoxTitle(), this.getErrorBoxText());
            }
        }
        return true;
    }

    private boolean isBetween(Object value) {
        String s1 = StringTool.strip(FormulaParser.getExpressionString(this.firstCond), "=");
        String s2 = StringTool.strip(FormulaParser.getExpressionString(this.secondCond), "=");
        String formulaStr = "=and(" + value.toString() + ">" + s1 + "," + s2 + ">" + value.toString() + ")";
        try {
            Formula f = FormulaParser.getFormulaFromString(formulaStr, this.getWorkBook().getWorkSheetByNumber(0), new int[]{1, 1});
            f.setCachedValue(null);
            Object o = f.calculateFormula();
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
        }
        catch (Exception e) {
            Logger.logErr("Error calculating formula in validation " + e.toString());
        }
        return false;
    }

    private boolean isNotBetween(Object value) {
        return !this.isBetween(value);
    }

    private boolean isEqual(Object value) {
        String s1 = StringTool.strip(FormulaParser.getExpressionString(this.firstCond), "=");
        String formulaStr = "=(" + value.toString() + "=" + s1 + ")";
        try {
            Formula f = FormulaParser.getFormulaFromString(formulaStr, this.getWorkBook().getWorkSheetByNumber(0), new int[]{1, 1});
            Object o = f.calculateFormula();
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
        }
        catch (Exception e) {
            Logger.logErr("Error calculating formula in validation " + e.toString());
        }
        return false;
    }

    private boolean isNotEqual(Object value) {
        return !this.isEqual(value);
    }

    private boolean isGreaterThan(Object value) {
        String s1 = StringTool.strip(FormulaParser.getExpressionString(this.firstCond), "=");
        String formulaStr = "=(" + value.toString() + ">" + s1 + ")";
        try {
            Formula f = FormulaParser.getFormulaFromString(formulaStr, this.getWorkBook().getWorkSheetByNumber(0), new int[]{1, 1});
            Object o = f.calculateFormula();
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
        }
        catch (Exception e) {
            Logger.logErr("Error calculating formula in validation " + e.toString());
        }
        return false;
    }

    private boolean isGreaterOrEqual(Object value) {
        String s1 = StringTool.strip(FormulaParser.getExpressionString(this.firstCond), "=");
        String formulaStr = "=(" + value.toString() + ">=" + s1 + ")";
        try {
            Formula f = FormulaParser.getFormulaFromString(formulaStr, this.getWorkBook().getWorkSheetByNumber(0), new int[]{1, 1});
            Object o = f.calculateFormula();
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
        }
        catch (Exception e) {
            Logger.logErr("Error calculating formula in validation " + e.toString());
        }
        return false;
    }

    private boolean isLessThan(Object value) {
        String s1 = StringTool.strip(FormulaParser.getExpressionString(this.firstCond), "=");
        String formulaStr = "=(" + value.toString() + "<" + s1 + ")";
        try {
            Formula f = FormulaParser.getFormulaFromString(formulaStr, this.getWorkBook().getWorkSheetByNumber(0), new int[]{1, 1});
            Object o = f.calculateFormula();
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
        }
        catch (Exception e) {
            Logger.logErr("Error calculating formula in validation " + e.toString());
        }
        return false;
    }

    private boolean isLessOrEqual(Object value) {
        String s1 = StringTool.strip(FormulaParser.getExpressionString(this.firstCond), "=");
        String formulaStr = "=(" + value.toString() + "<=" + s1 + ")";
        try {
            Formula f = FormulaParser.getFormulaFromString(formulaStr, this.getWorkBook().getWorkSheetByNumber(0), new int[]{1, 1});
            Object o = f.calculateFormula();
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
        }
        catch (Exception e) {
            Logger.logErr("Error calculating formula in validation " + e.toString());
        }
        return false;
    }

    public boolean isCorrectDataType(Object value) {
        switch (this.valType) {
            case 0: {
                return true;
            }
            case 4: {
                if (value instanceof Date) {
                    return true;
                }
                if (!(value instanceof Calendar)) break;
                return true;
            }
            case 2: {
                String possibleDec = value.toString();
                try {
                    new Double(possibleDec);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            case 7: {
                String possibleFormula = value.toString();
                if (possibleFormula.indexOf("=") != 0) break;
                return true;
            }
            case 1: {
                String possibleInt = value.toString();
                if (possibleInt.indexOf(".") > -1) {
                    return false;
                }
                try {
                    Long l = new Long(possibleInt);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            case 6: {
                return true;
            }
            case 5: {
                return true;
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    protected static XLSRecord getPrototype(WorkBook bk) {
        Dv dv = new Dv();
        dv.setOpcode((short)446);
        dv.setData(dv.PROTOTYPE_BYTES);
        dv.setWorkBook(bk);
        dv.init();
        return dv;
    }

    @Override
    public void init() {
        super.init();
        int offset = 0;
        this.grbit = ByteTools.readInt(this.getByteAt(offset++), this.getByteAt(offset++), this.getByteAt(offset++), this.getByteAt(offset++));
        short strLen = ByteTools.readShort(this.getByteAt(offset), this.getByteAt(offset + 1));
        byte strGrbit = this.getByteAt(offset + 2);
        if ((strGrbit & 1) == 1) {
            strLen = (short)(strLen * 2);
        }
        strLen = (short)(strLen + 3);
        byte[] namebytes = this.getBytesAt(offset, strLen);
        offset += strLen;
        this.dTitlePrompt = new Unicodestring();
        this.dTitlePrompt.init(namebytes, false);
        strLen = ByteTools.readShort(this.getByteAt(offset), this.getByteAt(offset + 1));
        strGrbit = this.getByteAt(offset + 2);
        if ((strGrbit & 1) == 1) {
            strLen = (short)(strLen * 2);
        }
        strLen = (short)(strLen + 3);
        namebytes = this.getBytesAt(offset, strLen);
        offset += strLen;
        this.dTitleError = new Unicodestring();
        this.dTitleError.init(namebytes, false);
        strLen = ByteTools.readShort(this.getByteAt(offset), this.getByteAt(offset + 1));
        strGrbit = this.getByteAt(offset + 2);
        if ((strGrbit & 1) == 1) {
            strLen = (short)(strLen * 2);
        }
        strLen = (short)(strLen + 3);
        namebytes = this.getBytesAt(offset, strLen);
        offset += strLen;
        this.dTextPrompt = new Unicodestring();
        this.dTextPrompt.init(namebytes, false);
        strLen = ByteTools.readShort(this.getByteAt(offset), this.getByteAt(offset + 1));
        strGrbit = this.getByteAt(offset + 2);
        if ((strGrbit & 1) == 1) {
            strLen = (short)(strLen * 2);
        }
        strLen = (short)(strLen + 3);
        namebytes = this.getBytesAt(offset, strLen);
        offset += strLen;
        this.dTextError = new Unicodestring();
        this.dTextError.init(namebytes, false);
        short sz1 = ByteTools.readShort(this.getByteAt(offset++), this.getByteAt(offset++));
        this.garbageByteOne[0] = this.getByteAt(offset++);
        this.garbageByteOne[1] = this.getByteAt(offset++);
        byte[] formulaBytes = this.getBytesAt(offset, sz1);
        this.firstCond = ExpressionParser.parseExpression(formulaBytes, this);
        offset += sz1;
        short sz2 = ByteTools.readShort(this.getByteAt(offset++), this.getByteAt(offset++));
        this.garbageByteTwo[0] = this.getByteAt(offset++);
        this.garbageByteTwo[1] = this.getByteAt(offset++);
        formulaBytes = this.getBytesAt(offset, sz2);
        this.secondCond = ExpressionParser.parseExpression(formulaBytes, this);
        offset += sz2;
        this.numLocs = this.getByteAt(offset++);
        this.cRangeList = new ArrayList();
        int i = 0;
        while (i < this.numLocs) {
            byte[] b = new byte[]{0};
            b = ByteTools.append(b, this.getBytesAt(offset, 8));
            PtgArea p = new PtgArea(false);
            p.setParentRec(this);
            p.init(b);
            this.cRangeList.add(p);
            offset += 8;
            ++i;
        }
        this.valType = (byte)(this.grbit & 0xF);
        this.errStyle = (byte)((this.grbit & 0x70) >> 4);
        this.IMEMode = (short)((this.grbit & 0x3FC00) >> 10);
        this.fStrLookup = (this.grbit & 0x80) == 128;
        this.fAllowBlank = (this.grbit & 0x100) == 256;
        this.fSuppressCombo = (this.grbit & 0x200) == 512;
        this.fShowInputMsg = true;
        this.fShowErrMsg = (this.grbit & 0x80000) == 524288;
        this.typOperator = (byte)((this.grbit & 0xF00000) >> 20);
    }

    private void updateRecord() {
        this.updateGrbit();
        byte[] recbytes = new byte[]{};
        byte[] tmp = ByteTools.cLongToLEBytes(this.grbit);
        recbytes = ByteTools.append(tmp, recbytes);
        recbytes = ByteTools.append(this.dTitlePrompt.read(), recbytes);
        recbytes = ByteTools.append(this.dTitleError.read(), recbytes);
        recbytes = ByteTools.append(this.dTextPrompt.read(), recbytes);
        recbytes = ByteTools.append(this.dTextError.read(), recbytes);
        tmp = new byte[]{};
        int i = 0;
        while (i < this.firstCond.size()) {
            Object o = this.firstCond.elementAt(i);
            Ptg ptg = (Ptg)o;
            tmp = ByteTools.append(ptg.getRecord(), tmp);
            ++i;
        }
        short sz = (short)tmp.length;
        recbytes = ByteTools.append(ByteTools.shortToLEBytes(sz), recbytes);
        recbytes = ByteTools.append(this.garbageByteOne, recbytes);
        recbytes = ByteTools.append(tmp, recbytes);
        tmp = new byte[]{};
        int i2 = 0;
        while (i2 < this.secondCond.size()) {
            Object o = this.secondCond.elementAt(i2);
            Ptg ptg = (Ptg)o;
            tmp = ByteTools.append(ptg.getRecord(), tmp);
            ++i2;
        }
        sz = (short)tmp.length;
        recbytes = ByteTools.append(ByteTools.shortToLEBytes(sz), recbytes);
        recbytes = ByteTools.append(this.garbageByteTwo, recbytes);
        recbytes = ByteTools.append(tmp, recbytes);
        tmp = new byte[1];
        if (this.cRangeList != null) {
            tmp[0] = (byte)this.cRangeList.size();
            recbytes = ByteTools.append(tmp, recbytes);
            i2 = 0;
            while (i2 < this.cRangeList.size()) {
                tmp = ((PtgArea)this.cRangeList.get(i2)).getRecord();
                byte[] tmp2 = new byte[8];
                tmp[0] = 0;
                System.arraycopy(tmp, 0, tmp2, 0, tmp2.length);
                recbytes = ByteTools.append(tmp2, recbytes);
                ++i2;
            }
            if (this.cRangeList.size() > 0) {
                tmp = new byte[]{0};
                recbytes = ByteTools.append(tmp, recbytes);
            }
        } else if (this.ooxmlranges != null && this.ooxmlranges.length > 0) {
            tmp[0] = (byte)this.ooxmlranges.length;
            recbytes = ByteTools.append(tmp, recbytes);
            i2 = 0;
            while (i2 < this.ooxmlranges.length) {
                Ptg p = PtgRef.createPtgRefFromString(String.valueOf(this.getSheet().getSheetName()) + "!" + this.ooxmlranges[i2], this);
                tmp = p.getRecord();
                tmp[0] = 0;
                byte[] tmp2 = new byte[8];
                System.arraycopy(tmp, 0, tmp2, 0, tmp2.length);
                recbytes = ByteTools.append(tmp, recbytes);
                ++i2;
            }
            if (this.ooxmlranges.length > 0) {
                tmp = new byte[]{0};
                recbytes = ByteTools.append(tmp, recbytes);
            }
        }
        this.setData(recbytes);
    }

    @Override
    public void preStream() {
        if (this.dirtyflag) {
            this.updateRecord();
        }
    }

    public void updateGrbit() {
        this.grbit = 0;
        this.grbit |= this.valType;
        this.grbit |= this.errStyle << 4;
        this.grbit |= this.IMEMode << 10;
        if (this.fStrLookup) {
            this.grbit |= 0x80;
        }
        if (this.fAllowBlank) {
            this.grbit |= 0x100;
        }
        if (this.fSuppressCombo) {
            this.grbit |= 0x200;
        }
        if (this.fShowInputMsg) {
            this.grbit |= 0x40000;
        }
        if (this.fShowErrMsg) {
            this.grbit |= 0x80000;
        }
        this.grbit |= this.typOperator << 20;
    }

    public String[] getRanges() {
        if (this.cRangeList == null && this.ooxmlranges != null && this.ooxmlranges.length > 0) {
            return this.ooxmlranges;
        }
        String[] s = new String[this.cRangeList.size()];
        int i = 0;
        while (i < s.length) {
            s[i] = ((PtgArea)this.cRangeList.get(i)).getLocation();
            s[i] = StringTool.strip(s[i], "$");
            ++i;
        }
        return s;
    }

    public void setRange(String range) {
        if (range == null) {
            this.cRangeList = null;
            return;
        }
        if (range.indexOf(":") == -1) {
            range = String.valueOf(range) + ":" + range;
        }
        PtgArea p = new PtgArea(range, (XLSRecord)this, false);
        this.cRangeList = new ArrayList();
        this.cRangeList.add(p);
        this.dirtyflag = true;
    }

    public void addRange(String range) {
        if (this.cRangeList == null) {
            this.cRangeList = new ArrayList();
        }
        PtgArea p = new PtgArea(range, (XLSRecord)this, false);
        this.cRangeList.add(p);
        this.dirtyflag = true;
    }

    public void addOoxmlRange(String range) {
        if (this.cRangeList == null) {
            this.cRangeList = new ArrayList();
        }
        PtgArea p = new PtgArea(range, (XLSRecord)this, range != null ? range.indexOf(36) == -1 : false);
        this.cRangeList.add(p);
        this.dirtyflag = true;
    }

    public String getErrorBoxText() {
        return this.dTextError.toString().trim();
    }

    public void setErrorBoxText(String textError) {
        this.dTextError.updateUnicodeString(textError);
        this.dirtyflag = true;
    }

    public String getPromptBoxText() {
        return this.dTextPrompt.toString().trim();
    }

    public void setPromptBoxText(String text) {
        this.dTextPrompt.updateUnicodeString(text);
        this.dirtyflag = true;
    }

    public void setErrorBoxTitle(String textError) {
        this.dTitleError.updateUnicodeString(textError);
        this.dirtyflag = true;
    }

    public String getErrorBoxTitle() {
        return this.dTitleError.toString().trim();
    }

    public String getPromptBoxTitle() {
        return this.dTitlePrompt.toString().trim();
    }

    public void setPromptBoxTitle(String text) {
        this.dTitlePrompt.updateUnicodeString(text);
        this.dirtyflag = true;
    }

    public byte getErrorStyle() {
        return this.errStyle;
    }

    public void setErrorStyle(byte errstyle) {
        this.errStyle = errstyle;
        this.dirtyflag = true;
    }

    public boolean isAllowBlank() {
        return this.fAllowBlank;
    }

    public void setAllowBlank(boolean allowBlank) {
        this.fAllowBlank = allowBlank;
        this.updateGrbit();
        this.dirtyflag = true;
    }

    public String getFirstCond() {
        String s = FormulaParser.getExpressionString(this.firstCond);
        if (s.substring(0, 1).equals("=")) {
            return s.substring(1, s.length());
        }
        return s;
    }

    public void setFirstCond(String firstCond) {
        this.firstCond = FormulaParser.getPtgsFromFormulaString(this, firstCond);
        this.dirtyflag = true;
    }

    public String getSecondCond() {
        String s = FormulaParser.getExpressionString(this.secondCond);
        if (s.substring(0, 1).equals("=")) {
            return s.substring(1, s.length());
        }
        return s;
    }

    public void setSecondCond(String secondCond) {
        this.secondCond = FormulaParser.getPtgsFromFormulaString(this, secondCond);
        this.dirtyflag = true;
    }

    public boolean isShowErrorMsg() {
        return this.fShowErrMsg;
    }

    public void setShowErrMsg(boolean showErrMsg) {
        this.fShowErrMsg = showErrMsg;
        this.dirtyflag = true;
    }

    public boolean getShowInputMsg() {
        return this.fShowInputMsg;
    }

    public void setShowInputMsg(boolean showInputMsg) {
        this.fShowInputMsg = showInputMsg;
        this.dirtyflag = true;
    }

    public boolean isStrLookup() {
        return this.fStrLookup;
    }

    public void setStrLookup(boolean strLookup) {
        this.fStrLookup = strLookup;
        this.dirtyflag = true;
    }

    public boolean isSuppressCombo() {
        return this.fSuppressCombo;
    }

    public short getIMEMode() {
        return this.IMEMode;
    }

    public void setIMEMode(short mode) {
        this.IMEMode = mode;
        this.dirtyflag = true;
    }

    public void setSuppressCombo(boolean suppressCombo) {
        this.fSuppressCombo = suppressCombo;
        this.dirtyflag = true;
    }

    public byte getTypeOperator() {
        return this.typOperator;
    }

    public void setTypeOperator(byte typOperator) {
        this.typOperator = typOperator;
        this.dirtyflag = true;
    }

    public byte getValType() {
        return this.valType;
    }

    public void setValType(byte valtype) {
        this.valType = valtype;
        this.dirtyflag = true;
    }

    public boolean isInRange(String celladdy) {
        int[] rc = ExcelTools.getRowColFromString(celladdy);
        int i = 0;
        while (i < this.cRangeList.size()) {
            if (((PtgArea)this.cRangeList.get(i)).contains(rc)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Dv parseOOXML(XmlPullParser xpp, Boundsheet bs) {
        Dv dv = bs.createDv(null);
        dv.setSheet(bs);
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("dataValidation")) {
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            String n = xpp.getAttributeName(i);
                            String v = xpp.getAttributeValue(i);
                            if (n.equals("allowBlank")) {
                                dv.setAllowBlank(true);
                            } else if (n.equals("error")) {
                                dv.setErrorBoxText(v);
                            } else if (n.equals("errorStyle")) {
                                if (v.equals("information")) {
                                    dv.setErrorStyle((byte)2);
                                } else if (v.equals("stop")) {
                                    dv.setErrorStyle((byte)0);
                                } else if (v.equals("warning")) {
                                    dv.setErrorStyle((byte)1);
                                }
                            } else if (n.equals("errorTitle")) {
                                dv.setErrorBoxTitle(v);
                            } else if (n.equals("imeMode")) {
                                if (v.equals("nocontrol")) {
                                    dv.setIMEMode((short)0);
                                } else if (v.equals("off")) {
                                    dv.setIMEMode((short)1);
                                } else if (v.equals("on")) {
                                    dv.setIMEMode((short)2);
                                } else if (v.equals("disabled")) {
                                    dv.setIMEMode((short)3);
                                } else if (v.equals("hiragana")) {
                                    dv.setIMEMode((short)4);
                                } else if (v.equals("fullKatakana")) {
                                    dv.setIMEMode((short)5);
                                } else if (v.equals("halfKatakana")) {
                                    dv.setIMEMode((short)6);
                                } else if (v.equals("fullAlpha")) {
                                    dv.setIMEMode((short)7);
                                } else if (v.equals("halfAlpha")) {
                                    dv.setIMEMode((short)8);
                                } else if (v.equals("fullHangul")) {
                                    dv.setIMEMode((short)9);
                                } else if (v.equals("halfHangul")) {
                                    dv.setIMEMode((short)10);
                                }
                            } else if (n.equals("operator")) {
                                if (v.equals("between")) {
                                    dv.setTypeOperator((byte)0);
                                } else if (v.equals("equal")) {
                                    dv.setTypeOperator((byte)2);
                                } else if (v.equals("greaterThan")) {
                                    dv.setTypeOperator((byte)4);
                                } else if (v.equals("greaterThanOrEqual")) {
                                    dv.setTypeOperator((byte)6);
                                } else if (v.equals("lessThan")) {
                                    dv.setTypeOperator((byte)5);
                                } else if (v.equals("lessThanOrEqual")) {
                                    dv.setTypeOperator((byte)7);
                                } else if (v.equals("notBetween")) {
                                    dv.setTypeOperator((byte)1);
                                } else if (v.equals("notEqual")) {
                                    dv.setTypeOperator((byte)3);
                                }
                            } else if (n.equals("prompt")) {
                                dv.setPromptBoxText(v);
                            } else if (n.equals("promptTitle")) {
                                dv.setPromptBoxTitle(v);
                            } else if (!n.equals("showDropDown")) {
                                if (n.equals("showErrorMessage")) {
                                    dv.setShowErrMsg(true);
                                } else if (n.equals("showInputMessage")) {
                                    dv.setShowInputMsg(true);
                                } else if (n.equals("sqref")) {
                                    dv.ooxmlranges = StringTool.splitString(v, " ");
                                    int z = 0;
                                    while (z < dv.ooxmlranges.length) {
                                        dv.addOoxmlRange(dv.ooxmlranges[z]);
                                        ++z;
                                    }
                                } else if (n.equals("type")) {
                                    if (v.equals("custom")) {
                                        dv.setValType((byte)7);
                                    } else if (v.equals("date")) {
                                        dv.setValType((byte)4);
                                    } else if (v.equals("decimal")) {
                                        dv.setValType((byte)2);
                                    } else if (v.equals("list")) {
                                        dv.setValType((byte)3);
                                    } else if (v.equals("none")) {
                                        dv.setValType((byte)0);
                                    } else if (v.equals("textLength")) {
                                        dv.setValType((byte)6);
                                    } else if (v.equals("time")) {
                                        dv.setValType((byte)5);
                                    } else if (v.equals("whole")) {
                                        dv.setValType((byte)1);
                                    }
                                }
                            }
                            ++i;
                        }
                    } else if (tnm.equals("formula1")) {
                        dv.setFirstCond(OOXMLAdapter.getNextText(xpp));
                    } else if (tnm.equals("formula2")) {
                        dv.setSecondCond(OOXMLAdapter.getNextText(xpp));
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("dataValidation")) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("OOXMLELEMENT.parseOOXML: " + e.toString());
        }
        return dv;
    }

    public String getOOXML() {
        String formula2;
        String[] ranges;
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<dataValidation");
        switch (this.valType) {
            case 0: {
                break;
            }
            case 1: {
                ooxml.append(" type=\"whole\"");
                break;
            }
            case 2: {
                ooxml.append(" type=\"decimal\"");
                break;
            }
            case 3: {
                ooxml.append(" type=\"list\"");
                break;
            }
            case 4: {
                ooxml.append(" type=\"date\"");
                break;
            }
            case 5: {
                ooxml.append(" type=\"time\"");
                break;
            }
            case 6: {
                ooxml.append(" type=\"textLength\"");
                break;
            }
            case 7: {
                ooxml.append(" type=\"custom\"");
            }
        }
        switch (this.typOperator) {
            case 0: {
                break;
            }
            case 1: {
                ooxml.append(" operator=\"notBetween\"");
                break;
            }
            case 2: {
                ooxml.append(" operator=\"equal\"");
                break;
            }
            case 3: {
                ooxml.append(" operator=\"notEqual\"");
                break;
            }
            case 4: {
                ooxml.append(" operator=\"greaterThan\"");
                break;
            }
            case 5: {
                ooxml.append(" operator=\"lessThan\"");
                break;
            }
            case 6: {
                ooxml.append(" operator=\"greaterThanOrEqual\"");
                break;
            }
            case 7: {
                ooxml.append(" operator=\"lessThanOrEqual\"");
            }
        }
        switch (this.errStyle) {
            case 0: {
                break;
            }
            case 1: {
                ooxml.append(" errorStyle=\"warning\"");
                break;
            }
            case 2: {
                ooxml.append(" errorStyle=\"information\"");
            }
        }
        if (!this.getErrorBoxText().equals("")) {
            ooxml.append(" error=\"" + OOXMLAdapter.stripNonAscii(this.getErrorBoxText()) + "\"");
        }
        if (!this.getErrorBoxTitle().equals("")) {
            ooxml.append(" errorTitle=\"" + OOXMLAdapter.stripNonAscii(this.getErrorBoxTitle()) + "\"");
        }
        if (!this.getPromptBoxText().equals("")) {
            ooxml.append(" prompt=\"" + OOXMLAdapter.stripNonAscii(this.getPromptBoxText()) + "\"");
        }
        if (!this.getPromptBoxTitle().equals("")) {
            ooxml.append(" promptTitle=\"" + OOXMLAdapter.stripNonAscii(this.getPromptBoxTitle()) + "\"");
        }
        if ((ranges = this.getRanges()).length > 0) {
            ooxml.append(" sqref=\"");
            int i = 0;
            while (i < ranges.length) {
                if (i > 0) {
                    ooxml.append(" ");
                }
                ooxml.append(ranges[i]);
                ++i;
            }
            ooxml.append("\"");
        }
        if (this.isAllowBlank()) {
            ooxml.append(" allowBlank=\"1\"");
        }
        if (this.isShowErrorMsg()) {
            ooxml.append(" showErrorMessage=\"1\"");
        }
        if (this.getShowInputMsg()) {
            ooxml.append(" showInputMessage=\"1\"");
        }
        switch (this.getIMEMode()) {
            case 0: {
                break;
            }
            case 1: {
                ooxml.append(" imeMode=\"off\"");
                break;
            }
            case 2: {
                ooxml.append(" imeMode=\"on\"");
                break;
            }
            case 3: {
                ooxml.append(" imeMode=\"disabled\"");
                break;
            }
            case 4: {
                ooxml.append(" imeMode=\"hiragana\"");
                break;
            }
            case 5: {
                ooxml.append(" imeMode=\"fullKatakana\"");
                break;
            }
            case 6: {
                ooxml.append(" imeMode=\"halfKatakana\"");
                break;
            }
            case 7: {
                ooxml.append(" imeMode=\"fullAlpha\"");
                break;
            }
            case 8: {
                ooxml.append(" imeMode=\"halfAlpha\"");
                break;
            }
            case 9: {
                ooxml.append(" imeMode=\"fullHangul\"");
                break;
            }
            case 10: {
                ooxml.append(" imeMode=\"halfHangul\"");
            }
        }
        ooxml.append(">");
        String formula1 = this.getFirstCond();
        if (formula1 != null && formula1.length() > 0) {
            formula1 = formula1.replace('\u0000', ',');
            ooxml.append("<formula1>" + formula1 + "</formula1>");
        }
        if ((formula2 = this.getSecondCond()) != null && formula2.length() > 0) {
            formula2 = formula2.replace('\u0000', ',');
            ooxml.append("<formula2>" + formula2 + "</formula2>");
        }
        ooxml.append("</dataValidation>");
        return ooxml.toString();
    }
}

