/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Isstinf;
import com.extentech.formats.XLS.Sst;
import com.extentech.formats.XLS.Unicodestring;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.util.AbstractList;
import java.util.List;

public final class Extsst
extends XLSRecord {
    private static final long serialVersionUID = -2409458213287279987L;
    Sst mysst = null;
    short Dsst;
    int numstructs;
    Isstinf[] mystinfs = null;
    boolean debug;

    void setSst(Sst s) {
        this.mysst = s;
        s.setExtsst(this);
    }

    public boolean getUpdatesAllBOFPositions() {
        return true;
    }

    @Override
    public void init() {
        this.debug = true;
        super.init();
        this.Dsst = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        int bpos = 2;
    }

    void setDsst(int newdst) {
        byte[] newdt = ByteTools.shortToLEBytes((short)newdst);
        this.getData()[0] = newdt[0];
        this.getData()[1] = newdt[1];
        this.Dsst = (short)newdst;
    }

    public void updateIsstinfs() {
        List strs = this.mysst.getStringVector();
        int totstrs = strs.size();
        int newdsst = 8;
        if (totstrs > 1024 && totstrs % (newdsst = totstrs / 128) > 0) {
            ++newdsst;
        }
        int totissts = totstrs / newdsst;
        if (totstrs % newdsst > 0) {
            ++totissts;
        }
        int ctr = 0;
        int sststartpos = this.mysst.getOffset() + 12;
        Isstinf[] mynewstinfs = new Isstinf[totissts];
        int continueStrPos = 0;
        int lastContinueStrPos = 0;
        boolean strlen = false;
        boolean off3 = false;
        int bytepos = 2;
        int sstpos = 0;
        int contoff = 0;
        byte[] bd = new byte[totissts * 8 + 2];
        byte[] numStrsPer = ByteTools.shortToLEBytes((short)newdsst);
        bd[0] = numStrsPer[0];
        bd[1] = numStrsPer[1];
        int RecLen = 8224;
        int whichContinue = -1;
        boolean updateRecLen = false;
        int lastsstpos = 0;
        int sstOffset = this.mysst.getOffset();
        int t = 0;
        while (t < totissts) {
            Unicodestring str = t == totissts ? this.mysst.getUStringAt(totstrs - 1) : this.mysst.getUStringAt(ctr);
            ctr += newdsst;
            lastsstpos = sstpos;
            lastContinueStrPos = continueStrPos;
            sstpos = str.getSSTPos() + 4;
            boolean newbucket = false;
            continueStrPos = sstpos - contoff;
            if (continueStrPos > RecLen && whichContinue + 1 < this.mysst.continues.size()) {
                Object[] grbits;
                Byte[] grbytes;
                updateRecLen = true;
                continueStrPos = continueStrPos - RecLen + 1;
                if (updateRecLen) {
                    AbstractList v = this.mysst.continues;
                    BiffRec br = (BiffRec)v.get(++whichContinue);
                    RecLen = br.getLength();
                    updateRecLen = false;
                }
                if ((grbytes = (Byte[])(grbits = Sst.getContinueDef(this.mysst, false))[1])[whichContinue] != null && (grbytes[whichContinue] == 0 || grbytes[whichContinue] == 1)) {
                    contoff += RecLen;
                    sstOffset += 5;
                } else {
                    contoff += RecLen;
                    sstOffset += 4;
                }
            }
            sststartpos = sstpos + sstOffset;
            byte[] ib1 = ByteTools.cLongToLEBytes(sststartpos);
            byte[] cb1 = ByteTools.shortToLEBytes((short)continueStrPos);
            bd[bytepos++] = ib1[0];
            bd[bytepos++] = ib1[1];
            bd[bytepos++] = ib1[2];
            bd[bytepos++] = ib1[3];
            bd[bytepos++] = cb1[0];
            bd[bytepos++] = cb1[1];
            bd[bytepos++] = 0;
            bd[bytepos++] = 0;
            lastContinueStrPos = continueStrPos;
            ++t;
        }
        this.setData(bd);
        this.setDsst(newdsst);
        int newsz = this.getLength();
        if (this.DEBUGLEVEL > 3) {
            Logger.logInfo("Done creating Isstinfs");
        }
    }

    @Override
    public void preStream() {
        try {
            this.updateIsstinfs();
        }
        catch (Exception e) {
            Logger.logErr("Extsst.preStream() failed updating Isstinfs.", e);
        }
    }
}

