/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;

public class FeatHeadr
extends XLSRecord {
    private static final long serialVersionUID = -5775187385375827918L;
    short isf = 0;
    int grbit = 0;
    boolean iprotObject;
    boolean iprotScenario;
    boolean iprotFormatCells;
    boolean iprotFormatColumns;
    boolean iprotFormatRows;
    boolean iprotInsertColumns;
    boolean iprotInsertRows;
    boolean iprotInsertHyperlinks;
    boolean iprotDeleteColumns;
    boolean iprotDeleteRows;
    boolean iprotSelLockedCells;
    boolean iprotSort;
    boolean iprotAutoFilter;
    boolean iprotPivotTable;
    boolean iprotSelUnlockedCells;
    public static final short ALLOWOBJECTS = 1;
    public static final short ALLOWSCENARIOS = 2;
    public static final short ALLOWFORMATCELLS = 4;
    public static final short ALLOWFORMATCOLUMNS = 8;
    public static final short ALLOWFORMATROWS = 16;
    public static final short ALLOWINSERTCOLUMNS = 32;
    public static final short ALLOWINSERTROWS = 64;
    public static final short ALLOWINSERTHYPERLINKS = 128;
    public static final short ALLOWDELETECOLUMNS = 256;
    public static final short ALLOWDELETEROWS = 512;
    public static final short ALLOWSELLOCKEDCELLS = 1024;
    public static final short ALLOWSORT = 2048;
    public static final short ALLOWAUTOFILTER = 4096;
    public static final short ALLOWPIVOTTABLES = 8192;
    public static final short ALLOWSELUNLOCKEDCELLS = 16384;
    private byte[] PROTOTYPE_BYTES;

    public FeatHeadr() {
        byte[] byArray = new byte[23];
        byArray[0] = 103;
        byArray[1] = 8;
        byArray[12] = 2;
        byArray[14] = 1;
        byArray[15] = -1;
        byArray[16] = -1;
        byArray[17] = -1;
        byArray[18] = -1;
        this.PROTOTYPE_BYTES = byArray;
    }

    protected static XLSRecord getPrototype() {
        FeatHeadr f = new FeatHeadr();
        f.setOpcode((short)2151);
        f.setData(f.PROTOTYPE_BYTES);
        f.init();
        return f;
    }

    @Override
    public void init() {
        super.init();
        this.isf = ByteTools.readShort(this.getData()[12], this.getData()[13]);
        if (this.isf == 2) {
            this.grbit = ByteTools.readInt(this.getData()[19], this.getData()[20], this.getData()[21], this.getData()[22]);
            this.parseProtectionGrbit();
        }
    }

    private void parseProtectionGrbit() {
        this.iprotObject = (this.grbit & 1) == 1;
        this.iprotScenario = (this.grbit & 2) == 2;
        this.iprotFormatCells = (this.grbit & 4) == 4;
        this.iprotFormatColumns = (this.grbit & 8) == 8;
        this.iprotFormatRows = (this.grbit & 0x10) == 16;
        this.iprotInsertColumns = (this.grbit & 0x20) == 32;
        this.iprotInsertRows = (this.grbit & 0x40) == 64;
        this.iprotInsertHyperlinks = (this.grbit & 0x80) == 128;
        this.iprotDeleteColumns = (this.grbit & 0x100) == 256;
        this.iprotDeleteRows = (this.grbit & 0x200) == 512;
        this.iprotSelLockedCells = (this.grbit & 0x400) == 1024;
        this.iprotSort = (this.grbit & 0x800) == 2048;
        this.iprotAutoFilter = (this.grbit & 0x1000) == 4096;
        this.iprotPivotTable = (this.grbit & 0x2000) == 8192;
        this.iprotSelUnlockedCells = (this.grbit & 0x4000) == 16384;
    }

    private void updateProtectionGrbit() {
        byte[] b = ByteTools.cLongToLEBytes(this.grbit);
        this.getData();
        this.data[19] = b[0];
        this.data[20] = b[1];
        this.data[21] = b[2];
        this.data[22] = b[3];
        this.parseProtectionGrbit();
    }

    public void setProtectionOption(int protectionOption, boolean set) {
        this.grbit = set ? (this.grbit |= protectionOption) : (this.grbit &= ~protectionOption);
        this.updateProtectionGrbit();
    }

    public boolean getProtectionOption(int protectionOption) {
        return (this.grbit & protectionOption) == protectionOption;
    }
}

