/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.CellRange;
import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.HLinkStruct;
import com.extentech.formats.XLS.Unicodestring;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;

public final class Hlink
extends XLSRecord {
    private static final long serialVersionUID = -4259979643231173799L;
    int colFirst = -1;
    int colLast = -1;
    int rowFirst = -1;
    int rowLast = -1;
    private HLinkStruct linkStruct = null;
    private CellRange range = null;

    public void setRowFirst(int c) {
        byte[] b = ByteTools.shortToLEBytes((short)c);
        byte[] dt = this.getData();
        System.arraycopy(b, 0, dt, 0, 2);
        this.rowFirst = c;
    }

    public int getRowFirst() {
        return this.rowFirst;
    }

    public void setRowLast(int c) {
        byte[] b = ByteTools.shortToLEBytes((short)c);
        byte[] dt = this.getData();
        System.arraycopy(b, 0, dt, 2, 2);
        this.rowLast = c;
    }

    public int getRowLast() {
        return this.rowLast;
    }

    public void setColFirst(int c) {
        byte[] b = ByteTools.shortToLEBytes((short)c);
        byte[] dt = this.getData();
        System.arraycopy(b, 0, dt, 4, 2);
        this.colFirst = c;
    }

    public int getColFirst() {
        return this.colFirst;
    }

    public void setColLast(int c) {
        byte[] b = ByteTools.shortToLEBytes((short)c);
        byte[] dt = this.getData();
        System.arraycopy(b, 0, dt, 6, 2);
        this.colLast = c;
    }

    public int getColLast() {
        return this.colLast;
    }

    public String getURL() {
        if (this.linkStruct == null) {
            return "";
        }
        return this.linkStruct.getUrl();
    }

    public String getDescription() {
        if (this.linkStruct == null) {
            return "";
        }
        return this.linkStruct.getLinkText();
    }

    public static XLSRecord getPrototype() {
        Hlink retlab = new Hlink();
        byte[] byArray = new byte[58];
        byArray[8] = -48;
        byArray[9] = -55;
        byArray[10] = -22;
        byArray[11] = 121;
        byArray[12] = -7;
        byArray[13] = -70;
        byArray[14] = -50;
        byArray[15] = 17;
        byArray[16] = -116;
        byArray[17] = -126;
        byArray[19] = -86;
        byArray[21] = 75;
        byArray[22] = -87;
        byArray[23] = 11;
        byArray[24] = 2;
        byArray[28] = 2;
        byArray[36] = -32;
        byArray[37] = -55;
        byArray[38] = -22;
        byArray[39] = 121;
        byArray[40] = -7;
        byArray[41] = -70;
        byArray[42] = -50;
        byArray[43] = 17;
        byArray[44] = -116;
        byArray[45] = -126;
        byArray[47] = -86;
        byArray[49] = 75;
        byArray[50] = -87;
        byArray[51] = 11;
        byArray[52] = -116;
        byte[] rbytes = byArray;
        retlab.setOpcode((short)440);
        retlab.setLength(94);
        retlab.setData(rbytes);
        retlab.init();
        return retlab;
    }

    public void setURL(String url, String desc, String textMark) {
        try {
            if (url.equals("") && textMark.equals("")) {
                Logger.logWarn("HLINK.setURL:  no url or text mark specified");
                return;
            }
            this.linkStruct.setUrl(url, desc, textMark);
        }
        catch (Exception e) {
            Logger.logWarn("setting URL " + url + " failed: " + e);
        }
        byte[] bt = this.linkStruct.getBytes();
        this.setData(bt);
    }

    public void setFileURL(String url, String desc, String textMark) {
        try {
            this.linkStruct.setFileURL(url, desc, textMark);
        }
        catch (Exception e) {
            Logger.logWarn("setting URL " + url + " failed: " + e);
        }
        byte[] bt = this.linkStruct.getBytes();
        this.setData(bt);
    }

    public boolean inrange(int x) {
        return x <= this.colLast && x >= this.colFirst;
    }

    @Override
    public void init() {
        super.init();
        int pos = 0;
        this.rowFirst = ByteTools.readShort(this.getByteAt(pos++), this.getByteAt(pos++));
        this.rowLast = ByteTools.readShort(this.getByteAt(pos++), this.getByteAt(pos++));
        this.colFirst = ByteTools.readShort(this.getByteAt(pos++), this.getByteAt(pos++));
        this.colLast = ByteTools.readShort(this.getByteAt(pos++), this.getByteAt(pos++));
        Unicodestring ustr = new Unicodestring();
        String nm = "";
        if (this.getSheet() != null && !this.getSheet().getSheetName().equals("")) {
            nm = String.valueOf(this.getSheet().getSheetName()) + "!";
        }
        nm = String.valueOf(nm) + ExcelTools.getAlphaVal(this.colFirst);
        nm = String.valueOf(nm) + this.rowFirst + ":";
        nm = String.valueOf(nm) + ExcelTools.getAlphaVal(this.colLast);
        nm = String.valueOf(nm) + this.rowLast;
        try {
            this.range = new CellRange(nm, null);
        }
        catch (Exception e) {
            Logger.logWarn("initializing Hlink record failed: " + e);
        }
        if (this.DEBUGLEVEL > 5) {
            Logger.logInfo("Hlink Cells: " + this.range.toString());
        }
        try {
            this.linkStruct = new HLinkStruct(this.getBytesAt(0, this.getLength()));
        }
        catch (Exception e) {
            Logger.logWarn("Hyperlink parse failed for Cells " + this.range.toString() + ": " + e);
        }
        if (this.DEBUGLEVEL > 5) {
            Logger.logInfo("Hlink URL: " + this.linkStruct.getUrl());
        }
    }

    public CellRange getRange() {
        return this.range;
    }

    public void setRange(CellRange range) {
        this.range = range;
    }

    public void initCells(WorkBookHandle wbook) {
        int[] cellcoords = new int[4];
        cellcoords[0] = this.getRowFirst();
        cellcoords[2] = this.getRowLast();
        cellcoords[1] = this.getColFirst();
        cellcoords[3] = this.getColLast();
        try {
            CellRange cr = new CellRange(wbook.getWorkSheet(this.getSheet().getSheetName()), cellcoords);
            cr.setWorkBook(wbook);
            BiffRec[] ch = cr.getCellRecs();
            int t = 0;
            while (t < ch.length) {
                ch[t].setHyperlink(this);
                ++t;
            }
        }
        catch (Exception e) {
            Logger.logWarn("initializing Hyperlink Cells failed: " + e);
        }
    }
}

