/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.ImageHandle;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.Continue;
import com.extentech.formats.XLS.MSODrawing;
import com.extentech.formats.XLS.Phonetic;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.escher.MsofbtBSE;
import com.extentech.formats.escher.MsofbtBstoreContainer;
import com.extentech.formats.escher.MsofbtDgg;
import com.extentech.formats.escher.MsofbtDggContainer;
import com.extentech.formats.escher.MsofbtOPT;
import com.extentech.formats.escher.MsofbtSplitMenuColors;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;

public final class MSODrawingGroup
extends XLSRecord {
    private AbstractList msoRecs = new ArrayList();
    public boolean dirtyflag = false;
    int spidMax = 1024;
    int numIdClusters = 2;
    int numShapes = 1;
    int numDrawings = 1;
    private ArrayList imageData = new ArrayList();
    private ArrayList imageType = new ArrayList();
    private ArrayList cRef = new ArrayList();
    public byte[] PROTOTYPE_BYTES;
    private static final long serialVersionUID = 2378100973014157878L;
    public byte[] PROTOTYPE_1C1;
    public byte[] PROTOTYPE_863;

    public MSODrawingGroup() {
        byte[] byArray = new byte[90];
        byArray[0] = 15;
        byArray[3] = -16;
        byArray[4] = 82;
        byArray[10] = 6;
        byArray[11] = -16;
        byArray[12] = 24;
        byArray[16] = 2;
        byArray[17] = 4;
        byArray[20] = 2;
        byArray[24] = 2;
        byArray[28] = 1;
        byArray[32] = 1;
        byArray[36] = 2;
        byArray[40] = 51;
        byArray[42] = 11;
        byArray[43] = -16;
        byArray[44] = 18;
        byArray[48] = -65;
        byArray[50] = 8;
        byArray[52] = 8;
        byArray[54] = -127;
        byArray[55] = 1;
        byArray[56] = 9;
        byArray[59] = 8;
        byArray[60] = -64;
        byArray[61] = 1;
        byArray[62] = 64;
        byArray[65] = 8;
        byArray[66] = 64;
        byArray[68] = 30;
        byArray[69] = -15;
        byArray[70] = 16;
        byArray[74] = 13;
        byArray[77] = 8;
        byArray[78] = 12;
        byArray[81] = 8;
        byArray[82] = 23;
        byArray[85] = 8;
        byArray[86] = -9;
        byArray[89] = 16;
        this.PROTOTYPE_BYTES = byArray;
        byte[] byArray2 = new byte[8];
        byArray2[0] = -63;
        byArray2[1] = 1;
        byArray2[4] = -128;
        byArray2[5] = 56;
        byArray2[6] = 1;
        this.PROTOTYPE_1C1 = byArray2;
        byte[] byArray3 = new byte[21];
        byArray3[0] = 99;
        byArray3[1] = 8;
        byArray3[12] = 21;
        byArray3[20] = -46;
        this.PROTOTYPE_863 = byArray3;
    }

    public void addMsodrawingrec(MSODrawing rec) {
        this.msoRecs.add(rec);
    }

    public int getNextMsoSPID() {
        int spid = 0;
        int i = 0;
        while (i < this.msoRecs.size()) {
            spid = Math.max(((MSODrawing)this.msoRecs.get(i)).getSPID(), spid);
            ++i;
        }
        return spid + 1;
    }

    public void removeMsodrawingrec(MSODrawing rec, Boundsheet sheet, boolean removeObjRec) {
        int imgIdx = rec.getImageIndex() - 1;
        int refCnt = this.getCRef(imgIdx);
        boolean wasHeader = rec.bIsHeader;
        if (refCnt > 0) {
            this.decCRef(imgIdx);
        }
        this.msoRecs.remove(rec);
        this.updateRecord();
        int idx = rec.getRecordIndex();
        if (idx > -1) {
            sheet.removeRecFromVec(rec);
            if (removeObjRec) {
                sheet.removeRecFromVec(idx);
            }
        }
        if (this.getMsodrawingrecs().size() == 0) {
            sheet.removeRecFromVec(this);
            this.getWorkBook().msodg = null;
            BiffRec b = sheet.getSheetRec((short)237);
            if (b != null) {
                sheet.removeRecFromVec(b);
            }
        } else {
            if (wasHeader) {
                MSODrawing mso = null;
                int z = 0;
                while (z < this.getMsodrawingrecs().size()) {
                    mso = (MSODrawing)this.getMsodrawingrecs().get(z);
                    if (mso.getSheet().equals(sheet) && mso.isShape) {
                        mso.setIsHeader();
                        break;
                    }
                    ++z;
                }
            }
            this.wkbook.updateMsodrawingHeaderRec(sheet);
        }
    }

    public MSODrawing getMsoHeaderRec(Boundsheet bs) {
        int i = 0;
        while (i < this.msoRecs.size()) {
            MSODrawing msd = (MSODrawing)this.msoRecs.get(i);
            if (msd.getSheet().equals(bs) && msd.isHeader()) {
                return msd;
            }
            ++i;
        }
        return null;
    }

    public AbstractList getMsodrawingrecs() {
        return this.msoRecs;
    }

    @Override
    public void init() {
        super.init();
        this.data = super.getData();
    }

    public static XLSRecord getPrototype() {
        MSODrawingGroup grp = new MSODrawingGroup();
        grp.setOpcode((short)235);
        grp.setData(grp.PROTOTYPE_BYTES);
        grp.init();
        return grp;
    }

    public void initNewMSODrawingGroup() {
        int index = this.streamer.getRecordIndex(252);
        XLSRecord rec = new XLSRecord();
        rec.setOpcode((short)449);
        rec.setData(this.PROTOTYPE_1C1);
        this.streamer.addRecordAt(rec, index++);
        this.streamer.addRecordAt(this, index);
        Boundsheet[] b = this.getWorkBook().getWorkSheets();
        int i = 0;
        while (i < b.length) {
            int z = b[i].getIndexOf((short)239);
            if (z == -1) {
                Phonetic p = new Phonetic();
                p.setData(p.PROTOTYPE_BYTES);
                p.setOpcode((short)239);
                p.setDebugLevel(this.DEBUGLEVEL);
                p.setStreamer(this.getStreamer());
                b[i].insertSheetRecordAt(p, b[i].getIndexOf((short)29) + 1);
            }
            ++i;
        }
    }

    public void parse() {
        this.imageData.clear();
        this.imageType.clear();
        this.cRef.clear();
        if (this.data == null) {
            return;
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.data);
            while (bis.available() > 0) {
                byte[] buf = new byte[8];
                int read = bis.read(buf, 0, 8);
                int version = 0xF & buf[0];
                int inst = (0xFF & buf[1]) << 4 | (0xF0 & buf[0]) >> 4;
                int fbt = (0xFF & buf[3]) << 8 | 0xFF & buf[2];
                int len = ByteTools.readInt(buf[4], buf[5], buf[6], buf[7]);
                if (fbt < 61444) continue;
                buf = new byte[len];
                read = bis.read(buf, 0, len);
                switch (fbt) {
                    case 61446: {
                        this.spidMax = ByteTools.readInt(buf[0], buf[1], buf[2], buf[3]);
                        this.numIdClusters = ByteTools.readInt(buf[4], buf[5], buf[6], buf[7]);
                        this.numShapes = ByteTools.readInt(buf[8], buf[9], buf[10], buf[11]);
                        this.numDrawings = ByteTools.readInt(buf[12], buf[13], buf[14], buf[15]);
                        break;
                    }
                    case 61447: {
                        byte[] byArray = this.getImageBytesWithBuffer(buf);
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.logErr("Msodrawingroup parse error.", e);
        }
    }

    private byte[] getImageBytesWithBuffer(byte[] buf) {
        int HEADERLEN;
        byte btWin32 = buf[0];
        this.imageType.add(Integer.valueOf(btWin32));
        int ref = ByteTools.readInt(buf[24], buf[25], buf[26], buf[27]);
        this.cRef.add(ref);
        int STARTPOS = HEADERLEN = 61;
        int BYTELEN = buf.length;
        if (HEADERLEN > BYTELEN) {
            BYTELEN = 0;
            STARTPOS = 0;
        }
        byte[] imgBuf = new byte[BYTELEN -= STARTPOS];
        System.arraycopy(buf, STARTPOS, imgBuf, 0, BYTELEN);
        this.imageData.add(imgBuf);
        return imgBuf;
    }

    public void updateRecord() {
        MsofbtBSE[] BSE = new MsofbtBSE[this.imageData.size()];
        byte[] imageBytes = null;
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            int i = 0;
            while (i < this.imageData.size()) {
                BSE[i] = new MsofbtBSE(61447, Integer.parseInt(this.imageType.get(i).toString()), 2);
                BSE[i].setImageData((byte[])this.imageData.get(i));
                BSE[i].setImageType(Integer.parseInt(this.imageType.get(i).toString()));
                BSE[i].setRefCount((Integer)this.cRef.get(i));
                bos.write(BSE[i].toByteArray());
                ++i;
            }
            imageBytes = bos.toByteArray();
        }
        catch (Exception e) {
            Logger.logErr("Msodrawingroup createData error.", e);
        }
        MsofbtDgg dgg = new MsofbtDgg(61446, 0, 0);
        dgg.setSpidMax(this.spidMax);
        this.numDrawings = this.getNumDrawings();
        dgg.setNumDrawings(this.numDrawings);
        this.numShapes = this.getNumShapes();
        dgg.setNumShapes(this.numShapes);
        byte[] dggBytes = dgg.toByteArray();
        MsofbtOPT OPT = new MsofbtOPT(61451, 0, 3);
        OPT.setProperty(191, false, false, 524296, null);
        OPT.setProperty(385, false, false, 134217793, null);
        OPT.setProperty(448, false, false, 0x8000040, null);
        byte[] OPTBytes = OPT.toByteArray();
        MsofbtSplitMenuColors SplitMenuColors = new MsofbtSplitMenuColors(61726, 4, 0);
        byte[] SplitMenuColorsBytes = SplitMenuColors.toByteArray();
        int totalLength = imageBytes.length;
        byte[] BstoreContainerBytes = new byte[]{};
        if (totalLength > 0) {
            MsofbtBstoreContainer BstoreContainer = new MsofbtBstoreContainer(61441, this.imageData.size(), 15);
            BstoreContainer.setLength(totalLength);
            BstoreContainerBytes = BstoreContainer.toByteArray();
            totalLength += OPTBytes.length + SplitMenuColorsBytes.length + BstoreContainerBytes.length + dggBytes.length;
        } else {
            totalLength += OPTBytes.length + SplitMenuColorsBytes.length + dggBytes.length;
        }
        MsofbtDggContainer dggContainer = new MsofbtDggContainer(61440, 0, 15);
        dggContainer.setLength(totalLength);
        byte[] dggContainerBytes = dggContainer.toByteArray();
        int pos = 0;
        byte[] retData = new byte[totalLength + dggContainerBytes.length];
        System.arraycopy(dggContainerBytes, 0, retData, pos, dggContainerBytes.length);
        System.arraycopy(dggBytes, 0, retData, pos += dggContainerBytes.length, dggBytes.length);
        System.arraycopy(BstoreContainerBytes, 0, retData, pos += dggBytes.length, BstoreContainerBytes.length);
        System.arraycopy(imageBytes, 0, retData, pos += BstoreContainerBytes.length, imageBytes.length);
        System.arraycopy(OPTBytes, 0, retData, pos += imageBytes.length, OPTBytes.length);
        System.arraycopy(SplitMenuColorsBytes, 0, retData, pos += OPTBytes.length, SplitMenuColorsBytes.length);
        pos += SplitMenuColorsBytes.length;
        this.setData(retData);
    }

    public boolean setImageBytes(byte[] bts, Boundsheet bs, MSODrawing rec, String name) {
        int trueIdx = rec.getImageIndex() - 1;
        if (trueIdx < 0) {
            return false;
        }
        if (this.imageData.size() <= trueIdx) {
            return false;
        }
        try {
            if (this.getCRef(trueIdx) > 1) {
                ImageHandle im = new ImageHandle(bts, bs);
                int index = -1;
                ImageHandle[] imgz = bs.getImages();
                int i = 0;
                while (i < imgz.length) {
                    if (imgz[i].getName().equals(name)) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                ImageHandle origIm = imgz[index];
                im.setName(origIm.getName());
                im.setShapeName(origIm.getShapeName());
                im.setImageType(origIm.getImageType());
                bs.insertImage(im, true);
                im.position(origIm);
                this.removeMsodrawingrec(rec, bs, true);
                index = this.imageData.size() - 1;
            } else {
                this.imageData.set(trueIdx, bts);
            }
        }
        catch (Exception ex) {
            Logger.logErr("Msodrawingroup setImageBytes failed.", ex);
            return false;
        }
        this.updateRecord();
        this.parse();
        this.wkbook.initImages();
        return true;
    }

    public byte[] getImageBytes(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.imageData.size()) {
            return null;
        }
        byte[] ret = null;
        try {
            ret = (byte[])this.imageData.get(index);
        }
        catch (Exception ex) {
            Logger.logErr("Msodrawingroup getImageBytes error.", ex);
        }
        return ret;
    }

    public int getImageType(int index) {
        return Integer.parseInt(this.imageType.get(index).toString());
    }

    public int getNumImages() {
        return this.imageData.size();
    }

    public int getNumDrawings() {
        this.numDrawings = 0;
        int i = 0;
        while (i < this.msoRecs.size()) {
            if (((MSODrawing)this.msoRecs.get(i)).isHeader()) {
                ++this.numDrawings;
            }
            ++i;
        }
        return this.numDrawings;
    }

    public int getNumShapes() {
        this.numShapes = this.msoRecs.size();
        return this.numShapes;
    }

    public int getNumIdClusters() {
        return this.numIdClusters;
    }

    public int getSpidMax() {
        return this.spidMax;
    }

    public void setSpidMax(int spid) {
        this.spidMax = spid;
    }

    protected int containsImage(byte[] imgData) {
        int z = -1;
        int i = 0;
        while (i < this.imageData.size() && z < 0) {
            if (Arrays.equals(imgData, (byte[])this.imageData.get(0))) {
                z = i;
            }
            ++i;
        }
        return z;
    }

    public int findImage(byte[] imgData) {
        return this.containsImage(imgData);
    }

    public int addImage(byte[] imgData, int imgType, boolean bAddUnconditionally) {
        int n = -1;
        if (bAddUnconditionally || (n = this.containsImage(imgData)) == -1) {
            this.imageData.add(imgData);
            this.imageType.add(imgType);
            this.cRef.add(1);
            n = this.imageData.size();
        } else {
            this.incCRef(n);
            ++n;
        }
        return n;
    }

    public void clear() {
        this.numShapes = 0;
        this.imageData.clear();
        this.imageType.clear();
    }

    public void mergeRecords(MSODrawingGroup rec) {
        if (rec.hasContinues()) {
            rec.mergeAndRemoveContinues();
        }
        byte[] prevData = this.getBytes();
        byte[] newData = rec.getBytes();
        byte[] totalData = new byte[newData.length];
        if (prevData != null) {
            totalData = new byte[prevData.length + newData.length];
            System.arraycopy(prevData, 0, totalData, 0, prevData.length);
            System.arraycopy(newData, 0, totalData, prevData.length, newData.length);
        } else {
            totalData = newData;
        }
        this.setData(totalData);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("MSODrawingGroup: numShapes=" + this.numShapes + " numDrawings=" + this.numDrawings + " numIdCluster=" + this.numIdClusters + " spidMax=" + this.spidMax);
        sb.append("\nNumber of drawing records=" + this.msoRecs.size());
        if (this.data != null) {
            sb.append(" Length of data=" + this.data.length);
        }
        return sb.toString();
    }

    public void mergeAndRemoveContinues() {
        if (!this.isContinueMerged && this.hasContinues()) {
            super.mergeContinues();
        }
        if (this.hasContinues()) {
            for (Continue ci : this.continues) {
                this.getStreamer().removeRecord(ci);
            }
            super.removeContinues();
            this.continues = null;
        }
    }

    protected void incCRef(int idx) {
        if (idx >= 0 && idx < this.cRef.size()) {
            int cr = (Integer)this.cRef.get(idx) + 1;
            this.cRef.remove(idx);
            this.cRef.add(idx, cr);
        }
    }

    protected int getCRef(int idx) {
        if (idx >= 0 && idx < this.cRef.size()) {
            return (Integer)this.cRef.get(idx);
        }
        return -1;
    }

    protected void decCRef(int idx) {
        if (idx >= 0 && idx < this.cRef.size()) {
            int cr = (Integer)this.cRef.get(idx) - 1;
            this.cRef.remove(idx);
            this.cRef.add(idx, cr);
        } else {
            Logger.logErr("MSODrawingGroup: error encountered when decrementing Reference Count");
        }
    }

    public void addDrawingRecord(int spidMax, MSODrawing rec) {
        ++this.numDrawings;
        this.incCRef(rec.imageIndex - 1);
        this.spidMax = spidMax;
        this.updateRecord();
    }

    public void prestream() {
        int j = 0;
        if (this.dirtyflag) {
            int i = 0;
            while (i < this.msoRecs.size()) {
                MSODrawing mso = (MSODrawing)this.msoRecs.get(i);
                if (mso.isHeader()) {
                    mso.setDrawingId(++j);
                }
                ++i;
            }
        }
    }

    public int getNumDrawingRecs() {
        return this.msoRecs.size();
    }

    @Override
    public void close() {
        super.close();
        int i = 0;
        while (i < this.msoRecs.size()) {
            MSODrawing m = (MSODrawing)this.msoRecs.get(i);
            m.close();
            ++i;
        }
        this.msoRecs.clear();
    }
}

