/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.CellRange;
import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.formats.XLS.Blank;
import com.extentech.formats.XLS.Sheet;
import com.extentech.formats.XLS.XLSCellRecord;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;

public final class Mulblank
extends XLSCellRecord {
    private static final long serialVersionUID = 2707362447402042745L;
    short colFirst;
    short colLast;
    byte[] rgixfe;

    @Override
    public String toString() {
        return this.getCellAddress();
    }

    @Override
    public String getCellAddress() {
        String retval = "00";
        if (this.col == -1) {
            int rownum = this.getRowNumber() + 1;
            retval = String.valueOf(ExcelTools.getAlphaVal(this.colFirst)) + String.valueOf(rownum);
            retval = String.valueOf(retval) + ":" + ExcelTools.getAlphaVal(this.colLast) + String.valueOf(rownum);
        } else {
            int rownum = this.getRowNumber() + 1;
            retval = String.valueOf(ExcelTools.getAlphaVal(this.col)) + String.valueOf(rownum);
        }
        return retval;
    }

    @Override
    public int[] getIntLocation() {
        if (this.col == -1) {
            return new int[]{this.rw, this.colFirst, this.rw, this.colLast};
        }
        return new int[]{this.rw, this.col};
    }

    public String getMulblankRange() {
        String retval = "00";
        int rownum = this.getRowNumber() + 1;
        retval = String.valueOf(ExcelTools.getAlphaVal(this.colFirst)) + String.valueOf(rownum);
        retval = String.valueOf(retval) + ":" + ExcelTools.getAlphaVal(this.colLast) + String.valueOf(rownum);
        return retval;
    }

    @Override
    public void setSheet(Sheet bs) {
        this.worksheet = bs;
    }

    @Override
    public void init() {
        this.data = this.getData();
        super.init();
        if (this.getLength() - 4 <= 0) {
            if (this.DEBUGLEVEL > -1) {
                Logger.logInfo("no data in MULBLANK");
            }
        } else {
            int numblanks;
            this.rw = ByteTools.readUnsignedShort(this.getByteAt(0), this.getByteAt(1));
            this.colFirst = ByteTools.readShort(this.getByteAt(2), this.getByteAt(3));
            this.col = (short)-1;
            this.colLast = ByteTools.readShort(this.getByteAt(this.reclen - 2), this.getByteAt(this.reclen - 1));
            if (this.colLast < this.colFirst) {
                short csav = this.colLast;
                this.colLast = this.colFirst;
                this.colFirst = csav;
                this.colLast = (short)(this.colLast - 1);
            }
            if (this.DEBUGLEVEL > 5) {
                Logger.logInfo("INFO: MULBLANK range: " + this.colFirst + ":" + this.colLast);
            }
            if ((numblanks = this.colLast - this.colFirst + 1) < 1) {
                Logger.logWarn("WARNING: could not parse Mulblank record: numblanks reported  as:" + numblanks);
                return;
            }
            this.rgixfe = this.getBytesAt(4, numblanks * 2);
        }
        this.setIsValueForCell(true);
        this.isBlank = true;
    }

    @Override
    public short getColNumber() {
        if (this.col != -1) {
            return this.col;
        }
        return this.colFirst;
    }

    public void resetCol() {
        this.col = this.colFirst;
    }

    public void setColFirst(int c) {
        this.colFirst = (short)c;
    }

    public void setColLast(int c) {
        this.colLast = (short)c;
    }

    @Override
    public int getColFirst() {
        return this.colFirst;
    }

    @Override
    public int getColLast() {
        return this.colLast;
    }

    public boolean removeCell(short c) {
        byte[] tmp;
        if (c == this.colFirst) {
            this.colFirst = (short)(this.colFirst + 1);
            tmp = new byte[this.rgixfe.length - 2];
            System.arraycopy(this.rgixfe, 2, tmp, 0, tmp.length);
            this.rgixfe = tmp;
        } else if (c == this.colLast) {
            this.colLast = (short)(this.colLast - 1);
            tmp = new byte[this.rgixfe.length - 2];
            System.arraycopy(this.rgixfe, 0, tmp, 0, tmp.length);
            this.rgixfe = tmp;
        }
        if (c > this.colFirst && c < this.colLast) {
            try {
                int i = c + 1;
                while (i <= this.colLast) {
                    byte[] newblank = new byte[6];
                    System.arraycopy(this.getBytesAt(0, 2), 0, newblank, 0, 2);
                    System.arraycopy(ByteTools.shortToLEBytes((short)i), 0, newblank, 2, 2);
                    System.arraycopy(this.rgixfe, (i - this.colFirst) * 2, newblank, 4, 2);
                    Blank b = new Blank(newblank);
                    b.streamer = this.streamer;
                    b.setWorkBook(this.getWorkBook());
                    b.setSheet(this.getSheet());
                    b.setMergeRange(this.getMergeRange(i - this.colFirst));
                    this.getRow().removeCell((short)i);
                    this.getWorkBook().addRecord(b, true);
                    ++i;
                }
                tmp = new byte[2 * (c - this.colFirst + 1)];
                System.arraycopy(this.rgixfe, 0, tmp, 0, tmp.length);
                this.rgixfe = tmp;
                this.colLast = (short)(c - 1);
            }
            catch (Exception e) {
                Logger.logInfo("initializing Mulblank failed: " + e);
            }
            this.col = c;
        }
        if (this.colFirst < 0 || this.colLast < 0) {
            return true;
        }
        if (this.colFirst == this.colLast) {
            byte[] newblank = new byte[6];
            System.arraycopy(this.getBytesAt(0, 2), 0, newblank, 0, 2);
            System.arraycopy(ByteTools.shortToLEBytes(this.colFirst), 0, newblank, 2, 2);
            System.arraycopy(this.rgixfe, 0, newblank, 4, 2);
            Blank b = new Blank(newblank);
            b.streamer = this.streamer;
            b.setWorkBook(this.getWorkBook());
            b.setSheet(this.getSheet());
            b.setMergeRange(this.getMergeRange(this.colFirst));
            this.col = this.colFirst;
            this.getRow().removeCell(this);
            this.getWorkBook().addRecord(b, true);
            this.col = c;
            return false;
        }
        this.updateRecord();
        return this.colFirst > this.colLast;
    }

    @Override
    public String getStringVal() {
        return "";
    }

    public void setCurrentCell(short c) {
        this.col = c;
    }

    @Override
    public CellRange getMergeRange() {
        if (this.mergeRange == null) {
            return null;
        }
        if (this.col == -1) {
            return this.mergeRange;
        }
        if (this.mergeRange.contains(new int[]{this.getRowNumber(), this.col, this.getRowNumber(), this.col})) {
            return this.mergeRange;
        }
        return null;
    }

    private CellRange getMergeRange(int col) {
        if (this.mergeRange == null) {
            return null;
        }
        if (col == -1) {
            return this.mergeRange;
        }
        if (this.mergeRange.contains(new int[]{this.getRowNumber(), col, this.getRowNumber(), col})) {
            return this.mergeRange;
        }
        return null;
    }

    @Override
    public int getIxfe() {
        int idx = 0;
        if (this.col != -1 && this.col >= this.colFirst && this.col <= this.colLast) {
            idx = (this.col - this.colFirst) * 2;
        }
        this.ixfe = ByteTools.readShort(this.rgixfe[idx], this.rgixfe[idx + 1]);
        this.myxf = this.getWorkBook().getXf(this.ixfe);
        return this.ixfe;
    }

    public ArrayList<Integer> getColReferences() {
        ArrayList<Integer> colRefs = new ArrayList<Integer>();
        int i = this.colFirst;
        while (i <= this.colLast) {
            colRefs.add(i);
            ++i;
        }
        return colRefs;
    }

    @Override
    public void setIxfe(int i) {
        int idx = 0;
        if (this.col != -1 && this.col >= this.colFirst && this.col <= this.colLast) {
            idx = (this.col - this.colFirst) * 2;
        }
        byte[] b = ByteTools.shortToLEBytes((short)i);
        this.rgixfe[idx] = b[0];
        this.rgixfe[idx + 1] = b[1];
        this.updateRecord();
        this.ixfe = i;
        this.myxf = this.getWorkBook().getXf(this.ixfe);
    }

    @Override
    public void setCol(short i) {
        this.col = i;
    }

    private void updateRecord() {
        byte[] data = new byte[6 + this.rgixfe.length];
        data[0] = this.getData()[0];
        data[1] = this.getData()[1];
        byte[] b = ByteTools.shortToLEBytes(this.colFirst);
        data[2] = b[0];
        data[3] = b[1];
        System.arraycopy(this.rgixfe, 0, data, 4, this.rgixfe.length);
        b = ByteTools.shortToLEBytes(this.colLast);
        data[4 + this.rgixfe.length] = b[0];
        data[5 + this.rgixfe.length] = b[1];
        this.setData(data);
    }

    public static XLSRecord getPrototype() {
        Mulblank mb = new Mulblank();
        mb.setOpcode((short)190);
        mb.setData(new byte[6]);
        mb.col = (short)-1;
        return mb;
    }

    int getNumFields() {
        return this.colLast - this.colFirst + 1;
    }
}

