/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.CellNotFoundException;
import com.extentech.formats.XLS.ExpressionParser;
import com.extentech.formats.XLS.Externsheet;
import com.extentech.formats.XLS.Formula;
import com.extentech.formats.XLS.FormulaNotFoundException;
import com.extentech.formats.XLS.FunctionNotSupportedException;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.WorkSheetNotFoundException;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.formulas.FormulaCalculator;
import com.extentech.formats.XLS.formulas.FormulaParser;
import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.IlblListener;
import com.extentech.formats.XLS.formulas.IxtiListener;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgArea3d;
import com.extentech.formats.XLS.formulas.PtgArray;
import com.extentech.formats.XLS.formulas.PtgMemFunc;
import com.extentech.formats.XLS.formulas.PtgMystery;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.formats.XLS.formulas.PtgRef3d;
import com.extentech.formats.XLS.formulas.PtgRefErr3d;
import com.extentech.formats.XLS.formulas.PtgStr;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public final class Name
extends XLSRecord {
    private static final long serialVersionUID = -7868028144327389601L;
    short grbit = (short)-1;
    boolean DEBUG = false;
    boolean builtIn = false;
    String rgch = "";
    String rgce = "";
    String rcchCustMenu = "";
    String rgchDescr = "";
    String rgchHelpTopic = "";
    String rgchStatusText = "";
    byte chKey = (byte)-1;
    byte cch = (byte)-1;
    short cce = (short)-1;
    short ixals = (short)-1;
    short itab = (short)-1;
    byte cchCustMenu = (byte)-1;
    byte cchDescript = (byte)-1;
    byte cchHelpTopic = (byte)-1;
    byte cchStatusText = (byte)-1;
    public byte builtInType = (byte)-1;
    private Stack expression = null;
    Externsheet externsheet;
    private Ptg ptga;
    private ArrayList ilblListeners = new ArrayList();
    private String cachedOOXMLExpression = null;
    private byte[] expressionbytes = null;
    protected static final byte CONSOLIDATE_AREA = 0;
    protected static final byte AUTO_OPEN = 1;
    protected static final byte AUTO_CLOSE = 2;
    protected static final byte EXTRACT = 3;
    protected static final byte DATABASE = 4;
    protected static final byte CRITERIA = 5;
    protected static final byte PRINT_AREA = 6;
    protected static final byte PRINT_TITLES = 7;
    protected static final byte RECORDER = 8;
    protected static final byte DATA_FORM = 9;
    protected static final byte AUTO_ACTIVATE = 10;
    protected static final byte AUTO_DEACTIVATE = 11;
    protected static final byte SHEET_TITLE = 12;
    protected static final byte _FILTER_DATABASE = 13;
    private byte[] FILLER_NAME_BYTES;
    private byte[] PROTOTYPE_NAME_BYTES;
    int calc_id;

    public Name() {
        byte[] byArray = new byte[16];
        byArray[3] = 1;
        this.FILLER_NAME_BYTES = byArray;
        this.PROTOTYPE_NAME_BYTES = new byte[15];
        this.calc_id = 1;
    }

    public Name(WorkBook bk, String namestr) {
        byte[] byArray = new byte[16];
        byArray[3] = 1;
        this.FILLER_NAME_BYTES = byArray;
        this.PROTOTYPE_NAME_BYTES = new byte[15];
        this.calc_id = 1;
        byte[] bl = this.PROTOTYPE_NAME_BYTES;
        this.setData(bl);
        this.setOpcode((short)24);
        this.setLength((short)bl.length);
        this.setWorkBook(bk);
        try {
            this.setExternsheet(bk.getExternSheet());
        }
        catch (WorkSheetNotFoundException x) {
            Logger.logWarn("Name could not reference WorkBook Externsheet." + x.toString());
        }
        this.init(false);
        this.setName(namestr);
        bk.insertName(this);
    }

    public Name(WorkBook bk, boolean b) {
        byte[] byArray = new byte[16];
        byArray[3] = 1;
        this.FILLER_NAME_BYTES = byArray;
        this.PROTOTYPE_NAME_BYTES = new byte[15];
        this.calc_id = 1;
        byte[] bl = this.FILLER_NAME_BYTES;
        this.setData(bl);
        this.setOpcode((short)24);
        this.setLength((short)bl.length);
        this.setWorkBook(bk);
        try {
            this.setExternsheet(bk.getExternSheet());
        }
        catch (WorkSheetNotFoundException x) {
            Logger.logWarn("Name could not reference WorkBook Externsheet." + x.toString());
        }
        this.init();
        bk.insertName(this);
    }

    public void addIlblListener(IlblListener ptgname) {
        this.ilblListeners.add(ptgname);
    }

    public void removeIlblListener(IlblListener ptgname) {
        this.ilblListeners.remove(ptgname);
    }

    public ArrayList getIlblListeners() {
        return this.ilblListeners;
    }

    public void updateIlblListeners() {
        short ilbl = (short)this.getWorkBook().getNameNumber(this.getName());
        Iterator i = this.ilblListeners.iterator();
        while (i.hasNext()) {
            ((IlblListener)i.next()).setIlbl(ilbl);
        }
    }

    @Override
    public void init() {
        this.init(true);
    }

    public void init(boolean initExpression) {
        block26: {
            super.init();
            this.getData();
            this.grbit = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
            this.chKey = this.getByteAt(2);
            this.cch = this.getByteAt(3);
            this.cce = ByteTools.readShort(this.getByteAt(4), this.getByteAt(5));
            this.ixals = ByteTools.readShort(this.getByteAt(6), this.getByteAt(7));
            this.itab = ByteTools.readShort(this.getByteAt(8), this.getByteAt(9));
            this.cchCustMenu = this.getByteAt(10);
            this.cchDescript = this.getByteAt(11);
            this.cchHelpTopic = this.getByteAt(12);
            this.cchStatusText = this.getByteAt(13);
            if ((this.grbit & 0x20) == 32) {
                this.builtIn = true;
            }
            int pos = 15;
            if (this.getByteAt(14) == 1) {
                this.cch = (byte)(this.cch * 2);
            }
            try {
                byte[] namebytes = this.getBytesAt(pos, this.cch);
                if (this.getByteAt(14) == 1) {
                    this.rgch = new String(namebytes, "UTF-16LE");
                } else if (this.builtIn) {
                    this.builtInType = namebytes[0];
                    switch (this.builtInType) {
                        case 0: {
                            this.rgch = "Built-in: CONSOLIDATE_AREA";
                            break;
                        }
                        case 1: {
                            this.rgch = "Built-in: AUTO_OPEN";
                            break;
                        }
                        case 2: {
                            this.rgch = "Built-in: AUTO_CLOSE";
                            break;
                        }
                        case 3: {
                            this.rgch = "Built-in: EXTRACT";
                            break;
                        }
                        case 4: {
                            this.rgch = "Built-in: DATABASE";
                            break;
                        }
                        case 5: {
                            this.rgch = "Built-in: CRITERIA";
                            break;
                        }
                        case 6: {
                            this.rgch = "Built-in: PRINT_AREA";
                            break;
                        }
                        case 7: {
                            this.rgch = "Built-in: PRINT_TITLES";
                            break;
                        }
                        case 8: {
                            this.rgch = "Built-in: RECORDER";
                            break;
                        }
                        case 9: {
                            this.rgch = "Built-in: DATA_FORM";
                            break;
                        }
                        case 10: {
                            this.rgch = "Built-in: AUTO_ACTIVATE";
                            break;
                        }
                        case 11: {
                            this.rgch = "Built-in: AUTO_DEACTIVATE";
                            break;
                        }
                        case 12: {
                            this.rgch = "Built-in: SHEET_TITLE";
                            break;
                        }
                        case 13: {
                            this.rgch = "Built-in: _FILTER_DATABASE";
                        }
                    }
                } else {
                    this.rgch = new String(namebytes);
                }
                if (this.DEBUG) {
                    Logger.logInfo(this.getName());
                }
                this.expressionbytes = this.getBytesAt(pos += this.cch, this.cce);
                if (initExpression) {
                    this.parseExpression();
                }
            }
            catch (Exception e) {
                if (this.DEBUGLEVEL <= -1) break block26;
                Logger.logWarn("problem reading Name record expression for Name:" + this.getName() + " " + e);
            }
        }
    }

    public void parseExpression() {
        if (this.expressionbytes != null && this.expression == null) {
            this.expression = ExpressionParser.parseExpression(this.expressionbytes, this);
            if (this.DEBUGLEVEL == 50) {
                Logger.logInfo(String.valueOf(this.getName()) + ":" + this.getDefinition());
            }
            if (this.expression == null) {
                PtgMystery gpg = new PtgMystery();
                gpg.init(this.expressionbytes);
                this.expression = new Stack();
                this.expression.push(gpg);
            }
            this.expressionbytes = null;
        }
    }

    public Boundsheet[] getBoundSheets() {
        if (this.ptga == null) {
            try {
                this.initPtga();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.ptga instanceof PtgRef3d) {
            PtgRef3d p3d = (PtgRef3d)this.ptga;
            Boundsheet b = p3d.getSheet(this.getWorkBook());
            Boundsheet[] ret = new Boundsheet[]{b};
            return ret;
        }
        if (this.ptga instanceof PtgArea3d) {
            PtgArea3d p3d = (PtgArea3d)this.ptga;
            return p3d.getSheets(this.getWorkBook());
        }
        if (this.ptga instanceof PtgMemFunc) {
            PtgMemFunc p = (PtgMemFunc)this.ptga;
            return p.getSheets(this.getWorkBook());
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public String getExpressionString() {
        if ((this.expression == null || this.expression.size() == 0) && this.getCachedOOXMLExpression() != null) {
            return "=" + this.getCachedOOXMLExpression();
        }
        if (this.expression != null) {
            return FormulaParser.getExpressionString(this.expression);
        }
        return "=";
    }

    public Stack getExpression() {
        return this.expression;
    }

    public void setExpression(Stack x) {
        this.expression = x;
        this.updatePtgs();
    }

    public String getLocation() throws Exception {
        if (this.ptga == null) {
            try {
                this.initPtga();
            }
            catch (Exception e) {
                Logger.logWarn("Name.getLocation() failed: " + e.toString());
            }
        }
        if (this.ptga == null) {
            return null;
        }
        if (this.ptga instanceof PtgRefErr3d) {
            throw new CellNotFoundException("Named Range " + this.getName() + " has been deleted or it's referenced cell is invalid");
        }
        if (this.ptga instanceof PtgArea3d) {
            return this.ptga.getLocation();
        }
        if (this.ptga instanceof PtgRef3d) {
            return this.ptga.getLocation();
        }
        return this.ptga.toString();
    }

    public boolean isStringReference() {
        return this.expression.size() == 1 && this.expression.get(0) instanceof PtgStr;
    }

    public void initializeExpression(String xpression) {
        try {
            this.setLocation(xpression, false);
        }
        catch (FunctionNotSupportedException e) {
            Logger.logWarn("Unable to parse Name record expression: " + xpression);
            this.cachedOOXMLExpression = xpression;
        }
    }

    public void setLocation(String newloc) {
        this.setLocation(newloc, true);
    }

    public void setLocation(String newloc, boolean clearAffectedCells) throws FunctionNotSupportedException {
        if (newloc.indexOf("{") > -1) {
            throw new FunctionNotSupportedException("Unable to parse string expression for name record " + newloc);
        }
        if (this.ptga == null) {
            this.initPtga();
        }
        if (this.ptga != null) {
            ((PtgRef)this.ptga).removeFromRefTracker();
        }
        try {
            Formula f = new Formula();
            f.setWorkBook(this.wkbook);
            Stack ptgs = FormulaParser.getPtgsFromFormulaString(f, newloc);
            if (ptgs.size() == 1) {
                this.ptga = (Ptg)ptgs.pop();
                if (this.ptga instanceof PtgRef && ((PtgRef)this.ptga).getUseReferenceTracker()) {
                    ((PtgRef)this.ptga).updateInRefTracker(this);
                }
                this.ptga.setParentRec(this);
            } else {
                this.expression = ptgs;
                this.ptga = null;
            }
        }
        catch (Exception e) {
            Logger.logErr("Name.setLocation: Error processing location " + e.toString());
        }
        if (this.ptga instanceof PtgRef) {
            ((PtgRef)this.ptga).setColRel(false);
            ((PtgRef)this.ptga).setRowRel(false);
            if (clearAffectedCells) {
                try {
                    BiffRec[] b = ((PtgRef)this.ptga).getRefCells();
                    int i = 0;
                    while (i < b.length) {
                        if (b[i] != null) {
                            this.getWorkBook().getRefTracker().clearAffectedFormulaCells(b[i]);
                        }
                        ++i;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
        if (this.ptga != null) {
            this.expression = new Stack();
            this.expression.add(this.ptga);
            try {
                this.externsheet.addPtgListener((IxtiListener)((Object)this.ptga));
            }
            catch (Exception exception) {}
        } else {
            this.initPtga();
        }
        this.updatePtgs();
    }

    @Override
    public boolean remove(boolean b) {
        boolean ret = super.remove(true);
        this.wkbook.removeName(this);
        return ret;
    }

    @Override
    public void setWorkBook(WorkBook b) {
        super.setWorkBook(b);
    }

    void setExternsheet(Externsheet e) throws WorkSheetNotFoundException {
        this.externsheet = e;
        if (e == null) {
            this.externsheet = this.wkbook.getExternSheet(true);
        }
    }

    void initPtga() {
        if (this.expression == null) {
            this.init();
        }
        if (this.expression == null || this.expression.size() == 0) {
            return;
        }
        if (this.expression.size() == 1) {
            Ptg p = (Ptg)this.expression.get(0);
            if (p.getIsReference()) {
                this.ptga = p;
            }
        } else {
            Ptg p = FormulaCalculator.calculateFormulaPtg(this.expression);
            if (p.getIsReference()) {
                this.ptga = p;
            }
        }
    }

    public void setExternsheetRef(int x) {
        int t = 0;
        while (t < this.expression.size()) {
            PtgRef ptg3d;
            Ptg p = (Ptg)this.expression.get(t);
            if (p instanceof PtgArea3d) {
                if (this.DEBUGLEVEL > 1) {
                    Logger.logInfo("PtgArea3d encountered in Ai record.");
                }
                ptg3d = (PtgArea3d)p;
                ((PtgArea3d)ptg3d).setIxti((short)x);
                this.ptga = ptg3d;
            }
            if (p instanceof PtgRef3d) {
                if (this.DEBUGLEVEL > 1) {
                    Logger.logInfo("PtgRef3d encountered in Ai record.");
                }
                ptg3d = (PtgRef3d)p;
                ((PtgRef3d)ptg3d).setIxti((short)x);
                this.ptga = ptg3d;
            }
            ++t;
        }
    }

    public void updateSheetRefs(String origWorkBookName) {
        if (this.ptga == null) {
            this.initPtga();
        }
        if (this.ptga instanceof PtgArea3d) {
            PtgArea3d p = (PtgArea3d)this.ptga;
            try {
                this.getWorkBook().getWorkSheetByName(p.getSheetName());
                this.ptga.setLocation(this.ptga.toString());
            }
            catch (WorkSheetNotFoundException we) {
                Logger.logWarn("External References Not Supported:  UpdateSheetReferences: External Worksheet Reference Found: " + p.getSheetName());
                p.setExternalReference(origWorkBookName);
            }
        }
    }

    public void setName(String newname) {
        try {
            byte[] namebytes;
            int modnamelen = 0;
            byte[] dta = this.getData();
            boolean isuni = false;
            if (this.getByteAt(14) == 1) {
                namebytes = newname.getBytes("UTF-16LE");
                isuni = true;
            } else {
                namebytes = newname.getBytes("ISO-8859-1");
            }
            modnamelen = namebytes.length;
            int bodlen = dta.length;
            bodlen -= this.cch;
            byte[] newbytes = new byte[bodlen += modnamelen];
            System.arraycopy(dta, 0, newbytes, 0, 15);
            System.arraycopy(namebytes, 0, newbytes, 15, modnamelen);
            System.arraycopy(dta, this.cch + 15, newbytes, modnamelen + 15, dta.length - (this.cch + 15));
            this.cch = (byte)modnamelen;
            newbytes[3] = !isuni ? this.cch : (byte)(this.cch / 2);
            this.setData(newbytes);
            this.rgch = newname;
        }
        catch (UnsupportedEncodingException e) {
            Logger.logWarn("UnsupportedEncodingException in setting NamedRange name: " + e);
        }
    }

    public String getName() {
        return this.rgch;
    }

    public String getNameA() {
        return this.rgch.toUpperCase();
    }

    public Object getCalculatedValue() throws FunctionNotSupportedException {
        return FormulaCalculator.calculateFormula(this.expression);
    }

    String getDefinition() {
        if (this.ptga == null) {
            this.initPtga();
        }
        return this.ptga.getString();
    }

    String getDescription() {
        return this.rgchDescr;
    }

    @Override
    public void preStream() {
        try {
            this.updatePtgs();
        }
        catch (Exception e) {
            Logger.logWarn("problem updating Name record expression for Name:" + this.getName());
        }
    }

    public void updatePtgs() {
        int offset;
        if (this.expression == null) {
            return;
        }
        byte[] rkdata = this.getData();
        int sz = offset = 15 + this.cch;
        int sz2 = rkdata.length - (offset + this.cce);
        this.cce = 0;
        int i = 0;
        while (i < this.expression.size()) {
            Ptg ptg = (Ptg)this.expression.elementAt(i);
            this.cce = (short)(this.cce + ptg.getLength());
            ++i;
        }
        sz += this.cce;
        byte[] updated = new byte[sz += sz2];
        System.arraycopy(rkdata, 0, updated, 0, offset);
        byte[] cbytes = ByteTools.shortToLEBytes(this.cce);
        updated[4] = cbytes[0];
        updated[5] = cbytes[1];
        boolean hasArray = false;
        byte[] arraybytes = new byte[]{};
        int i2 = 0;
        while (i2 < this.expression.size()) {
            byte[] b;
            Ptg ptg = (Ptg)this.expression.elementAt(i2);
            if (ptg instanceof PtgArray) {
                PtgArray pa = (PtgArray)ptg;
                b = pa.getPreRecord();
                arraybytes = ByteTools.append(pa.getPostRecord(), arraybytes);
                hasArray = true;
            } else {
                b = ptg.getRecord();
            }
            try {
                System.arraycopy(b, 0, updated, offset, b.length);
            }
            catch (Exception e) {
                Logger.logInfo("setting ExternalSheetValue in Name rec: value: " + ptg.getOpcode() + ": " + e);
            }
            offset += ptg.getLength();
            ++i2;
        }
        if (hasArray) {
            updated = ByteTools.append(arraybytes, updated);
        }
        if (sz2 > 0) {
            System.arraycopy(rkdata, rkdata.length - sz2, updated, offset, sz2);
        }
        this.setData(updated);
    }

    @Override
    public String getCellAddress() {
        if (this.getSheet() != null) {
            return this.getSheet() + "!" + this.getName();
        }
        return this.getName();
    }

    public Ptg[] getCellRangePtgs() throws FormulaNotFoundException {
        Ptg[] p;
        if (this.ptga == null) {
            this.initPtga();
        }
        if ((p = this.ptga.getComponents()) == null) {
            return new Ptg[]{this.ptga};
        }
        return p;
    }

    public List getPtgsByLocation(String loc) {
        try {
            return ExpressionParser.getPtgsByLocation(loc, this.expression);
        }
        catch (FormulaNotFoundException e) {
            Logger.logInfo("updating Chart Series Location failed: " + e);
            return null;
        }
    }

    public void updateSheetReferences(Boundsheet newSheet) {
        int i = 0;
        while (i < this.expression.size()) {
            Object o = this.expression.elementAt(i);
            if (o instanceof PtgMemFunc) {
                PtgMemFunc pmf = (PtgMemFunc)o;
                Stack<?> s = pmf.getSubExpression();
                int x = 0;
                while (x < s.size()) {
                    Object ox = s.elementAt(x);
                    if (ox instanceof PtgArea3d) {
                        PtgArea3d p3d = (PtgArea3d)ox;
                        p3d.setReferencedSheet(newSheet);
                    }
                    ++x;
                }
            } else if (o instanceof PtgArea3d) {
                ((PtgArea3d)o).setReferencedSheet(newSheet);
            }
            ++i;
        }
        this.updatePtgs();
    }

    public boolean setLocationPolicy(String loc, int l) {
        List dx = this.getPtgsByLocation(loc);
        for (Ptg d : dx) {
            if (d == null) continue;
            d.setLocationPolicy(l);
        }
        return true;
    }

    public Externsheet getExternsheet() {
        return this.externsheet;
    }

    public Ptg getPtga() {
        if (this.ptga == null) {
            this.initPtga();
        }
        return this.ptga;
    }

    public boolean isBuiltIn() {
        return this.builtIn;
    }

    public byte getBuiltInType() {
        return this.builtInType;
    }

    public void setBuiltIn(byte builtinType) {
        this.grbit = (short)(this.grbit | 0x20);
        if (builtinType == 13) {
            this.grbit = (short)(this.grbit | 1);
        }
        byte[] grbytes = ByteTools.shortToLEBytes(this.grbit);
        byte[] newData = new byte[16];
        newData[0] = grbytes[0];
        newData[1] = grbytes[1];
        newData[3] = 1;
        newData[15] = builtinType;
        this.setData(newData);
        this.init();
    }

    public short getIxals() {
        return this.ixals;
    }

    public void setIxals(short ixals) {
        this.ixals = ixals;
        byte[] b = ByteTools.shortToLEBytes(ixals);
        byte[] rkdata = this.getData();
        rkdata[6] = b[0];
        rkdata[7] = b[1];
        this.setData(rkdata);
    }

    public short getItab() {
        return this.itab;
    }

    public void setItab(short itab) {
        this.itab = itab;
        byte[] b = ByteTools.shortToLEBytes(itab);
        this.getData()[8] = b[0];
        this.getData()[9] = b[1];
    }

    public Name(WorkBook bk, String namestr, String value, int scope) {
        byte[] byArray = new byte[16];
        byArray[3] = 1;
        this.FILLER_NAME_BYTES = byArray;
        this.PROTOTYPE_NAME_BYTES = new byte[15];
        this.calc_id = 1;
        byte[] bl = this.PROTOTYPE_NAME_BYTES;
        this.setData(bl);
        this.setOpcode((short)24);
        this.setLength((short)bl.length);
        this.setItab((short)scope);
        this.setWorkBook(bk);
        try {
            this.setExternsheet(bk.getExternSheet());
        }
        catch (WorkSheetNotFoundException x) {
            Logger.logWarn("Name could not reference WorkBook Externsheet." + x.toString());
        }
        this.init();
        this.setName(namestr);
        bk.insertName(this);
        this.initializeExpression(value);
    }

    public String getCachedOOXMLExpression() {
        return this.cachedOOXMLExpression;
    }

    public void setCachedOOXMLExpression(String cachedOOXMLExpression) {
        this.cachedOOXMLExpression = cachedOOXMLExpression;
    }

    public void setNewScope(int newitab) throws WorkSheetNotFoundException {
        if (this.itab == 0) {
            this.getWorkBook().removeLocalName(this);
        } else {
            this.getWorkBook().getWorkSheetByNumber(this.itab - 1).removeLocalName(this);
        }
        if (newitab == 0) {
            this.getWorkBook().addLocalName(this);
        } else {
            this.getWorkBook().getWorkSheetByNumber(newitab - 1).addLocalName(this);
        }
        this.setItab((short)newitab);
    }

    @Override
    public void close() {
        this.externsheet = null;
        if (this.ptga != null) {
            if (this.ptga instanceof PtgRef) {
                ((PtgRef)this.ptga).close();
            } else {
                ((GenericPtg)this.ptga).close();
            }
            this.ptga = null;
        }
        if (this.expression != null) {
            while (!this.expression.isEmpty()) {
                GenericPtg p = (GenericPtg)this.expression.pop();
                if (p instanceof PtgRef) {
                    ((PtgRef)p).close();
                } else {
                    p.close();
                }
                Object var1_1 = null;
            }
        }
        super.close();
    }

    protected void finalize() {
        this.close();
    }
}

