/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.CellHandle;
import com.extentech.ExtenXLS.CellRange;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.LEO.BlockByteReader;
import com.extentech.formats.LEO.Storage;
import com.extentech.formats.LEO.StorageNotFoundException;
import com.extentech.formats.LEO.StorageTable;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.InvalidRecordException;
import com.extentech.formats.XLS.PivotCacheRecord;
import com.extentech.formats.XLS.SXBool;
import com.extentech.formats.XLS.SXDBEx;
import com.extentech.formats.XLS.SXFDBType;
import com.extentech.formats.XLS.SXNum;
import com.extentech.formats.XLS.SXString;
import com.extentech.formats.XLS.SxDB;
import com.extentech.formats.XLS.SxDBB;
import com.extentech.formats.XLS.SxFDB;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.XLSConstants;
import com.extentech.formats.XLS.XLSRecordFactory;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;
import java.util.HashMap;

public class PivotCache
implements XLSConstants {
    WorkBook book;
    HashMap<Integer, Storage> caches = new HashMap();
    HashMap<Integer, ArrayList<BiffRec>> pivotCacheRecs = new HashMap();

    public void init(StorageTable directories, WorkBookHandle wbh) throws StorageNotFoundException {
        Storage child = directories.getChild("_SX_DB_CUR");
        if (wbh != null) {
            this.caches = new HashMap();
            this.book = wbh.getWorkBook();
            if (wbh.getDebugLevel() > 25) {
                Logger.logInfo("PivotCache.init");
            }
        }
        while (child != null) {
            if (wbh != null) {
                this.caches.put(Integer.valueOf(child.getName()), child);
            }
            ArrayList<BiffRec> curRecs = new ArrayList<BiffRec>();
            BlockByteReader bytes = child.getBlockReader();
            int len = bytes.getLength();
            int i = 0;
            while (i <= len - 4) {
                byte[] headerbytes = bytes.getHeaderBytes(i);
                short opcode = ByteTools.readShort(headerbytes[0], headerbytes[1]);
                short reclen = ByteTools.readShort(headerbytes[2], headerbytes[3]);
                BiffRec rec = XLSRecordFactory.getBiffRecord(opcode);
                if (wbh != null) {
                    rec.setDebugLevel(wbh.getDebugLevel());
                }
                rec.setWorkBook(this.book);
                rec.setByteReader(bytes);
                rec.setLength(reclen);
                rec.setOffset(i);
                rec.init();
                if (wbh != null) {
                    curRecs.add(rec);
                }
                i += reclen + 4;
            }
            if (wbh != null) {
                this.pivotCacheRecs.put(Integer.valueOf(child.getName()), curRecs);
            }
            child = directories.getNext(child.getName());
        }
    }

    public void createPivotCache(StorageTable directories, WorkBookHandle wbh, String ref, int sId) throws InvalidRecordException {
        try {
            if (wbh.getDebugLevel() > 100) {
                System.out.println(String.format("creatpivotCache: ref: %s sid %d", ref, sId));
            }
            try {
                directories.getDirectoryByName("\u0001CompObj");
            }
            catch (StorageNotFoundException e) {
                Storage compObj = directories.createStorage("\u0001CompObj", 2, directories.getDirectoryStreamID("\u0005DocumentSummaryInformation") + 1);
                byte[] byArray = new byte[114];
                byArray[0] = 1;
                byArray[2] = -2;
                byArray[3] = -1;
                byArray[4] = 3;
                byArray[5] = 10;
                byArray[8] = -1;
                byArray[9] = -1;
                byArray[10] = -1;
                byArray[11] = -1;
                byArray[12] = 32;
                byArray[13] = 8;
                byArray[14] = 2;
                byArray[20] = -64;
                byArray[27] = 70;
                byArray[28] = 38;
                byArray[32] = 77;
                byArray[33] = 105;
                byArray[34] = 99;
                byArray[35] = 114;
                byArray[36] = 111;
                byArray[37] = 115;
                byArray[38] = 111;
                byArray[39] = 102;
                byArray[40] = 116;
                byArray[41] = 32;
                byArray[42] = 79;
                byArray[43] = 102;
                byArray[44] = 102;
                byArray[45] = 105;
                byArray[46] = 99;
                byArray[47] = 101;
                byArray[48] = 32;
                byArray[49] = 69;
                byArray[50] = 120;
                byArray[51] = 99;
                byArray[52] = 101;
                byArray[53] = 108;
                byArray[54] = 32;
                byArray[55] = 50;
                byArray[56] = 48;
                byArray[57] = 48;
                byArray[58] = 51;
                byArray[59] = 32;
                byArray[60] = 87;
                byArray[61] = 111;
                byArray[62] = 114;
                byArray[63] = 107;
                byArray[64] = 115;
                byArray[65] = 104;
                byArray[66] = 101;
                byArray[67] = 101;
                byArray[68] = 116;
                byArray[70] = 6;
                byArray[74] = 66;
                byArray[75] = 105;
                byArray[76] = 102;
                byArray[77] = 102;
                byArray[78] = 56;
                byArray[80] = 14;
                byArray[84] = 69;
                byArray[85] = 120;
                byArray[86] = 99;
                byArray[87] = 101;
                byArray[88] = 108;
                byArray[89] = 46;
                byArray[90] = 83;
                byArray[91] = 104;
                byArray[92] = 101;
                byArray[93] = 101;
                byArray[94] = 116;
                byArray[95] = 46;
                byArray[96] = 56;
                byArray[98] = -12;
                byArray[99] = 57;
                byArray[100] = -78;
                byArray[101] = 113;
                compObj.setBytesWithOverage(byArray);
                int compObjid = directories.getDirectoryStreamID("\u0001CompObj");
                Storage wb = directories.getDirectoryByName("Workbook");
                wb.setPrevStorageID(compObjid);
            }
            Storage sx_db_cur = directories.createStorage("_SX_DB_CUR", 1, directories.getDirectoryStreamID("\u0005SummaryInformation"));
            int sxdbcurid = directories.getDirectoryStreamID("_SX_DB_CUR");
            Storage pcache1 = directories.createStorage("0001", 2, sxdbcurid + 1);
            directories.getDirectoryByName("Root Entry").setChildStorageID(sxdbcurid);
            sx_db_cur.setPrevStorageID(directories.getDirectoryStreamID("Workbook"));
            sx_db_cur.setChildStorageID(directories.getDirectoryStreamID("0001"));
            sx_db_cur.setNextStorageID(directories.getDirectoryStreamID("\u0005SummaryInformation"));
            Storage si = directories.getDirectoryByName("\u0005SummaryInformation");
            si.setPrevStorageID(-1);
            si.setNextStorageID(directories.getDirectoryStreamID("\u0005DocumentSummaryInformation"));
            directories.getDirectoryByName("Root Entry").setChildStorageID(sxdbcurid);
            byte[] newbytes = this.createPivotCacheRecords(ref, wbh, sId);
            pcache1.setBytesWithOverage(newbytes);
            this.init(directories, wbh);
        }
        catch (StorageNotFoundException storageNotFoundException) {
            // empty catch block
        }
    }

    public void addCacheItem(int cacheId, int cacheItem) {
        int insertIndex = 0;
        for (BiffRec br : this.pivotCacheRecs.get(cacheId + 1)) {
            if (br.getOpcode() == 199) {
                ((SxFDB)br).setNCacheItems(((SxFDB)br).getNCacheItems() + 1);
                continue;
            }
            if (br.getOpcode() != 10) continue;
            insertIndex = this.pivotCacheRecs.get(cacheId + 1).indexOf(br);
        }
        if (cacheItem > -1) {
            SxDBB sxdbb = (SxDBB)SxDBB.getPrototype();
            sxdbb.setCacheItemIndexes(new byte[]{Integer.valueOf(cacheItem).byteValue()});
            this.pivotCacheRecs.get(cacheId + 1).add(insertIndex, sxdbb);
        }
        this.updateCacheRecords(cacheId);
    }

    private void updateCacheRecords(int cacheId) {
        byte[] newbytes = new byte[]{};
        for (BiffRec br : this.pivotCacheRecs.get(cacheId + 1)) {
            try {
                newbytes = ByteTools.append(((PivotCacheRecord)((Object)br)).getRecord(), newbytes);
            }
            catch (ClassCastException e) {
                newbytes = ByteTools.append(ByteTools.shortToLEBytes(br.getOpcode()), newbytes);
                newbytes = ByteTools.append(ByteTools.shortToLEBytes((short)br.getData().length), newbytes);
                newbytes = ByteTools.append(br.getData(), newbytes);
            }
        }
        Storage pcache1 = this.caches.get(cacheId + 1);
        pcache1.setBytesWithOverage(newbytes);
    }

    byte[] createPivotCacheRecords(String ref, WorkBookHandle wbh, int sId) {
        byte[] newbytes = new byte[]{};
        try {
            CellRange cr = new CellRange(ref, wbh, false, true);
            CellHandle[] ch = cr.getCells();
            int[] rows = cr.getRowInts();
            int[] cols = cr.getColInts();
            int[] types = new int[cols.length];
            byte[][] cachefieldindexes = new byte[cols.length][rows.length - 1];
            SxDB sxdb = (SxDB)SxDB.getPrototype();
            sxdb.setNCacheRecords(rows.length - 1);
            sxdb.setNCacheFields(cols.length);
            sxdb.setStreamID(sId);
            newbytes = ByteTools.append(sxdb.getRecord(), newbytes);
            SXDBEx sxdbex = (SXDBEx)SXDBEx.getPrototype();
            newbytes = ByteTools.append(sxdbex.getRecord(), newbytes);
            if (ch.length > cols.length) {
                int i = 0;
                while (i < cols.length) {
                    CellHandle c = ch[i + cols.length];
                    int type = -1;
                    type = c.isDate() ? 6 : c.getCellType();
                    types[i] = type;
                    ++i;
                }
            }
            int z = 0;
            while (z < rows.length) {
                int i = 0;
                while (i < cols.length) {
                    if (z == 0) {
                        SxFDB sxfdb = (SxFDB)SxFDB.getPrototype();
                        sxfdb.setCacheItemsType(types[i]);
                        sxfdb.setCacheField(ch[i].getStringVal());
                        sxfdb.setNCacheItems(0);
                        newbytes = ByteTools.append(sxfdb.getRecord(), newbytes);
                        SXFDBType sxfdbtype = (SXFDBType)SXFDBType.getPrototype();
                        newbytes = ByteTools.append(sxfdbtype.getRecord(), newbytes);
                    } else {
                        cachefieldindexes[i][z - 1] = (byte)i;
                        CellHandle c = ch[z * cols.length + i];
                        switch (types[i]) {
                            case 0: {
                                SXString sxstring = (SXString)SXString.getPrototype();
                                sxstring.setCacheItem(c.getStringVal());
                                newbytes = ByteTools.append(sxstring.getRecord(), newbytes);
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 5: {
                                SXNum sxnum = (SXNum)SXNum.getPrototype();
                                sxnum.setNum(c.getDoubleVal());
                                newbytes = ByteTools.append(sxnum.getRecord(), newbytes);
                                break;
                            }
                            case 4: {
                                SXBool sxbool = (SXBool)SXBool.getPrototype();
                                sxbool.setBool(c.getBooleanVal());
                                newbytes = ByteTools.append(sxbool.getRecord(), newbytes);
                            }
                        }
                    }
                    ++i;
                }
                ++z;
            }
        }
        catch (Exception e) {
            throw new InvalidRecordException("PivotCache.createPivotCache: invalid source range: " + ref);
        }
        byte[] b = new byte[4];
        System.arraycopy(ByteTools.shortToLEBytes((short)10), 0, b, 0, 2);
        newbytes = ByteTools.append(b, newbytes);
        return newbytes;
    }
}

