/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.XLSConstants;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.io.UnsupportedEncodingException;

public class QsiSXTag
extends XLSRecord
implements XLSConstants {
    private static final long serialVersionUID = 2639291289806138985L;
    private short flags;
    private short ver;
    private short cchName;
    private String name;
    private byte[] PROTOTYPE_BYTES;

    public QsiSXTag() {
        byte[] byArray = new byte[18];
        byArray[0] = 2;
        byArray[1] = 8;
        byArray[4] = 1;
        byArray[6] = 1;
        byArray[12] = 3;
        byArray[14] = 16;
        this.PROTOTYPE_BYTES = byArray;
    }

    @Override
    public void init() {
        super.init();
        this.flags = ByteTools.readShort(this.getByteAt(6), this.getByteAt(7));
        byte verSxLastUpdated = this.getByteAt(12);
        byte verSxUpdatableMin = this.getByteAt(13);
        this.cchName = ByteTools.readShort(this.getByteAt(16), this.getByteAt(17));
        if (this.cchName > 0) {
            byte encoding = this.getByteAt(18);
            byte[] tmp = this.getBytesAt(19, this.cchName * (encoding + 1));
            try {
                this.name = encoding == 0 ? new String(tmp, "ISO-8859-1") : new String(tmp, "UTF-16LE");
            }
            catch (UnsupportedEncodingException e) {
                Logger.logInfo("encoding PivotTable name in QxiSXTag: " + e);
            }
        }
        if (this.DEBUGLEVEL > 3) {
            Logger.logInfo("QXISXTAG- flags:" + this.flags + " verLast:" + verSxLastUpdated + " verMin:" + verSxUpdatableMin + " name:" + this.name);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        byte[] data = new byte[18];
        System.arraycopy(this.getData(), 0, data, 0, 15);
        if (name != null) {
            byte[] strbytes = null;
            try {
                strbytes = this.name.getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                Logger.logInfo("encoding pivot table name in SXVI: " + e);
            }
            this.cchName = (short)strbytes.length;
            byte[] nm = ByteTools.shortToLEBytes(this.cchName);
            data[16] = nm[0];
            data[17] = nm[1];
            byte[] newrgch = new byte[this.cchName + 1];
            System.arraycopy(strbytes, 0, newrgch, 1, this.cchName);
            data = ByteTools.append(newrgch, data);
            data = ByteTools.append(new byte[2], data);
        }
        this.setData(data);
    }

    public static XLSRecord getPrototype() {
        QsiSXTag qsi = new QsiSXTag();
        qsi.setOpcode((short)2050);
        qsi.setData(qsi.PROTOTYPE_BYTES);
        qsi.init();
        return qsi;
    }
}

