/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.PivotCacheRecord;
import com.extentech.formats.XLS.XLSConstants;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class SXString
extends XLSRecord
implements XLSConstants,
PivotCacheRecord {
    private static final long serialVersionUID = 9027599480633995587L;
    private short cch;
    private String segment;

    @Override
    public void init() {
        super.init();
        this.cch = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        if (this.cch > 0) {
            byte encoding = this.getByteAt(2);
            byte[] tmp = this.getBytesAt(3, this.cch * (encoding + 1));
            try {
                this.segment = encoding == 0 ? new String(tmp, "ISO-8859-1") : new String(tmp, "UTF-16LE");
            }
            catch (UnsupportedEncodingException e) {
                Logger.logInfo("SXString.init: " + e);
            }
        }
        if (this.DEBUGLEVEL > 3) {
            Logger.logInfo(this.toString());
        }
    }

    @Override
    public String toString() {
        return "SXString: " + (this.segment != null ? this.segment : "null") + Arrays.toString(this.getRecord());
    }

    public static XLSRecord getPrototype() {
        SXString sxstring = new SXString();
        sxstring.setOpcode((short)205);
        sxstring.setData(new byte[]{-1, -1});
        sxstring.init();
        return sxstring;
    }

    public void setCacheItem(String s) {
        this.segment = s;
        byte[] strbytes = new byte[]{};
        if (this.segment != null) {
            try {
                strbytes = this.segment.getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                Logger.logInfo("SxString: " + e);
            }
        }
        this.cch = (short)strbytes.length;
        byte[] nm = ByteTools.shortToLEBytes(this.cch);
        byte[] data = new byte[this.cch + 3];
        System.arraycopy(nm, 0, data, 0, 2);
        System.arraycopy(strbytes, 0, data, 3, this.cch);
        this.setData(data);
    }

    public String getCacheItem() {
        return this.segment;
    }

    @Override
    public byte[] getRecord() {
        byte[] b = new byte[4];
        System.arraycopy(ByteTools.shortToLEBytes(this.getOpcode()), 0, b, 0, 2);
        System.arraycopy(ByteTools.shortToLEBytes((short)this.getData().length), 0, b, 2, 2);
        return ByteTools.append(this.getData(), b);
    }
}

