/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.Ss_rPr;
import com.extentech.formats.XLS.Continue;
import com.extentech.formats.XLS.Extsst;
import com.extentech.formats.XLS.Font;
import com.extentech.formats.XLS.OOXMLAdapter;
import com.extentech.formats.XLS.Unicodestring;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.CompatibleVector;
import com.extentech.toolkit.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public final class Sst
extends XLSRecord {
    private static final long serialVersionUID = 6966063306230877101L;
    private int cstTotal = -1;
    private int cstUnique = -1;
    private final int boundincrement = 0;
    private int numconts = -1;
    private int[] boundaries = null;
    private byte[] grbits = null;
    private List stringvector = new SstArrayList();
    private HashSet dupeSstEntries = new HashSet();
    private HashSet existingSstEntries = new HashSet();
    private Extsst myextsst = null;
    int origsstlen = 0;
    Continue thiscont = null;
    int datalen = -1;
    int currbound = 0;
    byte[] deldata = null;
    int retpos = -1;
    CompatibleVector cbounds = new CompatibleVector();
    CompatibleVector sstgrbits = new CompatibleVector();
    boolean lastwasbreakable = true;
    boolean stringisonbound = false;
    boolean laststringwasonbound = false;
    boolean islast = false;
    int thisbounds = 8224;
    int lastbounds = 0;
    int contcounter = 0;
    int lastlen = 0;
    int grbitct = 0;
    int dl = 0;
    int leftoverlen = 0;
    byte gr = 0;
    int stringnumber = 0;
    int continuenumber = -1;
    int lastgrbit = 0;
    Object[] continueDef;
    int STRING_ENCODING_MODE = 1;

    int getOrigSstLen() {
        return this.origsstlen;
    }

    public int getRealOriginalSize() {
        return this.originalsize;
    }

    @Override
    public void setData(byte[] b) {
        if (this.data == null) {
            this.originalsize = b.length;
        }
        super.setData(b);
    }

    void setExtsst(Extsst e) {
        this.myextsst = e;
    }

    Extsst getExtsst() {
        return this.myextsst;
    }

    @Override
    public void removeContinues() {
        super.removeContinues();
        this.continues = null;
        this.thiscont = null;
    }

    private void initContinues() {
        this.datalen = this.getLength();
        this.numconts = this.getContinueVect().size();
        this.boundaries = new int[this.numconts + 1];
        int thisbound = 0;
        int ir = 0;
        this.grbits = new byte[this.numconts];
        for (Continue ci : this.continues) {
            this.grbits[ir++] = ci.getGrbit();
            this.getStreamer().removeRecord(ci);
        }
        this.boundaries[0] = thisbound = this.getRealOriginalSize();
        int lastcontlen = 0;
        int i = 1;
        while (i < this.boundaries.length) {
            Continue cxi = (Continue)this.continues.get(i - 1);
            int contlen = cxi.getLength();
            if (cxi.getHasGrbit()) {
                --contlen;
            }
            lastcontlen += contlen;
            this.datalen += contlen;
            this.boundaries[i] = (thisbound += contlen) - 4 * i;
            cxi.setContinueOffset(this.boundaries[i - 1]);
            ++i;
        }
        thisbound = 0;
    }

    public boolean getUpdatesAllBOFPositions() {
        return true;
    }

    @Override
    public void init() {
        if (this.originalsize == 0) {
            this.originalsize = this.reclen;
        }
        Sst.init(this);
    }

    public static void init(Sst sst) {
        sst.origsstlen = sst.getLength();
        sst.currbound = 0;
        sst.stringvector.clear();
        sst.cstTotal = ByteTools.readInt(sst.getByteAt(0), sst.getByteAt(1), sst.getByteAt(2), sst.getByteAt(3));
        sst.cstUnique = ByteTools.readInt(sst.getByteAt(4), sst.getByteAt(5), sst.getByteAt(6), sst.getByteAt(7));
        int strlen = 0;
        int strpos = 8;
        if (sst.DEBUGLEVEL > 5) {
            Logger.logInfo("INFO: initializing Sst: " + sst.cstTotal + " total Strings, " + sst.cstUnique + " unique Strings.");
        }
        sst.initContinues();
        int d = 0;
        while (d < sst.cstUnique) {
            int offr;
            short numruns = 0;
            int runlen = 0;
            int basereclen = 3;
            int cchExtRst = 0;
            boolean doubleByte = false;
            byte grbit = 0;
            if (sst.DEBUGLEVEL > 30) {
                Logger.logInfo("Initializing String: " + String.valueOf(d) + "/" + sst.cstTotal);
            }
            if (strpos >= sst.boundaries[sst.boundaries.length - (offr = (offr = sst.boundaries.length) < 1 ? 0 : 1)]) break;
            short[] recdef = sst.getNextStringDefData(strpos);
            strlen = recdef[0];
            grbit = (byte)recdef[1];
            XLSRecord currec = sst;
            if (sst.DEBUGLEVEL > 5) {
                Logger.logInfo("INFO: StrLen:" + strlen + " Strpos:" + strpos + " bound:" + sst.boundaries[sst.currbound]);
            }
            if (strpos >= sst.boundaries[0]) {
                currec = sst.thiscont;
            }
            switch (grbit) {
                case 1: {
                    doubleByte = true;
                    break;
                }
                case 4: {
                    cchExtRst = ByteTools.readInt(currec.getByteAt(strpos + 3), currec.getByteAt(strpos + 4), currec.getByteAt(strpos + 5), currec.getByteAt(strpos + 6));
                    basereclen = 7;
                    doubleByte = false;
                    break;
                }
                case 5: {
                    cchExtRst = ByteTools.readInt(currec.getByteAt(strpos + 3), currec.getByteAt(strpos + 4), currec.getByteAt(strpos + 5), currec.getByteAt(strpos + 6));
                    basereclen = 7;
                    doubleByte = true;
                    break;
                }
                case 8: {
                    numruns = ByteTools.readShort(currec.getByteAt(strpos + 3), currec.getByteAt(strpos + 4));
                    runlen = numruns * 4;
                    basereclen = 5;
                    doubleByte = false;
                    break;
                }
                case 9: {
                    numruns = ByteTools.readShort(currec.getByteAt(strpos + 3), currec.getByteAt(strpos + 4));
                    runlen = numruns * 4;
                    basereclen = 5;
                    doubleByte = true;
                    break;
                }
                case 12: {
                    numruns = ByteTools.readShort(currec.getByteAt(strpos + 3), currec.getByteAt(strpos + 4));
                    cchExtRst = ByteTools.readInt(currec.getByteAt(strpos + 5), currec.getByteAt(strpos + 6), currec.getByteAt(strpos + 7), currec.getByteAt(strpos + 8));
                    runlen = numruns * 4;
                    basereclen = 9;
                    doubleByte = false;
                    break;
                }
                case 13: {
                    numruns = ByteTools.readShort(currec.getByteAt(strpos + 3), currec.getByteAt(strpos + 4));
                    cchExtRst = ByteTools.readInt(currec.getByteAt(strpos + 5), currec.getByteAt(strpos + 6), currec.getByteAt(strpos + 7), currec.getByteAt(strpos + 8));
                    runlen = numruns * 4;
                    basereclen = 9;
                    doubleByte = true;
                    break;
                }
                default: {
                    doubleByte = false;
                    cchExtRst = 0;
                    basereclen = 3;
                    if (grbit == 0) break;
                    Logger.logWarn("ERROR: Invalid Unicodestring grbit:" + String.valueOf(grbit));
                }
            }
            if (strlen == 0 && sst.DEBUGLEVEL > 10) {
                Logger.logWarn("WARNING: Attempt to initialize Zero-length String.");
            }
            if (doubleByte) {
                strlen *= 2;
            }
            try {
                strpos = sst.initUnicodeString(strlen, strpos, basereclen, cchExtRst, runlen, doubleByte);
            }
            catch (Exception e) {
                Logger.logWarn("ERROR: Error Reading String @ " + strpos + e.toString() + " Skipping...");
                strpos += strlen + basereclen + runlen;
            }
            ++d;
        }
        if (sst.DEBUGLEVEL > 5) {
            Logger.logInfo("Done reading SST.");
        }
    }

    int initUnicodeString(int ustrLen, int pos, int ustrStart, int cchExtRst, int runlen, boolean doublebyte) {
        int bufferBoundary = this.boundaries[this.currbound];
        int totalStrLen = ustrStart + ustrLen + cchExtRst + runlen;
        int posEnd = pos + totalStrLen;
        AtomicInteger uLen = new AtomicInteger(ustrLen);
        if (posEnd < bufferBoundary) {
            byte[] newStringBytes = this.getData(uLen, pos, ustrStart, cchExtRst, runlen, doublebyte, false);
            this.initString(newStringBytes, pos, false);
            return posEnd;
        }
        if (posEnd == bufferBoundary) {
            if ((this.numconts == 0 || this.numconts == this.contcounter) && this.DEBUGLEVEL > 5) {
                Logger.logInfo("Last String in SST encountered.");
            }
            byte[] newStringBytes = this.getData(uLen, pos, ustrStart, cchExtRst, runlen, doublebyte, false);
            this.initString(newStringBytes, pos, false);
            if (this.continues.size() > this.currbound) {
                this.thiscont = (Continue)this.continues.get(this.currbound);
                ++this.currbound;
                if (this.thiscont.getHasGrbit()) {
                    this.thiscont.setHasGrbit(false);
                    this.shiftBoundaries(1);
                }
            }
            return posEnd;
        }
        byte[] newStringBytes = this.getData(uLen, pos, ustrStart, cchExtRst, runlen, doublebyte, true);
        this.initString(newStringBytes, pos, false);
        return pos + (uLen.intValue() + ustrStart + cchExtRst + runlen);
    }

    void shiftBoundaries(int x) {
        int t = this.currbound;
        while (t < this.continues.size()) {
            Continue nextcont = (Continue)this.continues.get(t);
            nextcont.setContinueOffset(nextcont.getContinueOffset() + x);
            this.boundaries[t] = nextcont.getContinueOffset();
            if (this.DEBUGLEVEL > 5) {
                Logger.logInfo("Sst.shiftBoundaries() Updated " + nextcont + " : " + nextcont.getContinueOffset());
            }
            ++t;
        }
        if (this.boundaries.length == this.continues.size() + 1) {
            int n = this.continues.size();
            this.boundaries[n] = this.boundaries[n] + x;
        }
    }

    short[] getNextStringDefData(int start) {
        short[] ret;
        block3: {
            ret = new short[2];
            try {
                int end = start + 3;
                if (end <= this.boundaries[0]) {
                    ret[0] = ByteTools.readShort(this.getByteAt(start++), this.getByteAt(start++));
                    ret[1] = this.getByteAt(start);
                    return ret;
                }
                byte b0 = this.thiscont.getByteAt(start++);
                byte b1 = this.thiscont.getByteAt(start++);
                byte b2 = this.thiscont.getByteAt(start++);
                ret[0] = ByteTools.readShort(b0, b1);
                ret[1] = b2;
            }
            catch (Exception e) {
                if (this.DEBUGLEVEL <= 0) break block3;
                Logger.logWarn("possible problem parsing String table getting next string def data: " + e);
            }
        }
        return ret;
    }

    Continue getContinue(int t) {
        if (t - 1 == this.datalen) {
            return (Continue)this.continues.get(this.continues.size() - 1);
        }
        int x = this.boundaries.length - 1;
        while (x >= 0) {
            if (t > this.boundaries[x]) {
                return (Continue)this.continues.get(x);
            }
            --x;
        }
        return null;
    }

    byte[] getData(AtomicInteger ustrLen, int pos, int ustrStart, int cchExtRst, int runlen, boolean doublebyte, boolean bSpans) {
        int string1ByteLength;
        int totalStrLen = ustrStart + ustrLen.intValue() + cchExtRst + runlen;
        int posEnd = pos + totalStrLen;
        if (posEnd <= this.boundaries[0]) {
            return this.getBytesAt(pos, totalStrLen);
        }
        if (!bSpans) {
            int thisoff = (pos += this.thiscont.grbitoff) - this.thiscont.getContinueOffset();
            return this.thiscont.getBytesAt(thisoff, totalStrLen);
        }
        int bufferBoundary = this.boundaries[this.currbound];
        if (this.DEBUGLEVEL > 5) {
            Logger.logInfo("Crossing Boundary: " + bufferBoundary + ".  Double-Bytes: " + doublebyte);
        }
        if (this.currbound < this.continues.size()) {
            this.thiscont = (Continue)this.continues.get(this.currbound++);
        }
        int currpos = pos + totalStrLen;
        boolean bfoundBreak = false;
        boolean bUnCompress = false;
        boolean bUnCompress1 = false;
        if (cchExtRst > 0 && (currpos -= cchExtRst) <= bufferBoundary) {
            if (this.DEBUGLEVEL > 5) {
                Logger.logInfo("Continue Boundary in ExtRst data.");
            }
            if (this.thiscont.getHasGrbit()) {
                this.thiscont.setHasGrbit(false);
                this.shiftBoundaries(1);
            }
            bfoundBreak = true;
        }
        if (runlen > 0 && !bfoundBreak && (currpos -= runlen) <= bufferBoundary) {
            if (this.DEBUGLEVEL > 5) {
                Logger.logInfo("Continue Boundary in Formatting Run data.");
            }
            if (this.thiscont.getHasGrbit()) {
                this.shiftBoundaries(1);
                this.thiscont.setHasGrbit(false);
            }
            bfoundBreak = true;
        }
        currpos = pos + ustrStart;
        if (!bfoundBreak && currpos < bufferBoundary && ustrLen.intValue() == 0) {
            if (this.DEBUGLEVEL > 5) {
                Logger.logInfo("1 byte length String on the Continue Boundary.");
            }
            int n = this.boundaries.length - 1;
            this.boundaries[n] = this.boundaries[n] + 1;
        }
        if (currpos <= bufferBoundary && currpos + ustrLen.intValue() > bufferBoundary) {
            int postBoundaryBytes;
            int preBoundaryBytes;
            if (this.DEBUGLEVEL > 5) {
                Logger.logInfo("Continue Boundary in String data.");
            }
            if (!this.thiscont.getHasGrbit()) {
                this.thiscont.setHasGrbit(true);
                this.shiftBoundaries(-1);
            }
            byte b = this.thiscont.getGrbit();
            if (doublebyte && b == 0) {
                preBoundaryBytes = bufferBoundary - pos - ustrStart;
                postBoundaryBytes = pos + ustrStart + ustrLen.intValue() - bufferBoundary;
                ustrLen.set(preBoundaryBytes + (postBoundaryBytes /= 2));
                bUnCompress1 = true;
            } else if (!doublebyte && b == 1) {
                preBoundaryBytes = bufferBoundary - pos - ustrStart;
                postBoundaryBytes = pos + ustrStart + ustrLen.intValue() - bufferBoundary;
                ustrLen.set(preBoundaryBytes + (postBoundaryBytes *= 2));
                bUnCompress = true;
            }
            totalStrLen = ustrStart + ustrLen.intValue() + cchExtRst + runlen;
            posEnd = pos + totalStrLen;
        }
        if ((string1ByteLength = pos - this.thiscont.getContinueOffset()) < 0) {
            string1ByteLength *= -1;
        }
        int string2ByteLength = totalStrLen - string1ByteLength;
        int extraData = cchExtRst + runlen;
        if ((string2ByteLength -= extraData) <= 0) {
            extraData = string2ByteLength + extraData;
            string2ByteLength = 0;
        }
        byte[] string1bytes = null;
        byte[] string2bytes = null;
        if (this.thiscont.predecessor instanceof Continue) {
            pos = this.thiscont.predecessor.getLength() - string1ByteLength;
            pos -= 4;
        }
        this.thiscont.grbitoff = this.thiscont.getHasGrbit() ? 1 : 0;
        string1bytes = !bUnCompress ? this.thiscont.predecessor.getBytesAt(pos, string1ByteLength) : this.convertCompressedBytesToDoubleBytes(pos, string1ByteLength, ustrStart);
        if (string2ByteLength < 8224) {
            if (!bUnCompress1) {
                string2bytes = this.thiscont.getBytesAt(0 + this.thiscont.grbitoff, string2ByteLength);
            } else {
                string2bytes = new byte[string2ByteLength *= 2];
                int t = 0;
                while (t < string2ByteLength / 2) {
                    string2bytes[t * 2] = this.thiscont.getByteAt(t + this.thiscont.getContinueOffset());
                    ++t;
                }
            }
            if (this.thiscont.predecessor instanceof Continue) {
                this.thiscont.predecessor.setData(null);
            }
        } else {
            int blen = string2ByteLength;
            int idx = 0;
            int start = 0;
            string2bytes = new byte[blen];
            while (blen > 0) {
                byte[] tmp;
                int curlen = Math.min(start + this.thiscont.getLength() - this.thiscont.grbitoff, blen);
                if (!bUnCompress1) {
                    tmp = this.thiscont.getBytesAt(start + this.thiscont.grbitoff, curlen);
                    System.arraycopy(tmp, 0, string2bytes, idx, curlen);
                } else {
                    tmp = new byte[curlen *= 2];
                    int t = 0;
                    while (t < curlen / 2) {
                        tmp[t * 2] = this.thiscont.getByteAt(t + this.thiscont.getContinueOffset());
                        ++t;
                    }
                    System.arraycopy(tmp, 0, string2bytes, idx, curlen);
                }
                if (this.thiscont.predecessor instanceof Continue) {
                    this.thiscont.predecessor.setData(null);
                }
                if (curlen >= this.thiscont.getLength() - this.thiscont.grbitoff) {
                    if (this.currbound < this.continues.size()) {
                        this.thiscont = (Continue)this.continues.get(this.currbound++);
                    }
                } else {
                    string2ByteLength = curlen + start;
                    break;
                }
                this.thiscont.grbitoff = this.thiscont.getHasGrbit() ? 1 : 0;
                start = 4;
                idx += curlen;
                blen -= curlen;
            }
        }
        byte[] returnstringbytes = new byte[string1bytes.length + string2bytes.length + extraData];
        System.arraycopy(string1bytes, 0, returnstringbytes, 0, string1bytes.length);
        System.arraycopy(string2bytes, 0, returnstringbytes, string1bytes.length, string2bytes.length);
        if (extraData > 0) {
            int startpos;
            if (posEnd <= this.boundaries[this.currbound]) {
                startpos = string2ByteLength;
                if (bUnCompress1) {
                    startpos /= 2;
                }
                if (string2ByteLength != 0) {
                    startpos += this.thiscont.grbitoff;
                }
                byte[] rx2 = this.thiscont.getBytesAt(startpos, extraData);
                System.arraycopy(rx2, 0, returnstringbytes, string1bytes.length + string2bytes.length, extraData);
            } else {
                startpos = string2ByteLength;
                if (bUnCompress1) {
                    startpos /= 2;
                }
                byte[] rx2 = new byte[extraData];
                string1ByteLength = this.thiscont.getLength() - startpos;
                string2ByteLength = extraData - string1ByteLength;
                if (this.currbound < this.continues.size()) {
                    this.thiscont = (Continue)this.continues.get(this.currbound++);
                    this.thiscont.grbitoff = this.thiscont.getHasGrbit() ? 1 : 0;
                }
                pos = this.thiscont.predecessor.getLength() - string1ByteLength;
                int start = 4;
                System.arraycopy(this.thiscont.predecessor.getBytesAt(pos -= 4, string1ByteLength), 0, rx2, 0, string1ByteLength);
                System.arraycopy(this.thiscont.getBytesAt(start + this.thiscont.grbitoff, string2ByteLength), 0, rx2, string1ByteLength, string2ByteLength);
                System.arraycopy(rx2, 0, returnstringbytes, string1bytes.length + string2bytes.length, extraData);
                ustrLen.set(ustrLen.get() - 1);
            }
        }
        if (this.DEBUGLEVEL > 23) {
            Logger.logInfo("Total Length from Continue: " + returnstringbytes.length);
        }
        return returnstringbytes;
    }

    byte[] convertCompressedBytesToDoubleBytes(int pos, int totallen, int uStrStart) {
        int uLenOnPrevious = totallen - uStrStart;
        byte[] converted = new byte[uStrStart + uLenOnPrevious * 2];
        System.arraycopy(this.thiscont.predecessor.getBytesAt(pos, uStrStart), 0, converted, 0, uStrStart);
        byte[] ustr = this.thiscont.predecessor.getBytesAt(pos + uStrStart, uLenOnPrevious);
        converted[2] = (byte)(converted[2] | 1);
        int i = 0;
        while (i < uLenOnPrevious) {
            converted[uStrStart + i * 2] = ustr[i];
            ++i;
        }
        return converted;
    }

    Unicodestring initString(byte[] newStringBytes, int strpos, boolean extrstbrk) {
        Unicodestring newString = new Unicodestring();
        newString.setSSTPos(strpos);
        newString.init(newStringBytes, extrstbrk);
        if (this.DEBUGLEVEL > 5) {
            Logger.logInfo(" val: " + newString.toString());
        }
        if (newString.getLen() == 0) {
            Logger.logInfo("Adding zero-length string!");
        } else {
            this.putString(newString);
        }
        return newString;
    }

    private int putString(Unicodestring newString) {
        ++this.retpos;
        ((SstArrayList)this.stringvector).put(newString, this.retpos);
        return this.retpos;
    }

    @Override
    public void close() {
        this.cbounds.removeAllElements();
        this.sstgrbits.removeAllElements();
        this.stringvector.clear();
        this.stringvector = new SstArrayList();
        this.dupeSstEntries.clear();
        this.dupeSstEntries = new HashSet();
        this.existingSstEntries.clear();
        this.existingSstEntries = new HashSet();
    }

    void updateUnicodestrings() {
        this.cbounds = new CompatibleVector();
        this.sstgrbits = new CompatibleVector();
        this.lastwasbreakable = true;
        this.stringisonbound = false;
        this.laststringwasonbound = false;
        this.islast = false;
        this.thisbounds = 8224;
        this.lastbounds = 0;
        this.contcounter = 0;
        this.lastlen = 0;
        this.grbitct = 0;
        this.dl = 0;
        this.leftoverlen = 0;
        this.gr = 0;
        byte[] cstot = ByteTools.cLongToLEBytes(this.cstTotal);
        byte[] cstun = ByteTools.cLongToLEBytes(this.cstUnique);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(cstot);
            out.write(cstun);
        }
        catch (IOException e) {
            Logger.logInfo("Exception getting String bytes: " + e);
        }
        if (this.stringvector.size() > 0) {
            int thispos = 8;
            int lastpos = 0;
            this.cbounds.removeAllElements();
            this.sstgrbits.removeAllElements();
            byte[] strb = null;
            for (Object ob : this.stringvector) {
                Unicodestring str = (Unicodestring)ob;
                str.setSSTPos(thispos);
                strb = str.read();
                try {
                    out.write(strb);
                }
                catch (IOException e) {
                    Logger.logInfo("Exception getting String bytes: " + e);
                }
                lastpos = thispos;
                thispos = lastpos + strb.length;
                this.checkOnBoundary(str, lastpos, thispos + 4, strb);
            }
            if (this.leftoverlen > 0) {
                this.cbounds.add(this.leftoverlen);
                this.sstgrbits.add(new Byte(this.gr));
            }
            this.numconts = this.cbounds.size() > 0 ? this.cbounds.size() - 1 : 0;
            byte[] bb = out.toByteArray();
            if (this.sanityCheck(bb.length)) {
                this.setData(bb);
            } else {
                this.datalen = bb.length + 4;
                this.updateUnicodestrings();
            }
        }
        if (this.DEBUGLEVEL > 15 && this.cbounds != null) {
            int t = 0;
            while (t < this.cbounds.size()) {
                Logger.logInfo(String.valueOf((Integer)this.cbounds.get(t)) + ",");
                ++t;
            }
            Logger.logInfo("");
        }
        if (this.DEBUGLEVEL > 150 && this.sstgrbits != null) {
            int t = 0;
            while (t < this.sstgrbits.size()) {
                Logger.logInfo("0x" + (Byte)this.sstgrbits.get(t) + ",");
                ++t;
            }
            Logger.logInfo("");
        }
    }

    private boolean sanityCheck(int realLen) {
        long contLens = 0L;
        int i = 0;
        while (i < this.cbounds.size()) {
            Integer intgr = (Integer)this.cbounds.get(i);
            contLens += (long)intgr.intValue();
            ++i;
        }
        if ((long)(this.datalen - 4) - contLens > 8223L) {
            if (this.DEBUGLEVEL > 1) {
                Logger.logWarn("SST continue lengths not correct, regenerating");
            }
            return false;
        }
        return true;
    }

    void checkOnBoundary(Unicodestring str, int lastpos, int thispos, byte[] strb) {
        while (thispos >= this.thisbounds) {
            ++this.continuenumber;
            if (this.DEBUGLEVEL > 5) {
                Logger.logInfo(String.valueOf(this.thisbounds));
            }
            boolean breaksok = str.isBreakable(this.thisbounds);
            int contlen = 0;
            this.gr = strb[0];
            if (breaksok) {
                this.gr = this.getContinueGrbitFromString(str);
            }
            if (this.DEBUGLEVEL > 5) {
                Logger.logInfo(" String @: " + thispos + " is breakable: " + breaksok);
            }
            contlen = 8224;
            if (this.islast) {
                contlen = this.leftoverlen;
                this.leftoverlen = 0;
                ++contlen;
                if (!this.lastwasbreakable) {
                    ++contlen;
                }
            } else if (!breaksok) {
                this.stringisonbound = true;
                contlen = lastpos - this.lastbounds;
                this.lastbounds = lastpos;
            } else if (breaksok && this.gr == 1 && str.charBreakOnBounds(this.thisbounds + this.lastgrbit)) {
                --contlen;
            }
            if (!this.laststringwasonbound && this.lastwasbreakable && this.contcounter > 0) {
                if (!breaksok) {
                    this.cbounds.add(contlen);
                } else {
                    if (!this.islast) {
                        --this.thisbounds;
                    }
                    this.cbounds.add(contlen - 1);
                }
            } else {
                this.cbounds.add(contlen);
            }
            if (str.cch < 2) {
                this.sstgrbits.add(null);
                this.lastgrbit = 0;
            } else if (!breaksok && this.gr < 2 && this.gr >= 0) {
                this.sstgrbits.add(null);
                this.lastgrbit = 0;
            } else {
                this.sstgrbits.add(new Byte(this.gr));
                this.lastgrbit = 1;
            }
            ++this.contcounter;
            this.lastwasbreakable = breaksok;
            this.laststringwasonbound = this.stringisonbound;
            this.stringisonbound = false;
            this.lastlen = contlen;
            if (breaksok) {
                this.lastbounds = this.thisbounds;
            }
            this.dl = this.reclen > this.datalen ? this.reclen : this.datalen;
            if (this.thisbounds + contlen + 4 < this.dl) {
                this.thisbounds += contlen;
                lastpos += contlen;
                continue;
            }
            if (!this.islast) {
                this.leftoverlen = this.dl + 4 - this.lastlen;
                if (!this.lastwasbreakable && this.leftoverlen > 0) {
                    ++this.leftoverlen;
                }
                this.thisbounds = this.dl;
                this.islast = true;
                continue;
            }
            this.thisbounds += contlen;
        }
    }

    byte getContinueGrbitFromString(Unicodestring str) {
        byte grb = 0;
        switch (str.getGrbit()) {
            case 1: {
                grb = 1;
                break;
            }
            case 5: {
                grb = 1;
                break;
            }
            case 9: {
                grb = 1;
                break;
            }
            case 13: {
                grb = 1;
            }
        }
        return grb;
    }

    public static Object[] getContinueDef(Sst rec, boolean cached) {
        if (cached) {
            return rec.continueDef;
        }
        Integer[] cbs = new Integer[rec.cbounds.size()];
        Byte[] sstgrs = new Byte[rec.sstgrbits.size()];
        int t = 0;
        while (t < cbs.length) {
            cbs[t] = (Integer)rec.cbounds.get(t);
            ++t;
        }
        t = 0;
        while (t < sstgrs.length) {
            sstgrs[t] = (Byte)rec.sstgrbits.get(t);
            ++t;
        }
        rec.continueDef = new Object[2];
        rec.continueDef[0] = cbs;
        rec.continueDef[1] = sstgrs;
        return rec.continueDef;
    }

    void initSharingOnStrings(int isst) {
        Integer iSst = isst;
        if (this.existingSstEntries.contains(iSst)) {
            if (!this.dupeSstEntries.contains(iSst)) {
                this.dupeSstEntries.add(iSst);
            }
        } else {
            this.existingSstEntries.add(iSst);
        }
    }

    public void setStringEncodingMode(int mode) {
        this.STRING_ENCODING_MODE = mode;
    }

    void removeUnicodestring(Unicodestring str) {
        this.stringvector.remove(this.idx);
        --this.retpos;
        this.reclen -= str.getLen();
    }

    void adjustSstLength(int delta) {
        this.reclen += delta;
        this.datalen += delta;
    }

    int insertUnicodestring(Unicodestring us) {
        int retpos = -1;
        ++this.cstTotal;
        boolean isuni = false;
        if (this.getWorkBook().isSharedupes()) {
            retpos = ((SstArrayList)this.stringvector).find(us);
        }
        if (retpos == -1) {
            ++this.cstUnique;
            int strlen = us.getLen();
            this.reclen += strlen + (us.isRichString() ? 5 : 3);
            this.datalen += strlen + (us.isRichString() ? 5 : 3);
            if (isuni) {
                this.reclen += strlen;
                this.datalen += strlen;
            }
            retpos = this.putString(us);
        } else {
            this.dupeSstEntries.add(retpos);
        }
        return retpos;
    }

    int addUnicodestring(String s, ArrayList formattingRuns) {
        ++this.cstTotal;
        ++this.cstUnique;
        Unicodestring str = Sst.createUnicodeString(s, formattingRuns, this.STRING_ENCODING_MODE);
        this.reclen += str.getLen();
        this.datalen += str.getLen();
        this.retpos = this.putString(str);
        return this.retpos;
    }

    public static Unicodestring createUnicodeString(String s, ArrayList formattingRuns, int ENCODINGMODE) {
        try {
            boolean isuni = false;
            if (ENCODINGMODE == WorkBook.STRING_ENCODING_AUTO) {
                isuni = ByteTools.isUnicode(s);
            } else if (ENCODINGMODE == WorkBook.STRING_ENCODING_COMPRESSED) {
                isuni = false;
            } else if (ENCODINGMODE == WorkBook.STRING_ENCODING_UNICODE) {
                isuni = true;
            }
            if (formattingRuns != null) {
                isuni = true;
            }
            byte[] charbytes = s.getBytes("ISO-8859-1");
            int strlen = charbytes.length;
            byte[] strbytes = null;
            if (strlen * 2 > Short.MAX_VALUE) {
                isuni = false;
            }
            if (strlen > 32764) {
                strlen = 32764;
                charbytes = new byte[strlen];
                System.arraycopy(s.getBytes("ISO-8859-1"), 0, charbytes, 0, strlen);
            }
            if (formattingRuns != null) {
                isuni = true;
            }
            if (isuni) {
                try {
                    charbytes = s.getBytes("UTF-16LE");
                }
                catch (UnsupportedEncodingException e) {
                    Logger.logWarn("error encoding string: " + e + " with default encoding 'UnicodeLittleUnmarked'");
                }
                strbytes = formattingRuns == null ? new byte[charbytes.length + 3] : new byte[charbytes.length + 5];
            } else {
                strbytes = new byte[charbytes.length + 3];
            }
            int pos = 0;
            int encodedlen = charbytes.length;
            byte[] lenbytes = ByteTools.shortToLEBytes((short)strlen);
            strbytes[pos++] = lenbytes[0];
            strbytes[pos++] = lenbytes[1];
            if (!isuni) {
                strbytes[pos++] = 0;
            } else {
                strbytes[pos++] = 1;
                if (formattingRuns != null) {
                    int n = pos - 1;
                    strbytes[n] = (byte)(strbytes[n] | 8);
                    byte[] fr = ByteTools.shortToLEBytes((short)formattingRuns.size());
                    strbytes[pos++] = fr[0];
                    strbytes[pos++] = fr[1];
                }
            }
            System.arraycopy(charbytes, 0, strbytes, pos, encodedlen);
            if (formattingRuns != null) {
                byte[] frs = new byte[formattingRuns.size() * 4];
                int i = 0;
                while (i < formattingRuns.size()) {
                    short[] o = (short[])formattingRuns.get(i);
                    byte[] charIndex = ByteTools.shortToLEBytes(o[0]);
                    byte[] fontIndex = ByteTools.shortToLEBytes(o[1]);
                    System.arraycopy(charIndex, 0, frs, i * 4, 2);
                    System.arraycopy(fontIndex, 0, frs, i * 4 + 2, 2);
                    ++i;
                }
                byte[] newdata = new byte[strbytes.length + frs.length];
                System.arraycopy(strbytes, 0, newdata, 0, strbytes.length);
                System.arraycopy(frs, 0, newdata, strbytes.length, frs.length);
                strbytes = newdata;
            }
            Unicodestring str = new Unicodestring();
            str.init(strbytes, false);
            return str;
        }
        catch (UnsupportedEncodingException e) {
            Logger.logWarn("error encoding string: " + e.toString());
            return null;
        }
    }

    int insertUnicodestring(String s) {
        Unicodestring str;
        int retpos = -1;
        if (this.getWorkBook().isSharedupes() && (retpos = ((SstArrayList)this.stringvector).indexOf(s)) > -1 && (str = (Unicodestring)this.stringvector.get(retpos)).hasFormattingRuns()) {
            retpos = -1;
        }
        if (retpos == -1) {
            retpos = this.addUnicodestring(s, null);
        } else {
            ++this.cstTotal;
            this.dupeSstEntries.add(retpos);
        }
        return retpos;
    }

    boolean isSharedString(int sstLoc) {
        return this.dupeSstEntries.contains(sstLoc);
    }

    Unicodestring getUStringAt(int i) {
        return (Unicodestring)this.stringvector.get(i);
    }

    int find(Unicodestring us) {
        return ((SstArrayList)this.stringvector).find(us);
    }

    public List getStringVector() {
        return this.stringvector;
    }

    public int getNumTotal() {
        return this.cstTotal;
    }

    public int getNumUnique() {
        return this.cstUnique;
    }

    public int getNumContinues() {
        return this.numconts;
    }

    @Override
    public void preStream() {
        this.updateUnicodestrings();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("cstTotal:" + this.cstTotal + " cstUnique:" + this.cstUnique + " numConts:" + this.numconts);
        int i = 0;
        while (i < this.stringvector.size()) {
            sb.append("\n " + this.stringvector.get(i));
            ++i;
        }
        return sb.toString();
    }

    public void writeOOXML(Writer zip) throws IOException {
        StringBuffer sstooxml = new StringBuffer();
        zip.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        zip.write("\r\n");
        zip.write("<sst xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" count=\"" + this.cstTotal + "\" uniqueCount=\"" + this.cstUnique + "\">");
        zip.write("\r\n");
        int i = 0;
        while (i < this.getStringVector().size()) {
            Unicodestring us = (Unicodestring)this.getStringVector().get(i);
            ArrayList frs = us.getFormattingRuns();
            String s = us.getStringVal();
            s = OOXMLAdapter.stripNonAscii(s).toString();
            zip.write("<si>");
            zip.write("\r\n");
            if (frs == null) {
                if (s.indexOf(" ") == 0 || s.lastIndexOf(" ") == s.length() - 1) {
                    zip.write("<t xml:space=\"preserve\">" + s + "</t>");
                } else {
                    zip.write("<t>" + s + "</t>");
                }
                zip.write("\r\n");
            } else {
                int begIdx = 0;
                int j = 0;
                while (j < frs.size()) {
                    short[] idxs = (short[])frs.get(j);
                    if (idxs[0] > begIdx) {
                        if (j == 0) {
                            zip.write("<r>");
                            zip.write("<t xml:space=\"preserve\">" + OOXMLAdapter.stripNonAscii(s.substring(begIdx, idxs[0])) + "</t>");
                            zip.write("</r>");
                            zip.write("\r\n");
                        } else {
                            zip.write("<t xml:space=\"preserve\">" + OOXMLAdapter.stripNonAscii(s.substring(begIdx, idxs[0])) + "</t>");
                            zip.write("</r>");
                            zip.write("\r\n");
                        }
                        begIdx = idxs[0];
                    }
                    zip.write("<r>");
                    Ss_rPr rp = Ss_rPr.createFromFont(this.getWorkBook().getFont(idxs[1]));
                    zip.write(rp.getOOXML());
                    ++j;
                }
                s = begIdx < s.length() ? s.substring(begIdx) : "";
                zip.write("<t xml:space=\"preserve\">" + OOXMLAdapter.stripNonAscii(s) + "</t>");
                zip.write("\r\n");
                zip.write("</r>");
            }
            zip.write("</si>");
            zip.write("\r\n");
            ++i;
        }
        zip.write("</sst>");
    }

    public static ArrayList parseOOXML(WorkBookHandle bk, InputStream ii) {
        boolean shareDups = false;
        if (bk.getWorkBook().isSharedupes()) {
            bk.getWorkBook().setSharedupes(false);
            shareDups = true;
        }
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XmlPullParser xpp = factory.newPullParser();
            xpp.setInput(new InputStreamReader(ii));
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block10: {
                    String tnm;
                    if (eventType != 2 || !(tnm = xpp.getName()).equals("si")) break block10;
                    String s = "";
                    ArrayList<short[]> formattingRuns = null;
                    while (eventType != 1) {
                        block13: {
                            block11: {
                                block12: {
                                    if (eventType != 2) break block11;
                                    if (!xpp.getName().equals("rPr")) break block12;
                                    int idx = s.length();
                                    Ss_rPr rp = (Ss_rPr)Ss_rPr.parseOOXML(xpp, bk).cloneElement();
                                    Font f = rp.generateFont(bk);
                                    int fIndex = bk.getWorkBook().getFontIdx(f);
                                    if (fIndex == -1) {
                                        fIndex = bk.getWorkBook().insertFont(f) + 1;
                                    }
                                    if (formattingRuns == null) {
                                        formattingRuns = new ArrayList<short[]>();
                                    }
                                    formattingRuns.add(new short[]{Integer.valueOf(idx).shortValue(), Integer.valueOf(fIndex).shortValue()});
                                    break block13;
                                }
                                if (!xpp.getName().equals("t")) break block13;
                                eventType = xpp.next();
                                while (eventType != 1 && eventType != 3 && eventType != 4) {
                                    eventType = xpp.next();
                                }
                                if (eventType != 4) break block13;
                                s = String.valueOf(s) + xpp.getText();
                                break block13;
                            }
                            if (eventType == 3 && xpp.getName().equals("si")) {
                                bk.getWorkBook().getSharedStringTable().addUnicodestring(s, formattingRuns);
                                break;
                            }
                        }
                        eventType = xpp.next();
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("SST.parseXML: " + e.toString());
        }
        if (shareDups) {
            bk.getWorkBook().setSharedupes(true);
        }
        return (ArrayList)bk.getWorkBook().getSharedStringTable().getStringVector();
    }

    public ArrayList getAllStrings() {
        ArrayList<String> al = new ArrayList<String>(this.stringvector.size());
        int i = 0;
        while (i < this.stringvector.size()) {
            al.add(this.stringvector.get(i).toString());
            ++i;
        }
        return al;
    }

    @Override
    public int getLength() {
        int len = super.getLength();
        int i = 0;
        while (i < this.sstgrbits.size() - 1) {
            byte grbyte;
            Byte b = (Byte)this.sstgrbits.get(i);
            if (b != null && (grbyte = b.byteValue()) < 2 && grbyte >= 0) {
                ++len;
            }
            ++i;
        }
        return len;
    }

    private class SstArrayList
    extends ArrayList {
        private static final long serialVersionUID = 7904551471519095640L;
        private final HashMap container = new HashMap();

        private SstArrayList() {
        }

        public boolean put(Object o, Integer isst) {
            this.container.put(((Unicodestring)o).toCachingString(), isst);
            return super.add(o);
        }

        @Override
        public int indexOf(Object o) {
            Object oo = this.container.get(o.toString());
            if (oo == null) {
                return -1;
            }
            return (Integer)oo;
        }

        @Override
        public boolean remove(Object o) {
            Logger.logWarn("String being removed from SST array, Indexing may be off");
            this.container.remove(((Unicodestring)o).toCachingString());
            return super.remove(o);
        }

        public int find(Unicodestring us) {
            return super.indexOf(us);
        }
    }
}

