/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.XLSConstants;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.io.UnsupportedEncodingException;

public class SxDI
extends XLSRecord
implements XLSConstants {
    short isxvdData;
    short isxvd;
    short iiftab;
    short df;
    short isxvi;
    short cchName;
    short ifmt;
    String name = null;
    private static final long serialVersionUID = 2639291289806138985L;
    private byte[] PROTOTYPE_BYTES;

    public SxDI() {
        byte[] byArray = new byte[14];
        byArray[12] = -1;
        byArray[13] = -1;
        this.PROTOTYPE_BYTES = byArray;
    }

    @Override
    public void init() {
        super.init();
        this.isxvdData = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        this.iiftab = ByteTools.readShort(this.getByteAt(2), this.getByteAt(3));
        this.df = ByteTools.readShort(this.getByteAt(4), this.getByteAt(5));
        this.isxvd = ByteTools.readShort(this.getByteAt(6), this.getByteAt(7));
        this.isxvi = ByteTools.readShort(this.getByteAt(8), this.getByteAt(9));
        this.ifmt = ByteTools.readShort(this.getByteAt(10), this.getByteAt(11));
        this.cchName = ByteTools.readShort(this.getByteAt(12), this.getByteAt(13));
        if (this.cchName != -1) {
            byte encoding = this.getByteAt(14);
            byte[] tmp = this.getBytesAt(15, this.cchName * (encoding + 1));
            try {
                this.name = encoding == 0 ? new String(tmp, "ISO-8859-1") : new String(tmp, "UTF-16LE");
            }
            catch (UnsupportedEncodingException e) {
                Logger.logInfo("encoding PivotTable caption name in Sxvd: " + e);
            }
        }
        if (this.DEBUGLEVEL > 3) {
            Logger.logInfo("SXDI - isxvdData:" + this.isxvdData + " iiftab:" + this.iiftab + " df:" + this.df + " isxvd:" + this.isxvd + " isxvi:" + this.isxvi + " ifmt:" + this.ifmt + " name:" + this.name);
        }
    }

    public short getPivotFieldIndex() {
        return this.isxvdData;
    }

    public void setPivotFieldIndex(int fi) {
        this.isxvdData = (short)fi;
        byte[] b = ByteTools.shortToLEBytes(this.isxvdData);
        this.getData()[0] = b[0];
        this.getData()[1] = b[1];
    }

    public int getAggregationFunction() {
        return this.iiftab;
    }

    public void setAggregationFunction(int af) {
        this.iiftab = (short)af;
        byte[] b = ByteTools.shortToLEBytes(this.iiftab);
        this.getData()[2] = b[0];
        this.getData()[3] = b[1];
    }

    public void addDataField(int fieldIndex, String aggregationFunction, String name) {
        this.setPivotFieldIndex(fieldIndex);
        this.setAggregationFunction(AGGREGATIONFUNCTIONS.get(aggregationFunction));
        this.setName(name);
    }

    public int getDisplayCalculation() {
        return this.df;
    }

    public void setDisplayCalculation(int dc) {
        this.df = (short)dc;
        byte[] b = ByteTools.shortToLEBytes(this.df);
        this.getData()[4] = b[0];
        this.getData()[5] = b[1];
    }

    public short getCalculationPivotFieldIndex() {
        return this.isxvd;
    }

    public void setCalculationPivotFieldIndex(int ci) {
        this.isxvd = (short)ci;
        byte[] b = ByteTools.shortToLEBytes(this.isxvd);
        this.getData()[6] = b[0];
        this.getData()[7] = b[1];
    }

    public short getCalculationPivotItemIndex() {
        return this.isxvi;
    }

    public void setCalculationPivotItemIndex(int ci) {
        this.isxvi = (short)ci;
        byte[] b = ByteTools.shortToLEBytes(this.isxvi);
        this.getData()[8] = b[0];
        this.getData()[9] = b[1];
    }

    public short getNumberFormat() {
        return this.ifmt;
    }

    public void setNumberFormat(int i) {
        this.ifmt = (short)i;
        byte[] b = ByteTools.shortToLEBytes(this.ifmt);
        this.getData()[10] = b[0];
        this.getData()[11] = b[1];
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        byte[] data = new byte[14];
        System.arraycopy(this.getData(), 0, data, 0, 13);
        if (name != null) {
            byte[] strbytes = null;
            try {
                strbytes = this.name.getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                Logger.logInfo("encoding pivot table name in SXVI: " + e);
            }
            this.cchName = (short)strbytes.length;
            byte[] nm = ByteTools.shortToLEBytes(this.cchName);
            data[12] = nm[0];
            data[13] = nm[1];
            byte[] newrgch = new byte[this.cchName + 1];
            System.arraycopy(strbytes, 0, newrgch, 1, this.cchName);
            data = ByteTools.append(newrgch, data);
        } else {
            data[12] = -1;
            data[13] = -1;
        }
        this.setData(data);
    }

    public static XLSRecord getPrototype() {
        SxDI di = new SxDI();
        di.setOpcode((short)197);
        di.setData(di.PROTOTYPE_BYTES);
        di.init();
        return di;
    }

    public static enum AGGREGATIONFUNCTIONS {
        Sum("sum"),
        Count("count"),
        Average("average"),
        Max("max"),
        Min("min"),
        Product("product"),
        CountNums("countnums"),
        StdDev("stdDev"),
        StdDevP("stdDevp"),
        Var("var"),
        VarP("varp");

        private final String agf;

        private AGGREGATIONFUNCTIONS(String s) {
            this.agf = s;
        }

        public static int get(String s) {
            AGGREGATIONFUNCTIONS[] aGGREGATIONFUNCTIONSArray = AGGREGATIONFUNCTIONS.values();
            int n = aGGREGATIONFUNCTIONSArray.length;
            int n2 = 0;
            while (n2 < n) {
                AGGREGATIONFUNCTIONS c = aGGREGATIONFUNCTIONSArray[n2];
                if (c.agf.equals(s)) {
                    return c.ordinal();
                }
                ++n2;
            }
            return 0;
        }
    }

    public static enum DISPLAYTYPES {
        value,
        difference,
        percentageValue,
        percentageDifference,
        runningTotal,
        percentageTotalRow,
        percentageTotalCol,
        grandTotal,
        calculated;

    }
}

