/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.PivotCacheRecord;
import com.extentech.formats.XLS.XLSConstants;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.io.UnsupportedEncodingException;

public class SxFDB
extends XLSRecord
implements XLSConstants,
PivotCacheRecord {
    private static final long serialVersionUID = 9027599480633995587L;
    private short ifdbParent;
    private short ifdbBase;
    private short csxoper;
    private short cisxoper;
    private short catm;
    private short grbit;
    private String stFieldName;
    boolean fAllAtoms;
    boolean fRangeGroup;
    boolean fNumField;
    boolean fTextEtcField;
    boolean fnumMinMaxValid;
    boolean fNonDates;
    boolean fDateInField;
    boolean fCalculatedField;
    boolean fShortItms;
    private byte[] PROTOTYPE_BYTES;

    public SxFDB() {
        byte[] byArray = new byte[16];
        byArray[0] = -128;
        byArray[1] = 4;
        byArray[6] = 1;
        byArray[14] = -1;
        byArray[15] = -1;
        this.PROTOTYPE_BYTES = byArray;
    }

    @Override
    public void init() {
        super.init();
        this.grbit = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        this.ifdbParent = ByteTools.readShort(this.getByteAt(2), this.getByteAt(3));
        this.ifdbBase = ByteTools.readShort(this.getByteAt(4), this.getByteAt(5));
        this.csxoper = ByteTools.readShort(this.getByteAt(8), this.getByteAt(9));
        this.cisxoper = ByteTools.readShort(this.getByteAt(10), this.getByteAt(11));
        this.catm = ByteTools.readShort(this.getByteAt(12), this.getByteAt(13));
        short cch = ByteTools.readShort(this.getByteAt(14), this.getByteAt(15));
        if (cch > 0) {
            byte encoding = this.getByteAt(16);
            byte[] tmp = this.getBytesAt(17, cch * (encoding + 1));
            try {
                this.stFieldName = encoding == 0 ? new String(tmp, "ISO-8859-1") : new String(tmp, "UTF-16LE");
            }
            catch (UnsupportedEncodingException e) {
                Logger.logInfo("SXString.init: " + e);
            }
        }
        this.fAllAtoms = (this.grbit & 1) == 1;
        this.fRangeGroup = (this.grbit & 0x10) == 16;
        this.fNumField = (this.grbit & 0x20) == 32;
        this.fTextEtcField = (this.grbit & 0x80) == 128;
        this.fnumMinMaxValid = (this.grbit & 0x100) == 256;
        this.fShortItms = (this.grbit & 0x200) == 512;
        this.fNonDates = (this.grbit & 0x400) == 1024;
        this.fDateInField = (this.grbit & 0x4000) == 16384;
        boolean bl = this.fCalculatedField = (this.grbit & 0x8000) == 32768;
        if (this.DEBUGLEVEL > 3) {
            Logger.logInfo(this.toString());
        }
    }

    @Override
    public String toString() {
        return String.format("SXFDB -p: %d d: %d csxoper: %d cisxoper: %d catm: %d stFieldName: %s fAllAtoms? %b text? %b num? %b calculated? %b", this.ifdbParent, this.ifdbBase, this.csxoper, this.cisxoper, this.catm, this.stFieldName, this.fAllAtoms, this.fTextEtcField, this.fNumField, this.fCalculatedField);
    }

    @Override
    public byte[] getRecord() {
        byte[] b = new byte[4];
        System.arraycopy(ByteTools.shortToLEBytes(this.getOpcode()), 0, b, 0, 2);
        System.arraycopy(ByteTools.shortToLEBytes((short)this.getData().length), 0, b, 2, 2);
        return ByteTools.append(this.getData(), b);
    }

    public static XLSRecord getPrototype() {
        SxFDB sxfdb = new SxFDB();
        sxfdb.setOpcode((short)199);
        sxfdb.setData(sxfdb.PROTOTYPE_BYTES);
        sxfdb.init();
        return sxfdb;
    }

    public void setNCacheItems(int n) {
        this.catm = (short)n;
        byte[] b = ByteTools.shortToLEBytes(this.catm);
        this.getData()[12] = b[0];
        this.getData()[13] = b[1];
        if (n > 0) {
            this.fAllAtoms = true;
            this.grbit = (short)(this.grbit | 1);
        } else {
            this.fAllAtoms = false;
            this.grbit = (short)(this.grbit & 0xFFFFFFFE);
        }
        b = ByteTools.shortToLEBytes(this.grbit);
        this.getData()[0] = b[0];
        this.getData()[1] = b[1];
    }

    public int getNCacheItems() {
        return this.catm;
    }

    public void setCacheField(String s) {
        this.stFieldName = s;
        byte[] strbytes = new byte[]{};
        if (this.stFieldName != null) {
            try {
                strbytes = this.stFieldName.getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                Logger.logInfo("SxFDB: " + e);
            }
        }
        short cch = (short)strbytes.length;
        byte[] nm = ByteTools.shortToLEBytes(cch);
        byte[] data = new byte[14];
        System.arraycopy(this.getData(), 0, data, 0, 14);
        byte[] newdata = new byte[cch + 3];
        System.arraycopy(nm, 0, newdata, 0, 2);
        System.arraycopy(strbytes, 0, newdata, 3, cch);
        data = ByteTools.append(newdata, data);
        this.setData(data);
    }

    public String getCachefield() {
        return this.stFieldName;
    }

    public void setCacheItemsType(int type) {
        switch (type) {
            case 0: {
                this.fTextEtcField = true;
                this.fNumField = false;
                this.fNonDates = true;
                this.fDateInField = false;
                this.fnumMinMaxValid = false;
                this.fCalculatedField = false;
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                this.fTextEtcField = false;
                this.fNumField = true;
                this.fNonDates = true;
                this.fDateInField = false;
                this.fnumMinMaxValid = true;
                this.fCalculatedField = false;
                break;
            }
            case 3: {
                this.fCalculatedField = true;
                break;
            }
            case 6: {
                this.fTextEtcField = false;
                this.fNumField = false;
                this.fNonDates = false;
                this.fDateInField = true;
                this.fnumMinMaxValid = true;
                this.fCalculatedField = false;
            }
        }
        this.grbit = this.fNumField ? (short)(this.grbit | 0x20) : (short)(this.grbit & 0xFFFFFFDF);
        this.grbit = this.fTextEtcField ? (short)(this.grbit | 0x80) : (short)(this.grbit & 0xFFFFFF7F);
        this.grbit = this.fnumMinMaxValid ? (short)(this.grbit | 0x100) : (short)(this.grbit & 0xFFFFFEFF);
        this.grbit = this.fNonDates ? (short)(this.grbit | 0x400) : (short)(this.grbit & 0xFFFFFBFF);
        this.grbit = this.fDateInField ? (short)(this.grbit | 0x4000) : (short)(this.grbit & 0xFFFFBFFF);
        this.grbit = this.fCalculatedField ? (short)(this.grbit | 0x8000) : (short)(this.grbit & 0xFFFF7FFF);
        byte[] b = ByteTools.shortToLEBytes(this.grbit);
        this.getData()[0] = b[0];
        this.getData()[1] = b[1];
    }
}

