/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.io.UnsupportedEncodingException;

public class Sxvd
extends XLSRecord {
    private static final long serialVersionUID = -6537376162863865578L;
    public static final short AXIS_NONE = 0;
    public static final short AXIS_ROW = 1;
    public static final short AXIS_COL = 2;
    public static final short AXIS_PAGE = 4;
    public static final short AXIS_DATA = 8;
    private short cSub = (short)-1;
    private short cItm = (short)-1;
    private short axis = (short)-1;
    private short cchName = (short)-1;
    private String caption = null;
    boolean fDefault;
    boolean fSum;
    boolean fCounta;
    boolean fAverage;
    boolean fMax;
    boolean fMin;
    boolean fProduct;
    boolean fCount;
    boolean fStdev;
    boolean fStdevp;
    boolean fVariance;
    boolean fVariancep;
    private byte[] PROTOTYPE_BYTES;

    public Sxvd() {
        byte[] byArray = new byte[10];
        byArray[2] = 1;
        byArray[4] = 1;
        byArray[8] = -1;
        byArray[9] = -1;
        this.PROTOTYPE_BYTES = byArray;
    }

    @Override
    public void init() {
        super.init();
        this.axis = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        this.cSub = ByteTools.readShort(this.getByteAt(2), this.getByteAt(3));
        this.cItm = ByteTools.readShort(this.getByteAt(6), this.getByteAt(7));
        this.cchName = ByteTools.readShort(this.getByteAt(8), this.getByteAt(9));
        if (this.cchName != -1) {
            byte encoding = this.getByteAt(10);
            byte[] tmp = this.getBytesAt(11, this.cchName * (encoding + 1));
            try {
                this.caption = encoding == 0 ? new String(tmp, "ISO-8859-1") : new String(tmp, "UTF-16LE");
            }
            catch (UnsupportedEncodingException e) {
                Logger.logInfo("encoding PivotTable caption name in Sxvd: " + e);
            }
        }
        byte b0 = this.getByteAt(4);
        byte b1 = this.getByteAt(5);
        this.fDefault = (b0 & 1) == 1;
        this.fSum = (b0 & 2) == 2;
        this.fCounta = (b0 & 4) == 4;
        this.fAverage = (b0 & 8) == 8;
        this.fMax = (b0 & 0x10) == 16;
        this.fMin = (b0 & 0x20) == 32;
        this.fProduct = (b0 & 0x40) == 64;
        this.fCount = (b0 & 0x80) == 128;
        this.fStdev = (b1 & 1) == 1;
        this.fStdevp = (b1 & 2) == 2;
        this.fVariance = (b1 & 4) == 4;
        boolean bl = this.fVariancep = (b1 & 8) == 8;
        if (this.DEBUGLEVEL > 3) {
            Logger.logInfo("SXVD - axis:" + this.getAxisTypeName() + " cSub:" + this.cSub + " cItm:" + this.cItm + " default?" + this.fDefault + " sum?" + this.fSum + " caption:" + this.caption);
        }
    }

    public String getSubTotalFunction() {
        if (this.fDefault) {
            return "Default";
        }
        if (this.fSum) {
            return "Sum";
        }
        if (this.fCounta) {
            return "Count";
        }
        if (this.fAverage) {
            return "Average";
        }
        if (this.fMax) {
            return "Max";
        }
        if (this.fMin) {
            return "Min";
        }
        if (this.fProduct) {
            return "Product";
        }
        if (this.fStdev) {
            return "Stddev";
        }
        if (this.fStdevp) {
            return "StddevP";
        }
        if (this.fVariance) {
            return "Variance";
        }
        if (this.fVariancep) {
            return "VarianceP";
        }
        return "Default";
    }

    public void setSubTotalFunction(String[] f) {
        if (f == null) {
            f = new String[]{"Default"};
        }
        this.cSub = (short)f.length;
        int i = 0;
        while (i < this.cSub) {
            this.fDefault = f[i].equalsIgnoreCase("Default");
            this.fSum = f[i].equalsIgnoreCase("Sum");
            this.fCounta = f[i].equalsIgnoreCase("Count");
            this.fAverage = f[i].equalsIgnoreCase("Average");
            this.fMax = f[i].equalsIgnoreCase("Max");
            this.fMin = f[i].equalsIgnoreCase("Min");
            this.fProduct = f[i].equalsIgnoreCase("Product");
            this.fStdev = f[i].equalsIgnoreCase("Stddev");
            this.fStdevp = f[i].equalsIgnoreCase("StddevP");
            this.fVariance = f[i].equalsIgnoreCase("Variance");
            this.fVariancep = f[i].equalsIgnoreCase("VarianceP");
            ++i;
        }
        if (this.fDefault) {
            this.cSub = 1;
        }
        byte[] b = ByteTools.shortToLEBytes(this.cSub);
        this.getData()[2] = b[0];
        this.getData()[3] = b[1];
        b[0] = 0;
        b[1] = 0;
        if (this.fDefault) {
            b[0] = (byte)(b[0] | 1);
        }
        if (this.fSum) {
            b[0] = (byte)(b[0] | 2);
        }
        if (this.fCounta) {
            b[0] = (byte)(b[0] | 4);
        }
        if (this.fAverage) {
            b[0] = (byte)(b[0] | 8);
        }
        if (this.fMax) {
            b[0] = (byte)(b[0] | 0x10);
        }
        if (this.fMin) {
            b[0] = (byte)(b[0] | 0x20);
        }
        if (this.fProduct) {
            b[0] = (byte)(b[0] | 0x40);
        }
        if (this.fCount) {
            b[0] = (byte)(b[0] | 0xFFFFFF80);
        }
        if (this.fStdev) {
            b[1] = (byte)(b[1] | 1);
        }
        if (this.fStdevp) {
            b[1] = (byte)(b[1] | 2);
        }
        if (this.fVariance) {
            b[1] = (byte)(b[1] | 4);
        }
        if (this.fVariancep) {
            b[1] = (byte)(b[1] | 8);
        }
        this.getData()[4] = b[0];
        this.getData()[5] = b[1];
    }

    int getAxisType() {
        return this.axis;
    }

    String getAxisTypeName() {
        String ret = "";
        switch (this.axis) {
            case 0: {
                ret = "NONE";
                break;
            }
            case 1: {
                ret = "ROW";
                break;
            }
            case 2: {
                ret = "COL";
                break;
            }
            case 4: {
                ret = "PAGE";
                break;
            }
            case 8: {
                ret = "DATA";
            }
        }
        return ret;
    }

    public void setAxis(int axis) {
        if (axis != 1 && axis != 2 && axis != 4 && axis != 8) {
            return;
        }
        this.axis = (short)axis;
        byte[] b = ByteTools.shortToLEBytes(this.axis);
        this.getData()[0] = b[0];
        this.getData()[1] = b[1];
    }

    int getNumItems() {
        return this.cItm;
    }

    public void setNumItems(int n) {
        this.cItm = (short)n;
        byte[] b = ByteTools.shortToLEBytes(this.cItm);
        this.getData()[6] = b[0];
        this.getData()[7] = b[1];
    }

    int getNumSubtotals() {
        return this.cSub;
    }

    public static XLSRecord getPrototype() {
        Sxvd sv = new Sxvd();
        sv.setOpcode((short)177);
        sv.setData(sv.PROTOTYPE_BYTES);
        sv.init();
        return sv;
    }

    @Override
    public String toString() {
        return "SXVD - axis:" + this.getAxisTypeName() + " cSub:" + this.cSub + " cItm:" + this.cItm + " default?" + this.fDefault + " sum?" + this.fSum + " caption:" + this.caption;
    }
}

