/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.CellRange;
import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.formats.LEO.BlockByteConsumer;
import com.extentech.formats.LEO.BlockByteReader;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.ByteStreamer;
import com.extentech.formats.XLS.Continue;
import com.extentech.formats.XLS.Font;
import com.extentech.formats.XLS.Formula;
import com.extentech.formats.XLS.Hlink;
import com.extentech.formats.XLS.Index;
import com.extentech.formats.XLS.InvalidRecordException;
import com.extentech.formats.XLS.Row;
import com.extentech.formats.XLS.Sheet;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.XLSConstants;
import com.extentech.formats.XLS.Xf;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.CompatibleVector;
import com.extentech.toolkit.Logger;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class XLSRecord
implements BiffRec,
BlockByteConsumer,
Serializable,
XLSConstants {
    private static final long serialVersionUID = -106915096753184441L;
    private short opcode;
    int reclen;
    byte[] data;
    private transient BlockByteReader databuf;
    private transient BlockByteReader encryptedDatabuf;
    protected boolean isContinueMerged = false;
    protected transient int DEBUGLEVEL = 0;
    boolean isValueForCell;
    boolean isFPNumber;
    boolean isDoubleNumber = false;
    boolean isIntNumber;
    public boolean isString;
    public boolean isBoolean;
    boolean isFormula;
    public boolean isBlank;
    boolean isReadOnly = false;
    protected int rw = -1;
    protected short col;
    public int offset = 0;
    protected transient Index idx;
    protected Sheet worksheet;
    public transient Xf myxf;
    protected transient WorkBook wkbook;
    protected transient ByteStreamer streamer;
    protected AbstractList continues;
    int originalsize = -1;
    int originalIndex = 0;
    int originalOffset = 0;
    int ixfe = -1;
    public Hlink hyperlink = null;
    Row myrow = null;
    CellRange mergeRange;
    private int firstblock;
    private int lastblock;
    public int lastidx = -1;

    @Override
    public short getOpcode() {
        return this.opcode;
    }

    @Override
    public void setOpcode(short op) {
        this.opcode = op;
    }

    @Override
    public void setHyperlink(Hlink hl) {
        this.hyperlink = hl;
    }

    @Override
    public Formula getFormulaRec() {
        if (this instanceof Formula) {
            ((Formula)this).populateExpression();
            return (Formula)this;
        }
        return null;
    }

    public boolean shouldEncrypt() {
        return true;
    }

    @Override
    public void setRow(Row r2) {
        this.myrow = r2;
    }

    @Override
    public Row getRow() {
        if (this.myrow == null) {
            this.myrow = this.worksheet.getRowByNumber(this.rw);
        }
        return this.myrow;
    }

    @Override
    public Xf getXfRec() {
        if (this.myxf == null && this.ixfe > -1 && this.ixfe < this.wkbook.getNumXfs()) {
            this.myxf = this.wkbook.getXf(this.ixfe);
        }
        return this.myxf;
    }

    @Override
    public Font getFont() {
        WorkBook b = this.getWorkBook();
        if (b == null) {
            return null;
        }
        this.getXfRec();
        if (this.myxf == null) {
            return null;
        }
        return this.myxf.getFont();
    }

    @Override
    public CellRange getMergeRange() {
        return this.mergeRange;
    }

    @Override
    public void setMergeRange(CellRange range) {
        this.mergeRange = range;
    }

    @Override
    public boolean remove(boolean nullme) {
        boolean success = false;
        if (this.worksheet != null && this.isValueForCell) {
            this.getSheet().removeCell(this);
        }
        if (this.streamer != null) {
            this.streamer.removeRecord(this);
        }
        if (nullme) {
            try {
                this.finalize();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.worksheet = null;
        return true;
    }

    @Override
    public String getFormatPattern() {
        if (this.myxf == null) {
            return "";
        }
        return this.myxf.getFormatPattern();
    }

    public int getCellType() {
        if (this.isBlank) {
            return -1;
        }
        if (this.isString) {
            return 0;
        }
        if (this.isDoubleNumber) {
            return 5;
        }
        if (this.isFPNumber) {
            return 1;
        }
        if (this.isIntNumber) {
            return 2;
        }
        if (this.isFormula) {
            return 3;
        }
        if (this.isBoolean) {
            return 4;
        }
        return -1;
    }

    @Override
    public void setOffset(int pos) {
        if (this.originalOffset < 1) {
            this.originalOffset = pos;
        }
        this.offset = pos;
    }

    @Override
    public int getOffset() {
        if (this.data == null) {
            return this.originalOffset;
        }
        return this.offset;
    }

    @Override
    public void setFirstBlock(int i) {
        this.firstblock = i;
    }

    @Override
    public void setLastBlock(int i) {
        this.lastblock = i;
    }

    @Override
    public int getFirstBlock() {
        return this.firstblock;
    }

    @Override
    public int getLastBlock() {
        return this.lastblock;
    }

    protected void initRowCol() {
        int pos = 0;
        byte[] bt = this.getBytesAt(pos, 2);
        this.rw = ByteTools.readUnsignedShort(bt[0], bt[1]);
        pos += 2;
        this.col = ByteTools.readShort(this.getByteAt(pos++), this.getByteAt(pos++));
    }

    public String toString() {
        return this.getRecDesc();
    }

    public String getRecDesc() {
        String ret = "";
        String name = this.getClass().getSimpleName();
        ret = String.valueOf(ret) + (name.equals("XLSRecord") ? "unknown" : name.toUpperCase());
        ret = String.valueOf(ret) + " (" + Integer.toHexString(this.opcode).toUpperCase() + "h)";
        ret = String.valueOf(ret) + " at " + Integer.toHexString(this.offset).toUpperCase() + "h";
        ret = String.valueOf(ret) + " length " + Integer.toHexString(this.reclen).toUpperCase() + "h";
        ret = String.valueOf(ret) + " file " + (this.databuf == null ? "no file" : this.databuf.getFileOffsetString(this.offset, this.reclen));
        if (this.isValueForCell()) {
            ret = String.valueOf(ret) + " cell " + this.getCellAddress();
        }
        return ret;
    }

    @Override
    public String toHexDump() {
        return String.valueOf(this.getRecDesc()) + "\n" + ByteTools.getByteDump(this.getData(), 0);
    }

    @Override
    public void copyFormat(BiffRec source) {
        Xf clone = (Xf)source.getXfRec().clone();
        Font fontClone = (Font)source.getXfRec().getFont().clone();
        Logger.logInfo(source + ":" + source.getXfRec() + ":" + clone);
        int fid = -1;
        int xid = -1;
        if (this.getWorkBook().getFontRecs().contains(fontClone)) {
            fid = this.getWorkBook().getFontRecs().indexOf(fontClone);
        }
        if (this.getWorkBook().getXfrecs().contains(clone)) {
            xid = this.getWorkBook().getXfrecs().indexOf(clone);
        }
        this.getWorkBook().addRecord(clone, false);
        this.getWorkBook().addRecord(fontClone, false);
        clone.setFont(fontClone.getIdx());
        this.setXFRecord(clone.getIdx());
    }

    public Object clone() {
        try {
            String cn = this.getClass().getName();
            XLSRecord rec = (XLSRecord)Class.forName(cn).newInstance();
            byte[] inb = this.getBytes();
            rec.setData(inb);
            rec.streamer = this.streamer;
            rec.setWorkBook(this.getWorkBook());
            rec.setOpcode(this.getOpcode());
            rec.setLength(this.getLength());
            rec.setSheet(this.getSheet());
            rec.init();
            return rec;
        }
        catch (Exception e) {
            Logger.logInfo("cloning XLSRecord " + this.getCellAddress() + " failed: " + e);
            return null;
        }
    }

    public boolean isNumber() {
        if (this.opcode == 638) {
            return true;
        }
        return this.opcode == 515;
    }

    public boolean isFormula() {
        return this.isFormula;
    }

    @Override
    public void setDebugLevel(int b) {
        this.DEBUGLEVEL = b;
    }

    public int getRealRecordIndex() {
        return this.streamer.getRealRecordIndex(this);
    }

    @Override
    public int getRecordIndex() {
        if (this.streamer == null) {
            if (this.getSheet() != null) {
                return this.getSheet().getSheetRecs().indexOf(this);
            }
            return -1;
        }
        return this.streamer.getRecordIndex(this);
    }

    @Override
    public void addContinue(Continue c) {
        if (this.continues == null) {
            this.continues = new ArrayList();
        }
        this.continues.add(c);
    }

    @Override
    public void removeContinues() {
        if (this.continues != null) {
            this.continues.clear();
        }
    }

    @Override
    public List getContinueVect() {
        if (this.continues != null) {
            return this.continues;
        }
        this.continues = new CompatibleVector();
        return this.continues;
    }

    @Override
    public boolean hasContinues() {
        if (this.continues == null) {
            return false;
        }
        return this.continues.size() > 0;
    }

    @Override
    public void setIsValueForCell(boolean b) {
        this.isValueForCell = b;
    }

    @Override
    public void setIndex(Index id) {
        this.idx = id;
    }

    @Override
    public void setSheet(Sheet b) {
        this.worksheet = b;
    }

    @Override
    public Boundsheet getSheet() {
        return (Boundsheet)this.worksheet;
    }

    @Override
    public void setWorkBook(WorkBook wk) {
        this.wkbook = wk;
    }

    @Override
    public WorkBook getWorkBook() {
        if (this.wkbook == null && this.worksheet != null) {
            this.wkbook = this.worksheet.getWorkBook();
        }
        return this.wkbook;
    }

    @Override
    public void setCol(short i) {
        byte[] c = ByteTools.shortToLEBytes(i);
        System.arraycopy(c, 0, this.getData(), 2, 2);
        this.col = i;
    }

    @Override
    public void setRowCol(int[] x) {
        this.setRowNumber(x[0]);
        this.setCol((short)x[1]);
    }

    @Override
    public void setRowNumber(int i) {
        byte[] r2 = ByteTools.cLongToLEBytes(i);
        System.arraycopy(r2, 0, this.getData(), 0, 2);
        this.rw = i;
    }

    @Override
    public short getColNumber() {
        return this.col;
    }

    @Override
    public int getRowNumber() {
        if (this.rw < 0) {
            int rowi = this.rw * -1;
            this.rw = this.wkbook.getIsExcel2007() ? 0x100000 - rowi : 256 - rowi;
        }
        return this.rw;
    }

    @Override
    public String getCellAddress() {
        int rownum = this.rw + 1;
        if (rownum < 0 && this.col >= 0) {
            rownum += 0x100000;
        } else if (rownum == 0 && this.col >= 0) {
            rownum = 0x100000;
        }
        if (rownum > 0x100000 || this.col < 0) {
            if (this.DEBUGLEVEL > -1) {
                Logger.logWarn("XLSRecord.getCellAddress() Row/Col info incorrect for Cell:" + ExcelTools.getAlphaVal(this.col) + String.valueOf(rownum));
            }
            return "";
        }
        return String.valueOf(ExcelTools.getAlphaVal(this.col)) + rownum;
    }

    public int[] getIntLocation() {
        return new int[]{this.rw, this.col};
    }

    public String getCellAddressWithSheet() {
        if (this.getSheet() != null) {
            return String.valueOf(this.getSheet().getSheetName()) + "!" + this.getCellAddress();
        }
        return this.getCellAddress();
    }

    @Override
    public void init() {
        if (this.originalsize == 0) {
            this.originalsize = this.reclen;
        }
    }

    @Override
    public Object getDefaultVal() {
        if (this.isDoubleNumber) {
            return new Double(0.0);
        }
        if (this.isFPNumber) {
            return new Float(0.0f);
        }
        if (this.isBoolean) {
            return false;
        }
        if (this.isIntNumber) {
            return 0;
        }
        if (this.isString) {
            return "";
        }
        if (this.isFormula) {
            return this.getFormulaRec().getFormulaString();
        }
        if (this.isBlank) {
            return "";
        }
        return null;
    }

    @Override
    public String getDataType() {
        if (this.isValueForCell) {
            if (this.isBlank) {
                return "Blank";
            }
            if (this.isDoubleNumber) {
                return "Double";
            }
            if (this.isFPNumber) {
                return "Float";
            }
            if (this.isBoolean) {
                return "Boolean";
            }
            if (this.isIntNumber) {
                return "Integer";
            }
            if (this.isString) {
                return "String";
            }
            if (this.isFormula) {
                return "Formula";
            }
        }
        return null;
    }

    @Override
    public Object getInternalVal() {
        try {
            switch (this.getCellType()) {
                case -1: {
                    return this.getStringVal();
                }
                case 0: {
                    return this.getStringVal();
                }
                case 1: {
                    return new Double(this.getDblVal());
                }
                case 5: {
                    return new Double(this.getDblVal());
                }
                case 2: {
                    return this.getIntVal();
                }
                case 3: {
                    Object obx = ((Formula)this).calculateFormula();
                    return obx;
                }
                case 4: {
                    return this.getBooleanVal();
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    Object getVal() {
        return null;
    }

    @Override
    public boolean getBooleanVal() {
        return false;
    }

    @Override
    public int getIntVal() {
        return 0;
    }

    @Override
    public double getDblVal() {
        return Double.NaN;
    }

    @Override
    public float getFloatVal() {
        return Float.NaN;
    }

    @Override
    public String getStringVal() {
        return null;
    }

    @Override
    public String getStringVal(String encoding) {
        return null;
    }

    @Override
    public void setStringVal(String v) {
        Logger.logErr("Setting String Val on generic XLSRecord, value not held");
    }

    @Override
    public void setBooleanVal(boolean b) {
        Logger.logErr("Setting Boolean Val on generic XLSRecord, value not held");
    }

    @Override
    public void setIntVal(int v) {
        Logger.logErr("Setting int Val on generic XLSRecord, value not held");
    }

    public void setFloatVal(float v) {
        Logger.logErr("Setting float Val on generic XLSRecord, value not held");
    }

    @Override
    public void setDoubleVal(double v) {
        Logger.logErr("Setting Double Val on generic XLSRecord, value not held");
    }

    @Override
    public void preStream() {
    }

    @Override
    public void setXFRecord() {
        if (this.wkbook == null) {
            return;
        }
        if (this.ixfe > -1 && this.ixfe < this.wkbook.getNumXfs() && (this.myxf == null || this.myxf.tableidx != this.ixfe)) {
            this.myxf = this.wkbook.getXf(this.ixfe);
            this.myxf.incUseCount();
        }
    }

    @Override
    public void setXFRecord(int i) {
        if (i != this.ixfe || this.myxf == null) {
            this.setIxfe(i);
            this.setXFRecord();
        }
    }

    @Override
    public void setIxfe(int i) {
        this.ixfe = i;
        byte[] newxfe = ByteTools.cLongToLEBytes(i);
        byte[] b = this.getData();
        if (b != null) {
            System.arraycopy(newxfe, 0, b, 4, 2);
        }
        this.setData(b);
    }

    @Override
    public int getIxfe() {
        return this.ixfe;
    }

    protected static XLSRecord getPrototype() {
        Logger.logWarn("Attempt to get prototype XLSRecord failed.  There is no prototype record defined for this record type.");
        return null;
    }

    @Override
    public void setByteReader(BlockByteReader db) {
        this.databuf = db;
        this.data = null;
    }

    @Override
    public BlockByteReader getByteReader() {
        return this.databuf;
    }

    @Override
    public void setEncryptedByteReader(BlockByteReader db) {
        this.encryptedDatabuf = db;
    }

    @Override
    public BlockByteReader getEncryptedByteReader() {
        return this.encryptedDatabuf;
    }

    @Override
    public void setData(byte[] b) {
        this.data = b;
        this.databuf = null;
    }

    @Override
    public byte[] getData() {
        int len = 0;
        len = this.getLength();
        if (len == 0) {
            return new byte[0];
        }
        if (this.data != null) {
            return this.data;
        }
        if (len > 8224) {
            this.setData(this.getBytesAt(0, 8224));
        } else {
            this.setData(this.getBytesAt(0, len - 4));
        }
        if (this.opcode == 252 || this.opcode == 181) {
            return this.data;
        }
        if (!this.isContinueMerged && this.hasContinues()) {
            this.mergeContinues();
        }
        return this.data;
    }

    protected void mergeContinues() {
        List cx = this.getContinueVect();
        if (cx != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                out.write(this.data);
            }
            catch (IOException e) {
                Logger.logWarn("ERROR: parsing record continues failed: " + this.toString() + ": " + e);
            }
            for (Continue c : cx) {
                byte[] nb = c.getData();
                if (c.getHasGrbit()) {
                    byte[] newnb = new byte[nb.length - 1];
                    System.arraycopy(nb, 1, newnb, 0, newnb.length);
                    nb = newnb;
                }
                try {
                    out.write(nb);
                }
                catch (IOException a) {
                    Logger.logWarn("ERROR: parsing record continues failed: " + this.toString() + ": " + a);
                }
            }
            this.data = out.toByteArray();
        }
        this.isContinueMerged = true;
    }

    @Override
    public byte[] getBytes() {
        return this.getBytesAt(0, this.getLength());
    }

    @Override
    public byte[] getBytesAt(int off, int len) {
        if (this.data != null) {
            if (len + off > this.data.length) {
                len = this.data.length - off;
            }
            byte[] ret = new byte[len];
            System.arraycopy(this.data, off, ret, 0, len);
            return ret;
        }
        if (this.databuf == null) {
            return null;
        }
        return this.databuf.get(this, off, len);
    }

    public void resetCacheBytes() {
    }

    @Override
    public byte getByteAt(int off) {
        if (this.data != null) {
            return this.data[off];
        }
        if (this.databuf == null) {
            throw new InvalidRecordException("XLSRecord has no data buffer." + this.getCellAddress());
        }
        return this.databuf.get(this, off);
    }

    @Override
    public void setLength(int len) {
        if (this.originalsize <= 0) {
            this.originalsize = len;
        }
        this.reclen = len;
    }

    @Override
    public int getLength() {
        if (this.data != null) {
            return this.data.length + 4;
        }
        if (this.databuf == null) {
            return -1;
        }
        if (this.hasContinues() && !this.isContinueMerged && this.opcode != 252 && this.opcode != 181) {
            if (this.reclen > 8224) {
                this.setData(this.getBytesAt(0, 8224));
            } else {
                this.setData(this.getBytesAt(0, this.reclen));
            }
            this.mergeContinues();
            return this.data.length + 4;
        }
        return this.reclen + 4;
    }

    @Override
    public boolean isValueForCell() {
        return this.isValueForCell;
    }

    public void setValueForCell(boolean isVal) {
        this.isValueForCell = isVal;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public ByteStreamer getStreamer() {
        return this.streamer;
    }

    @Override
    public void setStreamer(ByteStreamer str) {
        this.streamer = str;
    }

    @Override
    public Hlink getHyperlink() {
        return this.hyperlink;
    }

    @Override
    public void postStream() {
    }

    public void close() {
        if (this.databuf != null) {
            this.databuf.clear();
            this.databuf = null;
        }
        this.idx = null;
        this.worksheet = null;
        this.myxf = null;
        this.wkbook = null;
        this.streamer = null;
        if (this.continues != null) {
            int i = 0;
            while (i < this.continues.size()) {
                ((XLSRecord)this.continues.get(i)).close();
                ++i;
            }
            this.continues.clear();
        }
        if (this.hyperlink != null) {
            this.hyperlink.close();
            this.hyperlink = null;
        }
        this.mergeRange = null;
        if (this.myrow != null) {
            this.myrow = null;
        }
        this.mergeRange = null;
    }

    public Color[] getColorTable() {
        try {
            return this.getWorkBook().getColorTable();
        }
        catch (Exception e) {
            return FormatHandle.COLORTABLE;
        }
    }
}

