/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.toolkit.ByteTools;

public class AttachedLabel
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = 2532517522176536995L;
    public static final int VALUE = 1;
    public static final int VALUEPERCENT = 2;
    public static final int CATEGORYPERCENT = 4;
    public static final int CATEGORYLABEL = 16;
    public static final int BUBBLELABEL = 32;
    public static final int VALUELABEL = 64;
    private short grbit = 0;
    private byte[] PROTOTYPE_BYTES = new byte[2];

    @Override
    public void init() {
        super.init();
        this.grbit = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
    }

    public static XLSRecord getPrototype() {
        AttachedLabel al = new AttachedLabel();
        al.setOpcode((short)4108);
        al.setData(al.PROTOTYPE_BYTES);
        al.init();
        return al;
    }

    public String getType() {
        String ret = "";
        if ((this.grbit & 1) == 1) {
            ret = "Value ";
        }
        if ((this.grbit & 2) == 2) {
            ret = String.valueOf(ret) + "ValuePerecentage ";
        }
        if ((this.grbit & 4) == 4) {
            ret = String.valueOf(ret) + "CategoryPercentage ";
        }
        if ((this.grbit & 0x10) == 16) {
            ret = String.valueOf(ret) + "CategoryLabel ";
        }
        if ((this.grbit & 0x20) == 32) {
            ret = String.valueOf(ret) + "BubbleLabel ";
        }
        if ((this.grbit & 0x40) == 64) {
            ret = String.valueOf(ret) + "SeriesLabel ";
        }
        return ret.trim();
    }

    public int getTypeInt() {
        return this.grbit;
    }

    public void setType(short type) {
        this.grbit = type;
        byte[] b = ByteTools.shortToLEBytes(this.grbit);
        this.getData()[0] = b[0];
        this.getData()[1] = b[1];
    }

    public void setType(String type, String val) {
        boolean bSet;
        boolean bl = bSet = val.equals("true") || val.equals("1");
        if (type.equals("ShowValueLabel")) {
            this.grbit = ByteTools.updateGrBit(this.grbit, bSet, 0);
        }
        if (type.equals("ShowValueAsPercent")) {
            this.grbit = ByteTools.updateGrBit(this.grbit, bSet, 1);
        }
        if (type.equals("ShowLabelAsPercent")) {
            this.grbit = ByteTools.updateGrBit(this.grbit, bSet, 2);
        }
        if (type.equals("ShowLabel")) {
            this.grbit = ByteTools.updateGrBit(this.grbit, bSet, 4);
        }
        if (type.equals("ShowBubbleLabel")) {
            this.grbit = ByteTools.updateGrBit(this.grbit, bSet, 5);
        }
        if (type.equals("ShowSeriesName")) {
            this.grbit = ByteTools.updateGrBit(this.grbit, bSet, 6);
        }
        byte[] bb = ByteTools.shortToLEBytes(this.grbit);
        this.getData()[0] = bb[0];
        this.getData()[1] = bb[1];
    }

    public String getType(String type) {
        boolean b = false;
        String ret = "";
        if (type.equals("ShowValueLabel")) {
            boolean bl = b = (this.grbit & 1) == 1;
        }
        if (type.equals("ShowValueAsPercent")) {
            boolean bl = b = (this.grbit & 2) == 2;
        }
        if (type.equals("ShowLabelAsPercent")) {
            boolean bl = b = (this.grbit & 4) == 4;
        }
        if (type.equals("ShowLabel")) {
            boolean bl = b = (this.grbit & 0x10) == 16;
        }
        if (type.equals("ShowBubbleLabel")) {
            boolean bl = b = (this.grbit & 0x20) == 32;
        }
        if (type.equals("ShowSeriesName")) {
            b = (this.grbit & 0x40) == 64;
        }
        return b ? "1" : "0";
    }

    public void setType(String type) {
        int t = 0;
        if (type.equalsIgnoreCase("Value") || type.equalsIgnoreCase("Y Value")) {
            t = 1;
        } else if (type.equalsIgnoreCase("ValuePercentage")) {
            t = 2;
        } else if (type.equalsIgnoreCase("CategoryPercentage")) {
            t = 3;
        } else if (type.equalsIgnoreCase("Category") || type.equalsIgnoreCase("X Value")) {
            t = 16;
        } else if (type.equalsIgnoreCase("CandP")) {
            t = 22;
        } else if (type.equalsIgnoreCase("Bubble")) {
            t = 32;
        }
        this.grbit = t;
        byte[] b = ByteTools.shortToLEBytes(this.grbit);
        this.getData()[0] = b[0];
        this.getData()[1] = b[1];
    }

    @Override
    public String toString() {
        return this.getType();
    }
}

