/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.ExtenXLS.CellRange;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.NumFmt;
import com.extentech.formats.OOXML.SpPr;
import com.extentech.formats.OOXML.Title;
import com.extentech.formats.OOXML.TxPr;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Font;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.AreaFormat;
import com.extentech.formats.XLS.charts.Axcent;
import com.extentech.formats.XLS.charts.AxisLineFormat;
import com.extentech.formats.XLS.charts.AxisParent;
import com.extentech.formats.XLS.charts.CatLab;
import com.extentech.formats.XLS.charts.CatserRange;
import com.extentech.formats.XLS.charts.Chart;
import com.extentech.formats.XLS.charts.ChartAxes;
import com.extentech.formats.XLS.charts.ChartFormat;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.ChartType;
import com.extentech.formats.XLS.charts.Fontx;
import com.extentech.formats.XLS.charts.Frame;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.formats.XLS.charts.Ifmt;
import com.extentech.formats.XLS.charts.LineFormat;
import com.extentech.formats.XLS.charts.PlotArea;
import com.extentech.formats.XLS.charts.Scaling;
import com.extentech.formats.XLS.charts.Series;
import com.extentech.formats.XLS.charts.TextDisp;
import com.extentech.formats.XLS.charts.Tick;
import com.extentech.formats.XLS.charts.ValueRange;
import com.extentech.formats.XLS.charts.YMult;
import com.extentech.formats.cellformat.CellFormatFactory;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import com.extentech.toolkit.StringTool;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;

public class Axis
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = -8592219101790307789L;
    short wType = 0;
    private TextDisp linkedtd = null;
    private AxisParent ap = null;
    public static final int INVISIBLE = 0;
    public static final int LOW = 1;
    public static final int HIGH = 2;
    public static final int NEXTTO = 3;
    private SpPr shapeProps = null;
    private Title ttl = null;
    private TxPr txpr = null;
    private NumFmt nf = null;
    String axPos = null;
    private byte[] PROTOTYPE_BYTES = new byte[18];
    static int YLABELSSPACER_X = 10;
    static int YLABELSPACER_Y = 4;

    @Override
    public void init() {
        super.init();
        this.wType = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
    }

    public short getAxis() {
        return this.wType;
    }

    public void setAxis(int wType) {
        this.wType = (short)wType;
        if (wType == 3) {
            wType = 0;
        }
        byte[] b = ByteTools.shortToLEBytes((short)wType);
        this.getData()[0] = b[0];
        this.getData()[1] = b[1];
    }

    public static XLSRecord getPrototype(int wType) {
        Axis a = new Axis();
        a.setOpcode((short)4125);
        a.setData(a.PROTOTYPE_BYTES);
        a.setAxis(wType);
        switch (wType) {
            case 0: {
                a.addChartRecord((CatserRange)CatserRange.getPrototype());
                a.addChartRecord((Axcent)Axcent.getPrototype());
                a.addChartRecord((Tick)Tick.getPrototype());
                break;
            }
            case 1: 
            case 3: {
                a.addChartRecord((ValueRange)ValueRange.getPrototype());
                a.addChartRecord((Tick)Tick.getPrototype());
                AxisLineFormat alf = (AxisLineFormat)AxisLineFormat.getPrototype();
                alf.setId(1);
                a.addChartRecord(alf);
                a.addChartRecord((LineFormat)LineFormat.getPrototype());
                break;
            }
            case 2: {
                CatserRange c = (CatserRange)CatserRange.getPrototype();
                a.addChartRecord(c);
                a.addChartRecord((Tick)Tick.getPrototype());
            }
        }
        return a;
    }

    @Override
    public String getOptionsXML() {
        StringBuffer sb = new StringBuffer();
        boolean hasMajorGridLines = false;
        int i = 0;
        while (i < this.chartArr.size()) {
            BiffRec b = (BiffRec)this.chartArr.get(i);
            if (b instanceof CatserRange) {
                CatserRange c = (CatserRange)b;
                if (c.getCatCross() != 1) {
                    sb.append(" CatCross=\"" + c.getCatCross() + "\"");
                }
                if (c.getCatLabel() != 1) {
                    sb.append(" LabelCross=\"" + c.getCatLabel() + "\"");
                }
                if (c.getCatMark() != 1) {
                    sb.append(" Marks=\"" + c.getCatMark() + "\"");
                }
                if (!c.getCrossBetween()) {
                    sb.append(" CrossBetween=\"false\"");
                }
                if (c.getCrossMax()) {
                    sb.append(" CrossMax=\"true\"");
                }
            } else if (b instanceof AxisLineFormat) {
                short id = ((AxisLineFormat)b).getId();
                if (id == 1) {
                    hasMajorGridLines = true;
                } else if (id == 3) {
                    sb.append(" AddArea=\"true\"");
                }
            } else if (b instanceof AreaFormat) {
                int icvFore = ((AreaFormat)b).geticvFore();
                int icvBack = ((AreaFormat)b).geticvBack();
                if (icvBack == -1) {
                    icvBack = 77;
                }
                if (icvFore == 1) {
                    icvFore = 78;
                }
                if (this.wType == 0 && icvFore != 22 || this.wType == 1 && icvFore != -1) {
                    sb.append(" AreaFg=\"" + icvFore + "\"");
                }
                if (this.wType == 0 && icvBack != 0 || this.wType == 1 && icvBack != 1) {
                    sb.append(" AreaBg=\"" + icvBack + "\"");
                }
            }
            ++i;
        }
        if (this.wType == 1 && !hasMajorGridLines) {
            sb.append(" MajorGridLines=\"false\"");
        }
        return sb.toString();
    }

    public void setTd(TextDisp td) {
        this.linkedtd = td;
    }

    public TextDisp getTd() {
        if (this.linkedtd == null) {
            this.getTitleTD(false);
        }
        return this.linkedtd;
    }

    public void removeTitle() {
        if (this.linkedtd != null) {
            int x = Chart.findRecPosition(this.ap.chartArr, TextDisp.class);
            while (x > -1) {
                if (((TextDisp)this.ap.chartArr.get(x)).getType() == TextDisp.convertType(this.wType)) {
                    this.ap.chartArr.remove(x);
                    break;
                }
                if (((BiffRec)this.ap.chartArr.get(++x)).getOpcode() != 4133) break;
            }
        }
        this.linkedtd = null;
    }

    public boolean hasPlotAreaBorder() {
        Frame f = (Frame)Chart.findRec(this.ap.chartArr, Frame.class);
        if (f != null) {
            return f.hasBox();
        }
        return false;
    }

    public void setAP(AxisParent a) {
        this.ap = a;
    }

    public String getLabel() {
        return this.getTitle();
    }

    public String getTitle() {
        if (this.linkedtd == null) {
            this.getTitleTD(false);
        }
        if (this.linkedtd != null) {
            return this.linkedtd.toString();
        }
        return "";
    }

    public Font getTitleFont() {
        try {
            if (this.linkedtd != null) {
                Fontx fx = (Fontx)Chart.findRec(this.linkedtd.chartArr, Fontx.class);
                return this.getParentChart().getWorkBook().getFont(fx.getIfnt());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void getTitleTD(boolean add) {
        TextDisp td;
        int x;
        int tdtype = TextDisp.convertType(this.wType);
        int pos = 0;
        pos = x = Chart.findRecPosition(this.ap.chartArr, TextDisp.class);
        while (x > 0 && this.linkedtd == null) {
            td = (TextDisp)this.ap.chartArr.get(x);
            if (td.getType() == tdtype) {
                this.linkedtd = td;
                continue;
            }
            if (this.ap.chartArr.get(++x) instanceof TextDisp) continue;
            x = -1;
        }
        if (this.linkedtd == null && add) {
            this.linkedtd = (TextDisp)TextDisp.getPrototype(tdtype, "", this.wkbook);
            if (pos < 0) {
                pos = Chart.findRecPosition(this.ap.chartArr, PlotArea.class);
            } else {
                td = (TextDisp)this.ap.chartArr.get(pos);
                this.linkedtd.setFontId(td.getFontId());
                if (this.wType != 0) {
                    ++pos;
                }
            }
            if (pos < 0) {
                pos = Chart.findRecPosition(this.ap.chartArr, ChartFormat.class);
            }
            this.linkedtd.setParentChart(this.getParentChart());
            this.ap.chartArr.add(pos, this.linkedtd);
        }
    }

    public void setTitle(String l) {
        if (l == null) {
            this.removeTitle();
            return;
        }
        if (this.linkedtd == null) {
            this.getTitleTD(true);
        }
        this.linkedtd.setText(l);
    }

    public void setFont(int fondId) {
        if (this.linkedtd == null) {
            this.getTitleTD(true);
        }
        this.linkedtd.setFontId(fondId);
    }

    @Override
    public Font getFont() {
        if (this.linkedtd == null) {
            this.getTitleTD(true);
        }
        int idx = this.linkedtd.getFontId();
        return this.getWorkBook().getFont(idx);
    }

    public Font getLabelFont() {
        try {
            Fontx fx = (Fontx)Chart.findRec(this.chartArr, Fontx.class);
            return this.getParentChart().getWorkBook().getFont(fx.getIfnt());
        }
        catch (NullPointerException e) {
            return this.getParentChart().getDefaultFont();
        }
    }

    protected CatserRange getCatserRange(boolean bCreate) {
        CatserRange csr = (CatserRange)Chart.findRec(this.chartArr, CatserRange.class);
        if (csr == null) {
            csr = (CatserRange)CatserRange.getPrototype();
            csr.setParentChart(this.getParentChart());
            this.chartArr.add(0, csr);
        }
        return csr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasGridlines(int type) {
        int j = Chart.findRecPosition(this.chartArr, AxisLineFormat.class);
        if (j == -1) return false;
        try {
            while (true) {
                if (j >= this.chartArr.size()) {
                    return false;
                }
                AxisLineFormat al = (AxisLineFormat)this.chartArr.get(j);
                short id = al.getId();
                if (id == type) {
                    return true;
                }
                j += 2;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    protected String getLineSVG(int id) {
        LineFormat lf = this.getAxisLine(id);
        if (lf != null) {
            return lf.getSVG();
        }
        return "";
    }

    protected LineFormat getAxisLine(int type) {
        int j = this.getAxisLineFormat(type);
        if (j > -1) {
            return (LineFormat)this.chartArr.get(j + 1);
        }
        return null;
    }

    protected AxisLineFormat getAxisLineFormat(int type, boolean bCreate) {
        AxisLineFormat alf = null;
        int j = Chart.findRecPosition(this.chartArr, AxisLineFormat.class);
        if (j == -1 && !bCreate) {
            return null;
        }
        if (j > -1) {
            try {
                while (j < this.chartArr.size()) {
                    alf = (AxisLineFormat)this.chartArr.get(j);
                    if (alf.getId() == type) {
                        return alf;
                    }
                    if (alf.getId() <= type) {
                        j += 2;
                        continue;
                    }
                    break;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        j = 1;
        while (j < this.chartArr.size()) {
            BiffRec b = (BiffRec)this.chartArr.get(j);
            if (b.getOpcode() == 4106 || b.getOpcode() == 4198 || b.getOpcode() == 2213 || b.getOpcode() == 2212 || b.getOpcode() == 2206) break;
            ++j;
        }
        alf = (AxisLineFormat)AxisLineFormat.getPrototype();
        alf.setId(type);
        this.chartArr.add(j++, alf);
        alf.setParentChart(this.getParentChart());
        LineFormat lf = (LineFormat)LineFormat.getPrototype();
        lf.setParentChart(this.getParentChart());
        this.chartArr.add(j, lf);
        return alf;
    }

    /*
     * Exception decompiling
     */
    protected int getAxisLineFormat(int type) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected YMult getYMultRec(boolean bCreate) {
        YMult ym = (YMult)Chart.findRec(this.chartArr, YMult.class);
        if (ym == null && bCreate) {
            ym = (YMult)YMult.getPrototype();
            ym.setParentChart(this.getParentChart());
            this.chartArr.add(1, ym);
        }
        return ym;
    }

    public boolean isReversed() {
        CatserRange c;
        if (this.wType == 0 && (c = this.getCatserRange(false)) != null) {
            return c.isReversed();
        }
        ValueRange v = (ValueRange)Chart.findRec(this.chartArr, ValueRange.class);
        if (v != null) {
            return v.isReversed();
        }
        return false;
    }

    public String getNumberFormat() {
        Ifmt f = (Ifmt)Chart.findRec(this.chartArr, Ifmt.class);
        int i = 0;
        if (f != null) {
            i = f.getFmt();
        } else {
            Vector s = this.getParentChart().getAllSeries(-1);
            if (s.size() > 0) {
                if (this.wType == 1) {
                    return ((Series)s.get(0)).getSeriesFormatPattern();
                }
                return ((Series)s.get(0)).getCategoryFormatPattern();
            }
        }
        return "General";
    }

    public JSONObject getJSON(WorkBookHandle wbh, int chartType, double yMax, double yMin, int nSeries) {
        JSONObject axisJSON = new JSONObject();
        JSONObject axisOptions = new JSONObject();
        try {
            if (this.wType == 1 && chartType != 1) {
                axisOptions.put("vertical", true);
            } else if (this.wType == 0 && chartType == 1) {
                axisOptions.put("vertical", true);
            }
            axisOptions.put("label", (Object)this.getTitle());
            int i = 0;
            while (i < this.chartArr.size()) {
                BiffRec b = (BiffRec)this.chartArr.get(i);
                if (b instanceof CatserRange) {
                    CatserRange c = (CatserRange)b;
                    String[] categories = this.getParentChart().getCategories(-1);
                    if (categories != null) {
                        JSONArray labels = new JSONArray();
                        if (c.getCrossBetween()) {
                            axisOptions.put("includeZero", true);
                            JSONObject nullCat = new JSONObject();
                            nullCat.put("value", 0);
                            nullCat.put("text", (Object)"");
                            labels.put((Object)nullCat);
                        }
                        JSONArray cats = CellRange.getValuesAsJSON(categories[0], wbh);
                        int z = 0;
                        while (z < cats.length()) {
                            JSONObject aCat = new JSONObject();
                            aCat.put("value", z + c.getCatLabel());
                            aCat.put("text", cats.get(z));
                            labels.put((Object)aCat);
                            ++z;
                        }
                        if (c.getCrossBetween()) {
                            JSONObject nullCat = new JSONObject();
                            nullCat.put("value", cats.length() + c.getCatLabel());
                            nullCat.put("text", (Object)"");
                            labels.put((Object)nullCat);
                            axisOptions.put("max", cats.length() + c.getCatLabel());
                        }
                        axisOptions.put("labels", (Object)labels);
                        axisOptions.put("fixLower", (Object)"major");
                        axisOptions.put("fixUpper", (Object)"major");
                    }
                    c.getCatMark();
                } else if (b instanceof ValueRange) {
                    ValueRange v = (ValueRange)b;
                    if (this.wType == 1) {
                        v.setMaxMin(yMax, yMin);
                    } else {
                        v.setMaxMin(nSeries, 0.0);
                    }
                    axisOptions.put("min", v.getMin());
                    axisOptions.put("max", v.getMax());
                    axisOptions.put("majorTickStep", v.getMajorTick());
                } else if (b instanceof AxisLineFormat) {
                    JSONObject gridJSON = new JSONObject();
                    gridJSON.put("type", (Object)"Grid");
                    short id = ((AxisLineFormat)b).getId();
                    switch (id) {
                        case 1: {
                            if (this.wType == 0 || chartType == 1) {
                                gridJSON.put("hMajorLines", false);
                                break;
                            }
                            gridJSON.put("vMajorLines", false);
                            break;
                        }
                    }
                    axisJSON.put("back_grid", (Object)gridJSON);
                }
                ++i;
            }
            if (this.wType == 1) {
                axisJSON.put("y", (Object)axisOptions);
            }
            if (this.wType == 0) {
                axisJSON.put("x", (Object)axisOptions);
            }
        }
        catch (JSONException e) {
            Logger.logErr("Error getting Axis JSON: " + (Object)((Object)e));
        }
        return axisJSON;
    }

    @Override
    public boolean setChartOption(String op, String val) {
        if (op.equalsIgnoreCase("Label")) {
            this.setTitle(val);
            return true;
        }
        if (op.equalsIgnoreCase("CatCross")) {
            this.getCatserRange(true).setCatCross(Integer.parseInt(val));
            return true;
        }
        if (op.equalsIgnoreCase("LabelCross")) {
            this.getCatserRange(true).setCatLabel(Integer.parseInt(val));
            return true;
        }
        if (op.equalsIgnoreCase("Marks")) {
            this.getCatserRange(true).setCatMark(Integer.parseInt(val));
            return true;
        }
        if (op.equalsIgnoreCase("CrossBetween")) {
            this.getCatserRange(true).setCrossBetween(val.equals("true"));
            return true;
        }
        if (op.equalsIgnoreCase("CrossMax")) {
            this.getCatserRange(true).setCrossMax(val.equals("true"));
            return true;
        }
        if (op.equalsIgnoreCase("MajorGridLines")) {
            if (val.equals("false")) {
                int j = this.getAxisLineFormat(1);
                if (j > -1) {
                    this.chartArr.remove(j);
                    this.chartArr.remove(j);
                }
            } else {
                this.getAxisLineFormat(1, true);
            }
        } else if (op.equalsIgnoreCase("MinorGridLines")) {
            if (val.equals("false")) {
                int j = this.getAxisLineFormat(2);
                if (j > -1) {
                    this.chartArr.remove(j);
                    this.chartArr.remove(j);
                }
            } else {
                this.getAxisLineFormat(2, true);
            }
        } else {
            if (op.equalsIgnoreCase("AddArea")) {
                if (this.wType == 0) {
                    AxisLineFormat alf0 = (AxisLineFormat)AxisLineFormat.getPrototype();
                    alf0.setId(0);
                    this.addChartRecord(alf0);
                    LineFormat lf0 = (LineFormat)LineFormat.getPrototype(0, 0);
                    this.addChartRecord(lf0);
                }
                AxisLineFormat alf = (AxisLineFormat)AxisLineFormat.getPrototype();
                alf.setId(3);
                this.addChartRecord(alf);
                LineFormat lf = (LineFormat)LineFormat.getPrototype(0, -1);
                if (this.wType == 1) {
                    lf.setLineStyle(5);
                }
                this.addChartRecord(lf);
                AreaFormat af = (AreaFormat)AreaFormat.getPrototype(this.wType);
                this.addChartRecord(af);
                return true;
            }
            if (op.equals("AreaFg")) {
                AreaFormat af = (AreaFormat)Chart.findRec(this.chartArr, AreaFormat.class);
                af.seticvFore(Integer.valueOf(val));
                return true;
            }
            if (op.equals("AreaBg")) {
                AreaFormat af = (AreaFormat)Chart.findRec(this.chartArr, AreaFormat.class);
                af.seticvBack(Integer.valueOf(val));
                return true;
            }
            if (this.linkedtd != null) {
                return this.linkedtd.setChartOption(op, val);
            }
            if (op.equalsIgnoreCase("MajorGridLines")) {
                if (val.equals("false")) {
                    int j = this.getAxisLineFormat(1);
                    if (j > -1) {
                        this.chartArr.remove(j);
                        this.chartArr.remove(j);
                    }
                } else {
                    this.getAxisLineFormat(1, true);
                }
            } else if (op.equalsIgnoreCase("MinorGridLines")) {
                if (val.equals("false")) {
                    int j = this.getAxisLineFormat(2);
                    if (j > -1) {
                        this.chartArr.remove(j);
                        this.chartArr.remove(j);
                    }
                } else {
                    this.getAxisLineFormat(2, true);
                }
            }
        }
        return false;
    }

    private void setOption(String op, String val) {
        if (op.equals("axPos")) {
            this.axPos = val;
        } else if (op.equals("lblOffset") || op.equals("lblAlgn")) {
            CatLab cl = (CatLab)Chart.findRec(this.chartArr, CatLab.class);
            if (cl == null) {
                cl = (CatLab)CatLab.getPrototype();
                cl.setParentChart(this.getParentChart());
                this.chartArr.add(1, cl);
            }
            cl.setOption(op, val);
        } else if (op.equals("tickLblPos") || op.equals("majorTickMark") || op.equals("minorTickMark")) {
            Tick t = (Tick)Chart.findRec(this.chartArr, Tick.class);
            t.setOption(op, val);
        } else if (op.equalsIgnoreCase("MajorGridLines")) {
            if (val.equals("false")) {
                int j = this.getAxisLineFormat(1);
                if (j > -1) {
                    this.chartArr.remove(j);
                    this.chartArr.remove(j);
                }
            } else {
                this.getAxisLineFormat(1, true);
            }
        } else if (op.equalsIgnoreCase("MinorGridLines")) {
            if (val.equals("false")) {
                int j = this.getAxisLineFormat(2);
                if (j > -1) {
                    this.chartArr.remove(j);
                    this.chartArr.remove(j);
                }
            } else {
                this.getAxisLineFormat(2, true);
            }
        } else {
            int i = 0;
            while (i < this.chartArr.size()) {
                BiffRec b = (BiffRec)this.chartArr.get(i);
                if (b instanceof CatserRange ? ((CatserRange)b).setOption(op, val) : b instanceof ValueRange && ((ValueRange)b).setOption(op, val)) break;
                ++i;
            }
        }
    }

    public String getOption(String op) {
        if (op.equals("axPos")) {
            return this.axPos;
        }
        if (op.equals("lblAlign") || op.equals("lblOffset")) {
            CatLab c = (CatLab)Chart.findRec(this.chartArr, CatLab.class);
            if (c != null) {
                return c.getOption(op);
            }
            return null;
        }
        if (op.equals("crossesAt") || op.equals("orientation") || op.equals("crosses") || op.equals("max") || op.equals("max") || op.equals("tickLblSkip") || op.equals("tickMarkSkip") || op.equals("crossBetween")) {
            int i = 0;
            while (i < this.chartArr.size()) {
                BiffRec b = (BiffRec)this.chartArr.get(i);
                if (b instanceof CatserRange) {
                    return ((CatserRange)b).getOption(op);
                }
                if (b instanceof ValueRange) {
                    return ((ValueRange)b).getOption(op);
                }
                ++i;
            }
        } else if (op.equals("tickLblPos") || op.equals("majorTickMark") || op.equals("minorTickMark")) {
            Tick t = (Tick)Chart.findRec(this.chartArr, Tick.class);
            return t.getOption(op);
        }
        return null;
    }

    public JSONObject getMinMaxJSON(WorkBookHandle wbh, int chartType, double yMax, double yMin, int nSeries) {
        JSONObject axisJSON = new JSONObject();
        JSONObject axisOptions = new JSONObject();
        try {
            int i = 0;
            while (i < this.chartArr.size()) {
                BiffRec b = (BiffRec)this.chartArr.get(i);
                if (b instanceof CatserRange) {
                    CatserRange c = (CatserRange)b;
                    String[] categories = this.getParentChart().getCategories(-1);
                    if (categories == null) break;
                    JSONArray cats = CellRange.getValuesAsJSON(categories[0], wbh);
                    axisOptions.put("max", cats.length() + c.getCatLabel());
                    break;
                }
                if (b instanceof ValueRange) {
                    ValueRange v = (ValueRange)b;
                    if (this.wType == 1) {
                        v.setMaxMin(yMax, yMin);
                    } else {
                        v.setMaxMin(nSeries, 0.0);
                    }
                    axisOptions.put("min", v.getMin());
                    axisOptions.put("max", v.getMax());
                    axisOptions.put("majorTickStep", v.getMajorTick());
                    break;
                }
                ++i;
            }
            if (this.wType == 1) {
                axisJSON.put("y", (Object)axisOptions);
            }
            if (this.wType == 0) {
                axisJSON.put("x", (Object)axisOptions);
            }
        }
        catch (JSONException e) {
            Logger.logErr("Error getting Axis JSON: " + (Object)((Object)e));
        }
        return axisJSON;
    }

    public SpPr getSpPr() {
        return this.shapeProps;
    }

    public void setSpPr(SpPr sp) {
        this.shapeProps = sp;
    }

    public Title getOOXMLTitle() {
        return this.ttl;
    }

    public void setOOXMLTitle(Title t) {
        this.ttl = t;
    }

    public TxPr gettxPr() {
        return this.txpr;
    }

    public void settxPr(TxPr t) {
        this.txpr = (TxPr)t.cloneElement();
    }

    @Override
    public String toString() {
        String s = "";
        switch (this.wType) {
            case 0: {
                s = "XAxis";
                break;
            }
            case 1: {
                s = "YAxis";
                break;
            }
            case 2: {
                s = "ZAxis";
                break;
            }
            case 3: {
                s = "XValAxis";
            }
        }
        if (this.linkedtd != null) {
            s = String.valueOf(s) + " " + this.linkedtd.toString();
        }
        return s;
    }

    public double getMaxScale(double[] minmax) {
        ValueRange v = (ValueRange)Chart.findRec(this.chartArr, ValueRange.class);
        if (v != null) {
            if (v.isAutomaticMax()) {
                v.setMaxMin(minmax[1], minmax[0]);
            }
            return v.getMax();
        }
        return -1.0;
    }

    protected double[] getMinMax() {
        ValueRange v = (ValueRange)Chart.findRec(this.chartArr, ValueRange.class);
        if (v != null) {
            return new double[]{v.getMin(), v.getMax()};
        }
        return new double[]{0.0, 0.0};
    }

    public double getMinScale(double[] minmax) {
        ValueRange v = (ValueRange)Chart.findRec(this.chartArr, ValueRange.class);
        if (v != null) {
            if (v.isAutomaticMin()) {
                v.setMaxMin(minmax[1], minmax[0]);
            }
            return v.getMin();
        }
        return -1.0;
    }

    public int getMajorUnit() {
        ValueRange v = (ValueRange)Chart.findRec(this.chartArr, ValueRange.class);
        if (v != null) {
            return new Double(v.getMajorTick()).intValue();
        }
        return 10;
    }

    public int getMinorUnit() {
        ValueRange v = (ValueRange)Chart.findRec(this.chartArr, ValueRange.class);
        if (v != null) {
            return new Double(v.getMinorTick()).intValue();
        }
        return 0;
    }

    public boolean isAutomaticScale() {
        ValueRange v = (ValueRange)Chart.findRec(this.chartArr, ValueRange.class);
        if (v != null) {
            return v.isAutomaticMin() || v.isAutomaticMax();
        }
        return false;
    }

    public void setAutomaticScale(boolean b) {
        ValueRange v = (ValueRange)Chart.findRec(this.chartArr, ValueRange.class);
        if (v != null) {
            v.setAutomaticMin(b);
            v.setAutomaticMax(b);
        }
    }

    public void setMinScale(int min) {
        ValueRange v = (ValueRange)Chart.findRec(this.chartArr, ValueRange.class);
        if (v != null) {
            v.setMin(min);
        }
    }

    public void setMaxScale(int max) {
        ValueRange v = (ValueRange)Chart.findRec(this.chartArr, ValueRange.class);
        if (v != null) {
            v.setMax(max);
        }
    }

    public void setAxisPlacement(int Placement) {
        Tick t = (Tick)Chart.findRec(this.chartArr, Tick.class);
        if (t != null) {
            switch (Placement) {
                case 0: {
                    t.setOption("tickLblPos", "none");
                    break;
                }
                case 1: {
                    t.setOption("tickLblPos", "low");
                    break;
                }
                case 2: {
                    t.setOption("tickLblPos", "high");
                    break;
                }
                case 3: {
                    t.setOption("tickLblPos", "nextTo");
                }
            }
        }
    }

    public int getAxisPlacement() {
        Tick t = (Tick)Chart.findRec(this.chartArr, Tick.class);
        if (t != null) {
            String p = t.getOption("tickLblPos");
            if (p == null || p.equals("none")) {
                return 0;
            }
            if (p.equals("low")) {
                return 1;
            }
            if (p.equals("high")) {
                return 2;
            }
            if (p.equals("nextTo")) {
                return 3;
            }
        }
        return 0;
    }

    public void parseOOXML(XmlPullParser xpp, String axisTag, Stack<String> lastTag, WorkBookHandle bk) {
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block10: {
                    String endTag;
                    block8: {
                        String tnm;
                        block21: {
                            block20: {
                                block19: {
                                    block18: {
                                        block17: {
                                            block16: {
                                                block15: {
                                                    block14: {
                                                        block13: {
                                                            block12: {
                                                                block11: {
                                                                    block9: {
                                                                        if (eventType != 2) break block8;
                                                                        tnm = xpp.getName();
                                                                        if (!tnm.equals("scaling")) break block9;
                                                                        lastTag.push(tnm);
                                                                        Scaling sc = (Scaling)Scaling.parseOOXML(xpp, lastTag);
                                                                        String s = sc.getOption("orientation");
                                                                        if (s != null) {
                                                                            this.setOption("orientation", s);
                                                                        }
                                                                        if ((s = sc.getOption("min")) != null) {
                                                                            this.setOption("min", s);
                                                                        }
                                                                        if ((s = sc.getOption("max")) != null) {
                                                                            this.setOption("max", s);
                                                                        }
                                                                        break block10;
                                                                    }
                                                                    if (!tnm.equals("axPos")) break block11;
                                                                    this.setOption(tnm, xpp.getAttributeValue(0));
                                                                    break block10;
                                                                }
                                                                if (!tnm.equals("majorGridlines") && !tnm.equals("minorGridlines")) break block12;
                                                                lastTag.push(tnm);
                                                                this.parseGridlinesOOXML(xpp, lastTag, bk);
                                                                break block10;
                                                            }
                                                            if (!tnm.equals("title")) break block13;
                                                            lastTag.push(tnm);
                                                            this.setOOXMLTitle((Title)Title.parseOOXML(xpp, lastTag, bk).cloneElement());
                                                            this.setTitle(this.getOOXMLTitle().getTitle());
                                                            break block10;
                                                        }
                                                        if (!tnm.equals("numFmt")) break block14;
                                                        this.nf = (NumFmt)NumFmt.parseOOXML(xpp).cloneElement();
                                                        break block10;
                                                    }
                                                    if (!tnm.equals("majorTickMark") && !tnm.equals("minorTickMark") && !tnm.equals("tickLblPos")) break block15;
                                                    this.setOption(tnm, xpp.getAttributeValue(0));
                                                    break block10;
                                                }
                                                if (!tnm.equals("spPr")) break block16;
                                                lastTag.push(tnm);
                                                this.setSpPr((SpPr)SpPr.parseOOXML(xpp, lastTag, bk).cloneElement());
                                                break block10;
                                            }
                                            if (!tnm.equals("txPr")) break block17;
                                            lastTag.push(tnm);
                                            this.settxPr((TxPr)TxPr.parseOOXML(xpp, lastTag, bk).cloneElement());
                                            break block10;
                                        }
                                        if (!tnm.equals("crosses") && !tnm.equals("crossesAt")) break block18;
                                        this.setOption(tnm, xpp.getAttributeValue(0));
                                        break block10;
                                    }
                                    if (!tnm.equals("crossBetween")) break block19;
                                    this.setOption(tnm, xpp.getAttributeValue(0));
                                    break block10;
                                }
                                if (!tnm.equals("lblAlign") && !tnm.equals("lblOffset") && !tnm.equals("tickLblSkip") && !tnm.equals("tickMarkSkip")) break block20;
                                this.setOption(tnm, xpp.getAttributeValue(0));
                                break block10;
                            }
                            if (!tnm.equals("crossBeteween") && !tnm.equals("majorUnit") && !tnm.equals("minorUnit")) break block21;
                            this.setOption(tnm, xpp.getAttributeValue(0));
                            break block10;
                        }
                        if (!tnm.equals("dispUnits")) break block10;
                        this.parseDispUnitsOOXML(xpp, lastTag);
                        break block10;
                    }
                    if (eventType == 3 && (endTag = xpp.getName()).equals(axisTag)) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("Axis: " + e.toString());
        }
    }

    private void parseGridlinesOOXML(XmlPullParser xpp, Stack<String> lastTag, WorkBookHandle bk) {
        String endTag = lastTag.peek();
        this.setOption(endTag, "true");
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("spPr")) {
                        lastTag.push(tnm);
                        SpPr sppr = (SpPr)SpPr.parseOOXML(xpp, lastTag, bk).cloneElement();
                        LineFormat lf = this.getAxisLine(endTag.equals("majorGridlines") ? 1 : 2);
                        lf.setFromOOXML(sppr);
                    }
                } else if (eventType == 3 && xpp.getName().equals(endTag)) {
                    lastTag.pop();
                    break;
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("parseGridLinesOOXML: " + e.toString());
        }
    }

    private void parseDispUnitsOOXML(XmlPullParser xpp, Stack<String> lastTag) {
        try {
            int eventType = xpp.getEventType();
            YMult ym = null;
            while (eventType != 1) {
                block7: {
                    block5: {
                        String tnm;
                        block6: {
                            if (eventType != 2) break block5;
                            tnm = xpp.getName();
                            if (!tnm.equals("custUnit")) break block6;
                            ym = this.getYMultRec(true);
                            ym.setCustomMultiplier(Double.valueOf(xpp.getAttributeValue(0)));
                            break block7;
                        }
                        if (!tnm.equals("builtInUnit")) break block7;
                        ym = this.getYMultRec(true);
                        ym.setAxMultiplierId(xpp.getAttributeValue(0));
                        break block7;
                    }
                    if (eventType == 3 && xpp.getName().equals("dispUnits")) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("parseDispUnitsOOXML: " + e.toString());
        }
    }

    public String getOOXML(int type, String id, String crossId) {
        if (this.getParentChart() == null) {
            this.setParentChart(this.ap.getParentChart());
        }
        boolean from2003 = !this.parentChart.getWorkBook().getIsExcel2007();
        StringBuffer axisooxml = new StringBuffer();
        String axis = "";
        switch (type) {
            case 0: {
                axis = "catAx";
                break;
            }
            case 1: {
                axis = "valAx";
                break;
            }
            case 2: {
                axis = "valAx";
                break;
            }
            case 3: {
                axis = "serAx";
                break;
            }
            case 4: {
                axis = "dateAx";
            }
        }
        axisooxml.append("<c:" + axis + ">");
        axisooxml.append("\r\n");
        axisooxml.append("<c:axId val=\"" + id + "\"/>");
        axisooxml.append("\r\n");
        String s = this.getOption("orientation");
        double[] d = this.getMinMax();
        if (s != null || d[0] != d[1]) {
            axisooxml.append("<c:scaling>\r\n");
            if (s != null) {
                axisooxml.append("<c:orientation val=\"" + s + "\"/>\r\n");
            }
            axisooxml.append("</c:scaling>\r\n");
        }
        if (this.getOption("axPos") != null) {
            axisooxml.append("<c:axPos val=\"" + this.getOption("axPos") + "\"/>");
            axisooxml.append("\r\n");
        } else {
            if (this.getParentChart().getChartType() != 1) {
                if (axis.equals("catAx") || axis.equals("serAx")) {
                    axisooxml.append("<c:axPos val=\"b\"/>");
                } else {
                    axisooxml.append("<c:axPos val=\"l\"/>");
                }
            } else if (axis.equals("catAx") || axis.equals("serAx")) {
                axisooxml.append("<c:axPos val=\"l\"/>");
            } else {
                axisooxml.append("<c:axPos val=\"b\"/>");
            }
            axisooxml.append("\r\n");
        }
        if (this.hasGridlines(1)) {
            axisooxml.append("<c:majorGridlines>");
            axisooxml.append(this.getAxisLine(1).getOOXML());
            axisooxml.append("</c:majorGridlines>\r\n");
        }
        if (this.hasGridlines(2)) {
            axisooxml.append("<c:minorGridlines>");
            axisooxml.append(this.getAxisLine(2).getOOXML());
            axisooxml.append("</c:minorGridlines>\r\n");
        }
        if (this.getOOXMLTitle() != null) {
            axisooxml.append(this.getOOXMLTitle().getOOXML());
        } else if (from2003 && !this.getTitle().equals("")) {
            Title ttl = new Title(this.getTitle());
            if (type == 0) {
                ttl.setLayout(0.026, 0.378);
            } else if (type == 1) {
                ttl.setLayout(0.468, 0.863);
            }
            axisooxml.append(ttl.getOOXML());
        }
        if (this.nf != null) {
            axisooxml.append(this.nf.getOOXML("c:"));
        }
        if ((s = this.getOption("majorTickMark")) != null) {
            axisooxml.append("<c:majorTickMark val=\"" + s + "\"/>");
        }
        if ((s = this.getOption("minorTickMark")) != null) {
            axisooxml.append("<c:minorTickMark val=\"" + s + "\"/>");
        }
        if ((s = this.getOption("tickLblPos")) != null) {
            axisooxml.append("<c:tickLblPos val=\"" + s + "\"/>");
        }
        if (this.getSpPr() != null) {
            axisooxml.append(this.getSpPr().getOOXML());
        }
        if (this.gettxPr() != null) {
            axisooxml.append(this.gettxPr().getOOXML());
        } else if (from2003) {
            int rot = 0;
            Tick t = (Tick)Chart.findRec(this.chartArr, Tick.class);
            if (t != null) {
                rot = t.getRotation();
                switch (rot) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        rot = -5400000;
                        break;
                    }
                    case 3: {
                        rot = 5400000;
                    }
                }
                TxPr txpr = new TxPr(this.getLabelFont(), rot, null);
                axisooxml.append(txpr.getOOXML());
            }
            axisooxml.append("\r\n");
        }
        axisooxml.append("<c:crossAx val=\"" + crossId + "\"/>");
        axisooxml.append("\r\n");
        if (this.getOption("crosses") != null) {
            axisooxml.append("<c:crosses val=\"" + this.getOption("crosses") + "\"/>");
        }
        axisooxml.append("\r\n");
        if (axis.equals("catAx") || axis.equals("serAx")) {
            axisooxml.append("<c:auto val=\"1\"/>\r\n");
            s = this.getOption("lblAlgn");
            if (s != null) {
                axisooxml.append("<c:lblAlgn val=\"" + s + "\"/>\r\n");
            }
            if ((s = this.getOption("lblOffset")) != null) {
                axisooxml.append("<c:lblOffset val=\"" + s + "\"/>\r\n");
            }
            if ((s = this.getOption("tickLblSkip")) != null) {
                axisooxml.append("<c:tickLblSkip val=\"" + s + "\"/>\r\n");
            }
            if ((s = this.getOption("tickMarkSkip")) != null) {
                axisooxml.append("<c:tickMarkSkip val=\"" + s + "\"/>\r\n");
            }
        } else {
            s = this.getOption("crossBetween");
            if (s != null) {
                axisooxml.append("<c:crossBetween val=\"" + s + "\"/>\r\n");
            }
            if ((s = this.getOption("majorUnit")) != null) {
                axisooxml.append("<c:majorUnit val=\"" + s + "\"/>\r\n");
            }
            if ((s = this.getOption("minorUnit")) != null) {
                axisooxml.append("<c:minorUnit val=\"" + s + "\"/>\r\n");
            }
        }
        axisooxml.append("</c:" + axis + ">");
        axisooxml.append("\r\n");
        return axisooxml.toString();
    }

    public String getSVG(ChartAxes ca, Map<String, Double> chartMetrics, Object[] categories) {
        StringBuffer svg = new StringBuffer();
        String labelfontSVG = "";
        String titlefontSVG = "";
        try {
            labelfontSVG = this.getLabelFont().getSVG();
        }
        catch (Exception e) {
            labelfontSVG = "font-family='Arial' font-size='9pt' fill='" + ChartType.getDarkColor() + "' ";
        }
        try {
            titlefontSVG = this.linkedtd.getFont(this.getParentChart().getWorkBook()).getSVG();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        boolean showMinorTickMarks = false;
        boolean showMajorTickMarks = true;
        try {
            Tick t = (Tick)Chart.findRec(this.chartArr, Tick.class);
            showMinorTickMarks = t.showMinorTicks();
            showMajorTickMarks = t.showMajorTicks();
        }
        catch (Exception t) {
            // empty catch block
        }
        int charttype = this.getParentChart().getChartType();
        if (charttype == 1) {
            return this.getSVGBARCHART(ca, titlefontSVG, labelfontSVG, showMinorTickMarks, showMajorTickMarks, chartMetrics, categories);
        }
        if (charttype == 6) {
            return this.getSVGRADARCHART(ca, titlefontSVG, labelfontSVG, chartMetrics, categories);
        }
        int wtype = this.wType;
        if (wtype == 0 && (charttype == 5 || charttype == 9)) {
            wtype = 3;
        }
        switch (wtype) {
            case 0: {
                svg.append(this.drawXAxisSVG(ca, titlefontSVG, labelfontSVG, showMinorTickMarks, showMajorTickMarks, chartMetrics, categories));
                break;
            }
            case 1: {
                svg.append(this.drawYAxisSVG(ca, titlefontSVG, labelfontSVG, showMinorTickMarks, showMajorTickMarks, chartMetrics));
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                svg.append(this.drawXYValAxisSVG(ca, titlefontSVG, labelfontSVG, showMinorTickMarks, showMajorTickMarks, chartMetrics, categories));
            }
        }
        return svg.toString();
    }

    private String drawXAxisSVG(ChartAxes ca, String titlefontSVG, String labelfontSVG, boolean showMinorTickMarks, boolean showMajorTickMarks, Map<String, Double> chartMetrics, Object[] categories) {
        double x0;
        double y0;
        int labelRot;
        StringBuffer svg = new StringBuffer();
        java.awt.Font f = null;
        double x = chartMetrics.get("x");
        double y = chartMetrics.get("y");
        double w = chartMetrics.get("w");
        double h = chartMetrics.get("h");
        double canvash = chartMetrics.get("canvash");
        boolean yAxisReversed = (Boolean)ca.getMetric("yAxisReversed");
        boolean xAxisReversed = (Boolean)ca.getMetric("xAxisReversed");
        int xAxisRotate = (Integer)ca.getMetric("xAxisRotate");
        double XAXISLABELOFFSET = (Double)ca.getMetric("XAXISLABELOFFSET");
        double XAXISTITLEOFFSET = (Double)ca.getMetric("XAXISTITLEOFFSET");
        int n = labelRot = this.wType == 0 ? xAxisRotate : 0;
        if (labelRot != 0) {
            Font lf = this.getLabelFont();
            try {
                f = new java.awt.Font(lf.getFontName(), lf.getFontWeight(), (int)lf.getFontHeightInPoints());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (categories != null && categories.length > 0) {
            double inc = w / (double)categories.length;
            svg.append(this.getCategoriesSVG(x, y, w, h, inc, labelRot, categories, f, labelfontSVG, yAxisReversed, xAxisReversed, XAXISLABELOFFSET));
            y0 = y + (!yAxisReversed ? h : 0.0);
            x0 = x;
            int rfY = !yAxisReversed ? 1 : -1;
            int rfX = !xAxisReversed ? 1 : -1;
            svg.append("<g>\r\n");
            inc = w / (double)categories.length;
            double minorinc = 0.0;
            if (showMinorTickMarks) {
                minorinc = inc / 2.0;
            }
            double i = 0.0;
            while (i <= (double)categories.length) {
                double y1 = y0 + (double)(2 * rfY);
                if (showMinorTickMarks) {
                    int j = 0;
                    while (j < 2) {
                        svg.append("<line fill='none' fill-opacity='" + ChartType.getFillOpacity() + "' " + ChartType.getStrokeSVG() + " x1='" + x0 + "' y1='" + y0 + "' x2='" + x0 + "' y2='" + y1 + "'/>\r\n");
                        x0 += minorinc;
                        ++j;
                    }
                }
                y1 = y0 + (double)(5 * rfY);
                if (showMajorTickMarks) {
                    svg.append("<line fill='none' fill-opacity='" + ChartType.getFillOpacity() + "'" + ChartType.getStrokeSVG() + " x1='" + x0 + "' y1='" + y0 + "' x2='" + x0 + "' y2='" + y1 + "'/>\r\n");
                }
                x0 += inc;
                i += 1.0;
            }
            if (this.hasPlotAreaBorder()) {
                x0 = x + (!xAxisReversed ? w : 0.0);
                svg.append("<line fill='none' fill-opacity='" + ChartType.getFillOpacity() + "'" + ChartType.getStrokeSVG() + " x1='" + x0 + "' y1='" + y + "' x2='" + x0 + "' y2='" + (y + h) + "'/>\r\n");
            }
            svg.append("</g>\r\n");
        }
        int titleRot = this.linkedtd != null ? this.linkedtd.getRotation() : 0;
        x0 = x + w / 2.0;
        y0 = !yAxisReversed ? canvash - XAXISTITLEOFFSET : y - XAXISTITLEOFFSET - XAXISLABELOFFSET;
        svg.append(this.getAxisTitleSVG(x0, y0, titlefontSVG, titleRot, "xaxistitle"));
        return svg.toString();
    }

    private String drawYAxisSVG(ChartAxes ca, String titlefontSVG, String labelfontSVG, boolean showMinorTickMarks, boolean showMajorTickMarks, Map<String, Double> chartMetrics) {
        StringBuffer svg = new StringBuffer();
        double x = chartMetrics.get("x");
        double y = chartMetrics.get("y");
        double w = chartMetrics.get("w");
        double h = chartMetrics.get("h");
        double max = chartMetrics.get("max");
        double min = chartMetrics.get("min");
        double minor = (Double)ca.getMetric("minor");
        double major = (Double)ca.getMetric("major");
        boolean scaleIsInteger = major == Math.floor(major);
        int titleRot = this.linkedtd != null ? this.linkedtd.getRotation() : 0;
        boolean xAxisReversed = (Boolean)ca.getMetric("xAxisReversed");
        boolean yAxisReversed = (Boolean)ca.getMetric("yAxisReversed");
        String xPattern = (String)ca.getMetric("xPattern");
        String yPattern = (String)ca.getMetric("yPattern");
        double YAXISLABELOFFSET = (Double)ca.getMetric("YAXISLABELOFFSET");
        double YAXISTITLEOFFSET = (Double)ca.getMetric("YAXISTITLEOFFSET");
        if (major > 0.0) {
            double inc = h / ((max - min) / major);
            double minorinc = 0.0;
            if (minor > 0.0) {
                minorinc = inc / (major / minor);
            }
            double x0 = x;
            double y0 = y + h;
            double x1 = x + w;
            String lineSVG = this.getLineSVG(1);
            svg.append("<g>\r\n");
            double i = min;
            while (i <= max) {
                svg.append("<line fill='none' fill-opacity='" + ChartType.getFillOpacity() + "'" + lineSVG + " x1='" + x0 + "' y1='" + y0 + "' x2='" + x1 + "' y2='" + y0 + "'/>\r\n");
                y0 -= inc;
                i += major;
            }
            svg.append("</g>\r\n");
            svg.append("<g>\r\n");
            int rfY = !yAxisReversed ? 1 : -1;
            int rfX = !xAxisReversed ? 1 : -1;
            y0 = y + (!yAxisReversed ? h : 0.0);
            lineSVG = ChartType.getStrokeSVG();
            int scale = 0;
            String s = String.valueOf(major);
            int z = s.indexOf(".");
            if (z != -1) {
                scale = s.length() - (z + 1);
            }
            int k = 0;
            double i2 = min;
            while (i2 <= max) {
                x0 = x + (!xAxisReversed ? 0.0 : w);
                x1 = x0 - (double)(2 * rfX);
                double y1 = y0;
                if (i2 < max && minor > 0.0 && showMinorTickMarks) {
                    int j = 0;
                    while ((double)j < major / minor) {
                        svg.append("<line fill='none' fill-opacity='" + ChartType.getFillOpacity() + "' " + lineSVG + " x1='" + x0 + "' y1='" + y0 + "' x2='" + x1 + "' y2='" + y0 + "'/>\r\n");
                        y0 -= minorinc;
                        ++j;
                    }
                }
                y0 = y1;
                x1 = x0 - (double)(5 * rfX);
                if (showMajorTickMarks) {
                    svg.append("<line fill='none' fill-opacity='" + ChartType.getFillOpacity() + "' " + lineSVG + " x1='" + x0 + "' y1='" + y0 + "' x2='" + x1 + "' y2='" + y0 + "'/>\r\n");
                }
                BigDecimal bd = new BigDecimal(i2).setScale(scale, 4);
                if (!xAxisReversed) {
                    svg.append("<text id='yaxislabels" + k++ + "' x='" + (x0 - (double)YLABELSSPACER_X) + "' y='" + (y1 + (double)YLABELSPACER_Y) + "' style='text-anchor: end;' direction='rtl' alignment-baseline='text-after-edge' " + labelfontSVG + ">" + CellFormatFactory.fromPatternString(yPattern).format(bd) + "</text>\r\n");
                } else {
                    svg.append("<text id='yaxislabels" + k++ + "' x='" + (x0 + (double)YLABELSSPACER_X) + "' y='" + (y1 + (double)YLABELSPACER_Y) + "' style='text-anchor: start;' alignment-baseline='text-after-edge' " + labelfontSVG + ">" + CellFormatFactory.fromPatternString(yPattern).format(bd) + "</text>\r\n");
                }
                y0 -= inc * (double)rfY;
                i2 += major;
            }
            svg.append("</g>\r\n");
            x0 = x + (!xAxisReversed ? 0.0 : w);
            y0 = y;
            svg.append("<line fill='none' fill-opacity='" + ChartType.getFillOpacity() + "' " + ChartType.getStrokeSVG() + " x1='" + x0 + "' y1='" + y0 + "' x2='" + x0 + "' y2='" + (y0 + h) + "'/>\r\n");
            x0 = !xAxisReversed ? 10.0 : x + w + YAXISTITLEOFFSET;
            svg.append(this.getAxisTitleSVG(x0, y + h / 2.0, titlefontSVG, titleRot, "yaxistitle"));
        }
        return svg.toString();
    }

    private String drawXYValAxisSVG(ChartAxes ca, String titlefontSVG, String labelfontSVG, boolean showMinorTickMarks, boolean showMajorTickMarks, Map<String, Double> chartMetrics, Object[] categories) {
        StringBuffer svg = new StringBuffer();
        double minorinc = 0.0;
        double x = chartMetrics.get("x");
        double y = chartMetrics.get("y");
        double w = chartMetrics.get("w");
        double h = chartMetrics.get("h");
        double max = chartMetrics.get("max");
        double min = chartMetrics.get("min");
        double minor = (Double)ca.getMetric("minor");
        double major = (Double)ca.getMetric("major");
        boolean scaleIsInteger = major == Math.floor(major);
        String yPattern = (String)ca.getMetric("yPattern");
        double XAXISLABELOFFSET = (Double)ca.getMetric("XAXISLABELOFFSET");
        double XAXISTITLEOFFSET = (Double)ca.getMetric("XAXISTITLEOFFSET");
        if (categories != null && categories.length > 0) {
            double xmin = Double.MAX_VALUE;
            double xmax = Double.MIN_VALUE;
            boolean TEXTUALXAXIS = true;
            int j = 0;
            while (j < categories.length) {
                try {
                    double d = new Double(categories[j].toString());
                    xmax = Math.max(xmax, d);
                    xmin = Math.min(xmin, d);
                    TEXTUALXAXIS = false;
                }
                catch (Exception d) {
                    // empty catch block
                }
                ++j;
            }
            if (!TEXTUALXAXIS) {
                double[] d = ValueRange.calcMaxMin(xmax, xmin, w);
                minor = (int)d[0];
                major = (int)d[1];
                xmax = d[2];
            } else {
                major = 1.0;
                minor = 0.0;
                xmax = categories.length + 1;
                XAXISLABELOFFSET = 30.0;
            }
            double y0 = y + h + XAXISLABELOFFSET;
            double inc = w / (xmax / major);
            double x0 = x;
            int scale = 0;
            String s = String.valueOf(major);
            int z = s.indexOf(".");
            if (z != -1) {
                scale = s.length() - (z + 1);
            }
            int k = 0;
            double i = 0.0;
            while (i <= xmax) {
                if (!TEXTUALXAXIS) {
                    BigDecimal bd = new BigDecimal(i).setScale(scale, 4);
                    svg.append("<text id='xaxislabels" + k++ + "' x='" + x0 + "' y='" + y0 + "' style='text-anchor: middle;' " + labelfontSVG + ">" + CellFormatFactory.fromPatternString(yPattern).format(bd) + "</text>\r\n");
                } else {
                    svg.append("<text id='xaxislabels" + k++ + "' x='" + x0 + "' y='" + y0 + "' style='text-anchor: middle;' " + labelfontSVG + ">" + CellFormatFactory.fromPatternString(yPattern).format(i) + "</text>\r\n");
                }
                x0 += inc;
                i += major;
            }
            y0 = h + y;
            x0 = x;
            svg.append("<g>\r\n");
            if (minor > 0.0) {
                minorinc = inc / minor;
            }
            int i2 = 0;
            while ((double)i2 <= xmax) {
                double y1 = y0 + 2.0;
                int j2 = 0;
                while ((double)j2 < minor) {
                    svg.append("<line fill='none' fill-opacity='" + ChartType.getFillOpacity() + "' " + ChartType.getStrokeSVG() + " x1='" + x0 + "' y1='" + y0 + "' x2='" + x0 + "' y2='" + y1 + "'/>\r\n");
                    x0 += minorinc;
                    ++j2;
                }
                y1 = y0 + 5.0;
                svg.append("<line fill='none' fill-opacity='" + ChartType.getFillOpacity() + "' " + ChartType.getStrokeSVG() + " x1='" + x0 + "' y1='" + y0 + "' x2='" + x0 + "' y2='" + y1 + "'/>\r\n");
                if (minorinc == 0.0) {
                    x0 += inc;
                }
                i2 = (int)((double)i2 + major);
            }
            svg.append("</g>\r\n");
        }
        int titleRot = this.linkedtd != null ? this.linkedtd.getRotation() : 0;
        svg.append(this.getAxisTitleSVG(x + w / 2.0, y + h + XAXISTITLEOFFSET, titlefontSVG, titleRot, "zaxistitle"));
        return svg.toString();
    }

    private String getSVGBARCHART(ChartAxes ca, String titlefontSVG, String labelFontSVG, boolean showMinorTicks, boolean showMajorTicks, Map<String, Double> chartMetrics, Object[] categories) {
        StringBuffer svg = new StringBuffer();
        int rfX = 1;
        int rfY = 1;
        boolean scaleIsInteger = true;
        double x = chartMetrics.get("x");
        double y = chartMetrics.get("y");
        double w = chartMetrics.get("w");
        double h = chartMetrics.get("h");
        double canvasw = chartMetrics.get("canvasw");
        double canvash = chartMetrics.get("canvash");
        double max = chartMetrics.get("max");
        double min = chartMetrics.get("min");
        boolean xAxisReversed = (Boolean)ca.getMetric("xAxisReversed");
        boolean yAxisReversed = (Boolean)ca.getMetric("yAxisReversed");
        double YAXISTITLEOFFSET = (Double)ca.getMetric("YAXISTITLEOFFSET");
        String yPattern = (String)ca.getMetric("yPattern");
        double XAXISLABELOFFSET = (Double)ca.getMetric("XAXISLABELOFFSET");
        double XAXISTITLEOFFSET = (Double)ca.getMetric("XAXISTITLEOFFSET");
        double major = (Double)ca.getMetric("major");
        if (this.wType == 0) {
            scaleIsInteger = major == Math.floor(major);
        }
        switch (this.wType) {
            case 0: {
                double x0 = x;
                double y0 = y + (!xAxisReversed ? h : 0.0);
                rfX = !xAxisReversed ? 1 : -1;
                int n = rfY = !yAxisReversed ? 1 : -1;
                if (major > 0.0) {
                    svg.append("<g>\r\n");
                    double inc = w / ((max - min) / major);
                    int scale = 0;
                    String s = String.valueOf(major);
                    int z = s.indexOf(".");
                    if (z != -1) {
                        scale = s.length() - (z + 1);
                    }
                    int k = 0;
                    double i = min;
                    while (i <= max) {
                        double y1 = y0 + (double)(5 * rfX);
                        if (showMajorTicks) {
                            svg.append("<line fill='none' fill-opacity='" + ChartType.getFillOpacity() + "'" + ChartType.getStrokeSVG() + " x1='" + x0 + "' y1='" + y0 + "' x2='" + x0 + "' y2='" + y1 + "'/>\r\n");
                        }
                        BigDecimal bd = new BigDecimal(i).setScale(scale, 4);
                        if (!xAxisReversed) {
                            svg.append("<text id='xaxislabels" + k++ + "' x='" + (x0 + (!yAxisReversed ? 0.0 : w)) + "' y='" + (y0 + XAXISLABELOFFSET) + "' style='text-anchor: end;' alignment-baseline='middle' " + labelFontSVG + ">" + CellFormatFactory.fromPatternString(yPattern).format(bd) + "</text>\r\n");
                        } else {
                            svg.append("<text id='xaxislabels" + k++ + "' x='" + x0 + "' y='" + (y0 - 4.0) + "' style='text-anchor: end;' " + labelFontSVG + ">" + CellFormatFactory.fromPatternString(yPattern).format(bd) + "</text>\r\n");
                        }
                        x0 += inc * (double)rfY;
                        i += major;
                    }
                    svg.append("</g>\r\n");
                }
                y0 = y + (!xAxisReversed ? h : 0.0);
                x0 = x;
                svg.append("<line fill='none' fill-opacity='" + ChartType.getFillOpacity() + "' " + ChartType.getStrokeSVG() + " x1='" + x0 + "' y1='" + y0 + "' x2='" + (x0 + w) + "' y2='" + y0 + "'/>\r\n");
                x0 = !yAxisReversed ? YAXISTITLEOFFSET : x + w + YAXISTITLEOFFSET;
                svg.append(this.getAxisTitleSVG(x0, y + h / 2.0, titlefontSVG, 90, "xaxistitle"));
                break;
            }
            case 1: {
                rfX = !xAxisReversed ? 1 : -1;
                int n = rfY = !yAxisReversed ? 1 : -1;
                if (categories == null || categories.length <= 0) break;
                double inc = h / (double)categories.length;
                double x0 = x;
                double y0 = y + (!xAxisReversed ? h : 0.0);
                int k = 0;
                int i = 0;
                while (i < categories.length) {
                    double x1 = x0 - (double)(5 * rfY);
                    if (showMajorTicks) {
                        svg.append("<line fill='none' fill-opacity='" + ChartType.getFillOpacity() + "' " + ChartType.getStrokeSVG() + " x1='" + x0 + "' y1='" + y0 + "' x2='" + x1 + "' y2='" + y0 + "'/>\r\n");
                    }
                    double y1 = y0 - inc * (double)rfX + inc * 0.5 * (double)rfX;
                    if (!yAxisReversed) {
                        svg.append("<text id='yaxislabels" + k++ + "' x='" + (x0 - 8.0) + "' y='" + y1 + "' style='text-anchor: end;' direction='rtl' dominant-baseline='text-before-edge' " + labelFontSVG + ">" + categories[i].toString() + "</text>\r\n");
                    } else {
                        svg.append("<text id='yaxislabels" + k++ + "' x='" + (x0 + w + 8.0) + "' y='" + (y1 + 4.0) + "' style='text-anchor: start;' alignment-baseline='text-after-edge' " + labelFontSVG + ">" + categories[i].toString() + "</text>\r\n");
                    }
                    y0 -= inc * (double)rfX;
                    ++i;
                }
                String lineSVG = this.getLineSVG(1);
                if (!lineSVG.equals("")) {
                    y0 = y;
                    x0 = x;
                    inc = w / ((max - min) / major);
                    svg.append("<line fill='none' fill-opacity='" + ChartType.getFillOpacity() + "' " + this.getLineSVG(0) + " x1='" + x0 + "' y1='" + y0 + "' x2='" + x0 + "' y2='" + (y0 + h) + "'/>\r\n");
                    double i2 = min;
                    while (i2 < max) {
                        svg.append("<line fill='none' fill-opacity='" + ChartType.getFillOpacity() + "' " + lineSVG + " x1='" + (x0 += inc) + "' y1='" + y0 + "' x2='" + x0 + "' y2='" + (y0 + h) + "'/>\r\n");
                        i2 += major;
                    }
                }
                y0 = !xAxisReversed ? canvash - XAXISTITLEOFFSET : y - XAXISTITLEOFFSET;
                int titleRot = this.linkedtd != null ? this.linkedtd.getRotation() : 0;
                svg.append(this.getAxisTitleSVG(x + w / 2.0, y0, titlefontSVG, titleRot, "yaxistitle"));
            }
        }
        return svg.toString();
    }

    private String getSVGRADARCHART(ChartAxes ca, String titleFontSVG, String labelFontSVG, Map<String, Double> chartMetrics, Object[] categories) {
        double x = chartMetrics.get("x");
        double y = chartMetrics.get("y");
        double w = chartMetrics.get("w");
        double h = chartMetrics.get("h");
        double max = chartMetrics.get("max");
        double min = chartMetrics.get("min");
        double major = (Double)ca.getMetric("major");
        StringBuffer svg = new StringBuffer();
        if (this.wType == 1) {
            svg.append("<g>\r\n");
            if (categories != null && categories.length > 0) {
                major *= 2.0;
                double n = categories.length;
                double centerx = w / 2.0 + x;
                double centery = h / 2.0 + y;
                double percentage = 1.0 / n;
                double radius = Math.min(w, h) / 2.3;
                double radiusinc = radius / (max / major);
                double lastx = centerx;
                double lasty = centery - radius;
                int k = 0;
                double j = min;
                while (j <= max) {
                    double angle = 90.0;
                    int i = 0;
                    while ((double)i <= n) {
                        double x1 = centerx + radius * Math.cos(Math.toRadians(angle));
                        double y1 = centery - radius * Math.sin(Math.toRadians(angle));
                        svg.append("<line fill='none' fill-opacity='" + ChartType.getFillOpacity() + "'" + ChartType.getStrokeSVG() + " x1='" + lastx + "' y1='" + lasty + "' x2='" + x1 + "' y2='" + y1 + "'/>\r\n");
                        if (j == 0.0 && (double)i < n) {
                            svg.append("<line fill='none' fill-opacity='" + ChartType.getFillOpacity() + "' " + ChartType.getStrokeSVG() + " x1='" + centerx + "' y1='" + centery + "' x2='" + x1 + "' y2='" + y1 + "'/>\r\n");
                            double labelx1 = centerx + (radius + 10.0) * Math.cos(Math.toRadians(angle));
                            double labely1 = centery - (radius + 10.0) * Math.sin(Math.toRadians(angle));
                            svg.append("<text id='xaxislabels" + k++ + "' x='" + labelx1 + "' y='" + labely1 + "' style='text-anchor: middle;' " + labelFontSVG + ">" + categories[i].toString() + "</text>\r\n");
                        }
                        angle -= percentage * 360.0;
                        lastx = x1;
                        lasty = y1;
                        ++i;
                    }
                    radius -= radiusinc;
                    j += major;
                }
            }
            svg.append("</g>\r\n");
        }
        return svg.toString();
    }

    private String getCategoriesSVG(double x, double y, double w, double h, double inc, int labelRot, Object[] categories, java.awt.Font f, String labelfontSVG, boolean yAxisReversed, boolean xAxisReversed, double XAXISLABELOFFSET) {
        StringBuffer svg = new StringBuffer();
        int k = labelfontSVG.indexOf("font-size=") + 11;
        double fh = Double.parseDouble(labelfontSVG.substring(k, labelfontSVG.indexOf("pt")));
        double y0 = y + (!yAxisReversed ? h + XAXISLABELOFFSET / 3.0 : -XAXISLABELOFFSET);
        int m = 0;
        int i = 0;
        while (i < categories.length) {
            double x0 = !xAxisReversed ? x + inc * (double)i + inc / 2.0 : x + w - inc * (double)i - inc / 2.0;
            if (labelRot != 0) {
                double len = StringTool.getApproximateStringWidthLB(f, CellFormatFactory.fromPatternString(null).format(categories[i]));
                if (labelRot == 45) {
                    len = (int)Math.ceil(len * Math.cos(Math.toRadians(labelRot)));
                }
                int offset = (int)(len / 2.0) + 5;
                y0 = y + (!yAxisReversed ? h + (double)offset : (double)(-offset));
                if (labelRot == 45) {
                    x0 += inc / 2.0;
                }
            }
            String[] s = categories[i].toString().split("\n");
            svg.append("<text id='xaxislabels" + m++ + "' x='" + x0 + "' y='" + y0 + (labelRot == 0 ? "" : "' transform='rotate(" + labelRot + ", " + x0 + " , " + y0 + ")") + "' style='text-anchor: middle;' alignment-baseline='text-after-edge' " + labelfontSVG + ">");
            int z = 0;
            while (z < s.length) {
                svg.append("<tspan x='" + x0 + "' dy='" + fh * 1.4 + "'>" + s[z] + "</tspan>\r\n");
                ++z;
            }
            svg.append("</text>\r\n");
            ++i;
        }
        return svg.toString();
    }

    private String getAxisTitleSVG(double x, double y, String titlefontSVG, int titleRot, String scriptTitle) {
        StringBuffer svg = new StringBuffer();
        svg.append("<g>\r\n");
        svg.append("<text " + Axis.getScript(scriptTitle) + " x='" + x + "' y='" + y + (titleRot == 0 ? "" : "' transform='rotate(-" + titleRot + ", " + x + " ," + y + ")") + "' style='text-anchor: middle;' " + titlefontSVG + ">" + this.getTitle() + "</text>\r\n");
        svg.append("</g>\r\n");
        return svg.toString();
    }
}

