/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.charts.ChartFormat;
import com.extentech.formats.XLS.charts.ChartSeries;
import com.extentech.formats.XLS.charts.ChartType;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.formats.XLS.charts.Scatter;
import com.extentech.formats.XLS.charts.ValueRange;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;
import java.util.HashMap;

public class BubbleChart
extends ChartType {
    private Scatter bubble = null;
    private boolean is3d = false;

    public BubbleChart(GenericChartObject charttype, ChartFormat cf, WorkBook wb) {
        super(charttype, cf, wb);
        this.bubble = (Scatter)charttype;
    }

    public void setIs3d(boolean is3d) {
        this.is3d = is3d;
    }

    public boolean is3d() {
        return this.is3d;
    }

    @Override
    public String getSVG(HashMap<String, Double> chartMetrics, HashMap<String, Object> axisMetrics, ChartSeries s) {
        double x = chartMetrics.get("x");
        double y = chartMetrics.get("y");
        double w = chartMetrics.get("w");
        double h = chartMetrics.get("h");
        double max = chartMetrics.get("max");
        double min = chartMetrics.get("min");
        Object[] categories = s.getCategories();
        ArrayList series = s.getSeriesValues();
        String[] seriescolors = s.getSeriesBarColors();
        String[] legends = s.getLegends();
        StringBuffer svg = new StringBuffer();
        if (series.size() == 0) {
            Logger.logErr("Scatter.getSVG: error in series");
            return "";
        }
        boolean threeD = this.cf.isThreeD(9);
        int[] dls = this.getDataLabelInts();
        boolean hasLines = this.cf.getHasLines();
        int[] markers = this.getMarkerFormats();
        int n = series.size();
        double[] seriesx = null;
        double xfactor = 0.0;
        double yfactor = 0.0;
        double bfactor = 0.0;
        boolean TEXTUALXAXIS = true;
        seriesx = new double[categories.length];
        double xmin = Double.MAX_VALUE;
        double xmax = Double.MIN_VALUE;
        int j = 0;
        while (j < categories.length) {
            try {
                seriesx[j] = new Double(categories[j].toString());
                xmax = Math.max(xmax, seriesx[j]);
                xmin = Math.min(xmin, seriesx[j]);
                TEXTUALXAXIS = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++j;
        }
        if (!TEXTUALXAXIS) {
            double[] d = ValueRange.calcMaxMin(xmax, xmin, w);
            xfactor = w / d[2];
        } else {
            xfactor = w / (double)(categories.length + 1);
        }
        if (max - min != 0.0) {
            yfactor = h / Math.abs(max - min);
        }
        int i = 0;
        while (i < n) {
            double[] seriesy = (double[])series.get(i);
            String[] curranges = (String[])s.getSeriesRanges().get(i);
            int nseries = seriesy.length / 2;
            double bmin = Double.MAX_VALUE;
            double bmax = Double.MIN_VALUE;
            int j2 = nseries;
            while (j2 < seriesy.length) {
                bmax = Math.max(bmax, seriesy[j2]);
                bmin = Math.min(bmin, seriesy[j2]);
                ++j2;
            }
            if (bmax - bmin != 0.0) {
                bfactor = h / Math.abs(bmax - bmin) / 5.0;
            }
            ++i;
        }
        svg.append("<g>\r\n");
        if (threeD) {
            svg.append(this.get3DBubbleSVG(seriescolors));
        }
        i = 0;
        while (i < n) {
            String labels = "";
            double[] seriesy = (double[])series.get(i);
            String[] curranges = (String[])s.getSeriesRanges().get(i);
            int nseries = seriesy.length / 2;
            int j3 = 0;
            while (j3 < nseries) {
                double xval = 0.0;
                xval = TEXTUALXAXIS ? (double)(j3 + 1) : seriesx[j3];
                double cx = x + xval * xfactor;
                double cy = y + h - seriesy[j3] * yfactor;
                double r2 = seriesy[j3 + nseries] * bfactor;
                if (!threeD) {
                    svg.append("<circle " + BubbleChart.getScript(curranges[j3]) + " cx='" + cx + "' cy='" + cy + "' r='" + r2 + "' " + BubbleChart.getStrokeSVG() + " fill='" + seriescolors[i] + "'/>\r\n");
                } else {
                    svg.append("<circle " + BubbleChart.getScript(curranges[j3]) + "   id='series_" + (i + 1) + "' cx='" + cx + "' cy='" + cy + "' r='" + r2 + "' " + BubbleChart.getStrokeSVG() + " style='fill:url(#fill" + i + ")'/>\r\n");
                }
                String l = this.getSVGDataLabels(dls, axisMetrics, seriesy[j3 + nseries], 0.0, i, legends, categories[j3].toString());
                if (l != null) {
                    labels = String.valueOf(labels) + "<text x='" + (r2 + 10.0 + x + xval * xfactor) + "' y='" + (y + h - seriesy[j3] * yfactor) + "' " + BubbleChart.getDataLabelFontSVG() + ">" + l + "</text>\r\n";
                }
                ++j3;
            }
            svg.append(labels);
            ++i;
        }
        svg.append("</g>\r\n");
        return svg.toString();
    }

    private String get3DBubbleSVG(String[] seriescolors) {
        StringBuffer svg = new StringBuffer();
        svg.append("<defs>\r\n");
        int i = 0;
        while (i < seriescolors.length) {
            svg.append("<radialGradient id='fill" + i + "' " + "gradientUnits=\"objectBoundingBox\" fx=\"40%\" fy=\"30%\">");
            svg.append("<stop offset='0%' style='stop-color:#FFFFFF' />");
            svg.append("<stop offset='40%' style='stop-color:" + seriescolors[i] + "' stop-opacity='.65' />");
            svg.append("<stop offset='95%' style='stop-color:" + seriescolors[i] + "' stop-opacity='1' />");
            svg.append("<stop offset='99%' style='stop-color:" + seriescolors[i] + "' stop-opacity='.3' />");
            svg.append("<stop offset='100%' style='stop-color:" + seriescolors[i] + "'/>");
            svg.append("</radialGradient>\r\n");
            ++i;
        }
        svg.append("</defs>\r\n");
        return svg.toString();
    }

    @Override
    public StringBuffer getOOXML(String catAxisId, String valAxisId, String serAxisId) {
        StringBuffer cooxml = new StringBuffer();
        cooxml.append("<c:bubbleChart>");
        cooxml.append("\r\n");
        cooxml.append(this.getParentChart().getChartSeries().getOOXML(this.getChartType(), false, 0));
        if (this.is3d) {
            cooxml.append("bubble3d val=\"1\"");
        }
        cooxml.append("<c:bubbleScale val=\"100\"/>");
        cooxml.append("<c:axId val=\"" + catAxisId + "\"/>");
        cooxml.append("\r\n");
        cooxml.append("<c:axId val=\"" + valAxisId + "\"/>");
        cooxml.append("\r\n");
        cooxml.append("</c:bubbleChart>");
        cooxml.append("\r\n");
        return cooxml;
    }
}

