/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.toolkit.ByteTools;

public class CatLab
extends GenericChartObject
implements ChartObject {
    short wOffset;
    short at;
    private static final long serialVersionUID = 3042712098138741496L;
    private byte[] PROTOTYPE_BYTES;

    public CatLab() {
        byte[] byArray = new byte[12];
        byArray[0] = 86;
        byArray[1] = 8;
        byArray[4] = 100;
        byArray[6] = 2;
        byArray[8] = 86;
        byArray[9] = 66;
        this.PROTOTYPE_BYTES = byArray;
    }

    @Override
    public void init() {
        super.init();
        this.wOffset = ByteTools.readShort(this.getData()[4], this.getData()[5]);
        this.at = ByteTools.readShort(this.getData()[6], this.getData()[7]);
    }

    public static XLSRecord getPrototype() {
        CatLab cl = new CatLab();
        cl.setOpcode((short)2134);
        cl.setData(cl.PROTOTYPE_BYTES);
        cl.init();
        return cl;
    }

    public void setOption(String op, String val) {
        if (op.equals("lblAlign")) {
            this.at = val.equals("ctr") ? (short)2 : (val.equals("l") ? (short)1 : (short)3);
        } else if (op.equals("lblOffset")) {
            this.wOffset = (short)Integer.parseInt(val);
        }
        this.updateRecord();
    }

    public String getOption(String op) {
        if (op.equals("lblAlign")) {
            if (this.at == 2) {
                return "ctr";
            }
            if (this.at == 1) {
                return "l";
            }
            return "r";
        }
        if (op.equals("lblOffset")) {
            return Integer.toString(this.wOffset);
        }
        return null;
    }

    private void updateRecord() {
        byte[] b = new byte[2];
        b = ByteTools.shortToLEBytes(this.wOffset);
        this.getData()[4] = b[0];
        this.getData()[5] = b[1];
        b = ByteTools.shortToLEBytes(this.at);
        this.getData()[6] = b[0];
        this.getData()[7] = b[1];
    }
}

