/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.toolkit.ByteTools;

public class CatserRange
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = 905038625844435651L;
    private short grbit;
    private short catCross;
    private short catLabel;
    private short catMark;
    private boolean fBetween;
    private boolean fMaxCross;
    private boolean fReverse;
    private byte[] PROTOTYPE_BYTES;

    public CatserRange() {
        byte[] byArray = new byte[8];
        byArray[0] = 1;
        byArray[2] = 1;
        byArray[4] = 1;
        byArray[6] = 1;
        this.PROTOTYPE_BYTES = byArray;
    }

    public static XLSRecord getPrototype() {
        CatserRange c = new CatserRange();
        c.setOpcode((short)4128);
        c.setData(c.PROTOTYPE_BYTES);
        c.init();
        return c;
    }

    public void setOpt(int op) {
        byte[] b = ByteTools.shortToLEBytes((short)op);
        this.getData()[0] = b[0];
        this.getData()[1] = b[1];
        this.getData()[6] = 0;
    }

    @Override
    public void init() {
        super.init();
        this.catCross = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        this.catLabel = ByteTools.readShort(this.getByteAt(2), this.getByteAt(3));
        this.catMark = ByteTools.readShort(this.getByteAt(4), this.getByteAt(5));
        this.grbit = ByteTools.readShort(this.getByteAt(6), this.getByteAt(7));
        this.fBetween = (this.grbit & 1) == 1;
        this.fMaxCross = (this.grbit & 2) == 2;
        this.fReverse = (this.grbit & 4) == 4;
    }

    private void updateRecord() {
        byte[] b = ByteTools.shortToLEBytes(this.catCross);
        this.getData()[0] = b[0];
        this.getData()[1] = b[1];
        b = ByteTools.shortToLEBytes(this.catLabel);
        this.getData()[2] = b[0];
        this.getData()[3] = b[1];
        b = ByteTools.shortToLEBytes(this.catMark);
        this.getData()[4] = b[0];
        this.getData()[5] = b[1];
        b = ByteTools.shortToLEBytes(this.grbit);
        this.getData()[6] = b[0];
        this.getData()[7] = b[1];
    }

    public int getCatCross() {
        return this.catCross;
    }

    public int getCatLabel() {
        return this.catLabel;
    }

    public int getCatMark() {
        return this.catMark;
    }

    public boolean getCrossBetween() {
        return this.fBetween;
    }

    public boolean getCrossMax() {
        return this.fMaxCross;
    }

    public void setCatCross(int c) {
        this.catCross = (short)c;
        this.updateRecord();
    }

    public void setCatLabel(int c) {
        this.catLabel = (short)c;
        this.updateRecord();
    }

    public void setCatMark(int c) {
        this.catMark = (short)c;
        this.updateRecord();
    }

    public void setCrossBetween(boolean b) {
        this.fBetween = b;
        this.grbit = ByteTools.updateGrBit(this.grbit, this.fBetween, 0);
        this.updateRecord();
    }

    public void setCrossMax(boolean b) {
        this.fMaxCross = b;
        this.grbit = ByteTools.updateGrBit(this.grbit, this.fMaxCross, 1);
        this.updateRecord();
    }

    public boolean setOption(String op, String val) {
        if (op.equals("crossesAt")) {
            this.catCross = Short.valueOf(val);
        } else if (op.equals("orientation")) {
            this.fReverse = val.equals("maxMin");
            ByteTools.updateGrBit(this.grbit, this.fReverse, 2);
        } else if (op.equals("crosses")) {
            if (val.equals("max")) {
                this.fMaxCross = true;
                ByteTools.updateGrBit(this.grbit, this.fMaxCross, 7);
            } else if (val.equals("mid")) {
                this.fBetween = false;
                ByteTools.updateGrBit(this.grbit, this.fBetween, 0);
            } else if (val.equals("autoZero")) {
                this.fBetween = true;
                ByteTools.updateGrBit(this.grbit, this.fBetween, 0);
            } else if (val.equals("min")) {
                // empty if block
            }
        } else if (op.equals("tickMarkSkip")) {
            this.catMark = Integer.valueOf(val).shortValue();
        } else if (op.equals("tickLblSkip")) {
            this.catLabel = Integer.valueOf(val).shortValue();
        } else {
            return false;
        }
        this.updateRecord();
        return true;
    }

    public String getOption(String op) {
        if (op.equals("crossesAt")) {
            return String.valueOf(this.catCross);
        }
        if (op.equals("orientation")) {
            return this.fReverse ? "maxMin" : "minMax";
        }
        if (op.equals("crosses")) {
            if (this.fMaxCross) {
                return "max";
            }
            if (this.fBetween) {
                return "autoZero";
            }
            return "min";
        }
        if (op.equals("tickMarkSkip")) {
            return String.valueOf(this.catMark);
        }
        if (op.equals("tickLblSkip")) {
            return String.valueOf(this.catLabel);
        }
        return null;
    }

    public boolean isReversed() {
        return this.fReverse;
    }
}

