/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.ExtenXLS.ChartHandle;
import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.ByteStreamer;
import com.extentech.formats.XLS.Dimensions;
import com.extentech.formats.XLS.Font;
import com.extentech.formats.XLS.MSODrawing;
import com.extentech.formats.XLS.Obj;
import com.extentech.formats.XLS.Sheet;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.Ai;
import com.extentech.formats.XLS.charts.Axis;
import com.extentech.formats.XLS.charts.AxisParent;
import com.extentech.formats.XLS.charts.BubbleChart;
import com.extentech.formats.XLS.charts.ChartAxes;
import com.extentech.formats.XLS.charts.ChartFormat;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.ChartSeries;
import com.extentech.formats.XLS.charts.ChartType;
import com.extentech.formats.XLS.charts.CrtLayout12A;
import com.extentech.formats.XLS.charts.DataFormat;
import com.extentech.formats.XLS.charts.DefaultText;
import com.extentech.formats.XLS.charts.Fontx;
import com.extentech.formats.XLS.charts.Frame;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.formats.XLS.charts.Legend;
import com.extentech.formats.XLS.charts.Series;
import com.extentech.formats.XLS.charts.SeriesList;
import com.extentech.formats.XLS.charts.SeriesText;
import com.extentech.formats.XLS.charts.TextDisp;
import com.extentech.formats.XLS.charts.ThreeD;
import com.extentech.toolkit.Logger;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;

public class Chart
extends GenericChartObject
implements ChartObject {
    static final long serialVersionUID = 6702247464633674375L;
    protected ArrayList<ChartType> chartgroup = new ArrayList();
    protected int nCharts = 0;
    protected ChartAxes chartaxes = null;
    protected ChartSeries chartseries = new ChartSeries();
    protected TextDisp charttitle = null;
    protected Dimensions dimensions;
    protected Obj obj = null;
    protected MSODrawing msodrawobj = null;
    HashMap<String, Double> chartMetrics = new HashMap();
    public transient WorkBookHandle wbh;
    protected ArrayList chartRecs = new ArrayList();
    protected AbstractList preRecs;
    protected AbstractList postRecs = new ArrayList();
    protected boolean dirtyflag = false;
    protected boolean metricsDirty = true;
    protected Ai currentAi;
    protected int hierarchyDepth = 0;
    protected ArrayList initobs = new ArrayList();

    @Override
    public void init() {
        super.init();
        this.getData();
        this.chartseries.setParentChart(this);
    }

    public boolean addInitialChartRecord(BiffRec br) {
        if (br.getOpcode() == 4147) {
            ++this.hierarchyDepth;
        } else if (br.getOpcode() == 4148) {
            --this.hierarchyDepth;
            if (this.hierarchyDepth == 0) {
                this.chartRecs.add(br);
                return false;
            }
        }
        if (this.hierarchyDepth != 0) {
            if (br.getOpcode() == 4177) {
                this.currentAi = (Ai)br;
                this.currentAi.setParentChart(this);
                this.currentAi.setSheet(this.getSheet());
            } else if (this.currentAi != null && br.getOpcode() == 4109) {
                this.currentAi.setSeriesText((SeriesText)br);
                this.currentAi = null;
            } else if (br.getOpcode() == 4099) {
                this.chartseries.add(new Object[]{br, this.nCharts});
            } else if (br.getOpcode() == 4161) {
                this.chartaxes = new ChartAxes((AxisParent)br);
            } else if (br.getOpcode() == 4125) {
                this.chartaxes.add((Axis)br);
            } else if (br.getOpcode() == 4116) {
                ++this.nCharts;
            } else if (br.getOpcode() == 4118) {
                this.chartseries.addSeriesMapping(this.nCharts - 1, ((SeriesList)br).getSeriesMappings());
            }
            try {
                if (((GenericChartObject)br).chartType != -1) {
                    ChartFormat cf = null;
                    int i = this.chartRecs.size() - 1;
                    while (i >= 0) {
                        if (((BiffRec)this.chartRecs.get(i)).getOpcode() == 4116) {
                            cf = (ChartFormat)this.chartRecs.get(i);
                            break;
                        }
                        --i;
                    }
                    this.initobs.add(new BiffRec[]{br, cf});
                }
                ((GenericChartObject)br).setParentChart(this);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            this.chartRecs.add(br);
        } else {
            if (br.getOpcode() == 512) {
                this.dimensions = (Dimensions)br;
            }
            br.getData();
            this.postRecs.add(br);
        }
        return true;
    }

    public void setDirtyFlag(boolean b) {
        this.dirtyflag = b;
    }

    public void initChartRecords() {
        block5: {
            try {
                if (this.getSheet().isChartOnlySheet()) break block5;
                int pos = this.getSheet().getSheetRecs().size() - 1;
                BiffRec rec = (BiffRec)this.getSheet().getSheetRecs().get(pos);
                this.obj = (Obj)rec;
                this.obj.setChart(this);
                while (--pos > 0) {
                    rec = (BiffRec)this.getSheet().getSheetRecs().get(pos);
                    if (rec.getOpcode() != 236) continue;
                    this.msodrawobj = (MSODrawing)rec;
                    break;
                }
            }
            catch (Exception e) {
                Logger.logErr("initChartRecords: Error in Chart Records:  " + e.toString());
            }
        }
        BiffRec[] bArr = new BiffRec[this.chartRecs.size()];
        bArr = this.chartRecs.toArray(bArr);
        this.initChartObject(this, bArr);
        int i = 0;
        while (i < this.initobs.size()) {
            BiffRec[] ios = (BiffRec[])this.initobs.get(i);
            this.chartgroup.add(ChartType.createChartTypeObject((GenericChartObject)ios[0], (ChartFormat)ios[1], this.getWorkBook()));
            Legend l = (Legend)Chart.findRec(((ChartFormat)ios[1]).chartArr, Legend.class);
            if (l != null) {
                this.chartgroup.get(this.chartgroup.size() - 1).addLegend(l);
            }
            ++i;
        }
        this.initobs = new ArrayList();
    }

    private ChartObject initChartObject(ChartObject cobj, BiffRec[] cRecs) {
        int i = 0;
        while (i < cRecs.length) {
            BiffRec b = cRecs[i];
            b.getData();
            if (b.getOpcode() != 4147 && b.getOpcode() != 4148) {
                if (cRecs.length > i + 1 && cRecs[i + 1].getOpcode() == 4147) {
                    try {
                        ChartObject co = (ChartObject)((Object)b);
                        int endloc = this.getMatchingEndRecordLocation(i, cRecs);
                        int arrlen = endloc - i;
                        BiffRec[] objArr = new BiffRec[arrlen];
                        System.arraycopy(cRecs, i + 1, objArr, 0, arrlen);
                        cobj.addChartRecord((XLSRecord)((Object)this.initChartObject(co, objArr)));
                        if (co instanceof TextDisp) {
                            int type = ((TextDisp)co).getType();
                            if (type == 1) {
                                this.charttitle = (TextDisp)co;
                            } else if (type == 3) {
                                this.chartaxes.setTd(0, (TextDisp)co);
                            } else if (type == 2) {
                                this.chartaxes.setTd(1, (TextDisp)co);
                            } else if (type == 7) {
                                this.chartaxes.setTd(2, (TextDisp)co);
                            } else if (type == 4 || type == 12) {
                                // empty if block
                            }
                        }
                        try {
                            ((GenericChartObject)co).setParentChart(this);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        i += arrlen;
                    }
                    catch (ClassCastException e) {
                        Logger.logWarn("Error in parsing chart. Please add the correct object (opcode: " + b.getOpcode() + ") to be a Chart Object");
                    }
                } else {
                    cobj.addChartRecord((XLSRecord)b);
                }
            }
            ++i;
        }
        return cobj;
    }

    private int getMatchingEndRecordLocation(int startLoc, BiffRec[] cRecs) {
        int offset = 0;
        int i = startLoc + 2;
        while (i < cRecs.length) {
            BiffRec b = cRecs[i];
            if (b.getOpcode() == 4147) {
                ++offset;
            }
            if (b.getOpcode() == 4148 && --offset < 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public List assembleChartRecords() {
        Vector<Chart> outputVec = new Vector<Chart>();
        if (this.preRecs != null) {
            outputVec.addAll(this.preRecs);
        }
        if (this.dirtyflag) {
            int i = 0;
            while (i < this.nCharts) {
                this.chartseries.updateSeriesMappings(this.chartgroup.get(i).getSeriesList(), i);
                ++i;
            }
            outputVec.addAll(this.getRecordArray());
        } else {
            outputVec.add(this);
            outputVec.addAll(this.chartRecs);
        }
        if (this.postRecs != null) {
            outputVec.addAll(this.postRecs);
        }
        return outputVec;
    }

    public void setPreRecords(AbstractList recs) {
        this.preRecs = recs;
    }

    public HashMap getSeriesPtgs() {
        return this.chartseries.getSeriesPtgs();
    }

    public byte[] getChartBytes() {
        int i = 0;
        while (i < this.preRecs.size()) {
            ((BiffRec)this.preRecs.get(i)).getData();
            ++i;
        }
        ObjectOutputStream obs = null;
        byte[] b = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            obs = new ObjectOutputStream(baos);
            obs.writeObject(this);
            b = baos.toByteArray();
        }
        catch (IOException e) {
            Logger.logErr(e);
        }
        return b;
    }

    public byte[] getSerialBytes() {
        int i = 0;
        while (i < this.preRecs.size()) {
            ((BiffRec)this.preRecs.get(i)).getData();
            ++i;
        }
        ObjectOutputStream obs = null;
        byte[] b = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedOutputStream bufo = new BufferedOutputStream(baos);
            obs = new ObjectOutputStream(bufo);
            obs.writeObject(this);
            bufo.flush();
            b = baos.toByteArray();
        }
        catch (IOException e) {
            Logger.logErr(e);
        }
        return b;
    }

    public List getXLSrecs() {
        List l = this.assembleChartRecords();
        if (this.obj != null) {
            l.add(0, this.obj);
        }
        if (this.msodrawobj != null) {
            l.add(0, this.msodrawobj);
        }
        return l;
    }

    public int getMinRow() {
        return this.dimensions.getRowFirst();
    }

    public int getMaxRow() {
        return this.dimensions.getRowLast();
    }

    public int getMinCol() {
        return this.dimensions.getColFirst();
    }

    public int getMaxCol() {
        return this.dimensions.getColLast();
    }

    public void setDimensionsRecord(int r0, int r1, int c0, int c1) {
        this.dimensions.setRowFirst(r0 - 1);
        this.dimensions.setRowLast(r1 - 1);
        this.dimensions.setColFirst(c0);
        this.dimensions.setColLast(c1 - 1);
        int i = this.postRecs.size() - 1;
        while (i > 0) {
            BiffRec b = (BiffRec)this.postRecs.get(i);
            short op = b.getOpcode();
            if (op == 515 || op == 516) {
                this.postRecs.remove(i);
            }
            --i;
        }
    }

    public void setDimensions(Dimensions d) {
        this.dimensions = d;
    }

    public void setDimensionsRecord() {
        Vector serieslist = this.getAllSeries(-1);
        int nSeries = serieslist.size();
        int nPoints = 0;
        int i = 0;
        while (i < serieslist.size()) {
            try {
                Series s = (Series)serieslist.get(i);
                int[] coords = ExcelTools.getRangeCoords(s.getSeriesValueAi().getDefinition());
                nPoints = coords[3] > coords[1] ? Math.max(nPoints, coords[3] - coords[1] + 1) : Math.max(nPoints, coords[2] - coords[0] + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        this.setDimensionsRecord(0, nPoints, 0, nSeries);
    }

    public int getId() {
        if (this.obj != null) {
            return this.obj.getObjId();
        }
        return -1;
    }

    public void setId(int id) {
        if (this.obj != null) {
            this.obj.setObjId(id);
        }
    }

    public void setMetricsDirty() {
        this.dirtyflag = true;
        this.metricsDirty = true;
    }

    public boolean changeSeriesRange(String originalrange, String newrange) {
        this.setMetricsDirty();
        return this.chartseries.changeSeriesRange(originalrange, newrange);
    }

    public String[] getSeries(int nChart) {
        return this.chartseries.getSeries(nChart);
    }

    public String[] getCategories(int nChart) {
        return this.chartseries.getCategories(nChart);
    }

    public Vector getAllSeries() {
        return this.chartseries.getAllSeries(-1);
    }

    public Vector getAllSeries(int nChart) {
        return this.chartseries.getAllSeries(nChart);
    }

    public Series addSeries(String seriesRange, String categoryRange, String bubbleRange, String legendRange, String legendText, int nChart) {
        Series s = this.chartseries.addSeries(seriesRange, categoryRange, bubbleRange, legendRange, legendText, this.chartgroup.get(nChart), nChart);
        this.setMetricsDirty();
        return s;
    }

    public String[] getLegends(int nChart) {
        return this.chartseries.getLegends(nChart);
    }

    public void removeSeries(int index) {
        this.setMetricsDirty();
        this.chartseries.removeSeries(index);
    }

    public void removeSeries(Series seriestodelete) {
        this.setMetricsDirty();
        this.chartseries.removeSeries(seriestodelete);
        int nSeries = -1;
        int i = 0;
        block0: while (i < this.chartArr.size()) {
            BiffRec b = (BiffRec)this.chartArr.get(i);
            if (b.getOpcode() == 4099) {
                ++nSeries;
                if (seriestodelete.equals(b)) {
                    this.chartArr.remove(i);
                    int j = i;
                    while (j < this.chartArr.size()) {
                        b = (BiffRec)this.chartArr.get(j);
                        if (b.getOpcode() != 4099) break block0;
                        Series s = (Series)b;
                        int x = Chart.findRecPosition(s.chartArr, DataFormat.class);
                        if (x > 0) {
                            DataFormat df = (DataFormat)s.chartArr.get(x);
                            df.setSeriesIndex(nSeries++);
                        }
                        ++j;
                    }
                    break;
                }
            }
            ++i;
        }
    }

    public Series getSeries(String seriesName, int nChart) {
        return this.chartseries.getSeries(seriesName, nChart);
    }

    public boolean changeCategoryRange(String originalrange, String newrange) {
        this.setMetricsDirty();
        return this.chartseries.changeCategoryRange(originalrange, newrange);
    }

    public boolean changeTextValue(String originalval, String newval) {
        this.setMetricsDirty();
        return this.chartseries.changeTextValue(originalval, newval);
    }

    public String getPlotAreaBgColor() {
        String bg = null;
        try {
            Frame f = (Frame)Chart.findRec(this.chartArr, Frame.class);
            bg = f.getBgColor();
        }
        catch (Exception f) {
            // empty catch block
        }
        int ct = this.getChartType();
        if (bg == null || ct != 3 && ct != 6) {
            bg = this.chartaxes.getPlotAreaBgColor();
        }
        if (bg == null) {
            bg = "#FFFFFF";
        }
        return bg;
    }

    public void setPlotAreaBgColor(int bg) {
        this.chartaxes.setPlotAreaBgColor(bg);
        this.setMetricsDirty();
    }

    public String getPlotAreaLnColor() {
        String clr = "#000000";
        try {
            Frame f = (Frame)Chart.findRec(this.chartArr, Frame.class);
            clr = f.getLineColor();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clr;
    }

    public String getTitle() {
        if (this.charttitle != null) {
            return this.charttitle.toString();
        }
        return "";
    }

    public TextDisp getTitleTd() {
        return this.charttitle;
    }

    @Override
    public String toString() {
        String t = this.getTitle();
        if (!t.equals("")) {
            return t;
        }
        return "Untitled Chart";
    }

    public Font getDefaultFont() {
        int i = 0;
        while (i < this.chartArr.size()) {
            if (((BiffRec)this.chartArr.get(i)).getOpcode() == 4132 && ((DefaultText)this.chartArr.get(i)).getType() == 2) {
                TextDisp td = (TextDisp)this.chartArr.get(i + 1);
                int idx = td.getFontId();
                if (idx > -1) {
                    return this.wkbook.getFont(idx);
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    public void setDefaultFont(int type, int fontId) {
        int i = 0;
        while (i < this.chartArr.size()) {
            BiffRec b = (BiffRec)this.chartArr.get(i);
            b.getOpcode();
            ++i;
        }
        this.dirtyflag = true;
    }

    public ArrayList getFontxRecs() {
        ArrayList<BiffRec> ret = new ArrayList<BiffRec>();
        int i = 0;
        while (i < this.chartRecs.size()) {
            BiffRec b = (BiffRec)this.chartRecs.get(i);
            if (b.getOpcode() == 4134) {
                ret.add(b);
            }
            ++i;
        }
        return ret;
    }

    public void resetFonts() {
        int i = 0;
        while (i < this.chartRecs.size()) {
            BiffRec b = (BiffRec)this.chartRecs.get(i);
            if (b.getOpcode() == 4134) {
                ((Fontx)b).setIfnt(0);
            }
            ++i;
        }
    }

    public Font getTitleFont() {
        if (this.charttitle == null) {
            return null;
        }
        return this.charttitle.getFont(this.wkbook);
    }

    public void populateForTransfer() {
        for (Series s : this.getAllSeries(-1)) {
            try {
                int j = 0;
                while (j < s.chartArr.size()) {
                    if (((BiffRec)s.chartArr.get(j)).getOpcode() == 4177) {
                        ((Ai)s.chartArr.get(j)).populateForTransfer(this.getSheet().getSheetName());
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                Logger.logErr("Chart.populateForTransfer: " + e.toString());
            }
        }
    }

    public void updateSheetRefs(String newSheetName, String origWorkBook) {
        for (Series s : this.getAllSeries(-1)) {
            try {
                int j = 0;
                while (j < s.chartArr.size()) {
                    if (((BiffRec)s.chartArr.get(j)).getOpcode() == 4177) {
                        ((Ai)s.chartArr.get(j)).updateSheetRef(newSheetName, origWorkBook);
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                Logger.logErr("Chart.updateSheetRefs: " + e.toString());
            }
        }
    }

    public void setTitle(String str) {
        if ((str == null || str.equals("")) && this.charttitle == null) {
            return;
        }
        if (this.charttitle == null) {
            try {
                TextDisp td = (TextDisp)TextDisp.getPrototype(1, str, this.getWorkBook());
                this.addChartRecord(td);
                this.charttitle = td;
            }
            catch (Exception e) {
                Logger.logWarn("Unable to set title of chart to: " + str + " This chart object does not contain a title record");
            }
        } else {
            this.charttitle.setText(str);
        }
        this.setMetricsDirty();
    }

    public int getChartType() {
        return this.chartgroup.get(0).getChartType();
    }

    public int getChartType(int nChart) {
        return this.chartgroup.get(nChart).getChartType();
    }

    public int[] getAllChartTypes() {
        int[] charttypes = new int[this.nCharts];
        int i = 0;
        while (i < this.nCharts) {
            charttypes[i] = this.chartgroup.get(i).getChartType();
            ++i;
        }
        return charttypes;
    }

    public int getNumberOfCharts() {
        return this.nCharts - 1;
    }

    public ChartType getChartObject() {
        return this.chartgroup.get(0);
    }

    public ChartType getChartObject(int nChart) {
        return this.chartgroup.get(nChart);
    }

    public int getChartOrder(ChartType ct) {
        int i = 0;
        while (i < this.chartgroup.size()) {
            if (this.chartgroup.get(i).equals(ct)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private ChartFormat createNewChart(int nChart) {
        AxisParent ap = (AxisParent)Chart.findRec(this.chartArr, AxisParent.class);
        return ap.createNewChart(nChart);
    }

    protected void addChartType(ChartType ct, int nChart) {
        if (nChart < this.chartgroup.size()) {
            this.chartgroup.remove(nChart);
        } else {
            ++this.nCharts;
        }
        this.chartgroup.add(nChart, ct);
        this.dirtyflag = true;
    }

    protected ChartFormat getChartOjectParent(int nChart) {
        ChartFormat cf = null;
        cf = nChart >= this.chartgroup.size() ? this.createNewChart(nChart) : this.chartgroup.get((int)nChart).cf;
        return cf;
    }

    public void setChartType(int chartType, int nChart, EnumSet<ChartHandle.ChartOptions> options) {
        ChartFormat cf = this.getChartOjectParent(nChart);
        ChartType ct = ChartType.create(chartType, this, cf);
        ct.setOptions(options);
        Legend l = this.getLegend();
        ct.addLegend(l);
        if (ct instanceof BubbleChart && options.contains((Object)ChartHandle.ChartOptions.THREED)) {
            ((BubbleChart)ct).setIs3d(true);
        }
        this.addChartType(ct, nChart);
    }

    public boolean isThreeD() {
        return this.isThreeD(0);
    }

    public boolean isThreeD(int nChart) {
        return this.chartgroup.get(nChart).isThreeD();
    }

    public ThreeD getThreeDRec(int nChart) {
        return this.chartgroup.get(nChart).getThreeDRec(false);
    }

    @Override
    public boolean isStacked() {
        return this.isStacked(0);
    }

    public boolean isStacked(int nChart) {
        return this.chartgroup.get(nChart).isStacked();
    }

    public boolean is100PercentStacked() {
        return this.is100PercentStacked(0);
    }

    public boolean is100PercentStacked(int nChart) {
        return this.chartgroup.get(nChart).is100PercentStacked();
    }

    public boolean isClustered() {
        return this.isClustered(0);
    }

    public boolean isClustered(int nChart) {
        return this.chartgroup.get(nChart).isClustered();
    }

    public String getChartOptionsXML(int nChart) {
        return this.chartgroup.get(nChart).getChartOptionsXML();
    }

    @Override
    public boolean setChartOption(String op, String val) {
        this.dirtyflag = true;
        return this.setChartOption(op, val, 0);
    }

    public boolean setChartOption(String op, String val, int nChart) {
        this.dirtyflag = true;
        return this.chartgroup.get(nChart).setChartOption(op, val);
    }

    @Override
    public String getChartOption(String op) {
        return this.chartgroup.get(0).getChartOption(op);
    }

    public String getThreeDXML() {
        return this.getThreeDXML(0);
    }

    public String getThreeDXML(int nChart) {
        return this.chartgroup.get(nChart).getThreeDXML();
    }

    public ThreeD initThreeD() {
        return this.initThreeD(0, this.getChartType(0));
    }

    public ThreeD initThreeD(int nChart, int chartType) {
        return this.chartgroup.get(nChart).initThreeD(chartType);
    }

    public ChartAxes getAxes() {
        return this.chartaxes;
    }

    public ChartSeries getChartSeries() {
        return this.chartseries;
    }

    public boolean getAxisAutomaticScale() {
        return this.chartaxes.getAxisAutomaticScale();
    }

    public double[] getMinMax(WorkBookHandle wbh) {
        if (this.metricsDirty) {
            this.getMetrics(wbh);
        }
        if (this.wbh == null) {
            this.wbh = wbh;
        }
        this.metricsDirty = false;
        double[] minmaxcache = this.chartseries.getMetrics(this.metricsDirty);
        return minmaxcache;
    }

    public String getChartFontRecsXML() {
        HashMap<Integer, String> fonts = new HashMap<Integer, String>();
        int maxFont = 5;
        int i = 0;
        while (i < this.chartRecs.size()) {
            BiffRec b = (BiffRec)this.chartRecs.get(i);
            if (b.getOpcode() == 4134) {
                int fontId = ((Fontx)b).getIfnt();
                maxFont = Math.max(fontId, maxFont);
                Font f = this.getWorkBook().getFont(fontId);
                fonts.put(fontId, f.getXML());
            }
            ++i;
        }
        StringBuffer sb = new StringBuffer();
        int i2 = 5;
        while (i2 <= maxFont) {
            if (fonts.get(i2) != null) {
                sb.append("\n\t\t<ChartFontRec id=\"" + i2 + "\" ");
                sb.append(fonts.get(i2));
                sb.append("/>");
            }
            ++i2;
        }
        return sb.toString();
    }

    public String getChartFontsXML() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.chartArr.size()) {
            TextDisp td;
            BiffRec b = (BiffRec)this.chartArr.get(i);
            if (b.getOpcode() == 4132) {
                sb.append(" Default" + ((DefaultText)b).getType() + "=\"");
                b = (BiffRec)this.chartArr.get(++i);
                if (b.getOpcode() == 4133) {
                    td = (TextDisp)b;
                    sb.append(td.getFontId());
                }
                sb.append("\"");
            } else if (b.getOpcode() == 4133 && (td = (TextDisp)b).isChartTitle()) {
                sb.append(" Title=\"");
                sb.append(td.getFontId());
                sb.append("\"");
            }
            ++i;
        }
        return sb.toString();
    }

    public void setChartFont(String type, String val) {
        if (type.equalsIgnoreCase("Title")) {
            int i = 0;
            while (i < this.chartArr.size()) {
                TextDisp td;
                BiffRec b = (BiffRec)this.chartArr.get(i);
                if (b.getOpcode() == 4133 && (td = (TextDisp)b).isChartTitle()) {
                    td.setFontId(Integer.parseInt(val));
                    break;
                }
                ++i;
            }
        } else if (type.indexOf("Default") > -1) {
            type = type.substring(7);
            int i = 0;
            while (i < this.chartArr.size()) {
                BiffRec b = (BiffRec)this.chartArr.get(i);
                if (b.getOpcode() == 4132 && ((DefaultText)b).getType() == Integer.parseInt(type) && (b = (BiffRec)this.chartArr.get(++i)).getOpcode() == 4133) {
                    TextDisp td = (TextDisp)b;
                    td.setFontId(Integer.parseInt(val));
                    break;
                }
                ++i;
            }
        }
        this.setMetricsDirty();
    }

    public void setTitleFont(int fontId) {
        int i = 0;
        while (i < this.chartArr.size()) {
            TextDisp td;
            BiffRec b = (BiffRec)this.chartArr.get(i);
            if (b.getOpcode() == 4133 && (td = (TextDisp)b).isChartTitle()) {
                td.setFontId(fontId);
            }
            ++i;
        }
        this.setMetricsDirty();
    }

    public void writeChartRecs(String fName) {
        try {
            File f = new File(fName);
            BufferedWriter writer = new BufferedWriter(new FileWriter(f, true));
            int ctr = 0;
            if (this.preRecs != null) {
                ctr = ByteStreamer.writeRecs(new ArrayList(this.preRecs), writer, ctr, 0);
            }
            ctr = ByteStreamer.writeRecs(this.chartArr, writer, ctr, 0);
            writer.flush();
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setSheet(Sheet b) {
        super.setSheet(b);
        if (this.msodrawobj != null) {
            this.msodrawobj.setSheet(b);
        }
        int i = 0;
        while (i < this.chartArr.size()) {
            ((XLSRecord)this.chartArr.get(i)).setSheet(b);
            ++i;
        }
    }

    public short[] getCoords() {
        short[] coords = new short[]{20, 20, 100, 100};
        if (this.msodrawobj != null) {
            coords = this.msodrawobj.getCoords();
        } else {
            Logger.logWarn("Chart missing Msodrawing record. Chart has no coordinates.");
        }
        if (!this.metricsDirty) {
            coords[2] = this.chartMetrics.get("canvasw").shortValue();
            coords[3] = this.chartMetrics.get("canvash").shortValue();
        }
        return coords;
    }

    public float[] getPlotAreaCoords(float w, float h) {
        return this.chartaxes.getPlotAreaCoords(w, h);
    }

    public void setCoords(short[] coords) {
        if (this.msodrawobj != null) {
            this.msodrawobj.setCoords(coords);
            this.setMetricsDirty();
        } else {
            Logger.logWarn("Chart missing coordinates.");
        }
    }

    public short[] getBounds() {
        if (this.msodrawobj != null) {
            return this.msodrawobj.getBounds();
        }
        return null;
    }

    public short getColOffset() {
        if (this.msodrawobj != null) {
            return this.msodrawobj.getColOffset();
        }
        return 0;
    }

    public void setBounds(short[] bounds) {
        if (this.msodrawobj != null) {
            this.msodrawobj.setBounds(bounds);
        }
        this.setMetricsDirty();
    }

    public int getRow0() {
        if (this.msodrawobj != null) {
            return this.msodrawobj.getRow0();
        }
        return -1;
    }

    public void setRow(int r2) {
        if (this.msodrawobj != null) {
            this.msodrawobj.setRow(r2);
        }
        this.setMetricsDirty();
    }

    public int getCol0() {
        if (this.msodrawobj != null) {
            return this.msodrawobj.getCol();
        }
        return -1;
    }

    public int getHeight() {
        if (this.msodrawobj != null) {
            return this.msodrawobj.getHeight();
        }
        return -1;
    }

    public void setHeight(int h) {
        if (this.msodrawobj != null) {
            this.msodrawobj.setHeight(h);
        }
        this.setMetricsDirty();
    }

    public JSONArray getSeriesJSON() {
        return this.chartseries.getSeriesJSON();
    }

    public void setSeriesJSON(JSONArray s) throws JSONException {
        this.chartseries.setSeriesJSON(s);
        this.dirtyflag = true;
    }

    public void showDataTable(boolean bShow) {
    }

    public void showLegend(boolean bShow, boolean vertical) {
        this.chartgroup.get(0).showLegend(bShow, vertical);
    }

    public void removeLegend() {
        this.showLegend(false, false);
    }

    public Legend getLegend() {
        return this.chartgroup.get(0).getDataLegend();
    }

    protected int getDataLabel() {
        return this.chartgroup.get(0).getDataLabel();
    }

    protected int[] getDataLabelsPerSeries(int defaultDL) {
        return this.chartseries.getDataLabelsPerSeries(defaultDL, this.getChartType());
    }

    protected int[] getMarkerFormats(int nChart) {
        int[] mf;
        int[] nArray = mf = this.chartseries.getMarkerFormats();
        int n = mf.length;
        int n2 = 0;
        while (n2 < n) {
            int marker = nArray[n2];
            if (marker != 0) {
                return mf;
            }
            ++n2;
        }
        return this.chartgroup.get(nChart).getMarkerFormats();
    }

    public boolean hasMarkers(int nChart) {
        int[] markers;
        int[] nArray = markers = this.getMarkerFormats(nChart);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            int marker = nArray[n2];
            if (marker != 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean hasDataLegend() {
        return this.chartgroup.get(0).getDataLegend() != null;
    }

    public MSODrawing getMsodrawobj() {
        return this.msodrawobj;
    }

    public Obj getObj() {
        return this.obj;
    }

    public void setVaryColor(boolean vary, int nChart) {
        this.getChartObject((int)nChart).cf.setVaryColor(vary);
    }

    public static BiffRec findRec(ArrayList chartArr, Class c) {
        int i = 0;
        while (i < chartArr.size()) {
            BiffRec b = (BiffRec)chartArr.get(i);
            if (b.getClass() == c) {
                return b;
            }
            ++i;
        }
        return null;
    }

    public static int findRecPosition(ArrayList chartArr, Class c) {
        int i = 0;
        while (i < chartArr.size()) {
            BiffRec b = (BiffRec)chartArr.get(i);
            if (b.getClass() == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public HashMap getMetrics(WorkBookHandle wbh) {
        if (this.metricsDirty) {
            try {
                CrtLayout12A crt;
                this.wbh = wbh;
                double[] minmax = this.chartseries.getMetrics(this.metricsDirty);
                short[] coords = this.getCoords();
                this.chartMetrics.put("x", new Double(coords[0]));
                this.chartMetrics.put("y", new Double(coords[1]));
                this.chartMetrics.put("w", new Double(coords[2]));
                this.chartMetrics.put("h", new Double(coords[3]));
                this.chartMetrics.put("canvasw", new Double(coords[2]));
                this.chartMetrics.put("canvash", new Double(coords[3]));
                this.chartMetrics.put("min", minmax[0]);
                this.chartMetrics.put("max", minmax[1]);
                float[] plotcoords = null;
                plotcoords = this.getPlotAreaCoords(this.chartMetrics.get("w").floatValue(), this.chartMetrics.get("h").floatValue());
                if (plotcoords == null && (crt = (CrtLayout12A)Chart.findRec(this.chartArr, CrtLayout12A.class)) != null) {
                    plotcoords = crt.getInnerPlotCoords(this.chartMetrics.get("w").floatValue(), this.chartMetrics.get("h").floatValue());
                }
                this.chartMetrics.put("x", new Double(plotcoords[0]));
                this.chartMetrics.put("y", new Double(plotcoords[1]));
                this.chartMetrics.put("w", new Double(plotcoords[2]));
                this.chartMetrics.put("h", new Double(plotcoords[3]));
                Font titlefont = this.getTitleFont();
                if (titlefont != null && !this.getTitle().equals("")) {
                    float[] tdcoords = this.charttitle.getCoords();
                    double fh = titlefont.getFontHeightInPoints();
                    if (tdcoords[1] == 0.0f) {
                        this.chartMetrics.put("TITLEOFFSET", Math.ceil(fh * 1.5));
                    } else {
                        this.chartMetrics.put("TITLEOFFSET", fh);
                    }
                } else if (this.chartMetrics.get("y") < 5.0) {
                    this.chartMetrics.put("TITLEOFFSET", 10.0);
                } else {
                    this.chartMetrics.put("TITLEOFFSET", 0.0);
                }
                this.getAxes().getMetrics(this.getChartType(), this.chartMetrics, plotcoords, this.getChartSeries().getCategories());
                int[] lcoords = null;
                double adjust = 10.0;
                if (this.getLegend() != null) {
                    this.getLegend().getMetrics(this.chartMetrics, this.getChartType(), this.getChartSeries());
                    lcoords = this.getLegend().getCoords();
                    if (lcoords != null) {
                        adjust = 2 * lcoords[4];
                    } else {
                        lcoords = new int[6];
                        lcoords[0] = this.chartMetrics.get("canvasw").intValue();
                    }
                } else {
                    lcoords = new int[6];
                    lcoords[0] = this.chartMetrics.get("canvasw").intValue();
                }
                double ldist = (double)lcoords[0] - this.chartMetrics.get("w");
                this.chartMetrics.put("x", this.chartMetrics.get("x") + (Double)this.getAxes().axisMetrics.get("YAXISLABELOFFSET") + (Double)this.getAxes().axisMetrics.get("YAXISTITLEOFFSET"));
                this.chartMetrics.put("y", this.chartMetrics.get("y") + this.chartMetrics.get("TITLEOFFSET"));
                this.chartMetrics.put("w", this.chartMetrics.get("w") - (Double)this.getAxes().axisMetrics.get("YAXISLABELOFFSET"));
                this.chartMetrics.put("h", this.chartMetrics.get("canvash") - this.chartMetrics.get("y") - (Double)this.getAxes().axisMetrics.get("XAXISLABELOFFSET") - (Double)this.getAxes().axisMetrics.get("XAXISTITLEOFFSET") - 10.0);
                double cw = this.chartMetrics.get("canvasw");
                if (lcoords[5] == 3) {
                    double legendBeg = (double)lcoords[0] - (this.chartMetrics.get("w") + this.chartMetrics.get("x"));
                    double legendEnd = cw - ((double)(lcoords[0] + lcoords[2]) + adjust);
                    if ((legendBeg < 0.0 || legendEnd < 0.0) && legendEnd < 0.0) {
                        this.chartMetrics.put("canvasw", (double)(lcoords[0] + lcoords[2]) + adjust);
                        cw = (double)(lcoords[0] + lcoords[2]) + adjust;
                    }
                    if (this.getAxes().hasAxis(0) && ldist > 0.0) {
                        this.chartMetrics.put("w", (double)lcoords[0] - this.chartMetrics.get("x") - ldist);
                    }
                } else {
                    double w = this.chartMetrics.get("w") + this.chartMetrics.get("x");
                    if (w > cw) {
                        this.chartMetrics.put("w", this.chartMetrics.get("canvasw") - this.chartMetrics.get("x") - 10.0);
                    }
                }
                this.metricsDirty = false;
            }
            catch (Exception e) {
                Logger.logErr("Chart.getMetrics: " + e.toString());
            }
        }
        return this.chartMetrics;
    }
}

