/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.SpPr;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.AreaFormat;
import com.extentech.formats.XLS.charts.AttachedLabel;
import com.extentech.formats.XLS.charts.Bar;
import com.extentech.formats.XLS.charts.Chart;
import com.extentech.formats.XLS.charts.ChartLine;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.DataFormat;
import com.extentech.formats.XLS.charts.DataLabExtContents;
import com.extentech.formats.XLS.charts.DefaultText;
import com.extentech.formats.XLS.charts.Dropbar;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.formats.XLS.charts.Legend;
import com.extentech.formats.XLS.charts.LineFormat;
import com.extentech.formats.XLS.charts.MarkerFormat;
import com.extentech.formats.XLS.charts.PieFormat;
import com.extentech.formats.XLS.charts.Serfmt;
import com.extentech.formats.XLS.charts.TextDisp;
import com.extentech.formats.XLS.charts.ThreeD;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

public class ChartFormat
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = 4000704166442059677L;
    private short grbit = 0;
    private boolean fVaried = false;
    private short drawingOrder = 0;
    private byte[] PROTOTYPE_BYTES = new byte[20];

    @Override
    public void init() {
        super.init();
        this.grbit = ByteTools.readShort(this.getByteAt(16), this.getByteAt(17));
        this.drawingOrder = ByteTools.readShort(this.getByteAt(18), this.getByteAt(19));
        this.fVaried = (this.grbit & 1) == 1;
    }

    private void updateRecord() {
        byte[] b = ByteTools.shortToLEBytes(this.grbit);
        this.getData()[16] = b[0];
        this.getData()[17] = b[1];
    }

    public void setVaryColor(boolean vary) {
        this.fVaried = vary;
        this.grbit = ByteTools.updateGrBit(this.grbit, this.fVaried, 0);
        this.updateRecord();
    }

    public boolean getVaryColor() {
        return this.fVaried;
    }

    protected void setChartObject(ChartObject co) {
        this.chartArr.remove(0);
        this.chartArr.add(0, (XLSRecord)((Object)co));
    }

    public boolean isThreeD(int chartType) {
        if (chartType != 9) {
            int i = 0;
            while (i < this.chartArr.size()) {
                BiffRec b = (BiffRec)this.chartArr.get(i);
                if (b.getOpcode() == 4154) {
                    return true;
                }
                ++i;
            }
        } else {
            DataFormat df = this.getDataFormatRec(false);
            if (df != null) {
                return df.getHas3DBubbles();
            }
        }
        return false;
    }

    public boolean is3DClustered() {
        ThreeD td = (ThreeD)Chart.findRec(this.chartArr, ThreeD.class);
        if (td != null) {
            return td.isClustered();
        }
        return false;
    }

    public void setIsClustered(boolean bIsClustered) {
        ThreeD td = this.getThreeDRec(false);
        if (td != null) {
            td.setIsClustered(bIsClustered);
        } else if (((XLSRecord)this.chartArr.get(0)).getOpcode() == 4119) {
            ((Bar)this.chartArr.get(0)).setIsClustered();
        }
    }

    public void setGapDepth(int gap) {
        ThreeD td = this.getThreeDRec(true);
        td.setPcGap(gap);
    }

    public int getGapDepth() {
        ThreeD td = this.getThreeDRec(false);
        if (td != null) {
            td.getPcGap();
        }
        return 0;
    }

    public String getThreeDXML() {
        int i = 0;
        while (i < this.chartArr.size()) {
            BiffRec b = (BiffRec)this.chartArr.get(i);
            if (b.getOpcode() == 4154) {
                return ((ThreeD)b).getOptionsXML();
            }
            ++i;
        }
        return "";
    }

    public void setPercentage(int p) {
        DataFormat df = this.getDataFormatRec(true);
        df.setPercentage(p);
    }

    public void setBarShape(int shape) {
        DataFormat df = this.getDataFormatRec(true);
        df.setPointNumber(0);
        df.setSeriesIndex(0);
        df.setSeriesNumber(-3);
        df.setShape(shape);
    }

    public void setOption(String op, String val) {
        if (op.equalsIgnoreCase("Percentage")) {
            this.setPercentage(Short.valueOf(val).shortValue());
        } else if (op.equalsIgnoreCase("Shape")) {
            this.setBarShape(Integer.parseInt(val));
        } else if (op.equals("ShowBubbleSizes") || op.equals("ShowLabelPct") || op.equals("ShowCatLabel") || op.equals("ShowPct") || op.equals("Rotation") || op.equals("Label") || op.equals("TextRotation")) {
            TextDisp td = this.getDataLegendTextDisp(0);
            td.setChartOption(op, val);
        } else if (op.equals("Perspective") || op.equals("Cluster") || op.equals("ThreeDScaling") || op.equals("TwoDWalls") || op.equals("PcGap") || op.equals("PcDepth") || op.equals("PcHeight") || op.equals("PcDist") || op.equals("AnElev") || op.equals("AnRot")) {
            ThreeD td = this.getThreeDRec(true);
            td.setChartOption(op, val);
        } else if (op.equals("ShowValueLabel") || op.equals("ShowValueAsPercent") || op.equals("ShowLabelAsPercent") || op.equals("ShowLabel") || op.equals("ShowSeriesName") || op.equals("ShowBubbleLabel")) {
            DataFormat df = this.getDataFormatRec(true);
            df.setDataLabels(op);
        } else if (op.equalsIgnoreCase("SmoothedLine") || op.equalsIgnoreCase("ThreeDBubbles") || op.equalsIgnoreCase("ArShadow")) {
            DataFormat df = this.getDataFormatRec(true);
            if (op.equalsIgnoreCase("SmoothedLine")) {
                df.setSmoothLines(true);
            } else if (op.equalsIgnoreCase("ThreeDBubbles")) {
                df.setHas3DBubbles(true);
            } else {
                df.setHasShadow(true);
            }
        }
    }

    public ThreeD getThreeDRec(boolean bCreate) {
        ThreeD td = (ThreeD)Chart.findRec(this.chartArr, ThreeD.class);
        if (td == null && bCreate) {
            int i = 0;
            while (i < this.chartArr.size()) {
                BiffRec b = (BiffRec)this.chartArr.get(i);
                if (b.getOpcode() == 4130) {
                    if (i + 1 < this.chartArr.size() && ((BiffRec)this.chartArr.get(i + 1)).getOpcode() == 4118) {
                        ++i;
                    }
                    td = (ThreeD)ThreeD.getPrototype();
                    td.setParentChart(this.getParentChart());
                    this.chartArr.add(i + 1, td);
                    break;
                }
                ++i;
            }
        }
        return td;
    }

    private TextDisp getDataLegendTextDisp(int type) {
        int i = Chart.findRecPosition(this.chartArr, Legend.class);
        TextDisp td = null;
        if (this.chartArr.size() <= i + 1 || ((XLSRecord)this.chartArr.get(i + 1)).getClass() != DefaultText.class) {
            DefaultText d = (DefaultText)DefaultText.getPrototype();
            d.setType((short)type);
            d.setParentChart(this.getParentChart());
            this.chartArr.add(++i, d);
            td = (TextDisp)TextDisp.getPrototype(4, "", this.getWorkBook());
            td.setParentChart(this.getParentChart());
            this.chartArr.add(++i, td);
        } else {
            DefaultText d = (DefaultText)this.chartArr.get(i + 1);
            if (d.getType() != type) {
                i += 2;
                d = (DefaultText)DefaultText.getPrototype();
                d.setType((short)type);
                d.setParentChart(this.getParentChart());
                this.chartArr.add(++i, d);
                td = (TextDisp)TextDisp.getPrototype(4, "", this.getWorkBook());
                td.setParentChart(this.getParentChart());
                this.chartArr.add(++i, td);
            } else {
                td = (TextDisp)this.chartArr.get(i += 2);
            }
        }
        return td;
    }

    private DataFormat getDataFormatRec(boolean bCreate) {
        DataFormat df = (DataFormat)Chart.findRec(this.chartArr, DataFormat.class);
        if (df == null && bCreate) {
            df = (DataFormat)DataFormat.getPrototypeWithFormatRecs(this.getParentChart());
            this.addChartRecord(df);
        }
        return df;
    }

    public String getDataLabels() {
        DataFormat df = this.getDataFormatRec(false);
        if (df != null) {
            return df.getDataLabelType();
        }
        return "";
    }

    public boolean getHasLines() {
        DataFormat df = this.getDataFormatRec(false);
        if (df != null) {
            return df.getHasLines();
        }
        return false;
    }

    public void setHasLines() {
        DataFormat df = this.getDataFormatRec(true);
        df.setHasLines();
    }

    public void setHasLines(int lineStyle) {
        DataFormat df = this.getDataFormatRec(true);
        df.setHasLines(lineStyle);
    }

    public boolean getHasSmoothLines() {
        DataFormat df = this.getDataFormatRec(false);
        if (df != null) {
            return df.getSmoothedLines();
        }
        return false;
    }

    public void setHasSmoothLines(boolean b) {
        DataFormat df = this.getDataFormatRec(true);
        df.setSmoothLines(b);
    }

    public boolean getHasDropLines() {
        return false;
    }

    public void setHasDropLines() {
    }

    public void setHas3DBubbles(boolean has3dBubbles) {
        DataFormat df = this.getDataFormatRec(true);
        df.setHas3DBubbles(has3dBubbles);
    }

    public int getDataLabelsInt() {
        DataFormat df;
        int datalabels = 0;
        int z = Chart.findRecPosition(this.chartArr, DataLabExtContents.class);
        if (z > 0 && this.chartArr.get(z - 1) instanceof TextDisp) {
            DataLabExtContents dl = (DataLabExtContents)this.chartArr.get(z);
            datalabels = dl.getTypeInt();
        }
        if ((df = this.getDataFormatRec(false)) != null) {
            datalabels |= df.getDataLabelTypeInt();
        }
        return datalabels;
    }

    public void setHasDataLabels(int dl) {
        DataFormat df = this.getDataFormatRec(true);
        df.setHasDataLabels(dl);
    }

    public int getBarShape() {
        int shape = 0;
        DataFormat df = this.getDataFormatRec(false);
        if (df != null) {
            shape = df.getShape();
        }
        return shape;
    }

    public int getMarkerFormat() {
        int markertype = 8;
        DataFormat df = this.getDataFormatRec(false);
        if (df != null) {
            return df.getMarkerFormat();
        }
        return 0;
    }

    public void setMarkers(int markerFormat) {
        DataFormat df = this.getDataFormatRec(true);
        df.setMarkerFormat(markerFormat);
    }

    public ChartLine addChartLines(int lineType) {
        ChartLine cl = null;
        int i = this.chartArr.size() - 1;
        while (i >= 1) {
            BiffRec br = (BiffRec)this.chartArr.get(i);
            short op = br.getOpcode();
            if (op == 4157 || op == 4117 || op == 4154 || op == 4130) {
                cl = (ChartLine)ChartLine.getPrototype();
                cl.setParentChart(this.getParentChart());
                this.chartArr.add(++i, cl);
                cl.setParentChart(this.getParentChart());
                LineFormat lf = (LineFormat)LineFormat.getPrototype(0, 1);
                lf.setParentChart(this.getParentChart());
                this.chartArr.add(++i, lf);
                break;
            }
            --i;
        }
        cl.setLineType(lineType);
        return cl;
    }

    public int getChartLines() {
        ChartLine cl = (ChartLine)Chart.findRec(this.chartArr, ChartLine.class);
        if (cl != null) {
            return cl.getLineType();
        }
        return -1;
    }

    public ChartLine getChartLinesRec() {
        return (ChartLine)Chart.findRec(this.chartArr, ChartLine.class);
    }

    public ChartLine getChartLinesRec(int id) {
        int i = Chart.findRecPosition(this.chartArr, ChartLine.class);
        if (i > -1) {
            while (i < this.chartArr.size()) {
                if (((BiffRec)this.chartArr.get(i)).getOpcode() != 4124) break;
                ChartLine cl = (ChartLine)this.chartArr.get(i);
                if (cl.getLineType() == id) {
                    return cl;
                }
                i += 2;
            }
        }
        return null;
    }

    public void addUpDownBars() {
        if (Chart.findRec(this.chartArr, Dropbar.class) == null) {
            Dropbar upBar = (Dropbar)Dropbar.getPrototype();
            upBar.setParentChart(this.getParentChart());
            Dropbar downBar = (Dropbar)Dropbar.getPrototype();
            downBar.setParentChart(this.getParentChart());
            LineFormat lf = (LineFormat)LineFormat.getPrototype();
            lf.setParentChart(this.getParentChart());
            AreaFormat af = (AreaFormat)AreaFormat.getPrototype();
            af.setParentChart(this.getParentChart());
            upBar.chartArr.add(lf);
            upBar.chartArr.add(af);
            lf = (LineFormat)LineFormat.getPrototype();
            lf.setParentChart(this.getParentChart());
            af = (AreaFormat)AreaFormat.getPrototype();
            af.setParentChart(this.getParentChart());
            downBar.chartArr.add(lf);
            downBar.chartArr.add(af);
            int i = this.chartArr.size() - 1;
            while (i >= 0) {
                BiffRec br = (BiffRec)this.chartArr.get(i);
                short op = br.getOpcode();
                if (op == 4118 || op == 4117 || op == 4154 || op == 4130) {
                    this.chartArr.add(++i, upBar);
                    this.chartArr.add(++i, downBar);
                    break;
                }
                --i;
            }
        }
    }

    public void parseUpDownBarsOOXML(XmlPullParser xpp, Stack<String> lastTag, WorkBookHandle bk) {
        this.addUpDownBars();
        int z = Chart.findRecPosition(this.chartArr, Dropbar.class);
        Dropbar downBar = (Dropbar)this.chartArr.get(z++);
        Dropbar upBar = (Dropbar)this.chartArr.get(z);
        try {
            Dropbar curbar = null;
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block7: {
                    block5: {
                        String tnm;
                        block9: {
                            block8: {
                                block6: {
                                    if (eventType != 2) break block5;
                                    tnm = xpp.getName();
                                    if (!tnm.equals("downBars")) break block6;
                                    curbar = downBar;
                                    break block7;
                                }
                                if (!tnm.equals("upBars")) break block8;
                                curbar = upBar;
                                break block7;
                            }
                            if (!tnm.equals("gapWidth")) break block9;
                            upBar.setGapWidth(Integer.valueOf(xpp.getAttributeValue(0)));
                            downBar.setGapWidth(Integer.valueOf(xpp.getAttributeValue(0)));
                            break block7;
                        }
                        if (!tnm.equals("spPr")) break block7;
                        lastTag.push(tnm);
                        SpPr sppr = (SpPr)SpPr.parseOOXML(xpp, lastTag, bk).cloneElement();
                        LineFormat lf = (LineFormat)curbar.chartArr.get(0);
                        if (lf == null) break block7;
                        lf.setFromOOXML(sppr);
                        break block7;
                    }
                    if (eventType == 3 && xpp.getName().equals("upDownBars")) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("parseUpDownBarsOOXML: " + e.toString());
        }
    }

    public String getUpDownBarOOXML() {
        int z = Chart.findRecPosition(this.chartArr, Dropbar.class);
        if (z == -1) {
            return "";
        }
        StringBuffer ooxml = new StringBuffer();
        try {
            Dropbar upBars = (Dropbar)this.chartArr.get(z++);
            Dropbar downBars = (Dropbar)this.chartArr.get(z);
            ++z;
            ooxml.append("<c:upDownBars>");
            short gw = upBars.getGapWidth();
            if (gw != 150) {
                ooxml.append("<c:gapWidth val=\"" + gw + "\"/>");
            }
            ooxml.append(upBars.getOOXML(true));
            ooxml.append(downBars.getOOXML(false));
            ooxml.append("</c:upDownBars>");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ooxml.toString();
    }

    public int getDrawingOrder() {
        return this.drawingOrder;
    }

    public void setDrawingOrder(int order) {
        this.drawingOrder = (short)order;
        byte[] b = ByteTools.shortToLEBytes(this.drawingOrder);
        this.getData()[18] = b[0];
        this.getData()[19] = b[1];
    }

    public static XLSRecord getPrototype() {
        ChartFormat cf = new ChartFormat();
        cf.setOpcode((short)4116);
        cf.setData(cf.PROTOTYPE_BYTES);
        cf.init();
        return cf;
    }

    public String getChartOptionsXML() {
        boolean bFoundDefaultText0 = false;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.chartArr.size()) {
            BiffRec b = (BiffRec)this.chartArr.get(i);
            if (b instanceof ChartObject) {
                ChartObject co = (ChartObject)((Object)b);
                if (b instanceof DataFormat) {
                    DataFormat df = (DataFormat)b;
                    short shape = df.getShape();
                    if (shape != 0) {
                        sb.append(" Shape=\"" + shape + "\"");
                    }
                    int z = 0;
                    while (z < df.chartArr.size()) {
                        b = (BiffRec)df.chartArr.get(z);
                        if (b instanceof PieFormat) {
                            sb.append(((PieFormat)b).getOptionsXML());
                        } else if (b instanceof AttachedLabel) {
                            String type = ((AttachedLabel)b).getType();
                            sb.append(" DataLabel=\"" + type + "\"");
                        } else if (b instanceof Serfmt) {
                            sb.append(((Serfmt)b).getOptionsXML());
                        } else if (b instanceof MarkerFormat) {
                            sb.append(((MarkerFormat)b).getOptionsXML());
                        }
                        ++z;
                    }
                } else if (b instanceof DefaultText) {
                    if (!bFoundDefaultText0) {
                        boolean bl = bFoundDefaultText0 = ((DefaultText)b).getType() == 0;
                    }
                    if (((DefaultText)b).getType() == 1 && bFoundDefaultText0) {
                        sb.append(" ShowLegendKey=\"true\"");
                    }
                }
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String getChartOption(String op) {
        DataFormat df;
        block11: {
            df = this.getDataFormatRec(false);
            if (op.equals("Percentage")) {
                return String.valueOf(df.getPercentage());
            }
            if (op.equals("ShowValueLabel") || op.equals("ShowValueAsPercent") || op.equals("ShowLabelAsPercent") || op.equals("ShowLabel") || op.equals("ShowBubbleLabel")) {
                return df.getDataLabelType(op);
            }
            if (op.equals("ShowBubbleSizes") || op.equals("ShowLabelPct") || op.equals("ShowPct") || op.equals("ShowCatLabel") || op.equals("Rotation") || op.equals("Label") || op.equals("TextRotation")) {
                TextDisp td = this.getDataLegendTextDisp(0);
                return td.getChartOption(op);
            }
            if (!op.equals("Perspective") && !op.equals("Cluster") && !op.equals("ThreeDScaling") && !op.equals("TwoDWalls") && !op.equals("PcGap") && !op.equals("PcDepth") && !op.equals("PcHeight") && !op.equals("PcDist") && !op.equals("AnElev") && !op.equals("AnRot")) break block11;
            ThreeD td = this.getThreeDRec(false);
            if (td != null) {
                return td.getChartOption(op);
            }
            return "";
        }
        try {
            if (op.equals("ThreeDBubbles")) {
                return String.valueOf(df.getHas3DBubbles());
            }
            if (op.equals("ArShadow")) {
                return String.valueOf(df.getHasShadow());
            }
            if (op.equals("SmoothLines")) {
                return String.valueOf(df.getSmoothedLines());
            }
            if (!(op.equals("AxisLabels") || op.equals("BubbleSizeRatio") || op.equals("BubbleSize") || op.equals("ShowNeg") || op.equals("ColorFill") || op.equals("Shading"))) {
                op.equals("MarkerFormat");
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return "";
    }
}

