/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.toolkit.ByteTools;

public class DataLabExtContents
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = -1228364285066204304L;
    private short grbit;
    private boolean fSerName;
    private boolean fCatName;
    private boolean fValue;
    private boolean fPercent;
    private boolean fBubSizes;
    private byte[] PROTOTYPE_BYTES;

    public DataLabExtContents() {
        byte[] byArray = new byte[16];
        byArray[0] = 107;
        byArray[1] = 8;
        byArray[12] = 1;
        this.PROTOTYPE_BYTES = byArray;
    }

    @Override
    public void init() {
        super.init();
        byte[] data = this.getData();
        this.grbit = ByteTools.readShort(data[12], data[13]);
        this.fSerName = (this.grbit & 1) == 1;
        this.fCatName = (this.grbit & 2) == 2;
        this.fValue = (this.grbit & 4) == 4;
        this.fPercent = (this.grbit & 8) == 8;
        this.fBubSizes = (this.grbit & 0x10) == 16;
        int cfr_ignored_0 = data.length;
    }

    public static XLSRecord getPrototype() {
        DataLabExtContents dlc = new DataLabExtContents();
        dlc.setOpcode((short)2155);
        dlc.setData(dlc.PROTOTYPE_BYTES);
        dlc.init();
        return dlc;
    }

    public int getTypeInt() {
        short grbit = 0;
        if (this.fValue) {
            grbit = ByteTools.updateGrBit(grbit, true, 0);
        }
        if (this.fPercent) {
            grbit = ByteTools.updateGrBit(grbit, true, 1);
        }
        if (this.fCatName) {
            grbit = ByteTools.updateGrBit(grbit, true, 4);
        }
        if (this.fBubSizes) {
            grbit = ByteTools.updateGrBit(grbit, true, 5);
        }
        if (this.fSerName) {
            grbit = ByteTools.updateGrBit(grbit, true, 6);
        }
        return grbit;
    }
}

