/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.AreaFormat;
import com.extentech.formats.XLS.charts.Chart;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.GelFrame;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.formats.XLS.charts.LineFormat;
import com.extentech.toolkit.ByteTools;
import java.util.ArrayList;

public class Frame
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = 6302152932127918650L;
    boolean fAutoSize;
    boolean fAutoPosition;
    int frt;

    @Override
    public void init() {
        this.frt = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        byte flag = this.getByteAt(2);
        this.fAutoSize = (flag & 1) == 1;
        this.fAutoPosition = (flag & 2) == 2;
        super.init();
    }

    public static XLSRecord getPrototype() {
        Frame f = new Frame();
        f.setOpcode((short)4146);
        byte[] byArray = new byte[4];
        byArray[2] = 2;
        f.setData(byArray);
        f.init();
        return f;
    }

    public String getBgColor() {
        return Frame.getBgColor(this.chartArr);
    }

    public static String getBgColor(ArrayList chartArr) {
        GelFrame gf = (GelFrame)Chart.findRec(chartArr, GelFrame.class);
        if (gf != null) {
            return gf.getFillColor();
        }
        AreaFormat af = (AreaFormat)Chart.findRec(chartArr, AreaFormat.class);
        if (af != null) {
            return af.getFillColorStr();
        }
        return null;
    }

    public void setBgColor(int bg) {
        int i = 0;
        while (i < this.chartArr.size()) {
            BiffRec b = (BiffRec)this.chartArr.get(i);
            if (b instanceof AreaFormat) {
                ((AreaFormat)b).seticvFore(bg);
            }
            ++i;
        }
    }

    public void setAutosize() {
        this.getData()[2] = 3;
    }

    public void addBox(int lw, int lclr, int bgcolor) {
        AreaFormat af;
        LineFormat lf = (LineFormat)Chart.findRec(this.chartArr, LineFormat.class);
        if (lf == null) {
            lf = (LineFormat)LineFormat.getPrototype(0, 0);
            this.addChartRecord(lf);
        }
        if (lw != -1) {
            lf.setLineWeight(lw);
            lf.setLineStyle(0);
        } else {
            lf.setLineStyle(5);
        }
        if (lclr != -1) {
            lf.setLineColor(lclr);
        }
        if ((af = (AreaFormat)Chart.findRec(this.chartArr, AreaFormat.class)) == null) {
            af = (AreaFormat)AreaFormat.getPrototype(1);
            this.addChartRecord(af);
        }
        if (bgcolor != -1) {
            af.seticvBack(bgcolor);
        }
    }

    public boolean hasBox() {
        LineFormat l = (LineFormat)Chart.findRec(this.chartArr, LineFormat.class);
        return l.getLineStyle() != 5;
    }

    public String getLineColor() {
        LineFormat l = (LineFormat)Chart.findRec(this.chartArr, LineFormat.class);
        if (l != null) {
            return l.getLineColor();
        }
        return null;
    }

    public StringBuffer getSVG(float[] coords) {
        LineFormat lf;
        StringBuffer svg = new StringBuffer();
        String lineSVG = "";
        String bgclr = this.getBgColor();
        if (bgclr == null) {
            bgclr = "white";
        }
        if ((lf = (LineFormat)Chart.findRec(this.chartArr, LineFormat.class)) != null) {
            lineSVG = lf.getSVG();
        }
        float x = coords[0] - coords[2] / 2.0f;
        float y = coords[1] - coords[3] / 2.0f;
        svg.append("<rect x='" + x + "' y='" + y + "' width='" + coords[2] + "' height='" + coords[3] + "' fill='" + bgclr + "' fill-opacity='1' " + lineSVG + "/>\r\n");
        return svg;
    }
}

