/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.toolkit.ByteTools;

public class YMult
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = -6166267220292885486L;
    short axmid;
    short grbit;
    double numLabelMultiplier;
    private byte[] PROTOTYPE_BYTES = new byte[0];

    @Override
    public void init() {
        super.init();
        this.axmid = ByteTools.readShort(this.getByteAt(4), this.getByteAt(5));
        this.numLabelMultiplier = ByteTools.eightBytetoLEDouble(this.getBytesAt(6, 8));
        this.grbit = ByteTools.readShort(this.getByteAt(14), this.getByteAt(15));
    }

    public static XLSRecord getPrototype() {
        YMult ym = new YMult();
        ym.setOpcode((short)2135);
        ym.setData(ym.PROTOTYPE_BYTES);
        ym.init();
        return ym;
    }

    public short getAxMultiplierId() {
        return this.axmid;
    }

    public String getAxMultiplierIdAsString() {
        switch (this.axmid) {
            case -1: {
                return null;
            }
            case 0: {
                return null;
            }
            case 1: {
                return "hundreds";
            }
            case 2: {
                return "thousands";
            }
            case 3: {
                return "tenThousands";
            }
            case 4: {
                return "hundredThousands";
            }
            case 5: {
                return "millions";
            }
            case 6: {
                return "tenMillions";
            }
            case 7: {
                return "hundredMillions";
            }
            case 8: {
                return "billions";
            }
            case 9: {
                return "trillions";
            }
        }
        return null;
    }

    public void setAxMultiplierId(int m) {
        if (m <= -2 || m >= 10) {
            return;
        }
        this.axmid = (short)m;
        byte[] b = ByteTools.shortToLEBytes(this.axmid);
        this.getData()[4] = b[0];
        this.getData()[5] = b[1];
    }

    public void setAxMultiplierId(String m) {
        this.axmid = m.equalsIgnoreCase("hundreds") ? (short)1 : (m.equalsIgnoreCase("thousands") ? (short)2 : (m.equalsIgnoreCase("tenThousands") ? (short)3 : (m.equalsIgnoreCase("hundredThousands") ? (short)4 : (m.equalsIgnoreCase("millions") ? (short)5 : (m.equalsIgnoreCase("tenMillions") ? (short)6 : (m.equalsIgnoreCase("hundredMillions") ? (short)7 : (m.equalsIgnoreCase("billions") ? (short)8 : (m.equalsIgnoreCase("trillions") ? (short)9 : (short)0))))))));
        byte[] b = ByteTools.shortToLEBytes(this.axmid);
        this.getData()[4] = b[0];
        this.getData()[5] = b[1];
    }

    public double getCustomMultiplier() {
        return this.numLabelMultiplier;
    }

    public void setCustomMultiplier(double m) {
        this.numLabelMultiplier = m;
        this.axmid = (short)-1;
        byte[] b = ByteTools.shortToLEBytes(this.axmid);
        this.getData()[4] = b[0];
        this.getData()[5] = b[1];
        b = ByteTools.doubleToLEByteArray(this.numLabelMultiplier);
        System.arraycopy(b, 0, this.getData(), 6, 8);
    }
}

