/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.formulas.DB;
import com.extentech.formats.XLS.formulas.DatabaseCalculator;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.toolkit.Logger;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

class Criteria
extends DB {
    private Map criteriaCache = null;

    public Criteria(int nCols, int nRows) {
        super(nCols, nRows);
    }

    public static Criteria parseCriteria(Ptg[] criteria) {
        DB dblist = DB.parseList(criteria);
        if (dblist == null) {
            return null;
        }
        Criteria crit = new Criteria(dblist.getNCols(), dblist.getNRows());
        crit.colHeaders = dblist.colHeaders;
        crit.rows = dblist.rows;
        if (DatabaseCalculator.DEBUG) {
            Logger.logInfo("\nCriteria:");
            int i = 0;
            while (i < crit.getNCols()) {
                Logger.logInfo("\t" + crit.getCol(i));
                ++i;
            }
            int j = 0;
            while (j < crit.getNCols()) {
                int i2 = 0;
                while (i2 < crit.getNRows()) {
                    Logger.logInfo("\t" + crit.getCell(i2, j));
                    ++i2;
                }
                ++j;
            }
        }
        return crit;
    }

    public boolean matches(String v, Object cx) {
        boolean bMatches;
        block12: {
            bMatches = false;
            String c = "";
            c = cx instanceof Ptg ? ((Ptg)cx).getValue().toString() : cx.toString();
            if (c == null || c.length() == 0) {
                return false;
            }
            if (v == null) {
                return false;
            }
            if (c.substring(0, 1).equals(">")) {
                try {
                    if (c.length() > 1 && c.substring(0, 2).equals(">=")) {
                        c = c.substring(2);
                        bMatches = Double.parseDouble(v) >= Double.parseDouble(c);
                        break block12;
                    }
                    c = c.substring(1);
                    bMatches = Double.parseDouble(v) > Double.parseDouble(c);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (c.substring(0, 1).equals("<")) {
                try {
                    if (c.length() > 1 && c.substring(0, 2).equals("<=")) {
                        c = c.substring(2);
                        bMatches = Double.parseDouble(v) <= Double.parseDouble(c);
                        break block12;
                    }
                    c = c.substring(1);
                    bMatches = Double.parseDouble(v) < Double.parseDouble(c);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                bMatches = v.equalsIgnoreCase(c);
            }
        }
        return bMatches;
    }

    public boolean passes(String field, Ptg[] curRow, DB db) {
        int nrows = this.getNRows();
        int ncols = this.getNCols();
        int crit_format = -1;
        if (nrows > 1 && ncols == 1) {
            crit_format = 0;
        }
        if (nrows == 1 && ncols > 1) {
            crit_format = 1;
        }
        if (nrows > 1 && ncols > 1) {
            crit_format = 2;
        }
        if (nrows == 1 && ncols == 1) {
            crit_format = 0;
        }
        switch (crit_format) {
            case 0: {
                return this.criteriaCheck1(curRow, db);
            }
            case 1: {
                return this.criteriaCheck2(field, curRow, db);
            }
            case 2: {
                return this.criteriaCheck3(field, curRow, db);
            }
        }
        return this.criteriaCheck3(field, curRow, db);
    }

    private boolean criteriaCheck1(Ptg[] curRow, DB db) {
        boolean bColOK = false;
        boolean bRowOK = true;
        int nrows = this.getNRows();
        int ncols = this.getNCols();
        int ndbrows = db.getNRows();
        String cl = this.getCol(0);
        int j = db.findCol(cl);
        if (j >= 0) {
            bColOK = false;
            int k = 0;
            while (k < nrows && !bColOK) {
                try {
                    String v = curRow[j].getValue().toString();
                    Ptg r2 = this.rows[k][0];
                    String rv = r2.getValue().toString();
                    bColOK = this.matches(v, r2);
                    if (bColOK) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++k;
            }
            if (!bColOK) {
                bRowOK = false;
            }
        }
        return bRowOK;
    }

    private boolean criteriaCheck2(String field, Ptg[] curRow, DB db) {
        boolean pass = true;
        int t = 0;
        while (t < curRow.length) {
            String valcheck = curRow[t].getValue().toString();
            int x = 0;
            while (x < this.rows.length) {
                List r2 = this.getCriteria(db.colHeaders[t]);
                for (Ptg cv : r2) {
                    String vc = cv.getValue().toString();
                    if (vc.equals("") || (pass = this.matches(valcheck, vc))) continue;
                    return false;
                }
                ++x;
            }
            ++t;
        }
        return pass;
    }

    private boolean criteriaCheck3(String field, Ptg[] curRow, DB db) {
        boolean critRowMatch = false;
        int x = 0;
        while (x < this.rows.length) {
            critRowMatch = true;
            int rs = 0;
            while (rs < this.colHeaders.length) {
                String critField = this.colHeaders[rs];
                List r2 = this.getCriteria(x, critField);
                Iterator tx = r2.iterator();
                int dv = db.getCol(critField);
                String valcheck = curRow[dv].getValue().toString();
                while (tx.hasNext() && critRowMatch) {
                    Ptg cv = (Ptg)tx.next();
                    String vc = cv.getValue().toString();
                    if (vc.equals("")) continue;
                    critRowMatch = this.matches(valcheck, vc);
                }
                ++rs;
            }
            if (critRowMatch) {
                return true;
            }
            ++x;
        }
        return critRowMatch;
    }

    private boolean criteriaCheck4(String field, Ptg[] curRow, DB db) {
        boolean bColOK = false;
        boolean bRowOK = false;
        int nrows = this.getNRows();
        int ncols = this.getNCols();
        int k = 0;
        while (k < nrows && !bRowOK) {
            int i = 0;
            while (i < ncols) {
                int coln = db.findCol(field);
                if (coln >= 0) {
                    Ptg curcrit = null;
                    if (this.rows[k].length <= ncols) {
                        Logger.logWarn("DatabaseCalculator.Criteria.criteriaCheck4: wrong criteria count for db value count");
                        return false;
                    }
                    curcrit = this.rows[k][coln];
                    String rt = curcrit.getValue().toString();
                    Ptg rx = curRow[coln];
                    String mv = rx.getValue().toString();
                    if (i == 0) {
                        if (!mv.equals(rt)) {
                            return false;
                        }
                    } else if (!rt.equals("")) {
                        bColOK = this.matches(rt, rx);
                        if (!bColOK && nrows == 1) {
                            return false;
                        }
                        if (bColOK) {
                            return true;
                        }
                    }
                }
                ++i;
            }
            if (bColOK) {
                return true;
            }
            ++k;
        }
        return bRowOK;
    }

    private List getCriteria(String field) {
        this.criteriaCache = new Hashtable();
        Vector<Ptg> crits = new Vector<Ptg>();
        int x = 0;
        while (x < this.rows.length) {
            int t = 0;
            while (t < this.colHeaders.length) {
                if (this.colHeaders[t].equals(field)) {
                    crits.add(this.rows[x][t]);
                }
                ++t;
            }
            ++x;
        }
        this.criteriaCache.put(field, crits);
        return crits;
    }

    private List getCriteria(int critRow, String field) {
        Vector<Ptg> crits = new Vector<Ptg>();
        if (critRow != -1) {
            int t = 0;
            while (t < this.colHeaders.length) {
                if (this.colHeaders[t].equals(field)) {
                    crits.add(this.rows[critRow][t]);
                }
                ++t;
            }
        }
        return crits;
    }
}

