/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgRef;

class DB {
    protected String[] colHeaders;
    protected Ptg[][] rows;

    public DB(int nCols, int nRows) {
        this.colHeaders = new String[nCols];
        this.rows = new Ptg[nRows][nCols];
    }

    public int getNCols() {
        return this.colHeaders.length;
    }

    public int getNRows() {
        return this.rows.length;
    }

    public int getCol(String cname) {
        int t = 0;
        while (t < this.colHeaders.length) {
            if (this.colHeaders[t].equalsIgnoreCase(cname)) {
                return t;
            }
            ++t;
        }
        return -1;
    }

    public Ptg[] getRow(int i) {
        if (i > -1 && i < this.rows.length) {
            return this.rows[i];
        }
        return null;
    }

    public String getCol(int i) {
        if (i > -1 && i < this.colHeaders.length) {
            return this.colHeaders[i];
        }
        return null;
    }

    public Ptg getCell(int row, int col) {
        try {
            return this.rows[row][col];
        }
        catch (Exception e) {
            return null;
        }
    }

    public int findCol(String f) {
        int i = 0;
        while (i < this.colHeaders.length) {
            if (this.colHeaders[i].trim().equalsIgnoreCase(f)) {
                return i;
            }
            ++i;
        }
        try {
            int j = Integer.parseInt(f);
            return j - 1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static DB parseList(Ptg[] dbrange) {
        int prevCol = -1;
        int nCols = 0;
        int nRows = 0;
        int maxRows = 0;
        int i = 0;
        while (i < dbrange.length) {
            if (dbrange[i] instanceof PtgRef) {
                PtgRef pref = (PtgRef)dbrange[i];
                int[] loc = pref.getIntLocation();
                if (loc[1] != prevCol) {
                    prevCol = loc[1];
                    ++nCols;
                    nRows = 0;
                } else {
                    maxRows = Math.max(++nRows, maxRows);
                }
            } else {
                return null;
            }
            ++i;
        }
        DB dblist = new DB(nCols, maxRows);
        prevCol = -1;
        nCols = -1;
        nRows = -1;
        int i2 = 0;
        while (i2 < dbrange.length) {
            PtgRef db1 = (PtgRef)dbrange[i2];
            int[] loc = db1.getIntLocation();
            Object vs = null;
            if (!db1.isBlank()) {
                vs = db1.getValue();
            }
            if (loc[1] != prevCol) {
                if (vs != null) {
                    dblist.colHeaders[++nCols] = vs.toString();
                }
                prevCol = loc[1];
                nRows = 0;
            } else {
                try {
                    dblist.rows[nRows++][nCols] = db1;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            ++i2;
        }
        return dblist;
    }
}

