/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.FunctionNotSupportedException;
import com.extentech.formats.XLS.formulas.Complex;
import com.extentech.formats.XLS.formulas.MathFunctionCalculator;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgCalculator;
import com.extentech.formats.XLS.formulas.PtgErr;
import com.extentech.formats.XLS.formulas.PtgMissArg;
import com.extentech.formats.XLS.formulas.PtgNumber;
import com.extentech.formats.XLS.formulas.PtgStr;
import com.extentech.toolkit.Logger;
import com.extentech.toolkit.StringTool;

public class EngineeringCalculator {
    public static boolean DEBUG = false;
    static final double PI_SQRT = Math.sqrt(Math.PI);
    static final double TSQPI = 2.0 / PI_SQRT;
    private static boolean firstCall = true;
    private static final double[] ERF_A = new double[]{3.1611237438705655, 113.86415415105016, 377.485237685302, 3209.3775891384694, 0.18577770618460315};
    private static final double[] ERF_B = new double[]{23.601290952344122, 244.02463793444417, 1282.6165260773723, 2844.236833439171};
    private static final double[] ERF_C = new double[]{0.5641884969886701, 8.883149794388377, 66.11919063714163, 298.6351381974001, 881.952221241769, 1712.0476126340707, 2051.0783778260716, 1230.3393547979972, 2.1531153547440383E-8};
    private static final double[] ERF_D = new double[]{15.744926110709835, 117.6939508913125, 537.1811018620099, 1621.3895745666903, 3290.7992357334597, 4362.619090143247, 3439.3676741437216, 1230.3393548037495};
    private static final double[] ERF_P = new double[]{0.30532663496123236, 0.36034489994980445, 0.12578172611122926, 0.016083785148742275, 6.587491615298378E-4, 0.016315387137302097};
    private static final double[] ERF_Q = new double[]{2.568520192289822, 1.8729528499234604, 0.5279051029514285, 0.06051834131244132, 0.0023352049762686918};
    static final double THRESHOLD = 0.46875;
    static final double SQRPI = 1.0 / PI_SQRT;
    static final double X_INF = Double.MAX_VALUE;
    static final double X_MIN = Double.MIN_VALUE;
    static final double X_NEG = -Math.sqrt(Math.log(8.988465674311579E307));
    static final double X_SMALL = EngineeringCalculator.getDEPS();
    static final double X_HUGE = 1.0 / (2.0 * Math.sqrt(X_SMALL));
    static final double X_MAX = Math.min(Double.MAX_VALUE, 1.0 / (PI_SQRT * Double.MIN_VALUE));
    static final double X_BIG = 26.543;
    private static final float FEPS_START = 2.0E-6f;

    protected static Ptg calcBin2Dec(Ptg[] operands) {
        String bString;
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "BIN2DEC");
        }
        if ((bString = operands[0].getString().trim()).length() > 10) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        boolean bIsNegative = bString.length() == 10 && bString.substring(0, 1).equalsIgnoreCase("1");
        int dec = 0;
        try {
            dec = Integer.parseInt(bString, 2);
            if (bIsNegative) {
                dec -= 1024;
            }
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        PtgNumber pnum = new PtgNumber(dec);
        if (DEBUG) {
            Logger.logInfo("Result from BIN2DEC= " + pnum.getVal());
        }
        return pnum;
    }

    protected static Ptg calcBin2Hex(Ptg[] operands) {
        String hString;
        long dec;
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "BIN2HEX");
        }
        String bString = operands[0].getString().trim();
        int places = 0;
        if (operands.length > 1) {
            places = operands[1].getIntVal();
        }
        if (bString.length() > 10) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        boolean bIsNegative = bString.length() == 10 && bString.substring(0, 1).equalsIgnoreCase("1");
        try {
            dec = Long.parseLong(bString, 2);
            if (bIsNegative) {
                dec -= 1024L;
            }
            hString = Long.toHexString(dec).toUpperCase();
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        if (dec < 0L) {
            hString = hString.substring(Math.max(hString.length() - 10, 0));
        } else if (places > 0) {
            if (hString.length() > places) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            hString = "0000000000" + hString;
            hString = hString.substring(hString.length() - places);
        }
        PtgStr pstr = new PtgStr(hString);
        if (DEBUG) {
            Logger.logInfo("Result from BIN2HEX= " + pstr.getString());
        }
        return pstr;
    }

    protected static Ptg calcBin2Oct(Ptg[] operands) {
        String oString;
        int dec;
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "Bin2Oct");
        }
        String bString = operands[0].getString().trim();
        int places = 0;
        if (operands.length > 1) {
            places = operands[1].getIntVal();
        }
        if (bString.length() > 10) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        boolean bIsNegative = bString.length() == 10 && bString.substring(0, 1).equalsIgnoreCase("1");
        try {
            dec = Integer.parseInt(bString, 2);
            if (bIsNegative) {
                dec -= 1024;
            }
            oString = Integer.toOctalString(dec);
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        if (dec < 0) {
            oString = oString.substring(Math.max(oString.length() - 10, 0));
        } else if (places > 0) {
            if (oString.length() > places) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            oString = "0000000000" + oString;
            oString = oString.substring(oString.length() - places);
        }
        PtgStr pstr = new PtgStr(oString);
        if (DEBUG) {
            Logger.logInfo("Result from BIN2OCT= " + pstr.getString());
        }
        return pstr;
    }

    protected static Ptg calcComplex(Ptg[] operands) {
        if (operands.length < 2) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "Complex");
        }
        int real = operands[0].getIntVal();
        int imaginary = operands[1].getIntVal();
        String suffix = "i";
        if (operands.length > 2 && !(suffix = operands[2].getString().trim()).equals("i") && !suffix.equals("j")) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        String complexString = "";
        if (real != 0) {
            complexString = String.valueOf(real);
            if (imaginary > 0) {
                complexString = String.valueOf(complexString) + " + ";
            }
        }
        if (imaginary != 0) {
            complexString = String.valueOf(complexString) + (Math.abs(imaginary) != 1 ? String.valueOf(imaginary) : "") + suffix;
        }
        if (complexString.equals("")) {
            complexString = "0";
        }
        PtgStr pstr = new PtgStr(complexString);
        if (DEBUG) {
            Logger.logInfo("Result from COMPLEX= " + pstr.getString());
        }
        return pstr;
    }

    private static int findUnits(String u, String[] units) {
        boolean bFound = false;
        int i = 0;
        while (i < units.length) {
            if (u.equals(units[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static double prefixMultiplier(String p, String[] prefixes) {
        double multiplier = 1.0;
        if (p.equals("")) {
            return multiplier;
        }
        int i = 0;
        while (i < prefixes.length) {
            if (p.equals(prefixes[i])) {
                switch (i) {
                    case 0: {
                        multiplier = 1.0E18;
                        break;
                    }
                    case 1: {
                        multiplier = 1.0E15;
                        break;
                    }
                    case 2: {
                        multiplier = 1.0E12;
                        break;
                    }
                    case 3: {
                        multiplier = 1.0E9;
                        break;
                    }
                    case 4: {
                        multiplier = 1000000.0;
                        break;
                    }
                    case 5: {
                        multiplier = 1000.0;
                        break;
                    }
                    case 6: {
                        multiplier = 100.0;
                        break;
                    }
                    case 7: {
                        multiplier = 10.0;
                        break;
                    }
                    case 8: {
                        multiplier = 0.1;
                        break;
                    }
                    case 9: {
                        multiplier = 0.01;
                        break;
                    }
                    case 10: {
                        multiplier = 0.001;
                        break;
                    }
                    case 11: {
                        multiplier = 1.0E-6;
                        break;
                    }
                    case 12: {
                        multiplier = 1.0E-9;
                        break;
                    }
                    case 13: {
                        multiplier = 1.0E-12;
                        break;
                    }
                    case 14: {
                        multiplier = 1.0E-15;
                        break;
                    }
                    case 15: {
                        multiplier = 1.0E-18;
                    }
                }
                return multiplier;
            }
            ++i;
        }
        return multiplier;
    }

    protected static Ptg calcConvert(Ptg[] operands) {
        if (operands.length < 3) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "CONVERT");
        }
        double number = operands[0].getDoubleVal();
        String fromUnits = operands[1].getString().trim();
        String toUnits = operands[2].getString().trim();
        String[] allUnits = new String[]{"g", "sg", "lbm", "u", "ozm", "m", "mi", "Nmi", "in", "ft", "yd", "ang", "Pica", "yr", "day", "hr", "mn", "sec", "Pa", "atm", "mmHg", "N", "dyn", "lbf", "J", "e", "c", "cal", "eV", "HPh", "Wh", "flb", "BTU", "HP", "W", "T", "ga", "C", "F", "K", "tsp", "tbs", "oz", "cup", "pt", "uk_pt", "qt", "gal", "l"};
        String[] weightUnits = new String[]{"g", "sg", "lbm", "u", "ozm"};
        String[] distanceUnits = new String[]{"m", "mi", "Nmi", "in", "ft", "yd", "ang", "Pica"};
        String[] timeUnits = new String[]{"yr", "day", "hr", "mn", "sec"};
        String[] pressureUnits = new String[]{"Pa", "atm", "mmHg"};
        String[] forceUnits = new String[]{"N", "dyn", "lbf"};
        String[] energyUnits = new String[]{"J", "e", "c", "cal", "eV", "HPh", "Wh", "flb", "BTU"};
        String[] powerUnits = new String[]{"HP", "W"};
        String[] magnetismUnits = new String[]{"T", "ga"};
        String[] temperatureUnits = new String[]{"C", "F", "K"};
        String[] liquidMeasureUnits = new String[]{"tsp", "tbs", "oz", "cup", "pt", "uk_pt", "qt", "gal", "l"};
        String fromPrefix = "";
        String toPrefix = "";
        String[] metricPrefixes = new String[]{"E", "P", "T", "G", "M", "k", "h", "e", "d", "c", "m", "u", "n", "p", "f", "a"};
        if (EngineeringCalculator.findUnits(fromUnits, allUnits) < 0) {
            if (fromUnits.length() > 1) {
                fromPrefix = fromUnits.substring(0, 1);
                if (EngineeringCalculator.findUnits(fromUnits = fromUnits.substring(1), allUnits) < 0) {
                    return new PtgErr(PtgErr.ERROR_NA);
                }
                if (EngineeringCalculator.findUnits(fromPrefix, metricPrefixes) < 0) {
                    return new PtgErr(PtgErr.ERROR_NA);
                }
            } else {
                return new PtgErr(PtgErr.ERROR_NA);
            }
        }
        if (EngineeringCalculator.findUnits(toUnits, allUnits) < 0) {
            if (toUnits.length() > 1) {
                toPrefix = toUnits.substring(0, 1);
                if (EngineeringCalculator.findUnits(toUnits = toUnits.substring(1), allUnits) < 0) {
                    return new PtgErr(PtgErr.ERROR_NA);
                }
                if (EngineeringCalculator.findUnits(toPrefix, metricPrefixes) < 0) {
                    return new PtgErr(PtgErr.ERROR_NA);
                }
            } else {
                return new PtgErr(PtgErr.ERROR_NA);
            }
        }
        double result = 0.0;
        double from = 0.0;
        int j = -1;
        int i = EngineeringCalculator.findUnits(fromUnits, weightUnits);
        if (i >= 0) {
            j = EngineeringCalculator.findUnits(toUnits, weightUnits);
            if (j > -1) {
                switch (i) {
                    case 0: {
                        from = number * EngineeringCalculator.prefixMultiplier(fromPrefix, metricPrefixes);
                        break;
                    }
                    case 1: {
                        from = 14593.8424189287 * number;
                        break;
                    }
                    case 2: {
                        from = 453.5923097488115 * number;
                        break;
                    }
                    case 3: {
                        from = 1.66053100460465E-24 * number * EngineeringCalculator.prefixMultiplier(fromPrefix, metricPrefixes);
                        break;
                    }
                    case 4: {
                        from = 28.349515207973 * number;
                    }
                }
                switch (j) {
                    case 0: {
                        result = from / EngineeringCalculator.prefixMultiplier(toPrefix, metricPrefixes);
                        break;
                    }
                    case 1: {
                        result = from * 6.85220500053478E-5;
                        break;
                    }
                    case 2: {
                        result = from * 0.00220462291469134;
                        break;
                    }
                    case 3: {
                        result = from * 6.02217E23 / EngineeringCalculator.prefixMultiplier(toPrefix, metricPrefixes);
                        break;
                    }
                    case 4: {
                        result = from * 0.0352739718003627;
                    }
                }
            } else {
                return new PtgErr(PtgErr.ERROR_NA);
            }
        }
        if (j == -1 && (i = EngineeringCalculator.findUnits(fromUnits, distanceUnits)) >= 0) {
            j = EngineeringCalculator.findUnits(toUnits, distanceUnits);
            if (j > -1) {
                switch (i) {
                    case 0: {
                        from = number * EngineeringCalculator.prefixMultiplier(fromPrefix, metricPrefixes);
                        break;
                    }
                    case 1: {
                        from = 1609.344 * number;
                        break;
                    }
                    case 2: {
                        from = 1852.0 * number;
                        break;
                    }
                    case 3: {
                        from = 0.0254 * number;
                        break;
                    }
                    case 4: {
                        from = 0.3048 * number;
                        break;
                    }
                    case 5: {
                        from = 0.9144000003 * number;
                        break;
                    }
                    case 6: {
                        from = 1.0E-10 * number * EngineeringCalculator.prefixMultiplier(fromPrefix, metricPrefixes);
                        break;
                    }
                    case 7: {
                        from = 3.527777777778E-4 * number;
                    }
                }
                switch (j) {
                    case 0: {
                        result = from / EngineeringCalculator.prefixMultiplier(toPrefix, metricPrefixes);
                        break;
                    }
                    case 1: {
                        result = 6.21371192237334E-4 * from;
                        break;
                    }
                    case 2: {
                        result = 5.39956803455724E-4 * from;
                        break;
                    }
                    case 3: {
                        result = 39.3700787401575 * from;
                        break;
                    }
                    case 4: {
                        result = 3.28083989501312 * from;
                        break;
                    }
                    case 5: {
                        result = 1.09361329797891 * from;
                        break;
                    }
                    case 6: {
                        result = 1.0E10 * from / EngineeringCalculator.prefixMultiplier(toPrefix, metricPrefixes);
                        break;
                    }
                    case 7: {
                        result = 2834.64566929116 * from;
                    }
                }
            } else {
                return new PtgErr(PtgErr.ERROR_NA);
            }
        }
        if (j == -1 && (i = EngineeringCalculator.findUnits(fromUnits, timeUnits)) >= 0) {
            j = EngineeringCalculator.findUnits(toUnits, timeUnits);
            if (j > -1) {
                switch (i) {
                    case 0: {
                        from = number;
                        break;
                    }
                    case 1: {
                        from = 0.0027378507871321 * number;
                        break;
                    }
                    case 2: {
                        from = 1.14077116130504E-4 * number;
                        break;
                    }
                    case 3: {
                        from = 1.90128526884174E-6 * number;
                        break;
                    }
                    case 4: {
                        from = 3.168808781403E-8 * number;
                    }
                }
                switch (j) {
                    case 0: {
                        result = from;
                        break;
                    }
                    case 1: {
                        result = 365.25 * from;
                        break;
                    }
                    case 2: {
                        result = 8766.0 * from;
                        break;
                    }
                    case 3: {
                        result = 525960.0 * from;
                        break;
                    }
                    case 4: {
                        result = 3.15576E7 * from;
                    }
                }
            } else {
                return new PtgErr(PtgErr.ERROR_NA);
            }
        }
        if (j == -1 && (i = EngineeringCalculator.findUnits(fromUnits, pressureUnits)) >= 0) {
            j = EngineeringCalculator.findUnits(toUnits, pressureUnits);
            if (j > -1) {
                switch (i) {
                    case 0: {
                        from = number * EngineeringCalculator.prefixMultiplier(fromPrefix, metricPrefixes);
                        break;
                    }
                    case 1: {
                        from = 101324.996583 * number * EngineeringCalculator.prefixMultiplier(fromPrefix, metricPrefixes);
                        break;
                    }
                    case 2: {
                        from = 133.322363925 * number * EngineeringCalculator.prefixMultiplier(fromPrefix, metricPrefixes);
                    }
                }
                switch (j) {
                    case 0: {
                        result = from / EngineeringCalculator.prefixMultiplier(toPrefix, metricPrefixes);
                        break;
                    }
                    case 1: {
                        result = 9.86923299998193E-6 * from / EngineeringCalculator.prefixMultiplier(toPrefix, metricPrefixes);
                        break;
                    }
                    case 2: {
                        result = 0.00750061707998627 * from / EngineeringCalculator.prefixMultiplier(toPrefix, metricPrefixes);
                    }
                }
            } else {
                return new PtgErr(PtgErr.ERROR_NA);
            }
        }
        if (j == -1 && (i = EngineeringCalculator.findUnits(fromUnits, forceUnits)) >= 0) {
            j = EngineeringCalculator.findUnits(toUnits, forceUnits);
            if (j > -1) {
                switch (i) {
                    case 0: {
                        from = number * EngineeringCalculator.prefixMultiplier(fromPrefix, metricPrefixes);
                        break;
                    }
                    case 1: {
                        from = 1.0E-5 * number * EngineeringCalculator.prefixMultiplier(fromPrefix, metricPrefixes);
                        break;
                    }
                    case 2: {
                        from = 4.448222 * number;
                    }
                }
                switch (j) {
                    case 0: {
                        result = from / EngineeringCalculator.prefixMultiplier(toPrefix, metricPrefixes);
                        break;
                    }
                    case 1: {
                        result = 100000.0 * from / EngineeringCalculator.prefixMultiplier(toPrefix, metricPrefixes);
                        break;
                    }
                    case 2: {
                        result = 0.224808923655339 * from;
                    }
                }
            } else {
                return new PtgErr(PtgErr.ERROR_NA);
            }
        }
        if (j == -1 && (i = EngineeringCalculator.findUnits(fromUnits, energyUnits)) >= 0) {
            j = EngineeringCalculator.findUnits(toUnits, energyUnits);
            if (j > -1) {
                switch (i) {
                    case 0: {
                        from = number * EngineeringCalculator.prefixMultiplier(fromPrefix, metricPrefixes);
                        break;
                    }
                    case 1: {
                        from = 1.000000480657E-7 * number * EngineeringCalculator.prefixMultiplier(fromPrefix, metricPrefixes);
                        break;
                    }
                    case 2: {
                        from = 4.18399101363672 * number * EngineeringCalculator.prefixMultiplier(fromPrefix, metricPrefixes);
                        break;
                    }
                    case 3: {
                        from = 4.18679484613929 * number * EngineeringCalculator.prefixMultiplier(fromPrefix, metricPrefixes);
                        break;
                    }
                    case 4: {
                        from = 1.60217646E-19 * number * EngineeringCalculator.prefixMultiplier(fromPrefix, metricPrefixes);
                        break;
                    }
                    case 5: {
                        from = 2684517.4131617 * number;
                        break;
                    }
                    case 6: {
                        from = 3599.9982055472 * number * EngineeringCalculator.prefixMultiplier(fromPrefix, metricPrefixes);
                        break;
                    }
                    case 7: {
                        from = 0.0421400003236424 * number;
                        break;
                    }
                    case 8: {
                        from = 1055.05813786749 * number;
                    }
                }
                switch (j) {
                    case 0: {
                        result = from / EngineeringCalculator.prefixMultiplier(toPrefix, metricPrefixes);
                        break;
                    }
                    case 1: {
                        result = 9999995.19343231 * from / EngineeringCalculator.prefixMultiplier(toPrefix, metricPrefixes);
                        break;
                    }
                    case 2: {
                        result = 0.239006249473467 * from / EngineeringCalculator.prefixMultiplier(toPrefix, metricPrefixes);
                        break;
                    }
                    case 3: {
                        result = 0.238846190642017 * from / EngineeringCalculator.prefixMultiplier(toPrefix, metricPrefixes);
                        break;
                    }
                    case 4: {
                        result = 6.241457E18 * from / EngineeringCalculator.prefixMultiplier(toPrefix, metricPrefixes);
                        break;
                    }
                    case 5: {
                        result = 3.72506430801E-7 * from;
                        break;
                    }
                    case 6: {
                        result = 2.77777916238711E-4 * from / EngineeringCalculator.prefixMultiplier(toPrefix, metricPrefixes);
                        break;
                    }
                    case 7: {
                        result = 23.7304222192651 * from;
                        break;
                    }
                    case 8: {
                        result = 9.47815067349015E-4 * from;
                    }
                }
            } else {
                return new PtgErr(PtgErr.ERROR_NA);
            }
        }
        if (j == -1 && (i = EngineeringCalculator.findUnits(fromUnits, powerUnits)) >= 0) {
            j = EngineeringCalculator.findUnits(toUnits, powerUnits);
            if (j > -1) {
                switch (i) {
                    case 0: {
                        from = number;
                        break;
                    }
                    case 1: {
                        from = 0.00134102006031908 * number * EngineeringCalculator.prefixMultiplier(fromPrefix, metricPrefixes);
                    }
                }
                switch (j) {
                    case 0: {
                        result = from;
                        break;
                    }
                    case 1: {
                        result = 745.701 * from / EngineeringCalculator.prefixMultiplier(toPrefix, metricPrefixes);
                    }
                }
            } else {
                return new PtgErr(PtgErr.ERROR_NA);
            }
        }
        if (j == -1 && (i = EngineeringCalculator.findUnits(fromUnits, magnetismUnits)) >= 0) {
            j = EngineeringCalculator.findUnits(toUnits, magnetismUnits);
            if (j > -1) {
                switch (i) {
                    case 0: {
                        from = number * EngineeringCalculator.prefixMultiplier(fromPrefix, metricPrefixes);
                        break;
                    }
                    case 1: {
                        from = 1.0E-4 * number * EngineeringCalculator.prefixMultiplier(fromPrefix, metricPrefixes);
                    }
                }
                switch (j) {
                    case 0: {
                        result = from / EngineeringCalculator.prefixMultiplier(toPrefix, metricPrefixes);
                        break;
                    }
                    case 1: {
                        result = 10000.0 * from / EngineeringCalculator.prefixMultiplier(toPrefix, metricPrefixes);
                    }
                }
            } else {
                return new PtgErr(PtgErr.ERROR_NA);
            }
        }
        if (j == -1 && (i = EngineeringCalculator.findUnits(fromUnits, temperatureUnits)) >= 0) {
            j = EngineeringCalculator.findUnits(toUnits, temperatureUnits);
            if (j > -1) {
                switch (i) {
                    case 0: {
                        from = number;
                        break;
                    }
                    case 1: {
                        from = (number - 32.0) / 1.8;
                        break;
                    }
                    case 2: {
                        from = number * EngineeringCalculator.prefixMultiplier(fromPrefix, metricPrefixes) - 273.15;
                    }
                }
                switch (j) {
                    case 0: {
                        result = from;
                        break;
                    }
                    case 1: {
                        result = from * 1.8 + 32.0;
                        break;
                    }
                    case 2: {
                        result = (273.15 + from) / EngineeringCalculator.prefixMultiplier(toPrefix, metricPrefixes);
                    }
                }
            } else {
                return new PtgErr(PtgErr.ERROR_NA);
            }
        }
        if (j == -1 && (i = EngineeringCalculator.findUnits(fromUnits, liquidMeasureUnits)) >= 0) {
            j = EngineeringCalculator.findUnits(toUnits, liquidMeasureUnits);
            if (j > -1) {
                switch (i) {
                    case 0: {
                        from = number;
                        break;
                    }
                    case 1: {
                        from = 3.0 * number;
                        break;
                    }
                    case 2: {
                        from = 6.0 * number;
                        break;
                    }
                    case 3: {
                        from = 48.0 * number;
                        break;
                    }
                    case 4: {
                        from = 96.0 * number;
                        break;
                    }
                    case 5: {
                        from = 115.266 * number;
                        break;
                    }
                    case 6: {
                        from = 192.0 * number;
                        break;
                    }
                    case 7: {
                        from = 768.0 * number;
                        break;
                    }
                    case 8: {
                        from = 202.84 * number * EngineeringCalculator.prefixMultiplier(fromPrefix, metricPrefixes);
                    }
                }
                switch (j) {
                    case 0: {
                        result = from;
                        break;
                    }
                    case 1: {
                        result = 0.333333333333333 * from;
                        break;
                    }
                    case 2: {
                        result = 0.166666666666667 * from;
                        break;
                    }
                    case 3: {
                        result = 0.0208333333333333 * from;
                        break;
                    }
                    case 4: {
                        result = 0.0104166666666667 * from;
                        break;
                    }
                    case 5: {
                        result = 0.0086755851682196 * from;
                        break;
                    }
                    case 6: {
                        result = 0.00520833333333333 * from;
                        break;
                    }
                    case 7: {
                        result = 0.00130208333333333 * from;
                        break;
                    }
                    case 8: {
                        result = 0.0049299940840071 * from / EngineeringCalculator.prefixMultiplier(toPrefix, metricPrefixes);
                    }
                }
            } else {
                return new PtgErr(PtgErr.ERROR_NA);
            }
        }
        PtgNumber pnum = new PtgNumber(result);
        if (DEBUG) {
            Logger.logInfo("Result from CONVERT= " + pnum.getString());
        }
        return pnum;
    }

    protected static Ptg calcDec2Bin(Ptg[] operands) {
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "DEC2BIN");
        }
        int dec = operands[0].getIntVal();
        int places = 0;
        if (operands.length > 1) {
            places = operands[1].getIntVal();
        }
        if (dec < -512 || dec > 511 || places < 0) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        String bString = Integer.toBinaryString(dec);
        if (dec < 0) {
            bString = bString.substring(Math.max(bString.length() - 10, 0));
        } else if (places > 0) {
            if (bString.length() > places) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            bString = "0000000000" + bString;
            bString = bString.substring(bString.length() - places);
        }
        PtgStr pstr = new PtgStr(bString);
        if (DEBUG) {
            Logger.logInfo("Result from DEC2BIN= " + pstr.getString());
        }
        return pstr;
    }

    protected static Ptg calcDec2Hex(Ptg[] operands) {
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "DEC2HEX");
        }
        long dec = PtgCalculator.getLongValue(operands[0]);
        int places = 0;
        if (operands.length > 1) {
            places = operands[1].getIntVal();
        }
        if (dec < -549755813888L || dec > 0x7FFFFFFFFFL || places < 0) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        String hString = Long.toHexString(dec).toUpperCase();
        if (dec < 0L) {
            hString = hString.substring(Math.max(hString.length() - 10, 0));
        } else if (places > 0) {
            if (hString.length() > places) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            hString = "0000000000" + hString;
            hString = hString.substring(hString.length() - places);
        }
        PtgStr pstr = new PtgStr(hString);
        if (DEBUG) {
            Logger.logInfo("Result from DEC2HEX= " + pstr.getString());
        }
        return pstr;
    }

    protected static Ptg calcDec2Oct(Ptg[] operands) {
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "DEC2OCT");
        }
        long dec = PtgCalculator.getLongValue(operands[0]);
        int places = 0;
        if (operands.length > 1) {
            places = operands[1].getIntVal();
        }
        if (dec < -536870912L || dec > 0x1FFFFFFFL || places < 0) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        String oString = Long.toOctalString(dec);
        if (dec < 0L) {
            oString = oString.substring(Math.max(oString.length() - 10, 0));
        } else if (places > 0) {
            if (oString.length() > places) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            oString = "0000000000" + oString;
            oString = oString.substring(oString.length() - places);
        }
        PtgStr pstr = new PtgStr(oString);
        if (DEBUG) {
            Logger.logInfo("Result from DEC2OCT= " + pstr.getString());
        }
        return pstr;
    }

    protected static Ptg calcDelta(Ptg[] operands) {
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "DELTA");
        }
        double number1 = operands[0].getDoubleVal();
        double number2 = 0.0;
        if (operands.length > 1) {
            number2 = operands[1].getDoubleVal();
        }
        boolean result = false;
        if (number1 == number2) {
            result = true;
        }
        PtgNumber pnum = new PtgNumber((double)result);
        if (DEBUG) {
            Logger.logInfo("Result from DELTA= " + pnum.getString());
        }
        return pnum;
    }

    private static double erf_try1(double x) {
        double t = x;
        double x2 = Math.pow(x, 2.0);
        double n = 1000.0;
        while (n >= 0.5) {
            t = x + n / t;
            n -= 0.5;
        }
        t = 1.0 / t;
        double tt = Math.exp(-x2) / Math.sqrt(Math.PI);
        return 1.0 - tt * t;
    }

    protected static Ptg calcErf(Ptg[] operands) throws FunctionNotSupportedException {
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        try {
            double result;
            double lower_limit = operands[0].getDoubleVal();
            double upper_limit = Double.NaN;
            if (operands.length == 2) {
                upper_limit = operands[1].getDoubleVal();
            }
            boolean neg = lower_limit < 0.0;
            double limit = lower_limit = Math.abs(lower_limit);
            if (limit < 0.005) {
                double r2 = 0.0;
                int i = 0;
                int n = 0;
                while (n < 12) {
                    double factor = 2.0 * (double)n + 1.0;
                    double z = Math.pow(limit, factor);
                    double zz = (double)MathFunctionCalculator.factorial(n) * factor;
                    double zzz = z / zz;
                    r2 = i % 2 != 0 ? (r2 -= zzz) : (r2 += zzz);
                    ++i;
                    ++n;
                }
                result = r2 * (2.0 / Math.sqrt(Math.PI));
            } else {
                result = EngineeringCalculator.erf_try1(limit);
            }
            if (neg) {
                result *= -1.0;
            }
            if (!Double.isNaN(upper_limit)) {
                Ptg result2 = EngineeringCalculator.calcErf(new Ptg[]{operands[1]});
                if (result2 instanceof PtgNumber) {
                    result = ((PtgNumber)result2).getDoubleVal() - result;
                } else {
                    return new PtgErr(PtgErr.ERROR_VALUE);
                }
            }
            return new PtgNumber(result);
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    public static double erf(double x) {
        return EngineeringCalculator.erfAS(x);
    }

    public static double erfc(double x) {
        return EngineeringCalculator.erfcAS(x);
    }

    private static double erfCody(double x) {
        double result = 0.0;
        double y = Math.abs(x);
        if (firstCall) {
            firstCall = false;
        }
        if (y <= 0.46875) {
            result = x * EngineeringCalculator.calcLower(y);
        } else {
            result = EngineeringCalculator.calcUpper(y);
            result = 0.5 - result + 0.5;
            if (x < 0.0) {
                result = -result;
            }
        }
        return result;
    }

    private static double erfcCody(double x) {
        double result = 0.0;
        double y = Math.abs(x);
        if (firstCall) {
            firstCall = false;
        }
        if (y <= 0.46875) {
            result = x * EngineeringCalculator.calcLower(y);
            result = 1.0 - result;
        } else {
            result = EngineeringCalculator.calcUpper(y);
            if (x < 0.0) {
                result = 2.0 - result;
            }
        }
        return result;
    }

    private static double calcLower(double y) {
        double ySq = 0.0;
        if (y > X_SMALL) {
            ySq = y * y;
        }
        double xNum = ERF_A[4] * ySq;
        double xDen = ySq;
        int i = 0;
        while (i < 3) {
            xNum = (xNum + ERF_A[i]) * ySq;
            xDen = (xDen + ERF_B[i]) * ySq;
            ++i;
        }
        double result = (xNum + ERF_A[3]) / (xDen + ERF_B[3]);
        return result;
    }

    private static double calcUpper(double y) {
        double ySq;
        double result;
        int i;
        if (y <= 4.0) {
            double xNum = ERF_C[8] * y;
            double xDen = y;
            i = 0;
            while (i < 7) {
                xNum = (xNum + ERF_C[i]) * y;
                xDen = (xDen + ERF_D[i]) * y;
                ++i;
            }
            result = (xNum + ERF_C[7]) / (xDen + ERF_D[7]);
        } else {
            result = 0.0;
            if (y >= X_HUGE) {
                result = SQRPI / y;
            } else {
                ySq = 1.0 / (y * y);
                double xNum = ERF_P[5] * ySq;
                double xDen = ySq;
                i = 0;
                while (i < 4) {
                    xNum = (xNum + ERF_P[i]) * ySq;
                    xDen = (xDen + ERF_Q[i]) * ySq;
                    ++i;
                }
                result = ySq * (xNum + ERF_P[4]) / (xDen + ERF_Q[4]);
                result = (SQRPI - result) / y;
            }
        }
        ySq = (double)Math.round(y * 16.0) / 16.0;
        double del = (y - ySq) * (y + ySq);
        result = Math.exp(-ySq * ySq) * Math.exp(-del) * result;
        return result;
    }

    private static double erfAS(double x) {
        if (firstCall) {
            firstCall = false;
        }
        if (x < 0.0) {
            return -EngineeringCalculator.erfAS(-x);
        }
        if (x < 2.0) {
            return EngineeringCalculator.erfSeries(x);
        }
        return EngineeringCalculator.erfRational(x);
    }

    private static double erfcAS(double x) {
        if (firstCall) {
            firstCall = false;
        }
        return 1.0 - EngineeringCalculator.erfAS(x);
    }

    private static double erfSeries(double x) {
        double erfo;
        double an;
        double ak;
        double eps = 1.0E-8;
        int kmax = 50;
        double erf = ak = x;
        int k = 1;
        while (!EngineeringCalculator.hasConverged(erf += (an = (ak *= -x * x / (double)k) / (2.0 * (double)k + 1.0)), erfo = erf, 1.0E-8, ++k, 50)) {
        }
        return TSQPI * erf;
    }

    public static boolean hasConverged(double xn, double xo, double eps, int n, int max) {
        if (EngineeringCalculator.hasReachedAccuracy(xn, xo, eps)) {
            return true;
        }
        if (n >= max) {
            throw new ArithmeticException();
        }
        return false;
    }

    public static boolean hasReachedAccuracy(double xn, double xo, double eps) {
        double z = Math.abs(xn + xo) / 2.0;
        double error = Math.abs(xn - xo);
        if (z > 1.0) {
            error /= z;
        }
        return error <= eps;
    }

    private static double erfRational(double x) {
        double[] a = new double[]{0.254829592, -0.284496736, 1.421413741, -1.453152027, 1.061405429};
        double p = 0.3275911;
        double r2 = 0.0;
        double t = 1.0 / (1.0 + 0.3275911 * x);
        int i = 4;
        while (i >= 0) {
            r2 = a[i] + r2 * t;
            --i;
        }
        double erf = 1.0 - t * r2 * Math.exp(-x * x);
        return erf;
    }

    static double getDEPS() {
        float feps = 2.0E-6f;
        float fy = 1.0f + feps;
        while (fy > 1.0f) {
            fy = 1.0f + (feps /= 2.0f);
        }
        double deps = feps * 2.0E-6f;
        double dy = 1.0 + deps;
        while (dy > 1.0) {
            dy = 1.0 + (deps /= 2.0);
        }
        return deps;
    }

    protected static Ptg calcGEStep(Ptg[] operands) {
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "GESTEP");
        }
        double number = operands[0].getDoubleVal();
        double step = 0.0;
        if (operands.length > 1) {
            step = operands[1].getDoubleVal();
        }
        boolean result = false;
        if (number >= step) {
            result = true;
        }
        PtgNumber pnum = new PtgNumber((double)result);
        if (DEBUG) {
            Logger.logInfo("Result from GESTEP= " + pnum.getString());
        }
        return pnum;
    }

    protected static Ptg calcHex2Bin(Ptg[] operands) {
        String bString;
        long dec;
        String hString;
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "HEX2BIN");
        }
        if ((hString = operands[0].getString().trim()).length() > 10) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        int places = 0;
        if (operands.length > 1) {
            places = operands[1].getIntVal();
        }
        try {
            dec = Long.parseLong(hString, 16);
            if (dec >= 0x8000000000L) {
                dec -= 0x10000000000L;
            }
            bString = Long.toBinaryString(dec);
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        if (dec < -512L || dec > 511L || places < 0) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        if (dec < 0L) {
            bString = bString.substring(Math.max(bString.length() - 10, 0));
        } else if (places > 0) {
            if (bString.length() > places) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            bString = "0000000000" + bString;
            bString = bString.substring(bString.length() - places);
        }
        PtgStr pstr = new PtgStr(bString);
        if (DEBUG) {
            Logger.logInfo("Result from HEX2BIN= " + pstr.getString());
        }
        return pstr;
    }

    protected static Ptg calcHex2Dec(Ptg[] operands) {
        long dec;
        String hString;
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "HEX2DEC");
        }
        if ((hString = operands[0].getString().trim()).length() > 10) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        try {
            dec = Long.parseLong(hString, 16);
            if (dec >= 0x8000000000L) {
                dec -= 0x10000000000L;
            }
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        PtgNumber pnum = new PtgNumber(dec);
        if (DEBUG) {
            Logger.logInfo("Result from HEX2DEC= " + pnum.getVal());
        }
        return pnum;
    }

    protected static Ptg calcHex2Oct(Ptg[] operands) {
        String oString;
        long dec;
        String hString;
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "HEX2OCT");
        }
        if ((hString = operands[0].getString().trim()).length() > 10) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        int places = 0;
        if (operands.length > 1) {
            places = operands[1].getIntVal();
        }
        try {
            dec = Long.parseLong(hString, 16);
            if (dec >= 0x8000000000L) {
                dec -= 0x10000000000L;
            }
            oString = Long.toOctalString(dec);
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        if (dec < -536870912L || dec > 0x1FFFFFFFL || places < 0) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        if (dec < 0L) {
            oString = oString.substring(Math.max(oString.length() - 10, 0));
        } else if (places > 0) {
            if (oString.length() > places) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            oString = "0000000000" + oString;
            oString = oString.substring(oString.length() - places);
        }
        PtgStr pstr = new PtgStr(oString);
        if (DEBUG) {
            Logger.logInfo("Result from HEX2OCT= " + pstr.getString());
        }
        return pstr;
    }

    private static Complex imParseComplexNumber(String complexNumber) throws NumberFormatException {
        Complex c = new Complex();
        if (complexNumber.length() > 0) {
            try {
                int i = complexNumber.length();
                if (complexNumber.substring(i - 1, i).equals("i") || complexNumber.substring(i - 1, i).equals("j")) {
                    String s;
                    c.suffix = complexNumber.substring(i - 1, i);
                    i -= 2;
                    while (i >= 0 && !complexNumber.substring(i, i + 1).equals("+") && !complexNumber.substring(i, i + 1).equals("-")) {
                        --i;
                    }
                    if (i < 0) {
                        complexNumber = "+" + complexNumber;
                        ++i;
                    }
                    if ((s = complexNumber.substring(i, complexNumber.length() - 1)).length() == 1) {
                        s = String.valueOf(s) + "1";
                    }
                    c.imaginary = Double.parseDouble(s);
                }
                if (i > 0) {
                    c.real = Double.parseDouble(complexNumber.substring(0, i));
                }
            }
            catch (Exception e) {
                throw new NumberFormatException();
            }
        }
        return c;
    }

    private static String imGetExcelStr(double d, int precision) {
        if (d == (double)((int)d)) {
            if ((int)d == 1) {
                return "";
            }
            return String.valueOf((int)d);
        }
        double r2 = Math.pow(10.0, precision);
        d *= r2;
        d = Math.round(d);
        return String.valueOf(d /= r2);
    }

    private static String imGetExcelStr(double d) {
        return EngineeringCalculator.imGetExcelStr(d, 15);
    }

    protected static Ptg calcImAbs(Ptg[] operands) {
        Complex c;
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "IMABS");
        }
        String complexString = StringTool.allTrim(operands[0].getString());
        try {
            c = EngineeringCalculator.imParseComplexNumber(complexString);
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double result = Math.sqrt(Math.pow(c.real, 2.0) + Math.pow(c.imaginary, 2.0));
        PtgNumber pnum = new PtgNumber(result);
        if (DEBUG) {
            Logger.logInfo("Result from IMABS= " + pnum.getString());
        }
        return pnum;
    }

    protected static Ptg calcImaginary(Ptg[] operands) {
        Complex c;
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "Imaginary");
        }
        String complexString = StringTool.allTrim(operands[0].getString());
        try {
            c = EngineeringCalculator.imParseComplexNumber(complexString);
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        PtgNumber pnum = new PtgNumber(c.imaginary);
        if (DEBUG) {
            Logger.logInfo("Result from IMAGINARY= " + pnum.getString());
        }
        return pnum;
    }

    protected static Ptg calcImArgument(Ptg[] operands) {
        Complex c;
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "ImArgument");
        }
        String complexString = StringTool.allTrim(operands[0].getString());
        try {
            c = EngineeringCalculator.imParseComplexNumber(complexString);
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double result = Math.atan(c.imaginary / c.real);
        PtgNumber pnum = new PtgNumber(result);
        if (DEBUG) {
            Logger.logInfo("Result from IMARGUMENT= " + pnum.getString());
        }
        return pnum;
    }

    protected static Ptg calcImConjugate(Ptg[] operands) {
        Complex c;
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "ImCongugate");
        }
        String complexString = StringTool.allTrim(operands[0].getString());
        try {
            c = EngineeringCalculator.imParseComplexNumber(complexString);
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        String congugate = c.real != 0.0 && c.imaginary != 0.0 ? String.valueOf(EngineeringCalculator.imGetExcelStr(c.real)) + (c.imaginary < 0.0 ? "+" : "-") + EngineeringCalculator.imGetExcelStr(Math.abs(c.imaginary)) + c.suffix : (c.real == 0.0 ? String.valueOf(EngineeringCalculator.imGetExcelStr(Math.abs(c.imaginary))) + c.suffix : EngineeringCalculator.imGetExcelStr(c.real));
        PtgStr pstr = new PtgStr(congugate);
        if (DEBUG) {
            Logger.logInfo("Result from IMCONGUGATE= " + pstr.getString());
        }
        return pstr;
    }

    protected static Ptg calcImCos(Ptg[] operands) {
        Complex c;
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "ImCos");
        }
        String complexString = StringTool.allTrim(operands[0].getString());
        try {
            c = EngineeringCalculator.imParseComplexNumber(complexString);
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double cosh = (Math.pow(Math.E, c.imaginary) + Math.pow(Math.E, c.imaginary * -1.0)) / 2.0;
        double sinh = (Math.pow(Math.E, c.imaginary) - Math.pow(Math.E, c.imaginary * -1.0)) / 2.0;
        double a = Math.cos(c.real) * cosh;
        double b = Math.sin(c.real) * sinh;
        String imCos = b < 0.0 ? String.valueOf(EngineeringCalculator.imGetExcelStr(a)) + "+" + EngineeringCalculator.imGetExcelStr(Math.abs(b)) + c.suffix : String.valueOf(EngineeringCalculator.imGetExcelStr(a)) + "-" + EngineeringCalculator.imGetExcelStr(b) + c.suffix;
        PtgStr pstr = new PtgStr(imCos);
        if (DEBUG) {
            Logger.logInfo("Result from IMCOS= " + pstr.getString());
        }
        return pstr;
    }

    protected static Ptg calcImDiv(Ptg[] operands) {
        Complex c2;
        Complex c1;
        if (operands.length < 2) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "IMDIV");
        }
        String complexString1 = StringTool.allTrim(operands[0].getString());
        String complexString2 = StringTool.allTrim(operands[1].getString());
        try {
            c1 = EngineeringCalculator.imParseComplexNumber(complexString1);
            c2 = EngineeringCalculator.imParseComplexNumber(complexString2);
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double divisor = Math.pow(c2.real, 2.0) + Math.pow(c2.imaginary, 2.0);
        double a = c1.real * c2.real + c1.imaginary * c2.imaginary;
        double b = c1.imaginary * c2.real - c1.real * c2.imaginary;
        double c = a / divisor;
        double d = b / divisor;
        String imDiv = d > 0.0 ? String.valueOf(EngineeringCalculator.imGetExcelStr(c)) + "+" + EngineeringCalculator.imGetExcelStr(d) + "i" : String.valueOf(EngineeringCalculator.imGetExcelStr(c)) + "-" + EngineeringCalculator.imGetExcelStr(d) + "i";
        PtgStr pstr = new PtgStr(imDiv);
        if (DEBUG) {
            Logger.logInfo("Result from IMDIV= " + pstr.getString());
        }
        return pstr;
    }

    protected static Ptg calcImExp(Ptg[] operands) {
        Complex c;
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "ImExp");
        }
        String complexString = StringTool.allTrim(operands[0].getString());
        try {
            c = EngineeringCalculator.imParseComplexNumber(complexString);
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double e_x = Math.pow(Math.E, c.real);
        double a = e_x * Math.cos(c.imaginary);
        double b = e_x * Math.sin(c.imaginary);
        String imExp = b > 0.0 ? String.valueOf(EngineeringCalculator.imGetExcelStr(a)) + "+" + EngineeringCalculator.imGetExcelStr(b) + c.suffix : String.valueOf(EngineeringCalculator.imGetExcelStr(a)) + EngineeringCalculator.imGetExcelStr(b) + c.suffix;
        PtgStr pstr = new PtgStr(imExp);
        if (DEBUG) {
            Logger.logInfo("Result from IMEXP= " + pstr.getString());
        }
        return pstr;
    }

    protected static Ptg calcImLn(Ptg[] operands) {
        Complex c;
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "ImLn");
        }
        String complexString = StringTool.allTrim(operands[0].getString());
        try {
            c = EngineeringCalculator.imParseComplexNumber(complexString);
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double a = Math.pow(c.real, 2.0) + Math.pow(c.imaginary, 2.0);
        a = Math.sqrt(a);
        a = Math.log(a);
        double b = Math.atan(c.imaginary / c.real);
        String imLn = b > 0.0 ? String.valueOf(EngineeringCalculator.imGetExcelStr(a)) + "+" + EngineeringCalculator.imGetExcelStr(b) + c.suffix : String.valueOf(EngineeringCalculator.imGetExcelStr(a)) + EngineeringCalculator.imGetExcelStr(b) + c.suffix;
        PtgStr pstr = new PtgStr(imLn);
        if (DEBUG) {
            Logger.logInfo("Result from IMLN= " + pstr.getString());
        }
        return pstr;
    }

    protected static Ptg calcImLog10(Ptg[] operands) {
        Complex c;
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "ImLog10");
        }
        String complexString = StringTool.allTrim(operands[0].getString());
        try {
            c = EngineeringCalculator.imParseComplexNumber(complexString);
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double a = Math.pow(c.real, 2.0) + Math.pow(c.imaginary, 2.0);
        a = Math.sqrt(a);
        a = Math.log(a);
        double b = Math.atan(c.imaginary / c.real);
        double logE = Math.log(Math.E) / Math.log(10.0);
        String imLog10 = b > 0.0 ? String.valueOf(EngineeringCalculator.imGetExcelStr(a)) + "+" + EngineeringCalculator.imGetExcelStr(b) + c.suffix : String.valueOf(EngineeringCalculator.imGetExcelStr(a *= logE)) + EngineeringCalculator.imGetExcelStr(b *= logE) + c.suffix;
        PtgStr pstr = new PtgStr(imLog10);
        if (DEBUG) {
            Logger.logInfo("Result from IMLOG10= " + pstr.getString());
        }
        return pstr;
    }

    protected static Ptg calcImLog2(Ptg[] operands) {
        Complex c;
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "ImLog2");
        }
        String complexString = StringTool.allTrim(operands[0].getString());
        try {
            c = EngineeringCalculator.imParseComplexNumber(complexString);
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double a = Math.pow(c.real, 2.0) + Math.pow(c.imaginary, 2.0);
        a = Math.sqrt(a);
        a = Math.log(a);
        double b = Math.atan(c.imaginary / c.real);
        double logE = Math.log(Math.E) / Math.log(2.0);
        String imLog2 = b > 0.0 ? String.valueOf(EngineeringCalculator.imGetExcelStr(a, 8)) + "+" + EngineeringCalculator.imGetExcelStr(b, 8) + c.suffix : String.valueOf(EngineeringCalculator.imGetExcelStr(a *= logE, 8)) + EngineeringCalculator.imGetExcelStr(b *= logE, 8) + c.suffix;
        PtgStr pstr = new PtgStr(imLog2);
        if (DEBUG) {
            Logger.logInfo("Result from IMLOG2= " + pstr.getString());
        }
        return pstr;
    }

    protected static Ptg calcImPower(Ptg[] operands) {
        Complex c;
        if (operands.length < 2) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "ImPower");
        }
        String complexString = StringTool.allTrim(operands[0].getString());
        double n = operands[1].getDoubleVal();
        try {
            c = EngineeringCalculator.imParseComplexNumber(complexString);
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double r2 = Math.pow(c.real, 2.0) + Math.pow(c.imaginary, 2.0);
        r2 = Math.sqrt(r2);
        r2 = Math.pow(r2, n);
        double t = Math.atan(c.imaginary / c.real);
        double a = r2 * Math.cos(n * t);
        double b = r2 * Math.sin(n * t);
        String imPower = b > 0.0 ? String.valueOf(EngineeringCalculator.imGetExcelStr(a)) + "+" + EngineeringCalculator.imGetExcelStr(b) + c.suffix : String.valueOf(EngineeringCalculator.imGetExcelStr(a)) + EngineeringCalculator.imGetExcelStr(b) + c.suffix;
        PtgStr pstr = new PtgStr(imPower);
        if (DEBUG) {
            Logger.logInfo("Result from IMPOWER= " + pstr.getString());
        }
        return pstr;
    }

    protected static Ptg calcImProduct(Ptg[] operands) {
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "IMPRODUCT");
        }
        Ptg[] ops = PtgCalculator.getAllComponents(operands);
        String[] complexStrings = new String[ops.length];
        int i = 0;
        while (i < ops.length) {
            complexStrings[i] = StringTool.allTrim(ops[i].getString());
            ++i;
        }
        Complex[] c = new Complex[complexStrings.length];
        int i2 = 0;
        while (i2 < complexStrings.length) {
            try {
                c[i2] = EngineeringCalculator.imParseComplexNumber(complexStrings[i2]);
            }
            catch (Exception e) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            ++i2;
        }
        i2 = 1;
        while (i2 < c.length) {
            double a = c[0].real;
            double b = c[0].imaginary;
            c[0].real = a * c[i2].real - b * c[i2].imaginary;
            c[0].imaginary = a * c[i2].imaginary + b * c[i2].real;
            ++i2;
        }
        String imSum = c[0].imaginary > 0.0 ? String.valueOf(EngineeringCalculator.imGetExcelStr(c[0].real)) + "+" + EngineeringCalculator.imGetExcelStr(c[0].imaginary) + c[0].suffix : String.valueOf(EngineeringCalculator.imGetExcelStr(c[0].real)) + EngineeringCalculator.imGetExcelStr(c[0].imaginary) + c[0].suffix;
        PtgStr pstr = new PtgStr(imSum);
        if (DEBUG) {
            Logger.logInfo("Result from IMSPRODUCT= " + pstr.getString());
        }
        return pstr;
    }

    protected static Ptg calcImReal(Ptg[] operands) {
        Complex c;
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "IMREAL");
        }
        String complexString = StringTool.allTrim(operands[0].getString());
        try {
            c = EngineeringCalculator.imParseComplexNumber(complexString);
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        PtgNumber pnum = new PtgNumber(c.real);
        if (DEBUG) {
            Logger.logInfo("Result from IMREAL= " + pnum.getString());
        }
        return pnum;
    }

    protected static Ptg calcImSin(Ptg[] operands) {
        Complex c;
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "ImSin");
        }
        String complexString = StringTool.allTrim(operands[0].getString());
        try {
            c = EngineeringCalculator.imParseComplexNumber(complexString);
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double cosh = (Math.pow(Math.E, c.imaginary) + Math.pow(Math.E, c.imaginary * -1.0)) / 2.0;
        double sinh = (Math.pow(Math.E, c.imaginary) - Math.pow(Math.E, c.imaginary * -1.0)) / 2.0;
        double a = Math.sin(c.real) * cosh;
        double b = Math.cos(c.real) * sinh;
        String imSin = b > 0.0 ? String.valueOf(EngineeringCalculator.imGetExcelStr(a)) + "+" + EngineeringCalculator.imGetExcelStr(b) + c.suffix : String.valueOf(EngineeringCalculator.imGetExcelStr(a)) + EngineeringCalculator.imGetExcelStr(b) + c.suffix;
        PtgStr pstr = new PtgStr(imSin);
        if (DEBUG) {
            Logger.logInfo("Result from IMSIN= " + pstr.getString());
        }
        return pstr;
    }

    protected static Ptg calcImSqrt(Ptg[] operands) {
        Complex c;
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "ImSqrt");
        }
        String complexString = StringTool.allTrim(operands[0].getString());
        try {
            c = EngineeringCalculator.imParseComplexNumber(complexString);
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double r2 = Math.pow(c.real, 2.0) + Math.pow(c.imaginary, 2.0);
        r2 = Math.sqrt(r2);
        r2 = Math.sqrt(r2);
        double t = Math.atan(c.imaginary / c.real);
        double a = r2 * Math.cos(t / 2.0);
        double b = r2 * Math.sin(t / 2.0);
        String imSqrt = b > 0.0 ? String.valueOf(EngineeringCalculator.imGetExcelStr(a)) + "+" + EngineeringCalculator.imGetExcelStr(b) + c.suffix : String.valueOf(EngineeringCalculator.imGetExcelStr(a)) + EngineeringCalculator.imGetExcelStr(b) + c.suffix;
        PtgStr pstr = new PtgStr(imSqrt);
        if (DEBUG) {
            Logger.logInfo("Result from IMSQRT= " + pstr.getString());
        }
        return pstr;
    }

    protected static Ptg calcImSub(Ptg[] operands) {
        Complex c2;
        Complex c1;
        if (operands.length < 2) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "IMSUB");
        }
        String complexString1 = StringTool.allTrim(operands[0].getString());
        String complexString2 = StringTool.allTrim(operands[1].getString());
        try {
            c1 = EngineeringCalculator.imParseComplexNumber(complexString1);
            c2 = EngineeringCalculator.imParseComplexNumber(complexString2);
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double a = c1.real - c2.real;
        double b = c1.imaginary - c2.imaginary;
        String imSub = b > 0.0 ? String.valueOf(EngineeringCalculator.imGetExcelStr(a)) + "+" + EngineeringCalculator.imGetExcelStr(b) + c1.suffix : String.valueOf(EngineeringCalculator.imGetExcelStr(a)) + EngineeringCalculator.imGetExcelStr(b) + c1.suffix;
        PtgStr pstr = new PtgStr(imSub);
        if (DEBUG) {
            Logger.logInfo("Result from IMSUB= " + pstr.getString());
        }
        return pstr;
    }

    protected static Ptg calcImSum(Ptg[] operands) {
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "IMSUM");
        }
        Ptg[] ops = PtgCalculator.getAllComponents(operands);
        String[] complexStrings = new String[ops.length];
        int i = 0;
        while (i < ops.length) {
            complexStrings[i] = StringTool.allTrim(ops[i].getString());
            ++i;
        }
        Complex[] c = new Complex[complexStrings.length];
        int i2 = 0;
        while (i2 < complexStrings.length) {
            try {
                c[i2] = EngineeringCalculator.imParseComplexNumber(complexStrings[i2]);
            }
            catch (Exception e) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            ++i2;
        }
        i2 = 1;
        while (i2 < c.length) {
            c[0].real += c[i2].real;
            c[0].imaginary += c[i2].imaginary;
            ++i2;
        }
        String imSum = c[0].imaginary > 0.0 ? String.valueOf(EngineeringCalculator.imGetExcelStr(c[0].real)) + "+" + EngineeringCalculator.imGetExcelStr(c[0].imaginary) + c[0].suffix : String.valueOf(EngineeringCalculator.imGetExcelStr(c[0].real)) + EngineeringCalculator.imGetExcelStr(c[0].imaginary) + c[0].suffix;
        PtgStr pstr = new PtgStr(imSum);
        if (DEBUG) {
            Logger.logInfo("Result from IMSUM= " + pstr.getString());
        }
        return pstr;
    }

    protected static Ptg calcOct2Bin(Ptg[] operands) {
        String bString;
        long dec;
        long l;
        String oString;
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "OCT2BIN");
        }
        if ((oString = String.valueOf(l = (long)operands[0].getDoubleVal()).trim()).length() > 10) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        int places = 0;
        if (operands.length > 1) {
            places = operands[1].getIntVal();
        }
        try {
            dec = Long.parseLong(oString, 8);
            if (dec >= 0x20000000L) {
                dec -= 0x40000000L;
            }
            bString = Long.toBinaryString(dec);
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        if (dec < -512L || dec > 511L || places < 0) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        if (dec < 0L) {
            bString = bString.substring(Math.max(bString.length() - 10, 0));
        } else if (places > 0) {
            if (bString.length() > places) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            bString = "0000000000" + bString;
            bString = bString.substring(bString.length() - places);
        }
        PtgStr pstr = new PtgStr(bString);
        if (DEBUG) {
            Logger.logInfo("Result from OCT2BIN= " + pstr.getString());
        }
        return pstr;
    }

    protected static Ptg calcOct2Dec(Ptg[] operands) {
        long dec;
        long l;
        String oString;
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "OCT2DEC");
        }
        if ((oString = String.valueOf(l = (long)operands[0].getDoubleVal()).trim()).length() > 10) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        try {
            dec = Long.parseLong(oString, 8);
            if (dec >= 0x20000000L) {
                dec -= 0x40000000L;
            }
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        PtgNumber pnum = new PtgNumber(dec);
        if (DEBUG) {
            Logger.logInfo("Result from OCT2DEC= " + pnum.getVal());
        }
        return pnum;
    }

    protected static Ptg calcOct2Hex(Ptg[] operands) {
        String hString;
        long dec;
        long l;
        String oString;
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            EngineeringCalculator.debugOperands(operands, "OCT2HEX");
        }
        if ((oString = String.valueOf(l = (long)operands[0].getDoubleVal()).trim()).length() > 10) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        int places = 0;
        if (operands.length > 1) {
            places = operands[1].getIntVal();
        }
        try {
            dec = Long.parseLong(oString, 8);
            if (dec >= 0x20000000L) {
                dec -= 0x40000000L;
            }
            hString = Long.toHexString(dec).toUpperCase();
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        if (dec < 0L) {
            hString = hString.substring(Math.max(hString.length() - 10, 0));
        } else if (places > 0) {
            if (hString.length() > places) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            hString = "0000000000" + hString;
            hString = hString.substring(hString.length() - places);
        }
        PtgStr pstr = new PtgStr(hString);
        if (DEBUG) {
            Logger.logInfo("Result from OCT2HEX= " + pstr.getString());
        }
        return pstr;
    }

    static void debugOperands(Ptg[] operands, String f) {
        if (DEBUG) {
            Logger.logInfo("Operands for " + f);
            int i = 0;
            while (i < operands.length) {
                String s = operands[i].getString();
                if (!(operands[i] instanceof PtgMissArg)) {
                    String v = operands[i].getValue().toString();
                    Logger.logInfo("\tOperand[" + i + "]=" + s + " " + v);
                } else {
                    Logger.logInfo("\tOperand[" + i + "]=" + s + " is Missing");
                }
                ++i;
            }
        }
    }
}

