/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.FunctionNotSupportedException;
import com.extentech.formats.XLS.formulas.CalculationException;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgAtr;
import com.extentech.formats.XLS.formulas.PtgErr;
import com.extentech.toolkit.Logger;
import java.util.Stack;

public class FormulaCalculator {
    private static boolean DEBUG = false;

    public static Object calculateFormula(Stack expression) throws FunctionNotSupportedException {
        int sz = expression.size();
        Ptg[] stck = new Ptg[sz];
        stck = expression.toArray(stck);
        Stack<Ptg> calcStack = new Stack<Ptg>();
        int t = 0;
        while (t < sz) {
            calcStack.add(0, stck[t]);
            ++t;
        }
        Stack tempstack = new Stack();
        Stack<Ptg> newstck = calcStack;
        while (!newstck.isEmpty()) {
            FormulaCalculator.handlePtg(newstck, tempstack);
        }
        Ptg finalptg = (Ptg)tempstack.pop();
        return finalptg.getValue();
    }

    public static Ptg calculateFormulaPtg(Stack expression) throws FunctionNotSupportedException {
        int sz = expression.size();
        Ptg[] stck = new Ptg[sz];
        stck = expression.toArray(stck);
        Stack<Ptg> calcStack = new Stack<Ptg>();
        int t = 0;
        while (t < sz) {
            calcStack.add(0, stck[t]);
            ++t;
        }
        Stack tempstack = new Stack();
        Stack<Ptg> newstck = calcStack;
        while (!newstck.isEmpty()) {
            FormulaCalculator.handlePtg(newstck, tempstack);
        }
        Ptg finalptg = (Ptg)tempstack.pop();
        return finalptg;
    }

    static void handlePtg(Stack newstck, Stack vals) throws FunctionNotSupportedException {
        Ptg p = (Ptg)newstck.pop();
        int x = 0;
        int t = 0;
        if (p.getIsOperator() || p.getIsControl() || p.getIsFunction()) {
            block19: {
                if (p.getIsControl() && !vals.isEmpty()) {
                    if (p.getOpcode() == 21) {
                        return;
                    }
                    if (DEBUG) {
                        Logger.logInfo("opr: " + p.toString());
                    }
                }
                if (p.getIsBinaryOperator()) {
                    t = 2;
                }
                if (p.getIsUnaryOperator()) {
                    t = 1;
                }
                if (p.getIsStandAloneOperator()) {
                    t = 0;
                }
                if (p.getOpcode() == 34 || p.getOpcode() == 66 || p.getOpcode() == 98) {
                    t = p.getNumParams();
                }
                if (p.getOpcode() == 33 || p.getOpcode() == 65 || p.getOpcode() == 97) {
                    t = p.getNumParams();
                }
                Ptg[] vx = new Ptg[t];
                while (x < t) {
                    vx[t - 1 - x] = (Ptg)vals.pop();
                    ++x;
                }
                try {
                    p = p.calculatePtg(vx);
                }
                catch (CalculationException e) {
                    p = new PtgErr(e.getErrorCode());
                    if (!e.getName().equals("#CIR_ERR!")) break block19;
                    ((PtgErr)p).setCircularError(true);
                }
            }
            if (DEBUG) {
                String adr = "";
                if (p.getParentRec() != null) {
                    adr = "addr: " + p.getParentRec().getCellAddress();
                }
                Logger.logInfo(String.valueOf(adr) + " val: " + p.toString());
            }
            vals.push(p);
        } else if (p.getIsOperand()) {
            if (DEBUG) {
                Logger.logInfo("opr: " + p.toString());
            }
            vals.push(p);
        } else if (!(p instanceof PtgAtr)) {
            throw new FunctionNotSupportedException("WARNING: Calculating Formula failed: Unsupported/Incorrect Ptg Type: 0x" + p.getOpcode() + " " + p.getString());
        }
    }
}

