/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.formats.XLS.Array;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.FunctionNotSupportedException;
import com.extentech.formats.XLS.Name;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.formulas.Calculator;
import com.extentech.formats.XLS.formulas.FormulaParser;
import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgArea;
import com.extentech.formats.XLS.formulas.PtgArea3d;
import com.extentech.formats.XLS.formulas.PtgArray;
import com.extentech.formats.XLS.formulas.PtgBool;
import com.extentech.formats.XLS.formulas.PtgErr;
import com.extentech.formats.XLS.formulas.PtgFuncVar;
import com.extentech.formats.XLS.formulas.PtgInt;
import com.extentech.formats.XLS.formulas.PtgMemFunc;
import com.extentech.formats.XLS.formulas.PtgMystery;
import com.extentech.formats.XLS.formulas.PtgName;
import com.extentech.formats.XLS.formulas.PtgNumber;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.formats.XLS.formulas.PtgRef3d;
import com.extentech.formats.XLS.formulas.PtgRefErr;
import com.extentech.formats.XLS.formulas.PtgStr;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;

public class LookupReferenceCalculator {
    protected static Ptg calcAddress(Ptg[] operands) {
        if (operands.length < 2) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        String rx1 = operands[0].getValue().toString();
        if (rx1.indexOf(".") > -1) {
            rx1 = rx1.substring(0, rx1.indexOf("."));
        }
        int row = Integer.valueOf(rx1);
        String cx1 = operands[1].getValue().toString();
        if (cx1.indexOf(".") > -1) {
            cx1 = cx1.substring(0, cx1.indexOf("."));
        }
        int col = Integer.valueOf(cx1);
        int abs_num = 1;
        boolean ref_style = true;
        String sheettext = "";
        if (operands.length > 2 && operands[2].getValue() != null) {
            abs_num = (Integer)operands[2].getValue();
        }
        if (operands.length > 3 && operands[3].getValue() != null) {
            Boolean b = Boolean.valueOf(String.valueOf(operands[3].getValue()));
            ref_style = b;
        }
        if (operands.length > 4 && operands[4].getValue() != null) {
            sheettext = String.valueOf((String)operands[4].getValue()) + "!";
        }
        String loc = "";
        String colstr = ExcelTools.getAlphaVal(col - 1);
        if (ref_style) {
            if (abs_num == 1) {
                loc = "$" + colstr + "$" + row;
            } else if (abs_num == 2) {
                loc = String.valueOf(colstr) + "$" + row;
            } else if (abs_num == 3) {
                loc = "$" + colstr + row;
            } else if (abs_num == 4) {
                loc = String.valueOf(colstr) + row;
            }
        } else if (abs_num == 1) {
            loc = "R" + row + "C" + col;
        } else if (abs_num == 2) {
            loc = "R" + row + "C[" + col + "]";
        } else if (abs_num == 3) {
            loc = "R[" + row + "]C" + col;
        } else if (abs_num == 4) {
            loc = "R[" + row + "]C[" + col + "]";
        }
        loc = String.valueOf(sheettext) + loc;
        return new PtgStr(loc);
    }

    protected static Ptg calcAreas(Ptg[] operands) {
        Ptg ref = operands[0];
        String s = ref.toString();
        String[] areas = s.split(",(?=([^'|\"]*'[^'|\"]*'|\")*[^'|\"]*$)");
        return new PtgNumber(areas.length);
    }

    protected static Ptg calcChoose(Ptg[] operands) {
        if (operands.length < 2) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        Object o = operands[0].getValue();
        try {
            Double dd = new Double(o.toString());
            double e = dd;
            int i = (int)e;
            if (i > operands.length + 1 || i < 1) {
                return new PtgErr(PtgErr.ERROR_REF);
            }
            o = operands[i].getValue();
            Double d = (Double)o;
            return new PtgNumber(d);
        }
        catch (Exception ex) {
            new PtgErr(PtgErr.ERROR_VALUE);
            return new PtgStr(o.toString());
        }
    }

    protected static Ptg calcColumn(Ptg[] operands) {
        if (operands[0] instanceof PtgFuncVar) {
            PtgFuncVar pfunk = (PtgFuncVar)operands[0];
            try {
                int loc = pfunk.getParentRec().getColNumber();
                return new PtgInt(++loc);
            }
            catch (Exception loc) {}
        } else {
            try {
                if (operands[0] instanceof PtgArea) {
                    PtgArea pa = (PtgArea)operands[0];
                    int[] loc = pa.getIntLocation();
                    return new PtgInt(loc[1] + 1);
                }
                if (operands[0] instanceof PtgRef) {
                    PtgRef pref = (PtgRef)operands[0];
                    int loc = pref.getIntLocation()[1];
                    return new PtgInt(++loc);
                }
                if (operands[0] instanceof PtgName) {
                    String range = ((PtgName)operands[0]).getName().getLocation();
                    int[] loc = ExcelTools.getRangeCoords(range);
                    return new PtgInt(loc[1] + 1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new PtgInt(-1);
    }

    protected static Ptg calcColumns(Ptg[] operands) {
        if (operands[0] instanceof PtgFuncVar) {
            PtgFuncVar pfunk = (PtgFuncVar)operands[0];
            try {
                int loc = pfunk.getParentRec().getColNumber();
                return new PtgInt(++loc);
            }
            catch (Exception loc) {}
        } else {
            try {
                if (operands[0] instanceof PtgArea) {
                    PtgArea pa = (PtgArea)operands[0];
                    int[] loc = pa.getIntLocation();
                    int ncols = loc[3] - loc[1] + 1;
                    return new PtgInt(ncols);
                }
                if (operands[0] instanceof PtgArray) {
                    PtgArray parr = (PtgArray)operands[0];
                    return new PtgInt(parr.nc + 1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new PtgInt(-1);
    }

    protected static Ptg calcHlookup(Ptg[] operands) throws FunctionNotSupportedException {
        if (operands.length < 3) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        boolean sorted = true;
        boolean isNumber = true;
        Ptg lookup_value = operands[0];
        Ptg table_array = operands[1];
        PtgInt row_index_num = (PtgInt)operands[2];
        int rowNum = row_index_num.getVal() - 1;
        if (operands.length > 3 && operands[3].getValue() != null) {
            Object o = operands[3].getValue();
            if (o instanceof Boolean) {
                sorted = (Boolean)o;
            } else if (o instanceof Integer) {
                sorted = (Integer)o != 0;
            }
        }
        int[] retarea = new int[2];
        Boundsheet bs = lookup_value.getParentRec().getSheet();
        WorkBook bk = table_array.getParentRec().getWorkBook();
        PtgRef[] lookupComponents = null;
        PtgRef[] valueComponents = null;
        if (!(table_array instanceof PtgName) && (table_array instanceof PtgArea || table_array instanceof PtgArea3d)) {
            try {
                PtgArea pa = (PtgArea)table_array;
                int[] range = table_array.getIntLocation();
                int firstrow = range[0];
                lookupComponents = (PtgRef[])pa.getRowComponents(firstrow);
                valueComponents = (PtgRef[])pa.getRowComponents(firstrow + rowNum);
            }
            catch (Exception e) {
                Logger.logWarn("Error in LookupReferenceCalculator: Cannot determine PtgArea location. " + e);
            }
        }
        if (lookupComponents == null || lookupComponents.length == 0) {
            return new PtgErr(PtgErr.ERROR_REF);
        }
        try {
            String val = lookupComponents[0].getValue().toString();
            Double d = new Double(val);
        }
        catch (NumberFormatException e) {
            isNumber = false;
        }
        if (isNumber) {
            double match_num;
            try {
                match_num = Double.parseDouble(lookup_value.getValue().toString());
            }
            catch (NumberFormatException e) {
                return new PtgErr(PtgErr.ERROR_NA);
            }
            int i = 0;
            while (i < lookupComponents.length) {
                block21: {
                    double val;
                    try {
                        val = Double.parseDouble(lookupComponents[i].getValue().toString());
                    }
                    catch (NumberFormatException e) {
                        break block21;
                    }
                    if (val == match_num) {
                        return valueComponents[i].getPtgVal();
                    }
                    if (sorted && val > match_num) {
                        if (i == 0) {
                            return new PtgErr(PtgErr.ERROR_NA);
                        }
                        return valueComponents[i - 1].getPtgVal();
                    }
                }
                ++i;
            }
            if (sorted) {
                return valueComponents[lookupComponents.length - 1].getPtgVal();
            }
            return new PtgErr(PtgErr.ERROR_NA);
        }
        return new PtgErr(PtgErr.ERROR_NULL);
    }

    protected static Ptg calcHyperlink(Ptg[] operands) {
        try {
            if (operands.length == 2) {
                return new PtgStr(operands[1].getValue().toString());
            }
            return new PtgStr(operands[0].getValue().toString());
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    protected static Ptg calcIndex(Ptg[] operands) {
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        Ptg o = operands[0];
        Object rowref = new Double(1.0);
        Object colref = new Double(1.0);
        double areanum = 1.0;
        int[] retarea = null;
        String sht = null;
        try {
            Ptg[] ps;
            if (operands.length > 1) {
                Ptg rowrefp = operands[1];
                rowref = rowrefp.getValue();
            }
            if (operands.length > 2) {
                Ptg colrefp = operands[2];
                colref = colrefp.getValue();
            }
            if (operands.length > 3) {
                areanum = operands[3].getDoubleVal();
            }
            if (o instanceof PtgArea) {
                retarea = ((PtgArea)o).getIntLocation();
                sht = ((PtgArea)o).getSheetName();
            } else if (o instanceof PtgName) {
                String r2 = ((PtgName)o).getName().getLocation();
                retarea = ExcelTools.getRangeRowCol(r2);
                sht = r2.indexOf("!") == -1 ? null : r2.substring(0, r2.indexOf("!"));
            } else if (o instanceof PtgMemFunc) {
                ps = ((PtgMemFunc)o).getComponents();
                o = (areanum -= 1.0) >= 0.0 && areanum < (double)ps.length ? ps[(int)areanum] : ps[0];
                retarea = ((PtgArea)o).getIntLocation();
                sht = ((PtgArea)o).getSheetName();
            } else if (o instanceof PtgArray) {
                ps = ((PtgArray)o).getComponents();
                o = (areanum -= 1.0) >= 0.0 && areanum < (double)ps.length ? ps[(int)areanum] : ps[0];
                retarea = ((PtgArea)o).getIntLocation();
            }
            if (retarea != null) {
                int rowoff = retarea[0];
                int coloff = retarea[1];
                int rowck = retarea[2] + 1;
                int colck = retarea[3] + 1;
                int[] dims = new int[2];
                try {
                    int cr;
                    int rr;
                    if (rowref instanceof Integer) {
                        rr = (Integer)rowref;
                    } else {
                        String rw = rowref.toString();
                        if (rw.indexOf(".") > -1) {
                            rw = rw.substring(0, rw.indexOf("."));
                        }
                        rr = Integer.parseInt(rw);
                    }
                    if (colref instanceof Integer) {
                        cr = (Integer)colref;
                    } else {
                        String cl = colref.toString();
                        if (cl.indexOf(".") > -1) {
                            cl = cl.substring(0, cl.indexOf("."));
                        }
                        cr = Integer.parseInt(cl);
                    }
                    if (rr > rowck || cr > colck) {
                        return new PtgErr(PtgErr.ERROR_REF);
                    }
                    dims[0] = rr + rowoff - 1;
                    dims[1] = cr + coloff - 1;
                    PtgRef refp = new PtgRef();
                    if (o instanceof PtgArea3d) {
                        refp = new PtgRef3d();
                    }
                    refp.setParentRec(o.getParentRec());
                    refp.setUseReferenceTracker(false);
                    if (sht != null) {
                        refp.setSheetName(sht);
                    }
                    refp.setLocation(dims);
                    if (o instanceof PtgArea3d) {
                        ((PtgRef3d)refp).setLocation(String.valueOf(((PtgArea3d)o).getSheetName()) + "!" + ExcelTools.formatLocation(dims));
                    }
                    return refp;
                }
                catch (NumberFormatException e) {
                    return new PtgErr(PtgErr.ERROR_NULL);
                }
            }
        }
        catch (Exception e) {
            Logger.logWarn("could not calculate INDEX function: " + o.toString() + ":" + e);
        }
        return new PtgErr(PtgErr.ERROR_NULL);
    }

    protected static Ptg calcIndirect(Ptg[] operands) {
        try {
            if (operands[0] instanceof PtgStr) {
                PtgStr ps = (PtgStr)operands[0];
                String locx = ps.toString();
                if (!FormulaParser.isRef(locx) && !FormulaParser.isRange(locx)) {
                    Name nmx = ps.getParentRec().getWorkBook().getName(locx);
                    if (nmx != null) {
                        locx = nmx.getLocation();
                    } else {
                        return ps;
                    }
                }
                if ("".equals(locx)) {
                    return new PtgInt(0);
                }
                PtgArea3d refp = new PtgArea3d(false);
                refp.setParentRec(ps.getParentRec());
                refp.setUseReferenceTracker(true);
                refp.setLocation(locx);
                return refp;
            }
            if (operands[0] instanceof PtgRef) {
                Object o = ((PtgRef)operands[0]).getValue();
                PtgStr ps = new PtgStr(o.toString());
                ps.setParentRec(operands[0].getParentRec());
                operands = new Ptg[]{ps};
                return LookupReferenceCalculator.calcIndirect(operands);
            }
            if (operands[0] instanceof PtgName) {
                return LookupReferenceCalculator.calcIndirect(((PtgName)operands[0]).getComponents());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new PtgErr(PtgErr.ERROR_REF);
    }

    public static Ptg calcLookup(Ptg[] operands) {
        String lookup = operands[0].getValue().toString().toUpperCase();
        if (operands.length > 2) {
            Ptg[] vector = operands[1].getComponents();
            Ptg[] returnvector = operands[2].getComponents();
            if (returnvector == null) {
                return new PtgNumber(0.0);
            }
            Object retval = null;
            int i = 0;
            while (i < vector.length) {
                if (Calculator.compareCellValue(vector[i].getValue(), lookup, ">")) break;
                if (i < returnvector.length) {
                    retval = returnvector[i].getValue();
                }
                ++i;
            }
            if (retval instanceof Number) {
                return new PtgNumber(((Number)retval).doubleValue());
            }
            if (retval instanceof Boolean) {
                return new PtgBool((Boolean)retval);
            }
            if (retval == null) {
                return new PtgErr(PtgErr.ERROR_NA);
            }
            return new PtgStr(retval.toString());
        }
        try {
            Ptg[] array = ((PtgArray)operands[1]).getComponents();
            int nrs = ((PtgArray)operands[1]).getNumberOfRows();
            int ncs = ((PtgArray)operands[1]).getNumberOfColumns();
            Object retval = null;
            boolean found = false;
            boolean rowbased = ncs > nrs;
            ++ncs;
            int i = 0;
            int j = 0;
            while (j < nrs && !found) {
                int start = i;
                while (i < start + ncs && !found) {
                    if (Calculator.compareCellValue(array[i].getValue(), lookup, ">")) {
                        found = true;
                        break;
                    }
                    if (rowbased) {
                        retval = array[i + ncs].getValue();
                    } else {
                        retval = array[i + 1].getValue();
                        ++i;
                    }
                    ++i;
                }
                ++j;
            }
            if (retval instanceof Number) {
                return new PtgNumber(((Number)retval).doubleValue());
            }
            if (retval instanceof Boolean) {
                return new PtgBool((Boolean)retval);
            }
            if (retval == null) {
                return new PtgErr(PtgErr.ERROR_NA);
            }
            return new PtgStr(retval.toString());
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
    }

    public static Ptg calcMatch(Ptg[] operands) {
        try {
            GenericPtg pa;
            Object lookupValue = operands[0].getValue();
            Ptg lookupArray = operands[1];
            Ptg[] values = null;
            int matchType = 1;
            if (operands.length > 2) {
                Object o = operands[2].getValue();
                matchType = o instanceof Integer ? ((Integer)o).intValue() : ((Double)o).intValue();
            }
            if (lookupArray instanceof PtgName) {
                pa = new PtgArea3d(false);
                ((PtgArea3d)pa).setParentRec(lookupArray.getParentRec());
                ((PtgArea3d)pa).setLocation(((PtgName)lookupArray).getName().getLocation());
                lookupArray = pa;
            }
            if (lookupArray instanceof PtgArea) {
                pa = (PtgArea)lookupArray;
                values = ((PtgArea)pa).getComponents();
            } else if (lookupArray instanceof PtgMemFunc) {
                pa = (PtgMemFunc)lookupArray;
                values = ((PtgMemFunc)pa).getComponents();
            } else if (lookupArray instanceof PtgArray) {
                pa = (PtgArray)lookupArray;
                values = ((PtgArray)pa).getComponents();
            } else if (lookupArray instanceof PtgMystery) {
                ArrayList<Ptg> ptgs = new ArrayList<Ptg>();
                Ptg[] p = ((PtgMystery)lookupArray).vars;
                int j = 0;
                while (j < p.length) {
                    if (p[j] instanceof PtgArea) {
                        Ptg[] pa2 = p[j].getComponents();
                        int k = 0;
                        while (k < pa2.length) {
                            ptgs.add(pa2[k]);
                            ++k;
                        }
                    } else {
                        ptgs.add(p[j]);
                    }
                    ++j;
                }
                values = new Ptg[ptgs.size()];
                ptgs.toArray(values);
            } else if (lookupArray instanceof PtgStr) {
                pa = new PtgArea3d(false);
                ((PtgArea3d)pa).setParentRec(lookupArray.getParentRec());
                ((PtgArea3d)pa).setLocation(lookupArray.toString());
                values = ((PtgArea3d)pa).getComponents();
            } else {
                Logger.logErr("match: unknown type of lookup array");
            }
            int retIndex = -1;
            int i = 1;
            while (i <= values.length) {
                Object v0 = values[i - 1].getValue();
                Object v1 = null;
                if (i < values.length) {
                    v1 = values[i].getValue();
                }
                int mType = -2;
                int match = -2;
                if (v0 instanceof Integer) {
                    if (v1 != null) {
                        mType = ((Integer)v0).compareTo((Integer)v1);
                    }
                    match = ((Integer)v0).compareTo((Integer)lookupValue);
                } else if (v0 instanceof Double) {
                    if (v1 != null) {
                        mType = ((Double)v0).compareTo((Double)v1);
                    }
                    match = ((Double)v0).compareTo((Double)lookupValue);
                } else if (v0 instanceof Boolean) {
                    boolean bv1;
                    boolean bv0 = (Boolean)v0;
                    if (v1 != null) {
                        bv1 = (Boolean)v1;
                        int n = bv0 == bv1 ? 0 : (mType = !bv0 && bv1 ? -1 : 1);
                    }
                    match = bv0 == (bv1 = ((Boolean)lookupValue).booleanValue()) ? 0 : (!bv0 && bv1 ? -1 : 1);
                } else if (v0 instanceof String) {
                    if (v1 != null) {
                        mType = ((String)v0).compareTo((String)v1);
                    }
                    match = ((String)v0).compareTo((String)lookupValue);
                }
                if (i < values.length && (matchType == 1 && mType > 0 || matchType == -1 && mType < 0)) {
                    return new PtgErr(PtgErr.ERROR_NA);
                }
                if (matchType == 0 && match == 0) {
                    retIndex = i;
                    break;
                }
                if (matchType == 1 && match <= 0) {
                    retIndex = i;
                } else if (matchType == -1 && match >= 0) {
                    retIndex = i;
                }
                ++i;
            }
            if (retIndex > -1) {
                return new PtgInt(retIndex);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new PtgErr(PtgErr.ERROR_NA);
    }

    protected static Ptg calcOffset(Ptg[] operands) {
        int[] temp;
        Ptg ref = operands[0];
        if (!(ref instanceof PtgRef)) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        int nrows = operands[1].getIntVal();
        int ncols = operands[2].getIntVal();
        int height = -1;
        if (operands.length > 3 && (height = operands[3].getIntVal()) < 0) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        int width = -1;
        if (operands.length > 4 && (width = operands[4].getIntVal()) < 0) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        int[] rc = ((PtgRef)ref).getIntLocation();
        rc[0] = rc[0] + nrows;
        rc[1] = rc[1] + ncols;
        if (rc.length > 3) {
            rc[2] = rc[2] + nrows;
            rc[3] = rc[3] + ncols;
        }
        if (height == 1 && width == 1) {
            if (rc.length > 3) {
                temp = new int[2];
                System.arraycopy(rc, 0, temp, 0, 2);
                rc = temp;
            }
        } else if (height != -1 || width != -1) {
            if (rc.length < 3) {
                temp = new int[4];
                System.arraycopy(rc, 0, temp, 0, 2);
                rc = temp;
            }
            if (height > 0) {
                rc[2] = rc[0] + height - 1;
            }
            if (width > 0) {
                rc[3] = rc[1] + width - 1;
            }
        }
        if (rc.length > 3) {
            if (rc[0] < 0 || rc[1] < 0 || rc[2] < 0 || rc[3] < 0) {
                return new PtgErr(PtgErr.ERROR_REF);
            }
            PtgArea pa = new PtgArea(false);
            pa.setParentRec(ref.getParentRec());
            try {
                String sh = ref.getLocation();
                int z = sh.indexOf(33);
                if (z > 0) {
                    pa.setSheetName(sh.substring(0, z));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            pa.setLocation(rc);
            return pa;
        }
        if (rc[0] < 0 || rc[1] < 0) {
            return new PtgErr(PtgErr.ERROR_REF);
        }
        PtgRef pr = new PtgRef();
        pr.setParentRec(ref.getParentRec());
        pr.setLocation(rc);
        return pr;
    }

    protected static Ptg calcTranspose(Ptg[] operands) {
        String retArray = "";
        PtgArray ret = new PtgArray();
        if (!(operands[0] instanceof PtgArray)) {
            Ptg[] arr = operands[0].getComponents();
            int i = 0;
            while (i < arr.length) {
                retArray = String.valueOf(retArray) + arr[i].getValue().toString() + ";";
                ++i;
            }
            retArray = "{" + retArray.substring(0, retArray.length() - 1) + "}";
            ret.setVal(retArray);
        } else {
            PtgArray pa = (PtgArray)operands[0];
            Ptg[] arr = pa.getComponents();
            int nc = pa.getNumberOfColumns() + 1;
            int nr = pa.getNumberOfRows() + 1;
            int i = 0;
            while (i < nc) {
                int j = 0;
                while (j < nc * nr) {
                    retArray = String.valueOf(retArray) + arr[i + j].getValue().toString() + ",";
                    j += nc;
                }
                retArray = String.valueOf(retArray.substring(0, retArray.length() - 1)) + ";";
                ++i;
            }
            retArray = "{" + retArray.substring(0, retArray.length() - 1) + "}";
            ret.setVal(retArray);
        }
        return ret;
    }

    protected static Ptg calcRow(Ptg[] operands) throws FunctionNotSupportedException {
        if (operands == null || operands.length != 1) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        if (operands[0] instanceof PtgFuncVar) {
            PtgFuncVar pfunk = (PtgFuncVar)operands[0];
            try {
                int loc = pfunk.getParentRec().getRowNumber() + 1;
                return new PtgInt(loc);
            }
            catch (Exception e) {
                Logger.logErr("Error running calcRow " + e);
            }
        }
        try {
            boolean isArray = operands[0].getParentRec() instanceof Array;
            if (!isArray) {
                if (operands[0] instanceof PtgRef) {
                    return new PtgInt(((PtgRef)operands[0]).getRowCol()[0] + 1);
                }
                if (operands[0] instanceof PtgName) {
                    String range = ((PtgName)operands[0]).getName().getLocation();
                    return new PtgInt(ExcelTools.getRowColFromString(range)[0] + 1);
                }
                return new PtgInt(operands[0].getIntLocation()[0] + 1);
            }
            String retArry = "";
            Ptg[] comps = null;
            if (operands[0] instanceof PtgRef) {
                comps = operands[0].getComponents();
            } else if (operands[0] instanceof PtgName) {
                comps = ((PtgName)operands[0]).getComponents();
            }
            if (comps == null) {
                return new PtgInt(((PtgRef)operands[0]).getRowCol()[0] + 1);
            }
            int i = 0;
            while (i < comps.length) {
                try {
                    retArry = String.valueOf(retArry) + (((PtgRef)comps[i]).getIntLocation()[0] + 1) + ",";
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            retArry = "{" + retArry.substring(0, retArry.length() - 1) + "}";
            PtgArray pa = new PtgArray();
            pa.setVal(retArry);
            return pa;
        }
        catch (Exception ex) {
            return new PtgRefErr();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Ptg calcRows(Ptg[] operands) throws FunctionNotSupportedException {
        try {
            int rsz = 0;
            if (operands[0] instanceof PtgStr) {
                String rangestr = operands[0].getValue().toString();
                String startx = rangestr.substring(0, rangestr.indexOf(":"));
                String endx = rangestr.substring(rangestr.indexOf(":") + 1);
                int[] startints = ExcelTools.getRowColFromString(startx);
                int[] endints = ExcelTools.getRowColFromString(endx);
                rsz = endints[0] - startints[0];
                ++rsz;
                return new PtgInt(rsz);
            } else if (operands[0] instanceof PtgName) {
                int[] rc = ExcelTools.getRangeCoords(((PtgName)operands[0]).getLocation());
                rsz = rc[2] - rc[0];
                ++rsz;
                return new PtgInt(rsz);
            } else if (operands[0] instanceof PtgRef) {
                int[] rc = ExcelTools.getRangeCoords(((PtgRef)operands[0]).getLocation());
                rsz = rc[2] - rc[0];
                ++rsz;
                return new PtgInt(rsz);
            } else {
                if (!(operands[0] instanceof PtgMemFunc)) return new PtgErr(PtgErr.ERROR_VALUE);
                Ptg[] p = ((PtgMemFunc)operands[0]).getComponents();
                if (p == null || p.length <= 0) return new PtgErr(PtgErr.ERROR_VALUE);
                int[] rc0 = p[0].getIntLocation();
                int[] rc1 = null;
                if (p.length > 1) {
                    rc1 = p[p.length - 1].getIntLocation();
                }
                rsz = rc1 == null ? 0 : rc1[0] - rc0[0];
                ++rsz;
            }
            return new PtgInt(rsz);
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    /*
     * Exception decompiling
     */
    protected static Ptg calcVlookup(Ptg[] operands) throws FunctionNotSupportedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [21[CATCHBLOCK], 26[WHILELOOP]], but top level block is 9[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

