/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.formulas.CalculationException;
import com.extentech.formats.XLS.formulas.Calculator;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgArea;
import com.extentech.formats.XLS.formulas.PtgCalculator;
import com.extentech.formats.XLS.formulas.PtgErr;
import com.extentech.formats.XLS.formulas.PtgInt;
import com.extentech.formats.XLS.formulas.PtgNumber;
import com.extentech.formats.XLS.formulas.PtgStr;
import com.extentech.toolkit.Logger;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Random;

public class MathFunctionCalculator {
    protected static Ptg calcSum(Ptg[] operands) throws CalculationException {
        if (operands.length < 1) {
            return PtgCalculator.getNAError();
        }
        double result = 0.0;
        double[] dub = PtgCalculator.getDoubleValueArray(operands);
        if (dub == null) {
            return PtgCalculator.getNAError();
        }
        int i = 0;
        while (i < dub.length) {
            result += dub[i];
            ++i;
        }
        return new PtgNumber(result);
    }

    protected static Ptg calcAbs(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getNAError();
        }
        double dd = 0.0;
        try {
            dd = operands[0].getDoubleVal();
        }
        catch (NumberFormatException e) {
            return PtgCalculator.getValueError();
        }
        dd = Math.abs(dd);
        if (new Double(dd).isNaN()) {
            return PtgCalculator.getError();
        }
        PtgNumber ptnum = new PtgNumber(dd);
        return ptnum;
    }

    protected static Ptg calcAcos(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getNAError();
        }
        double dd = 0.0;
        try {
            dd = operands[0].getDoubleVal();
        }
        catch (NumberFormatException e) {
            return PtgCalculator.getValueError();
        }
        dd = Math.acos(dd);
        if (new Double(dd).isNaN()) {
            return PtgCalculator.getError();
        }
        PtgNumber ptnum = new PtgNumber(dd);
        return ptnum;
    }

    protected static Ptg calcAcosh(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getNAError();
        }
        double x = 0.0;
        try {
            x = operands[0].getDoubleVal();
        }
        catch (NumberFormatException e) {
            return PtgCalculator.getValueError();
        }
        double dd = Math.log(x + (1.0 + x) * Math.sqrt((x - 1.0) / (x + 1.0)));
        if (new Double(dd).isNaN()) {
            return PtgCalculator.getError();
        }
        PtgNumber ptnum = new PtgNumber(dd);
        return ptnum;
    }

    protected static Ptg calcAsin(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getNAError();
        }
        double dd = 0.0;
        try {
            dd = operands[0].getDoubleVal();
        }
        catch (NumberFormatException e) {
            return PtgCalculator.getValueError();
        }
        dd = Math.asin(dd);
        if (new Double(dd).isNaN()) {
            return PtgCalculator.getError();
        }
        PtgNumber ptnum = new PtgNumber(dd);
        return ptnum;
    }

    protected static Ptg calcAsinh(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getNAError();
        }
        double x = 0.0;
        try {
            x = operands[0].getDoubleVal();
        }
        catch (NumberFormatException e) {
            return PtgCalculator.getValueError();
        }
        if (new Double(x).isNaN()) {
            return PtgCalculator.getError();
        }
        BigDecimal bd = new BigDecimal((x > 0.0 ? 1.0 : -1.0) * MathFunctionCalculator.getAcosh(Math.sqrt(1.0 + x * x)));
        bd.setScale(15, 4);
        PtgNumber ptnum = new PtgNumber(bd.doubleValue());
        return ptnum;
    }

    protected static Ptg calcAtan(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getNAError();
        }
        double dd = 0.0;
        try {
            dd = operands[0].getDoubleVal();
        }
        catch (NumberFormatException e) {
            return PtgCalculator.getValueError();
        }
        dd = Math.atan(dd);
        if (new Double(dd).isNaN()) {
            return PtgCalculator.getError();
        }
        PtgNumber ptnum = new PtgNumber(dd);
        return ptnum;
    }

    protected static Ptg calcAtan2(Ptg[] operands) throws CalculationException {
        if (operands.length != 2) {
            return PtgCalculator.getNAError();
        }
        double[] dd = PtgCalculator.getDoubleValueArray(operands);
        if (dd == null) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        double res = Math.atan2(dd[0], dd[1]);
        PtgNumber ptnum = new PtgNumber(res);
        return ptnum;
    }

    protected static Ptg calcAtanh(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getNAError();
        }
        double dd = 0.0;
        try {
            dd = operands[0].getDoubleVal();
        }
        catch (NumberFormatException e) {
            return PtgCalculator.getValueError();
        }
        if (dd > 1.0 || dd < -1.0) {
            return PtgCalculator.getError();
        }
        if (new Double(dd).isNaN()) {
            return PtgCalculator.getError();
        }
        double res = 0.5 * Math.log((1.0 + dd) / (1.0 - dd));
        PtgNumber ptnum = new PtgNumber(res);
        return ptnum;
    }

    protected static Ptg calcCeiling(Ptg[] operands) throws CalculationException {
        double[] dd = PtgCalculator.getDoubleValueArray(operands);
        if (dd == null) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        if (dd.length != 2) {
            return PtgCalculator.getNAError();
        }
        double num = dd[0];
        double multiple = dd[1];
        double res = 0.0;
        while (res < num) {
            res += multiple;
        }
        PtgNumber ptnum = new PtgNumber(res);
        return ptnum;
    }

    protected static Ptg calcCombin(Ptg[] operands) throws CalculationException {
        long num2;
        double[] dd = PtgCalculator.getDoubleValueArray(operands);
        if (dd == null) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        if (dd.length != 2) {
            return PtgCalculator.getNAError();
        }
        long num1 = Math.round(dd[0]);
        if (num1 < (num2 = Math.round(dd[1]))) {
            return PtgCalculator.getError();
        }
        long res1 = MathFunctionCalculator.stepFactorial(num1, (int)num2);
        long res2 = MathFunctionCalculator.factorial(num2);
        double res = res1 / res2;
        PtgNumber ptnum = new PtgNumber(res);
        return ptnum;
    }

    protected static Ptg calcCos(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getNAError();
        }
        double dd = 0.0;
        try {
            dd = operands[0].getDoubleVal();
        }
        catch (NumberFormatException e) {
            return PtgCalculator.getValueError();
        }
        if (new Double(dd).isNaN()) {
            return PtgCalculator.getError();
        }
        double res = Math.cos(dd);
        PtgNumber ptnum = new PtgNumber(res);
        return ptnum;
    }

    protected static Ptg calcCosh(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getNAError();
        }
        double dd = 0.0;
        try {
            dd = operands[0].getDoubleVal();
        }
        catch (NumberFormatException e) {
            return PtgCalculator.getValueError();
        }
        if (new Double(dd).isNaN()) {
            return PtgCalculator.getError();
        }
        double res = 0.5 * (Math.exp(dd) + Math.exp(-dd));
        PtgNumber ptnum = new PtgNumber(res);
        return ptnum;
    }

    protected static Ptg calcDegrees(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getNAError();
        }
        double dd = 0.0;
        try {
            dd = operands[0].getDoubleVal();
        }
        catch (NumberFormatException e) {
            return PtgCalculator.getValueError();
        }
        if (new Double(dd).isNaN()) {
            return PtgCalculator.getError();
        }
        double res = Math.toDegrees(dd);
        PtgNumber ptnum = new PtgNumber(res);
        return ptnum;
    }

    protected static Ptg calcEven(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getNAError();
        }
        double dd = 0.0;
        try {
            dd = operands[0].getDoubleVal();
        }
        catch (NumberFormatException e) {
            return PtgCalculator.getValueError();
        }
        if (new Double(dd).isNaN()) {
            return PtgCalculator.getError();
        }
        long resnum = Math.round(dd);
        double remainder = dd % 2.0;
        if (remainder != 0.0) {
            ++resnum;
        }
        PtgInt pint = new PtgInt((int)resnum);
        return pint;
    }

    protected static Ptg calcExp(Ptg[] operands) {
        if (operands.length > 1 || operands[0].getComponents() != null) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        double d = Math.E;
        Ptg p = operands[0];
        try {
            Double dub = new Double(String.valueOf(p.getValue()));
            BigDecimal result = new BigDecimal(Math.pow(d, dub));
            result.setScale(15, 4);
            PtgNumber pnum = new PtgNumber(result.doubleValue());
            return pnum;
        }
        catch (NumberFormatException e) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    protected static Ptg calcFact(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getNAError();
        }
        long dd = 0L;
        try {
            dd = PtgCalculator.getLongValue(operands);
        }
        catch (NumberFormatException e) {
            return PtgCalculator.getValueError();
        }
        if (new Double(dd).isNaN()) {
            return PtgCalculator.getError();
        }
        long res = MathFunctionCalculator.factorial(dd);
        PtgNumber ptnum = new PtgNumber(res);
        return ptnum;
    }

    protected static Ptg calcFactDouble(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getNAError();
        }
        long n = PtgCalculator.getLongValue(operands);
        if (new Double(n).isNaN()) {
            return PtgCalculator.getError();
        }
        if (n < 0L) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double res = 1.0;
        long endPoint = n % 2L == 0L ? 2 : 1;
        long i = n;
        while (i >= endPoint) {
            res *= (double)i;
            i -= 2L;
        }
        if (n == 0L) {
            res = -1.0;
        }
        PtgNumber ptnum = new PtgNumber(res);
        return ptnum;
    }

    protected static Ptg calcFloor(Ptg[] operands) throws CalculationException {
        double[] dd = PtgCalculator.getDoubleValueArray(operands);
        if (dd == null) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        if (dd.length != 2) {
            return PtgCalculator.getError();
        }
        double num = dd[0];
        double multiple = dd[1];
        double res = 0.0;
        while (res < num) {
            res += multiple;
        }
        PtgNumber ptnum = new PtgNumber(res -= multiple);
        return ptnum;
    }

    protected static Ptg calcGCD(Ptg[] operands) {
        if (operands.length < 1) {
            return PtgCalculator.getNAError();
        }
        Ptg[] numbers = PtgCalculator.getAllComponents(operands);
        long gcd = 0L;
        try {
            long n1 = PtgCalculator.getLongValue(numbers[0]);
            if (n1 < 0L) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            gcd = n1;
            int i = 1;
            while (i < numbers.length) {
                long n2 = PtgCalculator.getLongValue(numbers[i]);
                if (n2 < 0L) {
                    return new PtgErr(PtgErr.ERROR_NUM);
                }
                long bigger = Math.max(n2, n1);
                long smaller = Math.min(n2, n1);
                long r2 = bigger % smaller;
                while (r2 != 0L) {
                    bigger = smaller;
                    smaller = r2;
                    r2 = bigger % smaller;
                }
                gcd = Math.min(gcd, smaller);
                ++i;
            }
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        PtgNumber pnum = new PtgNumber(gcd);
        return pnum;
    }

    protected static Ptg calcInt(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getNAError();
        }
        double dd = 0.0;
        try {
            dd = operands[0].getDoubleVal();
        }
        catch (NumberFormatException e) {
            return PtgCalculator.getValueError();
        }
        if (new Double(dd).isNaN()) {
            return PtgCalculator.getError();
        }
        long res = Math.round(dd);
        if ((double)res > dd) {
            --res;
        }
        PtgInt pint = new PtgInt((int)res);
        return pint;
    }

    protected static Ptg calcLCM(Ptg[] operands) {
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        Ptg[] numbers = PtgCalculator.getAllComponents(operands);
        long lcm = 0L;
        try {
            Ptg[] ops = new Ptg[2];
            lcm = PtgCalculator.getLongValue(numbers[0]);
            if (lcm < 0L) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            int i = 1;
            while (i < numbers.length) {
                long n2 = PtgCalculator.getLongValue(numbers[i]);
                if (n2 < 0L) {
                    return new PtgErr(PtgErr.ERROR_NUM);
                }
                ops[0] = new PtgNumber(lcm);
                ops[1] = new PtgNumber(n2);
                long gcd = PtgCalculator.getLongValue(MathFunctionCalculator.calcGCD(ops));
                lcm = lcm * n2 / gcd;
                ++i;
            }
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        PtgNumber pnum = new PtgNumber(lcm);
        return pnum;
    }

    protected static Ptg calcLn(Ptg[] operands) {
        if (operands.length > 1) {
            return PtgCalculator.getNAError();
        }
        double dd = 0.0;
        try {
            dd = operands[0].getDoubleVal();
        }
        catch (NumberFormatException e) {
            return PtgCalculator.getValueError();
        }
        if (new Double(dd).isNaN()) {
            return PtgCalculator.getError();
        }
        double res = Math.log(dd);
        PtgNumber ptnum = new PtgNumber(res);
        return ptnum;
    }

    protected static Ptg calcLog(Ptg[] operands) throws CalculationException {
        double num2;
        double num1;
        if (operands.length < 1) {
            return PtgCalculator.getNAError();
        }
        double[] dd = PtgCalculator.getDoubleValueArray(operands);
        if (dd == null) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        if (dd.length > 2) {
            return PtgCalculator.getError();
        }
        if (dd.length == 1) {
            num1 = dd[0];
            num2 = 10.0;
        } else {
            num1 = dd[0];
            num2 = dd[1];
        }
        double res = Math.log(num1) / Math.log(num2);
        PtgNumber ptnum = new PtgNumber(res);
        return ptnum;
    }

    protected static Ptg calcLog10(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getNAError();
        }
        double dd = 0.0;
        try {
            dd = operands[0].getDoubleVal();
        }
        catch (NumberFormatException e) {
            return PtgCalculator.getValueError();
        }
        if (new Double(dd).isNaN()) {
            return PtgCalculator.getError();
        }
        BigDecimal res = new BigDecimal(Math.log10(dd));
        res.setScale(15, 4);
        PtgNumber ptnum = new PtgNumber(res.doubleValue());
        return ptnum;
    }

    protected static Ptg calcMMult(Ptg[] operands) {
        if (operands.length != 2) {
            return PtgCalculator.getNAError();
        }
        try {
            double[][] a1 = PtgCalculator.getArray(operands[0]);
            double[][] a2 = PtgCalculator.getArray(operands[1]);
            if (a1[0].length != a2.length) {
                PtgCalculator.getValueError();
            }
            double sum = 0.0;
            int i = 0;
            while (i < a1[0].length) {
                sum += a1[0][i] * a2[i][0];
                ++i;
            }
            return new PtgNumber(sum);
        }
        catch (Exception exception) {
            return PtgCalculator.getValueError();
        }
    }

    protected static Ptg calcMod(Ptg[] operands) throws CalculationException {
        if (operands.length < 1) {
            return PtgCalculator.getNAError();
        }
        double[] dd = PtgCalculator.getDoubleValueArray(operands);
        if (dd == null) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        if (dd.length != 2) {
            return PtgCalculator.getError();
        }
        double num1 = dd[0];
        double num2 = dd[1];
        double res = num1 % num2;
        PtgNumber ptnum = new PtgNumber(res);
        return ptnum;
    }

    protected static Ptg calcMRound(Ptg[] operands) {
        if (operands.length != 2) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        double m = 0.0;
        double n = 0.0;
        try {
            n = operands[0].getDoubleVal();
            m = operands[1].getDoubleVal();
        }
        catch (NumberFormatException e) {
            return PtgCalculator.getValueError();
        }
        if (n < 0.0 && m > 0.0 || n > 0.0 && m < 0.0) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double result = (double)Math.round(n / m) * m;
        PtgNumber pnum = new PtgNumber(result);
        return pnum;
    }

    protected static Ptg calcMultinomial(Ptg[] operands) {
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        Ptg[] numbers = PtgCalculator.getAllComponents(operands);
        long sum = 0L;
        double facts = 1.0;
        int i = 0;
        while (i < numbers.length) {
            long n = PtgCalculator.getLongValue(operands[i]);
            if (n < 1L) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            sum += n;
            facts *= (double)MathFunctionCalculator.factorial(n);
            ++i;
        }
        double result = (double)MathFunctionCalculator.factorial(sum) / facts;
        PtgNumber pnum = new PtgNumber(result);
        return pnum;
    }

    protected static Ptg calcOdd(Ptg[] operands) {
        double remainder;
        if (operands.length != 1) {
            return PtgCalculator.getNAError();
        }
        double dd = 0.0;
        try {
            dd = operands[0].getDoubleVal();
        }
        catch (NumberFormatException e) {
            return PtgCalculator.getValueError();
        }
        if (new Double(dd).isNaN()) {
            return PtgCalculator.getError();
        }
        long resnum = Math.round(dd);
        if ((double)resnum < dd) {
            ++resnum;
        }
        if ((remainder = (double)(resnum % 2L)) == 0.0) {
            ++resnum;
        }
        PtgInt pint = new PtgInt((int)resnum);
        return pint;
    }

    protected static Ptg calcPi(Ptg[] operands) {
        double pi = Math.PI;
        PtgNumber pnum = new PtgNumber(pi);
        return pnum;
    }

    protected static Ptg calcPower(Ptg[] operands) throws CalculationException {
        if (operands.length < 1) {
            return PtgCalculator.getNAError();
        }
        double[] dd = PtgCalculator.getDoubleValueArray(operands);
        if (dd == null) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        if (dd.length != 2) {
            return PtgCalculator.getError();
        }
        BigDecimal num1 = new BigDecimal(dd[0]);
        num1.setScale(15, 4);
        BigDecimal num2 = new BigDecimal(dd[1]);
        num2.setScale(15, 4);
        BigDecimal res = new BigDecimal(Math.pow(num1.doubleValue(), num2.doubleValue()));
        res.setScale(15, 4);
        PtgNumber ptnum = new PtgNumber(res.doubleValue());
        return ptnum;
    }

    protected static Ptg calcProduct(Ptg[] operands) throws CalculationException {
        if (operands.length < 1) {
            return PtgCalculator.getNAError();
        }
        double[] dd = PtgCalculator.getDoubleValueArray(operands);
        if (dd == null) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        double result = dd[0];
        int i = 1;
        while (i < dd.length) {
            result *= dd[i];
            ++i;
        }
        PtgNumber ptnum = new PtgNumber(result);
        return ptnum;
    }

    protected static Ptg calcQuotient(Ptg[] operands) {
        if (operands.length != 2) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        double numerator = 0.0;
        double denominator = 0.0;
        try {
            numerator = operands[0].getDoubleVal();
            denominator = operands[1].getDoubleVal();
        }
        catch (NumberFormatException e) {
            return PtgCalculator.getValueError();
        }
        long result = new Double(numerator / denominator).longValue();
        PtgNumber pnum = new PtgNumber(result);
        return pnum;
    }

    protected static Ptg calcRadians(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getNAError();
        }
        double dd = 0.0;
        try {
            dd = operands[0].getDoubleVal();
        }
        catch (NumberFormatException e) {
            return PtgCalculator.getValueError();
        }
        if (new Double(dd).isNaN()) {
            return PtgCalculator.getError();
        }
        double res = Math.toRadians(dd);
        PtgNumber ptnum = new PtgNumber(res);
        return ptnum;
    }

    protected static Ptg calcRand(Ptg[] operands) {
        double dd = Math.random();
        PtgNumber pnum = new PtgNumber(dd);
        return pnum;
    }

    protected static Ptg calcRandBetween(Ptg[] operands) {
        if (operands.length != 2) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        int lower = 0;
        int upper = 0;
        try {
            lower = operands[0].getIntVal();
            upper = operands[1].getIntVal();
        }
        catch (NumberFormatException e) {
            return PtgCalculator.getValueError();
        }
        Random r2 = new Random();
        double result = r2.nextInt(upper - lower + 1) + lower;
        PtgNumber pnum = new PtgNumber(result);
        return pnum;
    }

    /*
     * Unable to fully structure code
     */
    protected static Ptg calcRoman(Ptg[] operands) {
        block4: {
            numbers = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
            letters = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
            roman = "";
            if (operands.length != 1) break block4;
            dd = operands[0].getDoubleVal();
            if (new Double(dd).isNaN()) {
                return PtgCalculator.getError();
            }
            i = (int)dd;
            if (i < 0 || i > 3999) {
                return PtgCalculator.getError();
            }
            z = 0;
            ** GOTO lbl18
            {
                roman = String.valueOf(roman) + letters[z];
                i -= numbers[z];
                do {
                    if (i >= numbers[z]) continue block0;
                    ++z;
lbl18:
                    // 2 sources

                } while (z < numbers.length);
            }
        }
        pstr = new PtgStr(roman);
        return pstr;
    }

    protected static Ptg calcRound(Ptg[] operands) throws CalculationException {
        double tempnum;
        if (operands.length < 1) {
            return PtgCalculator.getNAError();
        }
        double[] dd = PtgCalculator.getDoubleValueArray(operands);
        if (dd == null) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        double num = dd[0];
        double round = dd[dd.length - 1];
        double res = 0.0;
        if (round == 0.0) {
            res = Math.round(num);
        } else if (round > 0.0) {
            tempnum = num * Math.pow(10.0, round);
            tempnum = Math.round(tempnum);
            res = tempnum / Math.pow(10.0, round);
        } else {
            tempnum = num / Math.pow(10.0, round *= -1.0);
            tempnum = Math.round(tempnum);
            res = tempnum * Math.pow(10.0, round);
        }
        PtgNumber ptnum = new PtgNumber(res);
        return ptnum;
    }

    protected static Ptg calcRoundDown(Ptg[] operands) throws CalculationException {
        double tempnum;
        if (operands.length < 1) {
            return PtgCalculator.getNAError();
        }
        double[] dd = PtgCalculator.getDoubleValueArray(operands);
        if (dd == null) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        double num = dd[0];
        double round = dd[dd.length - 1];
        double res = 0.0;
        if (round == 0.0) {
            res = Math.round(num);
            if (res > num) {
                res -= 1.0;
            }
        } else if (round > 0.0) {
            tempnum = num * Math.pow(10.0, round);
            double tempnum2 = Math.round(tempnum);
            if (tempnum2 > tempnum) {
                tempnum2 -= 1.0;
            }
            res = tempnum2 / Math.pow(10.0, round);
        } else {
            tempnum = num / Math.pow(10.0, round *= -1.0);
            double tempnum2 = Math.round(tempnum);
            if (tempnum2 > tempnum) {
                tempnum2 -= 1.0;
            }
            res = tempnum2 * Math.pow(10.0, round);
        }
        PtgNumber ptnum = new PtgNumber(res);
        return ptnum;
    }

    protected static Ptg calcRoundUp(Ptg[] operands) throws CalculationException {
        double tempnum;
        if (operands.length < 1) {
            return PtgCalculator.getNAError();
        }
        double[] dd = PtgCalculator.getDoubleValueArray(operands);
        if (dd == null) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        double num = dd[0];
        double round = dd[dd.length - 1];
        double res = 0.0;
        if (round == 0.0) {
            res = Math.round(num);
            if (res < num) {
                res += 1.0;
            }
        } else if (round > 0.0) {
            tempnum = num * Math.pow(10.0, round);
            double tempnum2 = Math.round(tempnum);
            if (tempnum2 < tempnum) {
                tempnum2 += 1.0;
            }
            res = tempnum2 / Math.pow(10.0, round);
        } else {
            tempnum = num / Math.pow(10.0, round *= -1.0);
            double tempnum2 = Math.round(tempnum);
            if (tempnum2 < tempnum) {
                tempnum2 += 1.0;
            }
            res = tempnum2 * Math.pow(10.0, round);
        }
        PtgNumber ptnum = new PtgNumber(res);
        return ptnum;
    }

    protected static Ptg calcSign(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getNAError();
        }
        double dd = 0.0;
        try {
            dd = operands[0].getDoubleVal();
        }
        catch (NumberFormatException e) {
            return PtgCalculator.getValueError();
        }
        int res = 0;
        if (new Double(dd).isNaN()) {
            return PtgCalculator.getError();
        }
        if (dd == 0.0) {
            res = 0;
        }
        if (dd > 0.0) {
            res = 1;
        }
        if (dd < 0.0) {
            res = -1;
        }
        PtgInt pint = new PtgInt(res);
        return pint;
    }

    protected static Ptg calcSin(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getNAError();
        }
        double dd = 0.0;
        try {
            dd = operands[0].getDoubleVal();
        }
        catch (NumberFormatException e) {
            return PtgCalculator.getValueError();
        }
        if (new Double(dd).isNaN()) {
            return PtgCalculator.getError();
        }
        double res = Math.sin(dd);
        PtgNumber ptnum = new PtgNumber(res);
        return ptnum;
    }

    protected static Ptg calcSinh(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getNAError();
        }
        double dd = 0.0;
        try {
            dd = operands[0].getDoubleVal();
        }
        catch (NumberFormatException e) {
            return PtgCalculator.getValueError();
        }
        if (new Double(dd).isNaN()) {
            return PtgCalculator.getError();
        }
        double res = 0.5 * (Math.exp(dd) - Math.exp(-dd));
        PtgNumber ptnum = new PtgNumber(res);
        return ptnum;
    }

    protected static Ptg calcSqrt(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getNAError();
        }
        double dd = 0.0;
        try {
            dd = operands[0].getDoubleVal();
        }
        catch (NumberFormatException e) {
            return PtgCalculator.getValueError();
        }
        if (new Double(dd).isNaN()) {
            return PtgCalculator.getError();
        }
        double res = Math.sqrt(dd);
        PtgNumber ptnum = new PtgNumber(res);
        return ptnum;
    }

    protected static Ptg calcSqrtPi(Ptg[] operands) {
        if (operands.length < 1) {
            return PtgCalculator.getNAError();
        }
        double dd = 0.0;
        try {
            dd = operands[0].getDoubleVal();
        }
        catch (NumberFormatException e) {
            return PtgCalculator.getValueError();
        }
        if (new Double(dd).isNaN()) {
            return PtgCalculator.getError();
        }
        double res = Math.sqrt(dd * Math.PI);
        PtgNumber ptnum = new PtgNumber(res);
        return ptnum;
    }

    protected static Ptg calcSumif(Ptg[] operands) {
        try {
            PtgArea range = Calculator.getRange(operands[0]);
            PtgArea sum_range = null;
            try {
                Ptg criteria = operands[1];
                if (operands.length > 2) {
                    sum_range = Calculator.getRange(operands[2]);
                }
                String op = "=";
                String sCriteria = criteria.getString();
                int j = Calculator.splitOperator(sCriteria);
                if (j > 0) {
                    op = sCriteria.substring(0, j);
                }
                sCriteria = sCriteria.substring(j);
                sCriteria = Calculator.translateWildcardsInCriteria(sCriteria);
                ArrayList<Ptg> passesList = new ArrayList<Ptg>();
                Ptg[] cells = range.getComponents();
                Ptg[] sumrangecells = null;
                if (sum_range != null) {
                    sumrangecells = sum_range.getComponents();
                }
                int i = 0;
                while (i < cells.length) {
                    boolean passes = false;
                    try {
                        Object v = cells[i].getValue();
                        passes = Calculator.compareCellValue(v, sCriteria, op);
                    }
                    catch (Exception v) {
                        // empty catch block
                    }
                    if (passes) {
                        if (sumrangecells != null) {
                            passesList.add(sumrangecells[i]);
                        } else {
                            passesList.add(cells[i]);
                        }
                    }
                    ++i;
                }
                double ret = 0.0;
                int i2 = 0;
                while (i2 < passesList.size()) {
                    Ptg cell = (Ptg)passesList.get(i2);
                    try {
                        ret += cell.getDoubleVal();
                    }
                    catch (Exception e) {
                        Logger.logErr("MathFunctionCalculator.calcSumif:  error obtaining cell value: " + e.toString());
                    }
                    ++i2;
                }
                return new PtgNumber(ret);
            }
            catch (Exception e) {
                Logger.logWarn("could not calculate SUMIF function: " + e.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new PtgErr(PtgErr.ERROR_NULL);
    }

    protected static Ptg calcSumIfS(Ptg[] operands) {
        try {
            PtgArea sum_range = Calculator.getRange(operands[0]);
            Ptg[] sumrangecells = sum_range.getComponents();
            String[] ops = new String[(operands.length - 1) / 2];
            String[] criteria = new String[(operands.length - 1) / 2];
            Ptg[][] criteria_cells = new Ptg[(operands.length - 1) / 2][];
            int j = 0;
            int i = 1;
            while (i + 1 < operands.length) {
                PtgArea cr = Calculator.getRange(operands[i]);
                criteria_cells[j] = cr.getComponents();
                if (criteria_cells[j].length != sumrangecells.length) {
                    return new PtgErr(PtgErr.ERROR_VALUE);
                }
                criteria[j] = operands[i + 1].toString();
                ops[j] = "=";
                int k = Calculator.splitOperator(criteria[j]);
                if (k > 0) {
                    ops[j] = criteria[j].substring(0, k);
                }
                criteria[j] = criteria[j].substring(k);
                criteria[j] = Calculator.translateWildcardsInCriteria(criteria[j]);
                ++j;
                i += 2;
            }
            ArrayList<Ptg> passesList = new ArrayList<Ptg>();
            int i2 = 0;
            while (i2 < sumrangecells.length) {
                boolean passes = true;
                int k = 0;
                while (k < criteria.length) {
                    try {
                        Object v = criteria_cells[k][i2].getValue();
                        boolean bl = passes = Calculator.compareCellValue(v, criteria[k], ops[k]) && passes;
                        if (!passes) {
                            break;
                        }
                    }
                    catch (Exception v) {
                        // empty catch block
                    }
                    ++k;
                }
                if (passes) {
                    passesList.add(sumrangecells[i2]);
                }
                ++i2;
            }
            double ret = 0.0;
            int i3 = 0;
            while (i3 < passesList.size()) {
                Ptg cell = (Ptg)passesList.get(i3);
                try {
                    ret += cell.getDoubleVal();
                }
                catch (Exception e) {
                    Logger.logErr("MathFunctionCalculator.calcSumif:  error obtaining cell value: " + e.toString());
                }
                ++i3;
            }
            return new PtgNumber(ret);
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Ptg calcSumproduct(Ptg[] operands) {
        double res = 0.0;
        int dim = 0;
        ArrayList<Object> arrays = new ArrayList<Object>();
        int i = 0;
        while (i < operands.length) {
            if (operands[i] instanceof PtgErr) {
                return new PtgErr(PtgErr.ERROR_NA);
            }
            Ptg[] a = operands[i].getComponents();
            if (a == null) {
                arrays.add(operands[i]);
                if (dim != 0) return new PtgErr(PtgErr.ERROR_VALUE);
                dim = 1;
            } else {
                if (dim == 0) {
                    dim = a.length;
                } else if (dim != a.length) {
                    return new PtgErr(PtgErr.ERROR_VALUE);
                }
                arrays.add(a);
            }
            ++i;
        }
        int j = 0;
        while (j < dim) {
            double d = 1.0;
            int i2 = 0;
            while (i2 < arrays.size()) {
                Object o = ((Ptg[])arrays.get(i2))[j].getValue();
                d = o instanceof Double ? (d *= ((Double)o).doubleValue()) : (o instanceof Integer ? (d *= (double)((Integer)o).intValue()) : (o instanceof Float ? (d *= (double)((Float)o).floatValue()) : 0.0));
                ++i2;
            }
            res += d;
            ++j;
        }
        return new PtgNumber(res);
    }

    protected static Ptg calcTan(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getNAError();
        }
        double dd = 0.0;
        try {
            dd = operands[0].getDoubleVal();
        }
        catch (NumberFormatException e) {
            return PtgCalculator.getValueError();
        }
        if (new Double(dd).isNaN()) {
            return PtgCalculator.getError();
        }
        double res = Math.tan(dd);
        PtgNumber ptnum = new PtgNumber(res);
        return ptnum;
    }

    protected static Ptg calcTanh(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getNAError();
        }
        double x = 0.0;
        try {
            x = operands[0].getDoubleVal();
        }
        catch (NumberFormatException e) {
            return PtgCalculator.getValueError();
        }
        double A = Math.pow(Math.E, x);
        double B = Math.pow(Math.E, -x);
        double result = (A - B) / (A + B);
        PtgNumber pnum = new PtgNumber(result);
        return pnum;
    }

    protected static Ptg calcTrunc(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getNAError();
        }
        double dd = 0.0;
        try {
            dd = operands[0].getDoubleVal();
        }
        catch (NumberFormatException e) {
            return PtgCalculator.getValueError();
        }
        if (new Double(dd).isNaN()) {
            return PtgCalculator.getError();
        }
        int res = (int)dd;
        PtgInt pint = new PtgInt(res);
        return pint;
    }

    private static double getAcosh(double x) {
        return Math.log(x + (1.0 + x) * Math.sqrt((x - 1.0) / (x + 1.0)));
    }

    public static long factorial(long n) {
        long result;
        if (n <= 1L) {
            result = 1L;
        } else {
            result = n;
            long partial = MathFunctionCalculator.factorial(n - 1L);
            result *= partial;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private static long stepFactorial(long n, int numsteps) {
        result = n;
        if (n >= (long)numsteps) ** GOTO lbl8
        return -1L;
lbl-1000:
        // 1 sources

        {
            partial = n - 1L;
            result = partial * result;
            --n;
            --numsteps;
lbl8:
            // 2 sources

            ** while (numsteps > 1)
        }
lbl9:
        // 1 sources

        return result;
    }

    private static long doubleFactorial(long n) {
        long result;
        if (n <= 1L) {
            result = 1L;
        } else if (n == 2L) {
            result = 2L;
        } else {
            result = n;
            long partial = MathFunctionCalculator.factorial(n - 2L);
            result *= partial;
        }
        return result;
    }
}

