/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.FunctionNotSupportedException;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.formulas.CalculationException;
import com.extentech.formats.XLS.formulas.FunctionConstants;
import com.extentech.formats.XLS.formulas.FunctionHandler;
import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgName;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.toolkit.ByteTools;
import java.util.Locale;

public class PtgFunc
extends GenericPtg
implements Ptg {
    private static final long serialVersionUID = 4435263700288188538L;
    private int iftab = -1;

    public PtgFunc(int funcType, XLSRecord parentRec) {
        this(funcType);
        this.setParentRec(parentRec);
    }

    public PtgFunc(int funcType) {
        byte[] recbyte = new byte[3];
        recbyte[0] = 65;
        byte[] b = ByteTools.shortToLEBytes((short)funcType);
        recbyte[1] = b[0];
        recbyte[2] = b[1];
        this.init(recbyte);
    }

    public PtgFunc() {
    }

    @Override
    public boolean getIsFunction() {
        return true;
    }

    @Override
    public int getNumParams() {
        return FunctionConstants.getNumParams(this.iftab);
    }

    @Override
    public boolean getIsUnaryOperator() {
        return true;
    }

    @Override
    public String getString() {
        short iftb = (short)this.iftab;
        String f = null;
        if (Locale.JAPAN.equals(Locale.getDefault())) {
            f = FunctionConstants.getJFunctionString(iftb);
        }
        if (f == null) {
            f = FunctionConstants.getFunctionString(iftb);
        }
        return f;
    }

    @Override
    public String getString2() {
        return ")";
    }

    @Override
    public void init(byte[] b) {
        this.ptgId = b[0];
        this.record = b;
        this.populateVals();
    }

    private void populateVals() {
        this.iftab = ByteTools.readShort(this.record[1], this.record[2]);
    }

    public int getVal() {
        return this.iftab;
    }

    public void setVal(int i) {
        this.iftab = i;
        this.updateRecord();
    }

    @Override
    public void updateRecord() {
        byte[] tmp = new byte[]{this.record[0]};
        byte[] brow = ByteTools.cLongToLEBytes(this.iftab);
        tmp = ByteTools.append(brow, tmp);
        this.record = tmp;
    }

    @Override
    public int getLength() {
        return 3;
    }

    @Override
    public Ptg calculatePtg(Ptg[] pthings) throws FunctionNotSupportedException, CalculationException {
        Ptg[] ptgarr = new Ptg[pthings.length + 1];
        ptgarr[0] = this;
        System.arraycopy(pthings, 0, ptgarr, 1, pthings.length);
        Ptg resPtg = FunctionHandler.calculateFunction(ptgarr);
        return resPtg;
    }

    public void adjustParameterIds() {
        if (this.vars == null) {
            return;
        }
        switch (this.iftab) {
            case 76: {
                int i = 0;
                if (i >= this.vars.length) break;
                if (this.vars[0] instanceof PtgRef) {
                    ((PtgRef)this.vars[0]).setPtgType((short)1);
                    break;
                }
                if (!(this.vars[0] instanceof PtgName)) break;
                ((PtgName)this.vars[0]).setPtgType((short)1);
            }
        }
    }
}

