/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgArea;
import com.extentech.formats.XLS.formulas.PtgArea3d;
import com.extentech.formats.XLS.formulas.PtgAreaErr3d;
import com.extentech.formats.XLS.formulas.PtgArray;
import com.extentech.formats.XLS.formulas.PtgErr;
import com.extentech.formats.XLS.formulas.PtgMystery;
import com.extentech.formats.XLS.formulas.PtgName;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.formats.XLS.formulas.PtgRef3d;
import com.extentech.formats.XLS.formulas.PtgRefErr;
import com.extentech.formats.XLS.formulas.PtgRefErr3d;
import com.extentech.formats.XLS.formulas.PtgStr;
import java.util.ArrayList;

public class PtgRange
extends GenericPtg
implements Ptg {
    private static final long serialVersionUID = 7181427387507157013L;

    @Override
    public boolean getIsOperator() {
        return true;
    }

    @Override
    public boolean getIsBinaryOperator() {
        return true;
    }

    @Override
    public boolean getIsPrimitiveOperator() {
        return true;
    }

    public PtgRange() {
        this.ptgId = (byte)17;
        this.record = new byte[1];
        this.record[0] = 17;
    }

    @Override
    public String getString() {
        return ":";
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public Ptg calculatePtg(Ptg[] form) {
        if (form.length != 2) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        try {
            int[] addr;
            int i;
            int cellctr;
            int rowctr;
            int numrows;
            int[] rc;
            PtgRef pr;
            String sheet = null;
            String sourceSheet = null;
            try {
                sourceSheet = this.getParentRec().getSheet().getSheetName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            ArrayList<Ptg> first = null;
            ArrayList<Ptg> last = null;
            int i2 = 0;
            while (i2 < 2) {
                Ptg[] pa;
                int j;
                Ptg[] pc;
                Ptg p = form[i2];
                ArrayList<Ptg> a = new ArrayList<Ptg>();
                if (p instanceof PtgArea) {
                    a.add(p);
                } else if (p instanceof PtgRef) {
                    a.add(p);
                } else if (p instanceof PtgName) {
                    pc = ((PtgName)p).getComponents();
                    j = 0;
                    while (j < pc.length) {
                        a.add(pc[j]);
                        ++j;
                    }
                } else if (p instanceof PtgStr) {
                    String[] comps = p.toString().split(",");
                    j = 0;
                    while (j < comps.length) {
                        if (comps[j].indexOf(":") == -1) {
                            PtgRef3d pr2;
                            if (!comps[j].equals("#REF!") && !comps[j].equals("#NULL!")) {
                                pr2 = new PtgRef3d(false);
                                pr2.setParentRec(this.getParentRec());
                                pr2.setLocation(comps[j]);
                                a.add(pr2);
                            } else {
                                pr2 = new PtgRefErr3d();
                                pr2.setParentRec(this.getParentRec());
                                a.add(pr2);
                            }
                        } else {
                            pa = new PtgArea3d(false);
                            pa.setParentRec(this.getParentRec());
                            pa.setLocation(comps[j]);
                            Ptg[] pcs = pa.getComponents();
                            if (pcs != null) {
                                int k = 0;
                                while (k < pcs.length) {
                                    ((PtgRef)pcs[k]).setSheetName(pa.getSheetName());
                                    a.add(pcs[k]);
                                    ++k;
                                }
                            }
                        }
                        ++j;
                    }
                } else if (p instanceof PtgArray) {
                    pc = ((PtgArray)p).getComponents();
                    j = 0;
                    while (j < pc.length) {
                        String loc = ((PtgStr)pc[j]).toString();
                        if (loc.indexOf(":") == -1) {
                            PtgRef pr3;
                            if (loc.indexOf("!") == -1) {
                                pr3 = new PtgRef();
                                pr3.setUseReferenceTracker(false);
                                pr3.setParentRec(this.getParentRec());
                                pr3.setLocation(loc);
                                a.add(pr3);
                            } else {
                                pr3 = new PtgRef3d(false);
                                ((PtgRef3d)pr3).setParentRec(this.getParentRec());
                                ((PtgRef3d)pr3).setLocation(loc);
                                a.add(pr3);
                            }
                        } else {
                            PtgArea3d pa2 = new PtgArea3d(false);
                            pa2.setParentRec(this.getParentRec());
                            pa2.setLocation(loc);
                            a.add(pa2);
                        }
                        ++j;
                    }
                } else if (!(p instanceof PtgErr || p instanceof PtgRefErr || p instanceof PtgAreaErr3d)) {
                    pc = ((GenericPtg)p).vars;
                    j = 0;
                    while (j < pc.length) {
                        if (pc[j] instanceof PtgArea & !(pc[j] instanceof PtgAreaErr3d)) {
                            pa = pc[j].getComponents();
                            int k = 0;
                            while (k < pa.length) {
                                a.add(pa[k]);
                                ++k;
                            }
                        } else {
                            a.add(pc[j]);
                        }
                        ++j;
                    }
                }
                if (first == null) {
                    first = a;
                } else {
                    last = a;
                }
                ++i2;
            }
            int[] nArray = new int[4];
            nArray[0] = Short.MAX_VALUE;
            nArray[1] = Short.MAX_VALUE;
            int[] rng = nArray;
            int k = 0;
            while (k < first.size()) {
                pr = (PtgRef)first.get(k);
                if (sheet == null) {
                    sheet = pr.getSheetName();
                }
                if ((rc = pr.getIntLocation()).length > 2) {
                    numrows = rc[2] - rc[0] + 1;
                    int numcols = rc[3] - rc[1] + 1;
                    int numcells = numrows * numcols;
                    if (numcells < 0) {
                        numcells *= -1;
                    }
                    rowctr = rc[0];
                    cellctr = rc[1] - 1;
                    i = 0;
                    while (i < numcells) {
                        if (cellctr == rc[3]) {
                            cellctr = rc[1] - 1;
                        }
                        addr = new int[]{++rowctr, ++cellctr};
                        this.adjustRange(addr, rng);
                        ++i;
                    }
                } else {
                    this.adjustRange(rc, rng);
                }
                ++k;
            }
            k = 0;
            while (k < last.size()) {
                pr = (PtgRef)last.get(k);
                if (sheet == null) {
                    sheet = pr.getSheetName();
                }
                if ((rc = pr.getIntLocation()).length > 2) {
                    if (rc.length > 2) {
                        numrows = rc[2] - rc[0] + 1;
                        int numcols = rc[3] - rc[1] + 1;
                        int numcells = numrows * numcols;
                        if (numcells < 0) {
                            numcells *= -1;
                        }
                        rowctr = rc[0];
                        cellctr = rc[1] - 1;
                        i = 0;
                        while (i < numcells) {
                            if (cellctr == rc[3]) {
                                cellctr = rc[1] - 1;
                            }
                            addr = new int[]{++rowctr, ++cellctr};
                            this.adjustRange(addr, rng);
                            ++i;
                        }
                    }
                } else {
                    this.adjustRange(rc, rng);
                }
                ++k;
            }
            PtgMystery retp = new PtgMystery();
            PtgArea3d pa = new PtgArea3d(false);
            pa.setParentRec(this.getParentRec());
            pa.setSheetName(sheet);
            pa.setLocation(rng);
            retp.setVars(new Ptg[]{pa});
            return retp;
        }
        catch (NumberFormatException e) {
            PtgErr perr = new PtgErr(PtgErr.ERROR_VALUE);
            return perr;
        }
        catch (Exception e) {
            PtgErr perr = new PtgErr(PtgErr.ERROR_VALUE);
            return perr;
        }
    }

    private void adjustRange(int[] rc, int[] rng) {
        if (ExcelTools.isBeforeRange(rc, rng)) {
            rng[0] = rc[0];
            rng[1] = rc[1];
        }
        if (ExcelTools.isAfterRange(rc, rng)) {
            rng[2] = rc[0];
            rng[3] = rc[1];
        }
    }
}

