/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.Externsheet;
import com.extentech.formats.XLS.Formula;
import com.extentech.formats.XLS.Name;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.WorkSheetNotFoundException;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.formulas.IxtiListener;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.FastAddVector;
import com.extentech.toolkit.Logger;

public class PtgRef3d
extends PtgRef
implements Ptg,
IxtiListener {
    boolean quoted = false;
    public short ixti;
    private static final long serialVersionUID = -441121385905948168L;

    @Override
    public void setParentRec(XLSRecord r2) {
        super.setParentRec(r2);
    }

    @Override
    public void addListener() {
        try {
            this.getParentRec().getWorkBook().getExternSheet().addPtgListener(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public short getIxti() {
        return this.ixti;
    }

    public boolean isExternalLink() {
        try {
            return this.getParentRec().getWorkBook().getExternSheet().getIsExternalLink(this.ixti);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public int getLength() {
        return 7;
    }

    @Override
    public boolean getIsOperand() {
        return true;
    }

    @Override
    public boolean getIsReference() {
        return true;
    }

    public PtgRef3d() {
        this.record = new byte[7];
        this.record[0] = this.ptgId = (byte)90;
        this.is3dRef = true;
    }

    @Override
    public void setPtgType(short type) {
        switch (type) {
            case 0: {
                this.ptgId = (byte)90;
                break;
            }
            case 1: {
                this.ptgId = (byte)58;
                break;
            }
            case 2: {
                this.ptgId = (byte)122;
            }
        }
        this.record[0] = this.ptgId;
    }

    public PtgRef3d(boolean addToRefTracker) {
        this.setUseReferenceTracker(addToRefTracker);
        this.record[0] = this.ptgId = (byte)90;
        this.is3dRef = true;
    }

    public PtgRef3d(String addr, short _ixti) {
        this();
        this.setLocation(addr);
        this.is3dRef = true;
    }

    @Override
    public void init(byte[] b) {
        this.ptgId = b[0];
        this.record = b;
        this.populateVals();
    }

    public Boundsheet getSheet(WorkBook b) {
        Boundsheet[] bsa = b.getExternSheet().getBoundSheets(this.ixti);
        if (bsa != null && bsa[0] == null) {
            if (this.parent_rec.getSheet() != null) {
                return this.parent_rec.getSheet();
            }
            if (b.getFactory().getDebugLevel() > 1) {
                Logger.logErr("PtgRef3d.getSheet: Unresolved External or Deleted Sheet Reference Found");
            }
            return null;
        }
        if (bsa == null) {
            return null;
        }
        return bsa[0];
    }

    @Override
    public void setLocation(String[] s) {
        if (this.useReferenceTracker && !this.getIsRefErr()) {
            this.getParentRec().getWorkBook().getRefTracker().removeCellRange(this);
        }
        this.sheetname = null;
        if (s[0] != null) {
            this.sheetname = s[0];
        } else {
            try {
                this.sheetname = this.getParentRec().getSheet().getSheetName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        String loc = s[1];
        if (this.sheetname != null) {
            loc = String.valueOf(this.sheetname) + "!" + loc;
            if (this.sheetname.indexOf("'") == 0) {
                this.sheetname = this.sheetname.substring(1, this.sheetname.length() - 1);
                this.quoted = true;
            }
        }
        if (this.sheetname != null) {
            Externsheet xsht = null;
            WorkBook b = this.parent_rec.getWorkBook();
            if (b == null) {
                b = this.parent_rec.getSheet().getWorkBook();
            }
            try {
                int boundnum = b.getWorkSheetByName(this.sheetname).getSheetNum();
                xsht = b.getExternSheet();
                try {
                    int xloc = xsht.insertLocation(boundnum, boundnum);
                    this.setIxti((short)xloc);
                }
                catch (Exception e) {
                    Logger.logWarn("PtgRef3d.setLocation could not update Externsheet:" + e.toString());
                }
            }
            catch (WorkSheetNotFoundException e) {
                try {
                    xsht = b.getExternSheet();
                    int boundnum = xsht.getXtiReference(s[0], s[0]);
                    if (boundnum == -1) {
                        this.setIxti((short)xsht.insertLocation(boundnum, boundnum));
                    } else {
                        this.setIxti((short)boundnum);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        super.setLocation(s);
    }

    @Override
    public void setLocation(String address) {
        String[] s = ExcelTools.stripSheetNameFromRange(address);
        this.setLocation(s);
    }

    @Override
    public void populateVals() {
        this.ixti = ByteTools.readShort(this.record[1], this.record[2]);
        this.sheetname = this.getSheetName();
        this.rw = this.readRow(this.record[3], this.record[4]);
        short column = ByteTools.readShort(this.record[5], this.record[6]);
        this.fRwRel = (column & 0x8000) == 32768;
        this.fColRel = (column & 0x4000) == 16384;
        this.col = (short)(column & 0x3FFF);
        this.setRelativeRowCol();
        this.getIntLocation();
        this.hashcode = super.getHashCode();
    }

    public void setLocation(String address, short ix) {
        this.ixti = ix;
        String[] s = ExcelTools.stripSheetNameFromRange(address);
        this.setLocation(s);
    }

    @Override
    public String toString() {
        String ret = "";
        try {
            ret = this.getLocation();
            if (ret.indexOf("!") == -1 && this.sheetname != null) {
                ret = this.sheetname.indexOf(32) == -1 && this.sheetname.charAt(0) != '\'' ? String.valueOf(this.sheetname) + "!" + ret : "'" + this.sheetname + "'!" + ret;
            }
        }
        catch (Exception ex) {
            Logger.logErr("PtgRef3d.toString() failed", ex);
        }
        return ret;
    }

    @Override
    public void setIxti(short ixf) {
        if (this.ixti != ixf) {
            this.ixti = ixf;
            if (this.record != null) {
                this.record[1] = (byte)ixf;
            }
            this.updateRecord();
        }
    }

    public void setReferencedSheet(Boundsheet b) {
        int boundnum = b.getSheetNum();
        Externsheet xsht = b.getWorkBook().getExternSheet(true);
        try {
            int xloc = xsht.insertLocation(boundnum, boundnum);
            this.setIxti((short)xloc);
            this.sheetname = null;
            this.getSheetName();
            this.locax = null;
        }
        catch (WorkSheetNotFoundException e) {
            Logger.logErr("Unable to set referenced sheet in PtgRef3d " + e);
        }
    }

    @Override
    public String getLocation() {
        String ret = super.getLocation();
        if (ret.indexOf("!") == -1) {
            if (this.sheetname == null) {
                this.sheetname = this.getSheetName();
            }
            if (this.sheetname != null) {
                if (this.sheetname.equals("#REF!")) {
                    return String.valueOf(this.sheetname) + ret;
                }
                this.sheetname = PtgRef3d.qualifySheetname(this.sheetname);
                return String.valueOf(this.sheetname) + "!" + ret;
            }
        }
        return ret;
    }

    @Override
    public void updateRecord() {
        byte[] tmp = new byte[7];
        tmp[0] = this.record[0];
        byte[] ix = ByteTools.shortToLEBytes(this.ixti);
        System.arraycopy(ix, 0, tmp, 1, 2);
        byte[] brow = ByteTools.cLongToLEBytes(this.rw);
        System.arraycopy(brow, 0, tmp, 3, 2);
        if (this.fRwRel) {
            this.col = (short)(0x8000 | this.col);
        }
        if (this.fColRel) {
            this.col = (short)(0x4000 | this.col);
        }
        byte[] bcol = ByteTools.cLongToLEBytes(this.col);
        if (this.col == -1) {
            bcol[1] = 0;
        }
        System.arraycopy(bcol, 0, tmp, 5, 2);
        this.record = tmp;
        if (this.parent_rec != null) {
            if (this.parent_rec instanceof Formula) {
                ((Formula)this.parent_rec).updateRecord();
            } else if (this.parent_rec instanceof Name) {
                ((Name)this.parent_rec).updatePtgs();
            }
        }
        this.col = (short)this.col & 0x3FFF;
    }

    public Boundsheet getSheet() {
        WorkBook wb;
        if (this.parent_rec != null && (wb = this.parent_rec.getWorkBook()) != null && wb.getExternSheet() != null) {
            Boundsheet[] bsa = wb.getExternSheet().getBoundSheets(this.ixti);
            if (bsa == null || bsa[0] == null) {
                if (this.parent_rec instanceof Formula) {
                    Logger.logErr("PtgRef3d.getSheet: Unresolved External Worksheet in Formula " + this.parent_rec.getCellAddressWithSheet());
                } else if (this.parent_rec instanceof Name) {
                    Logger.logErr("PtgRef3d.getSheet: Unresolved External Worksheet in Name " + ((Name)this.parent_rec).getName());
                } else {
                    Logger.logErr("PtgRef3d.getSheet: Unresolved External Worksheet for " + this.parent_rec.getCellAddressWithSheet());
                }
                return null;
            }
            return bsa[0];
        }
        return null;
    }

    @Override
    public String getSheetName() {
        String[] sheets;
        WorkBook wb;
        if (this.sheetname == null && this.parent_rec != null && (wb = this.parent_rec.getWorkBook()) != null && wb.getExternSheet() != null && (sheets = wb.getExternSheet().getBoundSheetNames(this.ixti)) != null && sheets[0] != null) {
            this.sheetname = sheets[0];
        }
        return this.sheetname;
    }

    @Override
    public BiffRec[] getRefCells() {
        if (this.sheetname == null) {
            this.sheetname = this.getSheetName();
        }
        this.refCell = super.getRefCells();
        return this.refCell;
    }

    @Override
    public Ptg[] getComponents() {
        return null;
    }

    public Ptg[] getColComponents(int colNum) {
        FastAddVector v = new FastAddVector();
        int[] x = this.getIntLocation();
        if (x[1] == colNum) {
            v.add(this);
        }
        Object[] pref = new PtgRef[v.size()];
        v.toArray(pref);
        return pref;
    }
}

