/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.io.UnsupportedEncodingException;

public class PtgStr
extends GenericPtg
implements Ptg {
    private static final long serialVersionUID = -1427051673654768400L;
    short cch;
    byte grbit;
    boolean negativeCch = false;
    private String tempstr = null;

    @Override
    public boolean getIsOperand() {
        return true;
    }

    @Override
    public String getString() {
        String strVal = null;
        try {
            if ((this.grbit & 1) == 1) {
                byte[] barr = new byte[this.cch * 2];
                System.arraycopy(this.record, 3, barr, 0, this.cch * 2);
                strVal = new String(barr, "UTF-16LE");
            } else {
                byte[] barr = new byte[this.cch];
                System.arraycopy(this.record, 3, barr, 0, this.cch);
                strVal = new String(barr, "ISO-8859-1");
            }
        }
        catch (Exception e) {
            byte[] barr = new byte[this.cch];
            System.arraycopy(this.record, 3, barr, 0, this.cch);
            strVal = new String(barr);
        }
        return strVal;
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public String getTextString() {
        try {
            Double d = new Double(this.getString());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return "\"" + this.getString() + "\"";
    }

    @Override
    public Object getValue() {
        return this.getString();
    }

    public PtgStr() {
    }

    public PtgStr(String s) {
        this.ptgId = (byte)23;
        this.setVal(s);
    }

    @Override
    public void init(byte[] b) {
        this.grbit = b[2];
        this.cch = (short)(b[1] & 0xFF);
        this.ptgId = b[0];
        this.record = b;
        this.populateVals();
    }

    private void populateVals() {
    }

    public String getVal() {
        return this.getString();
    }

    public void setVal(String s) {
        this.tempstr = s;
        this.updateRecord();
    }

    @Override
    public void updateRecord() {
        String ts = this.tempstr;
        if (ts == null) {
            return;
        }
        if (ByteTools.isUnicode(ts)) {
            this.grbit = (byte)(this.grbit | 1);
        }
        try {
            short strbytelen;
            byte[] strbytes = null;
            strbytes = (this.grbit & 1) == 1 ? ts.getBytes("UTF-16LE") : ts.getBytes("ISO-8859-1");
            this.cch = strbytelen = (short)strbytes.length;
            if ((this.grbit & 1) == 1) {
                this.cch = (short)(strbytelen / 2);
            }
            this.record = new byte[strbytelen + 3];
            this.record[0] = 23;
            this.record[1] = (byte)this.cch;
            this.record[2] = this.grbit;
            System.arraycopy(strbytes, 0, this.record, 3, strbytelen);
        }
        catch (UnsupportedEncodingException e) {
            Logger.logInfo("decoding formula string failed: " + e);
        }
    }

    @Override
    public int getLength() {
        return this.record.length;
    }
}

