/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.toolkit;

import com.extentech.toolkit.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;

public final class ByteTools
implements Serializable {
    private static final long serialVersionUID = 1220042103372057083L;
    private static String hexits = "0123456789ABCDEF";

    public static String getByteDump(byte[] bt, int offset) {
        return ByteTools.getByteDump(bt, offset, bt.length);
    }

    public static String getByteDump(byte[] bt, int offset, int len) {
        if (bt == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int every4 = 0;
        int every16 = 0;
        buf.append("\r\n");
        String offst = Integer.toHexString(offset);
        while (offst.length() < 4) {
            offst = "0" + offst;
        }
        buf.append(offst);
        buf.append(":    ");
        int origOffset = offset;
        offset += 16;
        int i = origOffset;
        while (i < len) {
            buf.append(hexits.charAt(bt[i] >>> 4 & 0xF));
            buf.append(hexits.charAt(bt[i] & 0xF));
            buf.append(" ");
            if (++every4 == 4) {
                every4 = 0;
                buf.append("  ");
                if (++every16 == 4) {
                    buf.append("\r\n");
                    offst = Integer.toHexString(offset);
                    while (offst.length() < 4) {
                        offst = "0" + offst;
                    }
                    buf.append(offst);
                    buf.append(":    ");
                    offset += 16;
                    every16 = 0;
                }
            }
            ++i;
        }
        return "" + buf;
    }

    public static String getByteString(byte[] bt, boolean pad) {
        if (bt.length == 0) {
            return "null";
        }
        StringBuffer ret = new StringBuffer();
        int x = 0;
        while (x < bt.length) {
            if (x % 8 == 0 && x > 0) {
                ret.append("\r\n");
            }
            String bstr = Byte.toString(bt[x]);
            if (pad) {
                while (bstr.length() < 4) {
                    bstr = " " + bstr;
                }
            }
            ret.append(bstr);
            ret.append(",");
            ++x;
        }
        ret.setLength(ret.length() - 1);
        return ret.toString();
    }

    public static byte[] append(byte[] src, byte[] dest) {
        if (src == null) {
            return (byte[])dest.clone();
        }
        if (dest == null) {
            return (byte[])src.clone();
        }
        int srclen = src.length;
        int destlen = dest.length;
        byte[] ret = new byte[srclen + destlen];
        System.arraycopy(dest, 0, ret, 0, destlen);
        System.arraycopy(src, 0, ret, destlen, srclen);
        return ret;
    }

    public static byte[] append(byte[] src, byte[] dest, int pos) {
        int destlen;
        int srclen = src.length;
        if (dest == null) {
            dest = new byte[srclen];
        }
        if ((destlen = dest.length) < srclen) {
            Logger.logInfo("Your destination byte array is too small to copy into: srclen=" + String.valueOf(srclen) + ": destlen=" + String.valueOf(destlen));
            srclen = destlen;
        }
        System.arraycopy(src, 0, dest, pos, srclen);
        return dest;
    }

    public static byte[] cLongToLEBytes(int i) {
        byte[] ret = new byte[]{(byte)(i & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 24 & 0xFF)};
        return ret;
    }

    public static short[] cLongToLEShorts(int x) {
        short low;
        short[] buf = new short[2];
        short high = (short)(x >>> 16);
        buf[0] = low = (short)x;
        buf[1] = high;
        return buf;
    }

    public static byte[] doubleToLEByteArray(double d) {
        long l;
        byte[] bite = new byte[8];
        long t = l = Double.doubleToLongBits(d);
        int i = bite.length - 1;
        while (i > -1) {
            long irr = t & 0xFFL;
            bite[i] = Integer.valueOf((int)irr).byteValue();
            t >>= 8;
            --i;
        }
        byte[] ret = new byte[bite.length];
        int x = 0;
        while (x < bite.length) {
            ret[x] = bite[bite.length - 1 - x];
            ++x;
        }
        return ret;
    }

    public static byte[] doubleToByteArray(double d) {
        long l;
        byte[] bite = new byte[8];
        long t = l = Double.doubleToLongBits(d);
        int i = bite.length - 1;
        while (i > -1) {
            long irr = t & 0xFFL;
            bite[i] = Integer.valueOf((int)irr).byteValue();
            t >>= 8;
            --i;
        }
        return bite;
    }

    public static double eightBytetoLEDouble(byte[] bite) {
        byte[] b = new byte[]{bite[7], bite[6], bite[5], bite[4], bite[3], bite[2], bite[1], bite[0]};
        double d = 0.0;
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        DataInputStream dis = new DataInputStream(bais);
        try {
            Double dbl = new Double(dis.readDouble());
            d = dbl;
        }
        catch (IOException e) {
            Logger.logInfo("io exception in byte to Double conversion" + e);
        }
        return d;
    }

    public static long eightBytetoLELong(byte[] bite) {
        byte[] b = new byte[]{bite[7], bite[6], bite[5], bite[4], bite[3], bite[2], bite[1], bite[0]};
        long l = 0L;
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        DataInputStream dis = new DataInputStream(bais);
        try {
            Long lg = new Long(dis.readLong());
            l = lg;
        }
        catch (IOException e) {
            Logger.logInfo("io exception in byte to Double conversion" + e);
        }
        return l;
    }

    public static byte[] getBytes(List records) {
        Iterator e = records.iterator();
        int buflen = 0;
        while (e.hasNext()) {
            byte[] barr = (byte[])e.next();
            buflen += barr.length;
        }
        byte[] outbytes = new byte[buflen];
        int pos = 0;
        int i = 0;
        while (i < records.size()) {
            byte[] stream = (byte[])records.get(i);
            outbytes = ByteTools.append(stream, outbytes, pos);
            pos += stream.length;
            ++i;
        }
        return outbytes;
    }

    public static byte[] getExcelEncoding(String s) {
        byte[] strbytes = null;
        try {
            strbytes = s.getBytes("UnicodeLittleUnmarked");
        }
        catch (UnsupportedEncodingException e) {
            Logger.logInfo("Error creating encoded string: " + e);
        }
        boolean unicode = false;
        int i = 0;
        while (i < strbytes.length) {
            if (strbytes[++i] != 0) {
                unicode = true;
                i = strbytes.length;
            }
            ++i;
        }
        if (unicode) {
            return strbytes;
        }
        return s.getBytes();
    }

    public static byte[] longToLEByteArray(long l) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeLong(l);
            dos.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] bite = bos.toByteArray();
        byte[] b = new byte[]{bite[7], bite[6], bite[5], bite[4], bite[3], bite[2], bite[1], bite[0]};
        return b;
    }

    public static boolean isUnicode(String s) {
        byte[] strbytes = null;
        try {
            strbytes = s.getBytes("UnicodeLittleUnmarked");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        int i = 0;
        while (i < strbytes.length) {
            if (strbytes[i] >= 127) {
                return true;
            }
            if (strbytes[++i] != 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static byte[] longToByteArray(long l) {
        byte[] bite = new byte[8];
        long t = l;
        int i = bite.length - 1;
        while (i > -1) {
            long irr = t & 0xFFL;
            bite[i] = Integer.valueOf((int)irr).byteValue();
            t >>= 8;
            --i;
        }
        return bite;
    }

    public static int readInt(byte[] bs) {
        return ByteTools.readInt(ByteTools.readShort(bs[2], bs[3]), (int)ByteTools.readShort(bs[0], bs[1]));
    }

    public static int readInt(byte b1, byte b2, byte b3, byte b4) {
        return ByteTools.readInt(ByteTools.readShort(b3, b4), (int)ByteTools.readShort(b1, b2));
    }

    public static int readInt(byte[] b, int offset) {
        return ByteTools.readInt(b[offset++], b[offset++], b[offset++], b[offset++]);
    }

    public static int readInt(int low, int high) {
        if (low == 0 && high == 0) {
            return 0;
        }
        return (low &= 0xFFFF) << 16 | (high &= 0xFFFF);
    }

    public static int readUnsignedShort(byte low, byte high) {
        return ByteTools.readInt(low, high, (byte)0, (byte)0);
    }

    public static short readShort(int low, int high) {
        return (short)((high &= 0xFF) << 8 | (low &= 0xFF));
    }

    public static byte[] shortToLEBytes(short x) {
        byte[] buf = new byte[2];
        buf[1] = (byte)(x >>> 8);
        buf[0] = (byte)x;
        return buf;
    }

    public static byte[] toBEByteArray(double d) {
        long l;
        byte[] bite = new byte[8];
        long t = l = Double.doubleToLongBits(d);
        int i = bite.length - 1;
        while (i > -1) {
            long irr = t & 0xFFL;
            bite[i] = Integer.valueOf((int)irr).byteValue();
            t >>= 8;
            --i;
        }
        byte[] b = new byte[]{bite[7], bite[6], bite[5], bite[4], bite[3], bite[2], bite[1], bite[0]};
        return b;
    }

    public static void writeToFile(byte[] b, String fname) {
        try {
            FileOutputStream fos = new FileOutputStream(fname);
            fos.write(b);
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            Logger.logInfo("Error writing bytes to file in ByteTools: " + e);
        }
    }

    public byte[] cLongToLEBytesOLD(int i) {
        short[] sbuf = ByteTools.cLongToLEShorts(i);
        byte[] b1 = ByteTools.shortToLEBytes(sbuf[0]);
        byte[] b2 = ByteTools.shortToLEBytes(sbuf[1]);
        byte[] bbuf = new byte[]{b1[0], b1[1], b2[0], b2[1]};
        return bbuf;
    }

    public static short updateGrBit(short grbit, boolean set, int bitNum) {
        switch (bitNum) {
            case 0: {
                if (set) {
                    grbit = (short)(grbit | 1);
                    break;
                }
                grbit = (short)(grbit & 0xFFFE);
                break;
            }
            case 1: {
                if (set) {
                    grbit = (short)(grbit | 2);
                    break;
                }
                grbit = (short)(grbit & 0xFFFD);
                break;
            }
            case 2: {
                if (set) {
                    grbit = (short)(grbit | 4);
                    break;
                }
                grbit = (short)(grbit & 0xFFFB);
                break;
            }
            case 3: {
                if (set) {
                    grbit = (short)(grbit | 8);
                    break;
                }
                grbit = (short)(grbit & 0xFFF7);
                break;
            }
            case 4: {
                if (set) {
                    grbit = (short)(grbit | 0x10);
                    break;
                }
                grbit = (short)(grbit & 0xFFEF);
                break;
            }
            case 5: {
                if (set) {
                    grbit = (short)(grbit | 0x20);
                    break;
                }
                grbit = (short)(grbit & 0xFFDF);
                break;
            }
            case 6: {
                if (set) {
                    grbit = (short)(grbit | 0x40);
                    break;
                }
                grbit = (short)(grbit & 0xFFBF);
                break;
            }
            case 7: {
                if (set) {
                    grbit = (short)(grbit | 0x80);
                    break;
                }
                grbit = (short)(grbit & 0xFF7F);
                break;
            }
            case 8: {
                if (set) {
                    grbit = (short)(grbit | 0x100);
                    break;
                }
                grbit = (short)(grbit & 0xFEFF);
                break;
            }
            case 9: {
                if (set) {
                    grbit = (short)(grbit | 0x200);
                    break;
                }
                grbit = (short)(grbit & 0xFDFF);
                break;
            }
            case 10: {
                if (set) {
                    grbit = (short)(grbit | 0x400);
                    break;
                }
                grbit = (short)(grbit & 0xFBFF);
                break;
            }
            case 11: {
                if (set) {
                    grbit = (short)(grbit | 0x800);
                    break;
                }
                grbit = (short)(grbit & 0xF7FF);
                break;
            }
            case 12: {
                if (set) {
                    grbit = (short)(grbit | 0x1000);
                    break;
                }
                grbit = (short)(grbit & 0xEFFF);
                break;
            }
            case 13: {
                if (set) {
                    grbit = (short)(grbit | 0x2000);
                    break;
                }
                grbit = (short)(grbit & 0xDFFF);
                break;
            }
            case 14: {
                if (set) {
                    grbit = (short)(grbit | 0x4000);
                    break;
                }
                grbit = (short)(grbit & 0xBFFF);
                break;
            }
            case 15: {
                grbit = set ? (short)(grbit | 0x8000) : (short)(grbit & Short.MAX_VALUE);
            }
        }
        return grbit;
    }
}

